/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.wbem.cim;

import java.util.Iterator;
import java.util.Vector;
import org.sblim.wbem.cim.CIMDataType;
import org.sblim.wbem.cim.CIMParameter;
import org.sblim.wbem.cim.CIMQualifiableElement;
import org.sblim.wbem.cim.CIMQualifier;
import org.sblim.wbem.util.Utils;

public class CIMMethod
extends CIMQualifiableElement
implements Cloneable {
    private String originClass = null;
    private String overridingMethod = null;
    private Vector parameters = new Vector(0);
    private CIMDataType type;
    private boolean propagated = false;

    public CIMMethod() {
    }

    public CIMMethod(String name) {
        super(name);
    }

    public Object clone() {
        return this.clone(true, true);
    }

    public Object clone(boolean includeQualifier, boolean includeClassOrigin) {
        Iterator iter;
        CIMMethod that = new CIMMethod(this.name);
        if (includeQualifier) {
            iter = this.qualifiers.iterator();
            while (iter.hasNext()) {
                CIMQualifier qual = (CIMQualifier)iter.next();
                that.qualifiers.add(qual.clone());
            }
        }
        if (includeClassOrigin) {
            that.originClass = this.originClass;
        }
        that.overridingMethod = this.overridingMethod;
        that.type = (CIMDataType)this.type.clone();
        that.propagated = this.propagated;
        iter = this.parameters.iterator();
        while (iter.hasNext()) {
            CIMParameter param = (CIMParameter)iter.next();
            that.parameters.add(param.clone());
        }
        return that;
    }

    public int hashCode() {
        return (this.originClass != null ? this.originClass.hashCode() : 0) * 31 + (this.overridingMethod != null ? this.overridingMethod.hashCode() : 0) * 37 + (this.propagated ? 1 : 0) * 23 + this.qualifiers.hashCode() + this.parameters.hashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof CIMMethod)) {
            return false;
        }
        CIMMethod that = (CIMMethod)o;
        if (!this.parameters.equals(that.parameters) || !this.qualifiers.equals(that.qualifiers) || this.propagated != that.propagated) {
            return false;
        }
        if (!(this.overridingMethod != null ? this.overridingMethod.equalsIgnoreCase(that.overridingMethod) : that.overridingMethod == null)) {
            return false;
        }
        if (!(this.originClass != null ? this.originClass.equalsIgnoreCase(that.originClass) : that.originClass == null)) {
            return false;
        }
        return this.name.equalsIgnoreCase(that.name);
    }

    public String getOriginClass() {
        return this.originClass;
    }

    public String getOverridingMethod() {
        return this.overridingMethod;
    }

    public Vector getParameters() {
        return this.parameters;
    }

    public boolean isPropagated() {
        return this.propagated;
    }

    public int getSize() {
        if (this.type != null) {
            return this.type.getSize();
        }
        return -1;
    }

    public CIMDataType getType() {
        return this.type;
    }

    public void setOriginClass(String originClass) {
        this.originClass = originClass;
    }

    public void setOverridingMethod(String overridingMethod) {
        this.overridingMethod = overridingMethod;
    }

    public void addParameter(CIMParameter parameter) {
        if (parameter == null) {
            throw new IllegalArgumentException("null parameter argument");
        }
        Utils.addSorted(this.parameters, parameter);
    }

    public void setParameters(Vector parameters) {
        if (parameters == null) {
            this.parameters.setSize(0);
        } else {
            Utils.addSorted(this.parameters, parameters);
        }
    }

    public void setPropagated(boolean isPropagated) {
        this.propagated = isPropagated;
    }

    public void removeProperty(String parameterName) {
        if (parameterName == null) {
            throw new IllegalArgumentException("null parameterName argument");
        }
        Iterator iter = this.parameters.iterator();
        while (iter.hasNext()) {
            CIMParameter param = (CIMParameter)iter.next();
            if (!param.getName().equals(parameterName)) continue;
            iter.remove();
            return;
        }
    }

    public void setSize(int size) {
    }

    public void setType(CIMDataType type) {
        this.type = type;
    }

    public String toMOF() {
        StringBuffer buf = new StringBuffer();
        if (this.name != null && this.name.length() > 0) {
            buf.append(CIMMethod.vectorToMOFString(this.qualifiers, false, 1));
            buf.append("\n\t");
            if (this.type != null) {
                buf.append(this.type);
            } else {
                buf.append("void");
            }
            buf.append(" ");
            buf.append(this.name);
            buf.append("(\n");
            buf.append(CIMMethod.vectorToMOFString(this.parameters, true, 1, 0, true));
            buf.append("\t);");
        }
        return buf.toString();
    }

    public String toString() {
        return this.toMOF();
    }

    public static void main(String[] args) {
    }
}

