/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.wbem.cim;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Vector;
import org.sblim.wbem.cim.CIMDataType;
import org.sblim.wbem.cim.CIMException;
import org.sblim.wbem.cim.CIMQualifiableElement;
import org.sblim.wbem.cim.CIMQualifier;
import org.sblim.wbem.cim.CIMValue;

public class CIMProperty
extends CIMQualifiableElement
implements Cloneable,
Serializable {
    private CIMValue value;
    private String originClass = null;
    private String overridingProperty;
    private CIMDataType type;
    private boolean propagated = false;

    public CIMProperty() {
        this("");
    }

    public CIMProperty(String name) {
        this(name, null);
    }

    public CIMProperty(String name, CIMValue value) {
        super(name);
        this.value = value;
        if (value != null) {
            this.type = value.getType();
        }
    }

    public Object clone() {
        return this.clone(true, true);
    }

    public Object clone(boolean includeQualifier, boolean includeClassOrigin) {
        CIMProperty that = new CIMProperty();
        that.name = this.name;
        if (this.value != null) {
            that.value = (CIMValue)this.value.clone();
        }
        if (includeClassOrigin) {
            that.originClass = this.originClass;
        }
        that.overridingProperty = this.overridingProperty;
        that.propagated = this.propagated;
        if (this.type != null) {
            that.type = (CIMDataType)this.type.clone();
        }
        if (includeQualifier) {
            for (int i = 0; i < this.qualifiers.size(); ++i) {
                that.qualifiers.add(((CIMQualifier)this.qualifiers.elementAt(i)).clone());
            }
        }
        return that;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CIMProperty)) {
            return false;
        }
        CIMProperty that = (CIMProperty)obj;
        if (!(this.originClass != null ? this.originClass.equalsIgnoreCase(that.originClass) : that.originClass == null)) {
            return false;
        }
        if (!(this.overridingProperty != null ? this.overridingProperty.equals(that.overridingProperty) : that.overridingProperty == null)) {
            return false;
        }
        if (this.propagated != that.propagated) {
            return false;
        }
        if (!this.qualifiers.equals(that.qualifiers)) {
            return false;
        }
        if (!(this.type != null ? this.type.equals(that.type) : that.type == null)) {
            return false;
        }
        if (!(this.value != null ? this.value.equals(that.value) : that.value == null)) {
            return false;
        }
        return this.name.equalsIgnoreCase(that.name);
    }

    public String getOriginClass() {
        return this.originClass;
    }

    public String getOverridingProperty() {
        return this.overridingProperty;
    }

    public int getSize() {
        if (this.value != null) {
            return this.value.getSize();
        }
        if (this.type != null) {
            return this.type.getSize();
        }
        return -1;
    }

    public CIMValue getValue() {
        return this.value;
    }

    public CIMDataType getType() {
        return this.type != null ? this.type : (this.value != null ? this.value.getType() : null);
    }

    public boolean isKey() {
        Iterator iter = this.qualifiers.iterator();
        while (iter.hasNext()) {
            CIMQualifier qualifier = (CIMQualifier)iter.next();
            if (!qualifier.getName().equalsIgnoreCase("Key") || qualifier.getValue() != null && !CIMValue.TRUE.equals(qualifier.getValue())) continue;
            return true;
        }
        return false;
    }

    public boolean isPropagated() {
        return this.propagated;
    }

    public boolean isReference() {
        if (this.type != null) {
            return this.type.isReferenceType();
        }
        if (this.value != null && this.value.getType() != null) {
            return this.value.getType().isReferenceType();
        }
        return false;
    }

    public boolean removeQualifier(String name) {
        if (name == null) {
            throw new IllegalArgumentException("null qualifier name exception");
        }
        Iterator iter = this.qualifiers.iterator();
        while (iter.hasNext()) {
            CIMQualifier qualifier = (CIMQualifier)iter.next();
            if (!qualifier.getName().equalsIgnoreCase(name)) continue;
            iter.remove();
            return true;
        }
        return false;
    }

    public void setKey(boolean key) {
        if (key) {
            this.addQualifier(new CIMQualifier("Key"));
        } else {
            this.removeQualifier("Key");
        }
    }

    public void setOverridingProperty(String newOverrringProperty) {
        this.overridingProperty = newOverrringProperty;
    }

    public void setOriginClass(String originClass) {
        this.originClass = originClass;
    }

    public void setPropagated(boolean propagated) {
        this.propagated = propagated;
    }

    public void setSize(int size) {
    }

    public void setType(CIMDataType type) {
        if (this.value == null) {
            this.type = type;
        } else if (this.value.getType() != null && this.value.getType().getType() != type.getType()) {
            throw new IllegalArgumentException("Specified data type does not match data type of argument value");
        }
    }

    public CIMQualifier setQualifier(CIMQualifier qualifier) throws CIMException {
        if (qualifier == null) {
            throw new IllegalArgumentException("null qualifier argument");
        }
        Iterator iter = this.qualifiers.iterator();
        while (iter.hasNext()) {
            CIMQualifier q = (CIMQualifier)iter.next();
            if (!q.getName().equalsIgnoreCase(qualifier.getName())) continue;
            q.setValue(qualifier.getValue());
            return q;
        }
        throw new CIMException("CIM_ERR_NOT_FOUND");
    }

    public void setValue(CIMValue value) {
        if (this.type != null && value != null && value.getType().getType() != this.type.getType()) {
            throw new IllegalArgumentException("value type does not match property type");
        }
        this.value = value;
        if (this.type == null && value != null) {
            this.type = value.getType();
        }
    }

    public String toMOF() {
        StringBuffer buf = new StringBuffer();
        if (this.name != null && this.name.length() > 0 && this.qualifiers.size() > 0) {
            buf.append(CIMProperty.vectorToMOFString(this.qualifiers, false, 1));
            buf.append('\n');
        }
        buf.append('\t');
        if (this.type != null) {
            buf.append(this.type.getStringType());
        } else {
            buf.append("null");
        }
        buf.append(' ');
        buf.append(this.name);
        if (this.type != null && this.type.isArrayType()) {
            if (this.type.getSize() > -1 && this.type.getType() != 30) {
                buf.append("[");
                buf.append(this.type.getSize());
                buf.append("]");
            } else {
                buf.append("[]");
            }
        }
        if (this.value != null) {
            buf.append(" = ");
            if (this.value == null) {
                buf.append("null");
            } else if (this.value.getType() != null && this.value.getType().isArrayType()) {
                buf.append('{');
                buf.append(CIMProperty.vectorToMOFString((Vector)this.value.getValue(), false, 0, 0, true));
                buf.append('}');
            } else {
                buf.append(this.value);
            }
        }
        buf.append(";\n");
        return buf.toString();
    }

    public String toString() {
        return this.toMOF();
    }
}

