/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.wbem.cim;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Vector;
import org.sblim.wbem.cim.CIMElement;
import org.sblim.wbem.cim.CIMQualifier;
import org.sblim.wbem.util.Utils;

public abstract class CIMQualifiableElement
extends CIMElement
implements Serializable {
    protected Vector qualifiers = new Vector(0);

    protected CIMQualifiableElement() {
    }

    protected CIMQualifiableElement(String name) {
        super(name);
    }

    public void addQualifier(CIMQualifier qualifier) {
        if (qualifier == null) {
            throw new IllegalArgumentException("null qualifier argument");
        }
        if (this.getQualifier(qualifier.getName()) == null) {
            Utils.addSorted(this.qualifiers, qualifier);
        }
    }

    public CIMQualifier getQualifier(String name) {
        if (name == null) {
            throw new IllegalArgumentException("null qualifier name argument");
        }
        Iterator iter = this.qualifiers.iterator();
        while (iter.hasNext()) {
            CIMQualifier qualifier = (CIMQualifier)iter.next();
            if (!qualifier.getName().equalsIgnoreCase(name)) continue;
            return qualifier;
        }
        return null;
    }

    public void setQualifiers(Vector qualifiers) {
        if (qualifiers == null) {
            this.qualifiers.setSize(0);
        } else {
            Utils.addSorted(this.qualifiers, qualifiers);
        }
    }

    public Vector getQualifiers() {
        return this.qualifiers;
    }

    public boolean removeQualifier(String qName) {
        if (qName == null) {
            throw new IllegalArgumentException("null qualifier argument");
        }
        Iterator iter = this.qualifiers.iterator();
        while (iter.hasNext()) {
            CIMQualifier qual = (CIMQualifier)iter.next();
            if (!qual.getName().equalsIgnoreCase(qName)) continue;
            iter.remove();
            return true;
        }
        return false;
    }
}

