/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.wbem.cim;

import java.util.Vector;
import org.sblim.wbem.cim.CIMElement;
import org.sblim.wbem.cim.CIMFlavor;
import org.sblim.wbem.cim.CIMQualifierType;
import org.sblim.wbem.cim.CIMValue;
import org.sblim.wbem.util.Utils;

public class CIMQualifier
extends CIMElement
implements Cloneable {
    private CIMValue value = null;
    private boolean propagated = false;
    private Vector flavors = new Vector(0);
    private CIMQualifierType type;

    public CIMQualifier() {
    }

    public CIMQualifier(String name) {
        super(name);
    }

    public CIMQualifier(String name, CIMQualifierType type) {
        super(name);
        this.setDefaults(type);
    }

    public void addFlavor(CIMFlavor flavor) {
        if (flavor == null) {
            throw new IllegalArgumentException("null flavor argument");
        }
        Utils.addSorted(this.flavors, flavor);
    }

    public Object clone() {
        CIMQualifier that = new CIMQualifier(this.name);
        that.propagated = this.propagated;
        if (this.type != null) {
            that.type = (CIMQualifierType)this.type.clone();
        }
        that.flavors = (Vector)this.flavors.clone();
        if (this.value != null) {
            that.value = (CIMValue)this.value.clone();
        }
        return that;
    }

    public boolean equals(Object o) {
        if (!(o instanceof CIMQualifier)) {
            return false;
        }
        CIMQualifier that = (CIMQualifier)o;
        if (!(this.value != null ? this.value.equals(that.value) : that.value == null)) {
            return false;
        }
        if (!(this.type != null ? this.type.equals(that.type) : that.type == null)) {
            return false;
        }
        if (this.propagated != that.propagated || !this.flavors.equals(that.flavors)) {
            return false;
        }
        return this.name.equalsIgnoreCase(that.name);
    }

    public int hashCode() {
        return (this.value != null ? this.value.hashCode() : 0) << 16 + (this.type != null ? this.type.hashCode() : 0) << 8 + (this.flavors.hashCode() + (this.propagated ? 1 : 0)) + this.name.toUpperCase().hashCode();
    }

    public Vector getFlavor() {
        return this.flavors;
    }

    public CIMValue getValue() {
        if (this.value == null && this.type != null) {
            return this.type.getDefaultValue();
        }
        return this.value;
    }

    public boolean hasFlavor(CIMFlavor flavor) {
        if (flavor == null) {
            throw new IllegalArgumentException("null flavor argument");
        }
        return Utils.hasValue(this.flavors, flavor);
    }

    public boolean hasValue() {
        return this.value != null;
    }

    public void setDefaults(CIMQualifierType qualifierType) {
        if (qualifierType == null) {
            throw new IllegalArgumentException("null qualifier type argument");
        }
        if (this.value == null && qualifierType.hasDefaultValue()) {
            this.value = qualifierType.getDefaultValue();
        }
        this.flavors = qualifierType.getFlavor();
        this.type = qualifierType;
    }

    public void setValue(CIMValue value) {
        this.value = value;
    }

    public void setPropagated(boolean bool) {
        this.propagated = bool;
    }

    public boolean isPropagated() {
        return this.propagated;
    }

    public String toMOF() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.name);
        if (this.value != null && this.value.getType() != null && this.value.getType().isArrayType()) {
            buf.append(CIMElement.vectorToMOFString((Vector)this.value.getValue(), false, 0, 3, true));
        } else if (this.value != null) {
            buf.append(" ( ");
            buf.append(this.value);
            buf.append(" )");
        }
        return buf.toString();
    }

    public String toString() {
        return this.toMOF();
    }

    public int compareTo(Object o) {
        if (!(o instanceof CIMQualifier)) {
            throw new IllegalArgumentException("Invalid object to compare with");
        }
        return this.name.toUpperCase().compareTo(((CIMQualifier)o).name.toUpperCase());
    }
}

