/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.wbem.client;

import java.util.Arrays;

public class PasswordCredential {
    private char[] password;
    private String hostname;

    public PasswordCredential() {
    }

    public PasswordCredential(String password) {
        this.password = password.toCharArray();
    }

    public PasswordCredential(char[] password) {
        this.password = null;
        if (password != null) {
            this.password = new char[password.length];
            System.arraycopy(password, 0, this.password, 0, password.length);
        }
    }

    public void clearUserPassword() {
        if (this.password != null) {
            for (int i = 0; i < this.password.length; ++i) {
                this.password[i] = '\u0000';
            }
        }
        this.password = null;
    }

    public String getHostName() {
        return this.hostname;
    }

    public char[] getUserPassword() {
        if (this.password != null) {
            char[] passwordCopy = new char[this.password.length];
            System.arraycopy(this.password, 0, passwordCopy, 0, this.password.length);
            return passwordCopy;
        }
        return null;
    }

    public void setHostName(String hostname) {
        this.hostname = hostname;
    }

    public void setUserPassword(char[] password) {
        this.clearUserPassword();
        if (password != null) {
            this.password = new char[password.length];
            System.arraycopy(password, 0, this.password, 0, password.length);
        }
    }

    public boolean equals(Object o) {
        if (o instanceof PasswordCredential) {
            PasswordCredential that = (PasswordCredential)o;
            if (!(this.hostname == null && that.hostname == null || this.hostname != null && this.hostname.equals(that.hostname))) {
                return false;
            }
            return Arrays.equals(this.password, that.password);
        }
        return false;
    }

    public int hashCode() {
        return (this.hostname != null ? this.hostname.hashCode() : 0) + (this.password != null ? this.password.hashCode() : 0);
    }
}

