/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.wbem.client.indications;

import java.util.Vector;
import org.sblim.wbem.client.indications.CIMEvent;
import org.sblim.wbem.client.indications.CIMIndicationListenertList;
import org.sblim.wbem.client.indications.CIMListener;

public class CIMEventDispatcher
extends Thread {
    protected Vector eventQueue = new Vector();
    protected CIMIndicationListenertList client = null;
    private boolean alive = true;

    public CIMEventDispatcher(CIMIndicationListenertList client) {
        this.client = client;
        this.setDaemon(true);
        this.setName("CIMListener - EventDispatcher");
        this.start();
    }

    public synchronized void dispatchEvent(CIMEvent event) {
        this.eventQueue.add(event);
        this.notify();
    }

    public synchronized void startup() {
        this.alive = true;
        this.start();
    }

    public synchronized void kill() {
        this.alive = false;
        this.notify();
    }

    public synchronized void close() {
        this.kill();
    }

    private synchronized CIMEvent getEvent() {
        CIMEvent event = null;
        while (event == null) {
            try {
                if (this.eventQueue.size() == 0) {
                    this.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!this.alive) break;
            if (this.eventQueue.size() <= 0) continue;
            event = (CIMEvent)this.eventQueue.remove(0);
        }
        return event;
    }

    public void run() {
        block0: while (true) {
            CIMEvent event = this.getEvent();
            if (!this.alive) break;
            Vector currentListeners = this.client.getListeners(event.getID());
            int total = currentListeners.size();
            int i = 0;
            while (true) {
                if (i >= total) continue block0;
                CIMListener listener = (CIMListener)currentListeners.elementAt(i);
                listener.indicationOccured(event);
                ++i;
            }
            break;
        }
    }
}

