/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.wbem.client.indications;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.sblim.wbem.cim.CIMException;
import org.sblim.wbem.cim.CIMInstance;
import org.sblim.wbem.client.indications.CIMError;
import org.sblim.wbem.client.indications.CIMEvent;
import org.sblim.wbem.client.indications.CIMEventDispatcher;
import org.sblim.wbem.http.HttpContentHandler;
import org.sblim.wbem.http.HttpException;
import org.sblim.wbem.http.HttpHeader;
import org.sblim.wbem.http.HttpHeaderParser;
import org.sblim.wbem.http.MessageReader;
import org.sblim.wbem.http.MessageWriter;
import org.sblim.wbem.http.io.DebugInputStream;
import org.sblim.wbem.util.GlobalProperties;
import org.sblim.wbem.xml.CIMClientXML_HelperImpl;
import org.sblim.wbem.xml.CIMRequest;
import org.sblim.wbem.xml.CIMResponse;
import org.sblim.wbem.xml.CIMXMLBuilderImpl;
import org.sblim.wbem.xml.CIMXMLParserImpl;
import org.sblim.wbem.xml.XMLDefaultHandlerImpl;
import org.sblim.wbem.xml.parser.XMLPullParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public class CIMIndicationHandler
extends HttpContentHandler {
    CIMEventDispatcher dispatcher = null;
    int msgID = 0;

    public CIMIndicationHandler(CIMEventDispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    public void close() {
        if (this.dispatcher != null) {
            this.dispatcher.close();
        }
    }

    public synchronized int getMsgID() {
        ++this.msgID;
        if (this.msgID > 1000000) {
            this.msgID = 0;
        }
        return this.msgID;
    }

    public void handleContent(MessageReader mr, MessageWriter mw, InetAddress pInetAddress) throws HttpException, IOException {
        Document responseDoc;
        CIMError error = null;
        HttpHeader inputHeader = mr.getHeader();
        inputHeader = this.parseHeaders(inputHeader);
        String cimExport = inputHeader.getField("CIMExport");
        String cimExportMethod = inputHeader.getField("CIMExportMethod");
        String cimOperation = inputHeader.getField("CIMOperation");
        String cimMethod = inputHeader.getField("CIMMethod");
        if (cimOperation != null && !"MethodCall".equalsIgnoreCase(cimOperation)) {
            mw.getHeader().addField("CIMError", "unsupported-operation");
            throw new HttpException(400, "Bad Request");
        }
        if (cimExport != null && !"MethodRequest".equalsIgnoreCase(cimExport) && !"ExportMethodCall".equalsIgnoreCase(cimExport)) {
            mw.getHeader().addField("CIMError", "unsupported-operation");
            throw new HttpException(400, "Bad Request");
        }
        if (cimOperation == null && cimExport == null) {
            mw.getHeader().addField("CIMError", "unsupported-operation");
            throw new HttpException(400, "Bad Request");
        }
        CIMRequest request = null;
        CIMClientXML_HelperImpl xmlHelper = null;
        try {
            xmlHelper = new CIMClientXML_HelperImpl();
        }
        catch (ParserConfigurationException e1) {
            IOException e = new IOException("ParserConfigurationException");
            e.initCause(e1);
            throw e;
        }
        InputStream inputstream = null;
        inputstream = GlobalProperties.isDebugInputStream() ? new DebugInputStream(mr.getInputStream(), GlobalProperties.getDebugOutputStream()) : mr.getInputStream();
        if (GlobalProperties.getXmlParser() == 2) {
            Document doc = null;
            try {
                doc = xmlHelper.parse(new InputSource(new InputStreamReader(inputstream, mr.getCharacterEncoding())));
                if (GlobalProperties.isDebugXMLInput()) {
                    CIMClientXML_HelperImpl.dumpDocument(doc);
                }
                Element rootE = doc.getDocumentElement();
                request = (CIMRequest)CIMXMLParserImpl.parseCIM(rootE);
            }
            catch (Exception e) {
                Logger logger = GlobalProperties.getLogger();
                if (logger.isLoggable(Level.WARNING)) {
                    logger.log(Level.WARNING, "exception while parsing the XML with DOM parser", e);
                }
                throw new HttpException(400, "Bad Request");
            }
        }
        XMLDefaultHandlerImpl hndlr = new XMLDefaultHandlerImpl();
        if (GlobalProperties.getXmlParser() == 1) {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            try {
                SAXParser saxParser = factory.newSAXParser();
                saxParser.parse(new InputSource(new InputStreamReader(inputstream, mr.getCharacterEncoding())), (DefaultHandler)hndlr);
            }
            catch (Exception e) {
                Logger logger = GlobalProperties.getLogger();
                if (logger.isLoggable(Level.WARNING)) {
                    logger.log(Level.WARNING, "exception while parsing the XML with XML parser", e);
                }
                throw new HttpException(400, "Bad Request");
            }
        }
        XMLPullParser pullParser = new XMLPullParser(new InputStreamReader(inputstream, mr.getCharacterEncoding()));
        try {
            hndlr.parse(pullParser);
        }
        catch (Exception e) {
            Logger logger = GlobalProperties.getLogger();
            if (logger.isLoggable(Level.WARNING)) {
                logger.log(Level.WARNING, "exception while parsing the XML with PullBased parser", e);
            }
            throw new HttpException(400, "Bad Request");
        }
        Vector o = hndlr.getObjects();
        request = (CIMRequest)o.elementAt(0);
        if (request == null) {
            throw new HttpException(400, "Bad Request");
        }
        CIMResponse response = new CIMResponse(request);
        if ((cimExport != null || "Indication".equalsIgnoreCase(cimMethod)) && request.isCIMExport()) {
            try {
                Vector paramValue = request.getParamValue();
                if (paramValue.size() > 0 && paramValue.elementAt(0) instanceof CIMInstance) {
                    CIMInstance indicationInst = (CIMInstance)paramValue.elementAt(0);
                    String id = mr.getMethod().getFile();
                    id = id != null && id.startsWith("/") && id.length() > 1 && !id.equalsIgnoreCase("/cimom") ? id.substring(1) : "0";
                    this.dispatcher.dispatchEvent(new CIMEvent(indicationInst, id, pInetAddress));
                }
            }
            catch (Exception e) {
                error = new CIMError(CIMException.getStatusCode("CIM_ERR_FAILED"));
            }
            catch (Throwable t) {
                error = new CIMError(new CIMException("CIM_ERR_FAILED", t));
            }
            responseDoc = null;
            try {
                DocumentBuilder docBuilder = xmlHelper.getDocumentBuilder();
                responseDoc = docBuilder.newDocument();
                CIMXMLBuilderImpl.createIndication_response(responseDoc, this.getMsgID(), error);
            }
            catch (Exception e) {
                throw new HttpException(400, "Bad Request");
            }
        }
        throw new HttpException(400, "Bad Request");
        CIMClientXML_HelperImpl.serialize(mw.getOutputStream(), responseDoc);
        mw.getHeader().addField("CIMExport", "MethodResponse");
    }

    private HttpHeader parseHeaders(HttpHeader originalHeader) {
        String man = originalHeader.getField("Man");
        String opt = originalHeader.getField("Opt");
        HttpHeader headers = new HttpHeader();
        String ns = null;
        HttpHeaderParser manOptHeader = null;
        if (man != null && man.length() > 0) {
            manOptHeader = new HttpHeaderParser(man);
        } else if (opt != null && opt.length() > 0) {
            manOptHeader = new HttpHeaderParser(opt);
        }
        if (manOptHeader != null) {
            ns = manOptHeader.findValue("ns");
        }
        if (ns != null) {
            Iterator iter = originalHeader.iterator();
            boolean i = false;
            while (iter.hasNext()) {
                Map.Entry entry = (Map.Entry)iter.next();
                if (entry == null) continue;
                String key = entry.getKey().toString();
                if (key.startsWith(ns + "-")) {
                    headers.addField(key.substring(3), entry.getValue().toString());
                    continue;
                }
                headers.addField(key, entry.getValue().toString());
            }
        } else {
            headers = originalHeader;
        }
        return headers;
    }
}

