/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.wbem.http;

import java.io.IOException;
import java.io.InputStream;
import org.sblim.wbem.http.HttpException;
import org.sblim.wbem.http.HttpMethod;
import org.sblim.wbem.http.io.ASCIIPrintStream;

public class HttpClientMethod
extends HttpMethod {
    private boolean incomming = true;
    private String httpHeader;
    private int minor;
    private int major;
    private int status;
    private String method;
    private String request;
    private String response;

    public HttpClientMethod(String method, String request, int major, int minor) {
        this.minor = minor;
        this.major = major;
        this.request = request;
        this.method = method;
        this.incomming = false;
    }

    public HttpClientMethod(InputStream reader) throws IOException {
        String line = null;
        while ((line = HttpClientMethod.readLine(reader)) == null || line.length() == 0) {
        }
        int rqt = line.indexOf(32);
        int prev = 0;
        if (rqt > -1) {
            int next = rqt;
            this.httpHeader = line.substring(prev, next).toUpperCase();
            prev = this.httpHeader.indexOf(47);
            if (prev > 0 && this.httpHeader.substring(0, prev).equalsIgnoreCase("HTTP")) {
                next = this.httpHeader.indexOf(46, prev + 1);
                try {
                    this.major = Integer.parseInt(this.httpHeader.substring(prev + 1, next));
                    this.minor = Integer.parseInt(this.httpHeader.substring(next + 1));
                }
                catch (Exception e) {
                    throw new HttpException(405, "Bad method");
                }
                prev = rqt;
                rqt = line.indexOf(32, prev + 1);
                if (rqt > -1) {
                    try {
                        this.status = Integer.parseInt(line.substring(prev + 1, rqt));
                    }
                    catch (Exception e) {
                        throw new HttpException(405, "Bad method");
                    }
                    this.response = line.substring(rqt + 1);
                    return;
                }
            } else {
                throw new HttpException(405, "Bad method");
            }
        }
        throw new HttpException(405, "Bad method");
    }

    public int getMajorVersion() {
        return this.major;
    }

    public int getMinorVersion() {
        return this.minor;
    }

    public String getMethodName() {
        return this.method;
    }

    public int getStatus() {
        return this.status;
    }

    public void write(ASCIIPrintStream dos) throws IOException {
        dos.print(this.method + " " + this.request + " HTTP/" + this.major + "." + this.minor + "\r\n");
    }

    public String getResponseMessage() {
        return this.response;
    }

    public String toString() {
        if (this.incomming) {
            return this.httpHeader + " " + this.status + " " + this.response;
        }
        return this.method + " " + this.request + " HTTP/" + this.major + "." + this.minor;
    }
}

