/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.wbem.http;

import java.io.IOException;
import java.io.InputStream;
import org.sblim.wbem.http.HttpException;
import org.sblim.wbem.http.HttpMethod;
import org.sblim.wbem.http.io.ASCIIPrintStream;

public class HttpServerMethod
extends HttpMethod {
    private String methodName;
    private String file;
    private String protocol;
    private int minor;
    private int major;
    private int status;
    private String reason;

    public HttpServerMethod(int major, int minor, int status, String reason) {
        this.minor = minor;
        this.major = major;
        this.status = status;
        this.reason = reason;
    }

    public HttpServerMethod(InputStream reader) throws IOException, HttpException {
        String line;
        while ((line = HttpServerMethod.readLine(reader)) == null || line.length() == 0) {
        }
        int next = line.indexOf(32);
        int prev = 0;
        if (next > -1) {
            this.methodName = line.substring(0, next).toUpperCase();
            if (this.methodName.equals("GET") && line.indexOf(32, next + 1) == -1) {
                this.file = line.substring(next + 1);
            } else {
                prev = next + 1;
                next = line.indexOf(32, prev);
                this.file = line.substring(prev, next);
                prev = next + 1;
                this.protocol = line.substring(prev).toUpperCase();
                prev = this.protocol.indexOf(47);
                next = this.protocol.indexOf(46, prev + 1);
                try {
                    this.major = Integer.parseInt(this.protocol.substring(prev + 1, next));
                    this.minor = Integer.parseInt(this.protocol.substring(next + 1));
                }
                catch (Exception e) {
                    throw new HttpException(405, "Bad method");
                }
            }
        } else {
            throw new HttpException(405, "Bad method");
        }
    }

    public int getMajorVersion() {
        return this.major;
    }

    public int getMinorVersion() {
        return this.minor;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getFile() {
        return this.file;
    }

    public void write(ASCIIPrintStream dos) throws IOException {
        dos.print("HTTP/" + this.major + "." + this.minor + " " + this.status + " " + this.reason + "\r\n");
    }
}

