/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.wbem.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;

public class GlobalProperties
extends Properties {
    private static final String CLASSNAME = "org.sblim.wbem.util.GlobalProperties";
    private static final String CIMCLIENT_PROPERTIES = "cimclient.properties";
    private static final String HTTP_TIME_OUT = "http.timeout";
    private static final String HTTP_CONNECTION_POOL_SIZE = "http.pool.size";
    private static final String TRUSTSTORE = "https.truststore.path";
    private static final String TRUSTSTORE_PASSWORD = "https.truststore.password";
    private static final String KEYSTSTORE = "https.keystore.path";
    private static final String KEYSTSTORE_PASSWORD = "https.keystore.password";
    private static final String JSSE_PROVIDER = "https.provider";
    private static final String JSSE_CERTIFICATE = "https.certificate";
    private static final String XML_PARSER = "xml.parser";
    private static final String DEBUG_ISTREAM = "debug.istream";
    private static final String DEBUG_HTTP_POOL = "debug.http.pool";
    private static final String DEBUG_ISTREAM_OUTPUT = "debug.istream.output";
    private static final String DEBUG_XML_INPUT = "debug.xml.input";
    private static final String DEBUG_XML_OUTPUT = "debug.xml.output";
    private static final String LOGGER = "logger";
    private static final String LOG_OUTPUT = "log.output";
    private static final String LOG_CONSOLE_LEVEL = "log.console.level";
    private static final String LOG_FILE_LEVEL = "log.file.level";
    private static final Level DEFAULT_LOGGER_LEVEL;
    private static final Level DEFAULT_LOGGER_CONSOLE_LEVEL;
    private static final Level DEFAULT_LOGGER_FILE_LEVEL;
    private static final int DEFAULT_HTTP_CONNECTION_POOL_SIZE = 16;
    private static final String DEFAULT_PROPERTIES = "cim.defaults";
    public static final int PULL_PARSER = 0;
    public static final int SAX_PARSER = 1;
    public static final int DOM_PARSER = 2;
    private static final int DEFAULT_XML_PARSER = 0;
    public static final int DEVELOPER = 1;
    private static final int DEFAULT_DEBUG_LEVEL = 1;
    private static final String DEFAULT_LOG_OUTPUT = "cimclient.log";
    private static final int DEFAULT_HTTP_TIME_OUT = 0;
    private static final String DEFAULT_TRUSTSTORE = "truststore";
    private static final char[] DEFAULT_TRUSTSTORE_PASSWORD;
    private static final String DEFAULT_KEYSTORE = "keystore";
    private static final char[] DEFAULT_KEYSTORE_PASSWORD;
    private static final String DEFAULT_JSSE_PROVIDER = "com.ibm.jsse.IBMJSSEProvider";
    private static final String DEFAULT_JSSE_CERTIFICATE = "IbmX509";
    private static int httpTimeOut;
    private static String truststore;
    private static char[] truststore_password;
    private static String keystore;
    private static char[] keystore_password;
    private static String jsseCertificate;
    private static String jsseProvider;
    private static int xmlParser;
    private static boolean debugInputStream;
    private static boolean debugXMLInput;
    private static boolean debugXMLOutput;
    private static boolean debugHttpPool;
    private static GlobalProperties global;
    private static OutputStream out;
    private static int connectionPoolSize;
    private static String CREDENTIALS_DEFAULT_ENABLED;
    private static String DEFAULT_PRINCIPAL;
    private static String DEFAULT_CREDENTIAL;
    private static final String DEFAULT_PRINCIPAL_VALUE = "default";
    private static final String DEFAULT_CREDENTIALS_VALUE = "default";
    private static boolean credentialsDefaultEnabled;
    private static String defaultPrincipal;
    private static String defaultCredentials;
    private static Logger logger;

    private GlobalProperties() {
    }

    public static int getIntProperty(String key, int defaultValue) {
        int value;
        block2: {
            String methodName = "getIntProperty(String key, int defaultValue)";
            String property = global.getProperty(key, String.valueOf(defaultValue));
            value = defaultValue;
            try {
                value = Integer.parseInt(property);
            }
            catch (Exception e) {
                if (!logger.isLoggable(Level.WARNING)) break block2;
                logger.logp(Level.WARNING, CLASSNAME, methodName, "Unable to parse value of property " + key, e);
            }
        }
        return value;
    }

    public static boolean getBooleanProperty(String key, boolean defaultValue) {
        String property = global.getProperty(key, String.valueOf(defaultValue));
        boolean value = defaultValue;
        boolean bl = value = property.equalsIgnoreCase("true") || property.equalsIgnoreCase("yes");
        if (value) {
            return value;
        }
        boolean bl2 = value = property.equalsIgnoreCase("false") || property.equalsIgnoreCase("no");
        if (value) {
            return !value;
        }
        return defaultValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadProperties() {
        GlobalProperties.global.defaults = new Properties();
        File file = new File(DEFAULT_PROPERTIES);
        try {
            if (file.exists()) {
                GlobalProperties.global.defaults.load(new FileInputStream(file));
                boolean bl = true;
                return bl;
            }
            file = new File(CIMCLIENT_PROPERTIES);
            if (file.exists()) {
                GlobalProperties.global.defaults.load(new FileInputStream(file));
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception e) {
            System.err.println("Failed to load file " + file.getName());
            e.printStackTrace();
        }
        finally {
            GlobalProperties.loadLoggingFramework();
            GlobalProperties.setProperties();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean loadProperties(String propertyFile) {
        try {
            File file = new File(propertyFile);
            if (file.exists()) {
                GlobalProperties.global.defaults = new Properties();
                GlobalProperties.global.defaults.load(new FileInputStream(file));
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception e) {
            System.err.println("Failed to load file " + propertyFile);
        }
        finally {
            GlobalProperties.setLogLevels();
            GlobalProperties.setProperties();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean loadProperties(Properties properties) {
        try {
            if (properties == null) {
                throw new IllegalArgumentException("null argument");
            }
            GlobalProperties.global.defaults = new Properties(properties);
        }
        finally {
            GlobalProperties.setLogLevels();
            GlobalProperties.setProperties();
        }
        return true;
    }

    private static void setLogLevels() {
        Level logConsoleLevel;
        Level logFileLevel = GlobalProperties.getLevel(global.getProperty(LOG_FILE_LEVEL, DEFAULT_LOGGER_FILE_LEVEL.getName()));
        if (logFileLevel == null) {
            logFileLevel = DEFAULT_LOGGER_FILE_LEVEL;
        }
        if ((logConsoleLevel = GlobalProperties.getLevel(global.getProperty(LOG_CONSOLE_LEVEL, DEFAULT_LOGGER_CONSOLE_LEVEL.getName()))) == null) {
            logConsoleLevel = DEFAULT_LOGGER_CONSOLE_LEVEL;
        }
        Handler[] handlers = logger.getHandlers();
        for (int i = 0; i < handlers.length; ++i) {
            if (handlers[i] instanceof ConsoleHandler) {
                handlers[i].setLevel(logConsoleLevel);
                continue;
            }
            if (!(handlers[i] instanceof FileHandler)) continue;
            handlers[i].setLevel(logFileLevel);
        }
        if (!GlobalProperties.getBooleanProperty(LOGGER, false)) {
            logger.setLevel(Level.OFF);
        } else {
            logger.setLevel(Level.ALL);
        }
        logger.log(Level.CONFIG, "Console Logging Level = " + logConsoleLevel);
        logger.log(Level.CONFIG, "File Logging Level    = " + logFileLevel);
    }

    private static void loadLoggingFramework() {
        Level logConsoleLevel;
        logger = Logger.getLogger("org.sblim.wbem.cimclient");
        Level logFileLevel = GlobalProperties.getLevel(global.getProperty(LOG_FILE_LEVEL, DEFAULT_LOGGER_FILE_LEVEL.getName()));
        if (logFileLevel == null) {
            logFileLevel = DEFAULT_LOGGER_FILE_LEVEL;
        }
        if ((logConsoleLevel = GlobalProperties.getLevel(global.getProperty(LOG_CONSOLE_LEVEL, DEFAULT_LOGGER_CONSOLE_LEVEL.getName()))) == null) {
            logConsoleLevel = DEFAULT_LOGGER_CONSOLE_LEVEL;
        }
        ConsoleHandler consoleHandler = new ConsoleHandler();
        consoleHandler.setLevel(logConsoleLevel);
        logger.addHandler(consoleHandler);
        String logOutputFileName = global.getProperty(LOG_OUTPUT, DEFAULT_LOG_OUTPUT);
        File logOutputFile = new File(logOutputFileName);
        FileHandler fileHandler = null;
        try {
            if (!logOutputFile.exists()) {
                logOutputFile.createNewFile();
            }
            fileHandler = new FileHandler(logOutputFile.getAbsolutePath());
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Logging into file " + logOutputFileName + " could not be established.", e);
            try {
                fileHandler = new FileHandler();
            }
            catch (Exception e1) {
                fileHandler = null;
                logger.log(Level.SEVERE, "Logging into file specified in <JRE>/lib/logging.properties could not be established.", e1);
            }
        }
        if (fileHandler != null) {
            fileHandler.setLevel(logFileLevel);
            fileHandler.setFormatter(new SimpleFormatter());
            logger.addHandler(fileHandler);
            logger.log(Level.CONFIG, "fileHandler is set up properly. Logging into " + logOutputFileName);
        }
        if (!GlobalProperties.getBooleanProperty(LOGGER, false)) {
            logger.setLevel(Level.OFF);
        } else {
            logger.setLevel(Level.ALL);
        }
        logger.log(Level.CONFIG, "Console Logging Level = " + logConsoleLevel);
        logger.log(Level.CONFIG, "File Logging Level    = " + logFileLevel);
    }

    private static void setProperties() {
        xmlParser = GlobalProperties.getIntProperty(XML_PARSER, 0);
        httpTimeOut = GlobalProperties.getIntProperty(HTTP_TIME_OUT, 0);
        keystore = global.getProperty(KEYSTSTORE, DEFAULT_KEYSTORE);
        String keystorePass = global.getProperty(KEYSTSTORE_PASSWORD, null);
        if (keystorePass != null) {
            keystore_password = keystorePass.toCharArray();
        }
        truststore = global.getProperty(TRUSTSTORE, DEFAULT_TRUSTSTORE);
        String truststorePass = global.getProperty(TRUSTSTORE_PASSWORD, null);
        if (truststorePass != null) {
            truststore_password = truststorePass.toCharArray();
        }
        connectionPoolSize = GlobalProperties.getIntProperty(HTTP_CONNECTION_POOL_SIZE, 16);
        jsseProvider = global.getProperty(JSSE_PROVIDER, DEFAULT_JSSE_PROVIDER);
        jsseCertificate = global.getProperty(JSSE_CERTIFICATE, DEFAULT_JSSE_CERTIFICATE);
        debugHttpPool = GlobalProperties.getBooleanProperty(DEBUG_HTTP_POOL, false);
        debugInputStream = GlobalProperties.getBooleanProperty(DEBUG_ISTREAM, false);
        debugXMLInput = GlobalProperties.getBooleanProperty(DEBUG_XML_INPUT, false);
        debugXMLOutput = GlobalProperties.getBooleanProperty(DEBUG_XML_OUTPUT, false);
        String dbgIStreamOutputStream = global.getProperty(DEBUG_ISTREAM_OUTPUT, "stdout");
        credentialsDefaultEnabled = GlobalProperties.getBooleanProperty(CREDENTIALS_DEFAULT_ENABLED, false);
        defaultPrincipal = global.getProperty(DEFAULT_PRINCIPAL, "default");
        defaultCredentials = global.getProperty(DEFAULT_CREDENTIAL, "default");
        if ("stdout".equalsIgnoreCase(dbgIStreamOutputStream)) {
            out = System.out;
        } else {
            try {
                out = new FileOutputStream(new File(dbgIStreamOutputStream));
            }
            catch (IOException e) {
                out = System.out;
            }
        }
    }

    public static OutputStream getDebugOutputStream() {
        return out;
    }

    public static void setDebugOutputStream(OutputStream out) {
        GlobalProperties.out = out;
    }

    protected static Level getLevel(String level) {
        Level lvl = null;
        lvl = level == null || level.trim().length() == 0 ? DEFAULT_LOGGER_LEVEL : (level.equalsIgnoreCase(Level.OFF.getName()) ? Level.OFF : (level.equalsIgnoreCase(Level.SEVERE.getName()) ? Level.SEVERE : (level.equalsIgnoreCase(Level.WARNING.getName()) ? Level.WARNING : (level.equalsIgnoreCase(Level.INFO.getName()) ? Level.INFO : (level.equalsIgnoreCase(Level.CONFIG.getName()) ? Level.CONFIG : (level.equalsIgnoreCase(Level.FINE.getName()) ? Level.FINE : (level.equalsIgnoreCase(Level.FINER.getName()) ? Level.FINER : (level.equalsIgnoreCase(Level.FINEST.getName()) ? Level.FINEST : (level.equalsIgnoreCase(Level.ALL.getName()) ? Level.ALL : DEFAULT_LOGGER_LEVEL)))))))));
        return lvl;
    }

    public static Logger getLogger() {
        return logger;
    }

    public static void setLogger(Logger newLogger) {
        logger = newLogger;
    }

    public static String getKeystore() {
        return keystore;
    }

    public static String getTruststore() {
        return truststore;
    }

    public static String getTruststore_password() {
        if (truststore_password != null) {
            return new String(truststore_password);
        }
        return null;
    }

    public static char[] getTruststorePassword() {
        if (truststore_password != null) {
            return (char[])truststore_password.clone();
        }
        return null;
    }

    public static char[] getKeystorePassword() {
        if (keystore_password != null) {
            return (char[])keystore_password.clone();
        }
        return null;
    }

    public static int getXmlParser() {
        return xmlParser;
    }

    public static void setKeystore(String string) {
        keystore = string;
    }

    public static void setTruststore(String string) {
        truststore = string;
    }

    public static void setTruststore_password(String newPassword) {
        if (newPassword != null) {
            if (truststore_password != null) {
                for (int i = 0; i < truststore_password.length; ++i) {
                    GlobalProperties.truststore_password[i] = '\u0000';
                }
            }
            truststore_password = newPassword.toCharArray();
        } else {
            if (truststore_password != null) {
                for (int i = 0; i < truststore_password.length; ++i) {
                    GlobalProperties.truststore_password[i] = '\u0000';
                }
            }
            truststore_password = null;
        }
    }

    public static void setTruststore_password(char[] newPassword) {
        int i;
        if (truststore_password != null) {
            for (i = 0; i < truststore_password.length; ++i) {
                GlobalProperties.truststore_password[i] = '\u0000';
            }
        }
        if (newPassword != null) {
            truststore_password = new char[newPassword.length];
            for (i = 0; i < truststore_password.length; ++i) {
                GlobalProperties.truststore_password[i] = newPassword[i];
            }
        } else {
            truststore_password = newPassword;
        }
    }

    public static void setKeystore_password(char[] newPassword) {
        int i;
        if (keystore_password != null) {
            for (i = 0; i < keystore_password.length; ++i) {
                GlobalProperties.keystore_password[i] = '\u0000';
            }
        }
        if (newPassword != null) {
            keystore_password = new char[newPassword.length];
            for (i = 0; i < keystore_password.length; ++i) {
                GlobalProperties.keystore_password[i] = newPassword[i];
            }
        } else {
            keystore_password = newPassword;
        }
    }

    public static void setXmlParser(int i) {
        xmlParser = i;
    }

    public static int getHttpTimeOut() {
        return httpTimeOut;
    }

    public static void setHttpTimeOut(int i) {
        if (i < 0) {
            throw new IllegalArgumentException("invalid time out value: " + i);
        }
        httpTimeOut = i;
    }

    public static void setDebugXMLInput(boolean bool) {
        debugXMLInput = bool;
    }

    public static void setDebugXMLOutput(boolean bool) {
        debugXMLOutput = bool;
    }

    public static boolean isDebugXMLInput() {
        return debugXMLInput;
    }

    public static boolean isDebugXMLOutput() {
        return debugXMLOutput;
    }

    public static boolean isDebugInputStream() {
        return debugInputStream;
    }

    public static void setDebugInputStream(boolean bool) {
        debugInputStream = bool;
    }

    public static int getConnectionPoolSize() {
        return connectionPoolSize;
    }

    public static void setConnectionPoolSize(int size) {
        connectionPoolSize = size;
    }

    public static boolean isDebugHttpConnectionPool() {
        return debugHttpPool;
    }

    public static void setDebugHttpConnectionPool(boolean bool) {
        debugHttpPool = bool;
    }

    public static String getJSSEProvider() {
        return jsseProvider;
    }

    public static void setJSSEProvider(String prov) {
        jsseProvider = prov;
    }

    public static String getJSSECertificate() {
        return jsseCertificate;
    }

    public static void setJSSECertificate(String cert) {
        jsseCertificate = cert;
    }

    public static boolean isCredentialsDefaultEnabled() {
        return credentialsDefaultEnabled;
    }

    public static void setCredentialsDefaultEnabled(boolean credentialsDefaultEnabled) {
        GlobalProperties.credentialsDefaultEnabled = credentialsDefaultEnabled;
    }

    public static String getDefaultCredentials() {
        return defaultCredentials;
    }

    public static void setDefaultCredentials(String credentialsPassword) {
        defaultCredentials = credentialsPassword;
    }

    public static String getDefaultPrincipal() {
        return defaultPrincipal;
    }

    public static void setDefaultPrincipal(String credentialsUser) {
        defaultPrincipal = credentialsUser;
    }

    public static void main(String[] args) {
        GlobalProperties prop = new GlobalProperties();
        GlobalProperties.loadProperties(".//cim.defaults");
        char[] pass = GlobalProperties.getTruststorePassword();
        System.out.println("Password:" + (pass != null ? new String(pass) : "null"));
        GlobalProperties.setTruststore_password("password".toCharArray());
        pass = GlobalProperties.getTruststorePassword();
        System.out.println("Password:" + (pass != null ? new String(pass) : "null"));
        GlobalProperties.setTruststore_password((String)null);
        pass = GlobalProperties.getTruststorePassword();
        System.out.println("Password:" + (pass != null ? new String(pass) : "null"));
        GlobalProperties.setTruststore_password((char[])null);
        pass = GlobalProperties.getTruststorePassword();
        System.out.println("Password:" + (pass != null ? new String(pass) : "null"));
    }

    static {
        block2: {
            DEFAULT_LOGGER_LEVEL = Level.WARNING;
            DEFAULT_LOGGER_CONSOLE_LEVEL = Level.WARNING;
            DEFAULT_LOGGER_FILE_LEVEL = Level.WARNING;
            DEFAULT_TRUSTSTORE_PASSWORD = null;
            DEFAULT_KEYSTORE_PASSWORD = null;
            connectionPoolSize = 16;
            CREDENTIALS_DEFAULT_ENABLED = "default.authorization.enabled";
            DEFAULT_PRINCIPAL = "default.principal";
            DEFAULT_CREDENTIAL = "default.credential";
            try {
                global = new GlobalProperties();
                global.loadProperties();
            }
            catch (Exception e) {
                if (!logger.isLoggable(Level.WARNING)) break block2;
                logger.logp(Level.WARNING, CLASSNAME, "getIntProperty", "Unable to load the properties file", e);
            }
        }
    }
}

