/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.wbem.util;

import java.util.Iterator;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.sblim.wbem.util.GlobalProperties;

public class ThreadPool {
    private Vector idleThreads = new Vector();
    private Vector threadPool = new Vector();
    private Vector queue = new Vector();
    private static ThreadGroup group = new ThreadGroup("TreadPool Group");
    private long idleTimeout = 5000L;
    private int maxPoolSize = 5;
    private int minPoolSize = 2;
    private int threadCounter = 0;
    private int priority = 5;
    private int cntr = 0;
    private boolean shutdown = false;
    private static ThreadPool instance;

    public ThreadPool() {
        this(2, 5);
    }

    private int getID() {
        ++this.cntr;
        if (this.cntr > 1000000) {
            this.cntr = 0;
        }
        return this.cntr;
    }

    public ThreadPool(int minPoolSize, int maxPoolSize) {
        this.minPoolSize = minPoolSize;
        this.maxPoolSize = maxPoolSize;
        for (int i = 0; i < minPoolSize; ++i) {
            Worker worker = new Worker(this, "WorkerThread " + (this.getID() + 1));
            this.threadPool.add(worker);
            worker.start();
        }
    }

    public static synchronized ThreadPool getInstance() {
        if (instance == null) {
            instance = new ThreadPool();
        }
        return instance;
    }

    public synchronized long getIdleTimeOutMs() {
        return this.idleThreads.size() <= this.minPoolSize ? -1L : this.idleTimeout;
    }

    public boolean execute(Runnable task) {
        return this.execute(task, true);
    }

    public synchronized boolean execute(Runnable task, boolean enqueue) {
        if (this.shutdown) {
            return false;
        }
        int totalIdle = this.idleThreads.size();
        if (totalIdle > 0) {
            Worker worker = (Worker)this.idleThreads.remove(totalIdle - 1);
            return worker.assignTask(task);
        }
        if (this.maxPoolSize == -1 || this.threadPool.size() <= this.maxPoolSize) {
            Worker worker = this.createWorker();
            return worker.assignTask(task);
        }
        if (!enqueue) {
            return false;
        }
        this.queue.add(task);
        return true;
    }

    protected synchronized Worker createWorker() {
        Worker worker = new Worker(this, "WorkerThread " + (this.getID() + 1));
        this.threadPool.add(worker);
        return worker;
    }

    public synchronized ThreadGroup getGroup() {
        return group;
    }

    public synchronized boolean taskCompleted(Worker worker, boolean timeout) {
        if (this.shutdown) {
            return false;
        }
        if (this.queue.size() > 0) {
            this.idleThreads.remove(worker);
            worker.assignTask((Runnable)this.queue.remove(0));
            return true;
        }
        if (timeout && this.threadPool.size() > this.minPoolSize) {
            this.idleThreads.remove(worker);
            this.threadPool.remove(worker);
            return false;
        }
        if (this.maxPoolSize == -1 || this.threadPool.size() <= this.maxPoolSize) {
            if (!this.idleThreads.contains(worker)) {
                this.idleThreads.add(worker);
            }
            return true;
        }
        return false;
    }

    private synchronized void removeThread(Worker worker) {
        if (worker != null && this.threadPool != null) {
            this.threadPool.remove(worker);
        }
    }

    public synchronized void shutdown() {
        if (!this.shutdown) {
            Worker worker;
            Iterator iter;
            this.shutdown = true;
            if (this.idleThreads != null) {
                iter = this.idleThreads.iterator();
                while (iter.hasNext()) {
                    worker = (Worker)iter.next();
                    worker.kill();
                }
                this.idleThreads = null;
            }
            if (this.threadPool != null) {
                iter = this.threadPool.iterator();
                while (iter.hasNext()) {
                    worker = (Worker)iter.next();
                    worker.kill();
                }
                this.threadPool = null;
            }
        }
    }

    private class Worker
    extends Thread {
        private boolean alive = true;
        private boolean started;
        private ThreadPool pool;
        private Runnable task;

        public Worker(ThreadPool pool) {
            this(pool, "WorkerThread " + (this$0.threadPool.size() + 1));
        }

        public Worker(ThreadPool pool, String name) {
            super(pool.getGroup(), name);
            this.pool = pool;
            this.setDaemon(true);
        }

        public synchronized void start() {
            this.started = true;
            this.alive = true;
            super.start();
        }

        public synchronized void kill() {
            this.alive = false;
            this.started = false;
            this.notify();
        }

        public synchronized boolean assignTask(Runnable task) {
            if (this.alive) {
                this.task = task;
                if (!this.started) {
                    this.start();
                }
                this.notify();
                return true;
            }
            return false;
        }

        private synchronized Runnable waitForTask() {
            boolean timedout = false;
            while (this.alive) {
                if (this.task != null) {
                    Runnable tsk = this.task;
                    this.task = null;
                    return tsk;
                }
                this.alive = this.pool.taskCompleted(this, timedout);
                if (!this.alive || this.task != null) continue;
                try {
                    long idleTimeOut = this.pool.getIdleTimeOutMs();
                    timedout = false;
                    if (idleTimeOut > 0L) {
                        this.wait(idleTimeOut);
                        timedout = this.task == null;
                        continue;
                    }
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            return null;
        }

        public void run() {
            while (this.alive) {
                block4: {
                    Runnable tsk = this.waitForTask();
                    if (tsk != null) {
                        try {
                            tsk.run();
                        }
                        catch (Throwable t) {
                            Logger logger = GlobalProperties.getLogger();
                            if (!logger.isLoggable(Level.SEVERE)) break block4;
                            logger.log(Level.SEVERE, "exception while executing task from thread pool", t);
                        }
                    }
                }
                if (this.alive) continue;
                break;
            }
            this.started = false;
            this.pool.removeThread(this);
        }
    }
}

