/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.simulator.cimom.connection;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMValue;
import org.eclipse.aperi.simulator.cimom.common.DatabaseManager;
import org.eclipse.aperi.simulator.cimom.common.generator.DataGeneratorResponse;
import org.eclipse.aperi.simulator.cimom.common.generator.DeviceDataGenerator;
import org.eclipse.aperi.simulator.cimom.common.generator.SimClass;
import org.eclipse.aperi.simulator.cimom.connection.ConnectionConfig;
import org.eclipse.aperi.simulator.cimom.connection.SourceConnection;
import org.eclipse.aperi.simulator.cimom.connection.SourceDBConnection;
import org.eclipse.aperi.simulator.cimom.connection.TargetCIMConnection;
import org.eclipse.aperi.simulator.cimom.connection.TargetConnection;
import org.eclipse.aperi.simulator.cimom.connection.TargetDBConnection;

public class ConnectionDataGenerator {
    private static final String CONFIG_FILE = "resources/ConnectionSimulation.Properties";
    private static final String BROCADE_CONNECT_XML = "XML/Connectivity.Switch/ConnectivityClasses.xml";
    private static final String NAMESPACE_ROOT_BROCADE1 = "/root/brocade1";
    private DeviceDataGenerator dataGenerator;
    private DataGeneratorResponse response;
    private SourceConnection switchClient;
    private TargetConnection targetDevcieClient;
    private CIMValue sourceFabricName;

    private void persistData(DataGeneratorResponse response) throws Exception {
        String namespace = NAMESPACE_ROOT_BROCADE1;
        int nsID = DatabaseManager.getDbManager().getNamespaceID(namespace);
        Map classMap = this.dataGenerator.getParserResponse().getClassMap();
        DatabaseManager.getDbManager().persistInstances(nsID, response.getInstanceMap(), classMap);
        System.out.println("Connection Data Stored");
    }

    public void generateData() throws IOException, Exception {
        System.out.println("In data Generator");
        this.dataGenerator = new DeviceDataGenerator(BROCADE_CONNECT_XML, CONFIG_FILE);
        ConnectionConfig.loadProperties();
        this.sourceFabricName = new CIMValue((Object)ConnectionConfig.getProperty("SOURCE_FABRIC_ID"));
        this.switchClient = new SourceDBConnection();
        this.switchClient.init();
        if (ConnectionConfig.getProperty("SWITCH_CONNECTED_TO").equals("Switch")) {
            this.connectSwitchToSwitch();
        }
        if (ConnectionConfig.getProperty("SWITCH_CONNECTED_TO").equals("Storage")) {
            if (ConnectionConfig.getProperty("TARGET_DEVICE_CLIENT").equals("CIM Client")) {
                this.targetDevcieClient = new TargetCIMConnection();
            } else if (ConnectionConfig.getProperty("TARGET_DEVICE_CLIENT").equals("DB Client")) {
                this.targetDevcieClient = new TargetDBConnection();
            }
            this.connectSwitchToStorage();
        } else if (ConnectionConfig.getProperty("SWITCH_CONNECTED_TO").equals("Host")) {
            this.connectSwitchToHost();
        }
        ConnectionConfig.closeProperties();
    }

    private void connectSwitchToHost() throws Exception {
    }

    private void connectSwitchToSwitch() throws Exception {
        this.response = this.dataGenerator.generateData(NAMESPACE_ROOT_BROCADE1);
        String connections = this.dataGenerator.getConfProperties().getProperty("PORT_CONNECTIVITY");
        String[] portConnections = connections.split(",");
        String[] switch1PortWWN = new String[portConnections.length];
        String[] switch2PortWWN = new String[portConnections.length];
        int i = 0;
        int j = 0;
        while (i < portConnections.length) {
            String[] portNos = portConnections[i].split(":");
            switch1PortWWN[j] = portNos[0].substring(portNos[0].indexOf("(") + 1, portNos[0].indexOf(")"));
            switch2PortWWN[j] = portNos[1].substring(portNos[1].indexOf("(") + 1, portNos[1].indexOf(")"));
            ++i;
            ++j;
        }
        CIMInstance instFabric = this.switchClient.getInstance("Brocade_Fabric", "Name", this.sourceFabricName);
        String classFabric = "/root/brocade1:Brocade_Fabric";
        this.response.addInstances(classFabric, instFabric);
        CIMInstance instLogicalNetwork = this.switchClient.getInstance("Brocade_LogicalNetwork", "InstanceID", this.sourceFabricName);
        String classLogicalNetwork = "/root/brocade1:Brocade_LogicalNetwork";
        this.response.addInstances(classLogicalNetwork, instLogicalNetwork);
        SimClass assocSANActiveConnection = (SimClass)this.dataGenerator.getParserResponse().getClassMap().get("Brocade_SANActiveConnection");
        for (int i2 = 0; i2 < portConnections.length; ++i2) {
            CIMValue switch1Port = new CIMValue((Object)switch1PortWWN[i2]);
            if (switch1Port == null) {
                System.out.println("Specified Port Number Does not exist !");
                System.exit(0);
            }
            CIMInstance instSwitchFCPort = this.switchClient.getInstance("Brocade_SwitchFCPort", "DeviceID", switch1Port);
            CIMInstance instSANProtocolEndPoint1 = this.createSANPEndPoint("Switch", instSwitchFCPort);
            this.addInstancesToResponse(this.response, "/root/brocade1:Brocade_SANProtocolEndPoint", instSANProtocolEndPoint1);
            this.createAssociationInst(this.response, "Brocade_FabricHostedSANAccessPoint", instFabric, instSANProtocolEndPoint1);
            this.createAssociationInst(this.response, "Brocade_FCPortSANProtocolEndPoint", instSwitchFCPort, instSANProtocolEndPoint1);
            this.createAssociationInst(this.response, "Brocade_InLogicalNetwork", instLogicalNetwork, instSANProtocolEndPoint1);
            CIMValue switch2Port = new CIMValue((Object)switch2PortWWN[i2]);
            if (switch2Port == null) {
                System.out.println("Specified Port Number Does not exist !");
                System.exit(0);
            }
            instSwitchFCPort = this.switchClient.getInstance("Brocade_SwitchFCPort", "DeviceID", switch2Port);
            CIMInstance instSANProtocolEndPoint2 = this.createSANPEndPoint("Switch", instSwitchFCPort);
            this.addInstancesToResponse(this.response, "/root/brocade1:Brocade_SANProtocolEndPoint", instSANProtocolEndPoint2);
            this.createAssociationInst(this.response, "Brocade_FabricHostedSANAccessPoint", instFabric, instSANProtocolEndPoint2);
            this.createAssociationInst(this.response, "Brocade_FCPortSANProtocolEndPoint", instSwitchFCPort, instSANProtocolEndPoint2);
            this.createAssociationInst(this.response, "Brocade_InLogicalNetwork", instLogicalNetwork, instSANProtocolEndPoint2);
            CIMInstance iSANActiveConnection = this.dataGenerator.getCreator().createAssociationInstance(assocSANActiveConnection, instSANProtocolEndPoint1, instSANProtocolEndPoint2);
            this.addInstancesToResponse(this.response, "/root/brocade1:Brocade_SANActiveConnection", iSANActiveConnection);
        }
        this.response.getInstanceMap().remove("/root/brocade1:Brocade_Fabric");
        this.response.getInstanceMap().remove("/root/brocade1:Brocade_LogicalNetwork");
        this.printInstanceMap(this.response);
        this.persistData(this.response);
    }

    private void connectSwitchToStorage() throws Exception, IOException {
        CIMValue switchPort;
        int i;
        HashMap<String, String> deviceIDMap = new HashMap<String, String>();
        this.targetDevcieClient.init();
        this.response = this.dataGenerator.generateData(NAMESPACE_ROOT_BROCADE1);
        Properties confProperties = new Properties();
        confProperties.load(new FileInputStream(CONFIG_FILE));
        String connections = this.dataGenerator.getConfProperties().getProperty("PORT_CONNECTIVITY");
        String deviceConnection = this.dataGenerator.getConfProperties().getProperty("DEVICE_CONNECTIVTY");
        String targetDevice = deviceConnection.split(":")[1];
        String targetDeviceName = targetDevice.substring(targetDevice.indexOf("[DS_") + 4, targetDevice.indexOf(93));
        String[] portConnections = connections.split(",");
        int numberOfConnection = portConnections.length;
        String[] switchPortWWN = new String[numberOfConnection];
        String[] nodePortWWN = new String[numberOfConnection];
        int i2 = 0;
        int j = 0;
        while (i2 < portConnections.length) {
            String[] portNos = portConnections[i2].split(":");
            switchPortWWN[j] = portNos[0].substring(portNos[0].indexOf("(") + 1, portNos[0].indexOf(")"));
            nodePortWWN[j] = portNos[1].substring(portNos[1].indexOf("(") + 1, portNos[1].indexOf(")"));
            ++i2;
            ++j;
        }
        CIMInstance instFabric = this.switchClient.getInstance("Brocade_Fabric", "Name", this.sourceFabricName);
        String classFabric = "/root/brocade1:Brocade_Fabric";
        this.response.addInstances(classFabric, instFabric);
        CIMInstance instLogicalNetwork = this.switchClient.getInstance("Brocade_LogicalNetwork", "InstanceID", this.sourceFabricName);
        String classLogicalNetwork = "/root/brocade1:Brocade_LogicalNetwork";
        this.response.addInstances(classLogicalNetwork, instLogicalNetwork);
        SimClass simClassNode = (SimClass)this.dataGenerator.getParserResponse().getClassMap().get("Brocade_Node");
        CIMInstance instNode = this.dataGenerator.getCreator().createDefaultInstance(simClassNode);
        instNode.getProperty("Name").setValue(instNode.getProperty("InstanceID").getValue());
        this.addInstancesToResponse(this.response, simClassNode.getName(), instNode);
        this.createAssociationInst(this.response, "Brocade_NodeInFabric", instFabric, instNode);
        for (i = 0; i < numberOfConnection; ++i) {
            switchPort = new CIMValue((Object)switchPortWWN[i]);
            if (switchPort == null) {
                System.out.println("Specified Port Number Does not exist !");
                System.exit(0);
            }
            CIMInstance instSwitchFCPort = this.switchClient.getInstance("Brocade_SwitchFCPort", "DeviceID", switchPort);
            CIMInstance instSANProtocolEndPoint = this.createSANPEndPoint("Switch", instSwitchFCPort);
            this.addInstancesToResponse(this.response, "/root/brocade1:Brocade_SANProtocolEndPoint", instSANProtocolEndPoint);
            this.createAssociationInst(this.response, "Brocade_FabricHostedSANAccessPoint", instFabric, instSANProtocolEndPoint);
            this.createAssociationInst(this.response, "Brocade_FCPortSANProtocolEndPoint", instSwitchFCPort, instSANProtocolEndPoint);
            this.createAssociationInst(this.response, "Brocade_InLogicalNetwork", instLogicalNetwork, instSANProtocolEndPoint);
        }
        for (i = 0; i < numberOfConnection; ++i) {
            CIMValue nodePort = new CIMValue((Object)nodePortWWN[i]);
            CIMValue deviceID = this.targetDevcieClient.getDeviceID(nodePort, targetDeviceName);
            if (nodePort == null) {
                System.out.println("Specified Port Number Does not exist !");
                System.exit(0);
            }
            deviceIDMap.put(nodePort.getValue().toString(), deviceID.getValue().toString());
            SimClass simClassNodeFCPort = (SimClass)this.dataGenerator.getParserResponse().getClassMap().get("Brocade_NodeFCPort");
            CIMInstance instNodeFCPort = this.dataGenerator.getCreator().createDefaultInstance(simClassNodeFCPort);
            instNodeFCPort.getProperty("DeviceID").setValue(deviceID);
            instNodeFCPort.getObjectPath().getKey("DeviceID").setValue(instNodeFCPort.getProperty("DeviceID").getValue());
            CIMValue sysName = instNode.getProperty("Name").getValue();
            instNodeFCPort.getProperty("SystemName").setValue(sysName);
            instNodeFCPort.getObjectPath().getKey("SystemName").setValue(instNodeFCPort.getProperty("SystemName").getValue());
            instNodeFCPort.getProperty("PermanentAddress").setValue(nodePort);
            this.addInstancesToResponse(this.response, "/root/brocade1:Brocade_NodeFCPort", instNodeFCPort);
            this.createAssociationInst(this.response, "Brocade_PortInNode", instNode, instNodeFCPort);
            this.createAssociationInst(this.response, "Brocade_NodePortInFabric", instFabric, instNodeFCPort);
            CIMInstance instSANProtocolEndPoint = this.createSANPEndPoint("Storage", instNodeFCPort);
            this.addInstancesToResponse(this.response, "/root/brocade1:Brocade_SANProtocolEndPoint", instSANProtocolEndPoint);
            this.createAssociationInst(this.response, "Brocade_FabricHostedSANAccessPoint", instFabric, instSANProtocolEndPoint);
            this.createAssociationInst(this.response, "Brocade_FCPortSANProtocolEndPoint", instNodeFCPort, instSANProtocolEndPoint);
            this.createAssociationInst(this.response, "Brocade_InLogicalNetwork", instLogicalNetwork, instSANProtocolEndPoint);
        }
        this.response.getInstanceMap().remove("/root/brocade1:Brocade_Fabric");
        this.response.getInstanceMap().remove("/root/brocade1:Brocade_LogicalNetwork");
        SimClass assocSANActiveConnection = (SimClass)this.dataGenerator.getParserResponse().getClassMap().get("Brocade_SANActiveConnection");
        for (int i3 = 0; i3 < portConnections.length; ++i3) {
            switchPort = new CIMValue((Object)switchPortWWN[i3]);
            CIMValue nodePort = new CIMValue((Object)nodePortWWN[i3]);
            CIMValue deviceID = new CIMValue(deviceIDMap.get(nodePort.getValue().toString()));
            CIMInstance switchSANPEndPoint = this.getInstanceFromMap("Brocade_SANProtocolEndPoint", "Name", switchPort);
            CIMInstance nodeSANPEndPoint = this.getInstanceFromMap("Brocade_SANProtocolEndPoint", "Name", deviceID);
            CIMInstance iSANActiveConnection = this.dataGenerator.getCreator().createAssociationInstance(assocSANActiveConnection, switchSANPEndPoint, nodeSANPEndPoint);
            this.addInstancesToResponse(this.response, "/root/brocade1:Brocade_SANActiveConnection", iSANActiveConnection);
        }
        this.printInstanceMap(this.response);
        this.persistData(this.response);
    }

    private void printInstanceMap(DataGeneratorResponse response) {
        Set keySet = response.getInstanceMap().keySet();
        Iterator iter = keySet.iterator();
        int count = 0;
        while (iter.hasNext()) {
            ++count;
            String simClass = (String)iter.next();
            System.out.println("CIM Class: " + response.getInstanceMap().get(simClass));
        }
    }

    private void createAssociationInst(DataGeneratorResponse response, String assoClassName, CIMInstance antecedent, CIMInstance instSANProtocolEndPoint) {
        SimClass associationSimClass = (SimClass)this.dataGenerator.getParserResponse().getClassMap().get(assoClassName);
        CIMInstance associationInst = this.dataGenerator.getCreator().createAssociationInstance(associationSimClass, antecedent, instSANProtocolEndPoint);
        this.addInstancesToResponse(response, "/root/brocade1:" + assoClassName, associationInst);
    }

    private CIMInstance createSANPEndPoint(String deviceType, CIMInstance instFCPort) throws CIMException {
        String instName = "Brocade_SANProtocolEndPoint";
        CIMValue deviceId = instFCPort.getProperty("DeviceID").getValue();
        CIMValue systemName = instFCPort.getProperty("SystemName").getValue();
        SimClass simClassSANPEndPoint = (SimClass)this.dataGenerator.getParserResponse().getClassMap().get(instName);
        CIMInstance instSANPEndPoint = this.dataGenerator.getCreator().createDefaultInstance(simClassSANPEndPoint);
        instSANPEndPoint.getProperty("Name").setValue(deviceId);
        instSANPEndPoint.getObjectPath().getKey("Name").setValue(instSANPEndPoint.getProperty("Name").getValue());
        instSANPEndPoint.getProperty("SystemName").setValue(systemName);
        instSANPEndPoint.getObjectPath().getKey("SystemName").setValue(instSANPEndPoint.getProperty("SystemName").getValue());
        if (deviceType.equalsIgnoreCase("Switch")) {
            instSANPEndPoint.getProperty("SystemCreationClassName").setValue(new CIMValue((Object)"Brocade_Switch"));
        } else if (deviceType.equalsIgnoreCase("Storage")) {
            instSANPEndPoint.getProperty("SystemCreationClassName").setValue(new CIMValue((Object)"Brocade_Node"));
        }
        instSANPEndPoint.getObjectPath().getKey("SystemCreationClassName").setValue(instSANPEndPoint.getProperty("SystemCreationClassName").getValue());
        return instSANPEndPoint;
    }

    private CIMInstance getInstanceFromMap(String className, String propName, CIMValue key) {
        Object instMap = this.response.getInstanceMap().get("/root/brocade1:" + className);
        if (instMap instanceof ArrayList) {
            ArrayList classList = (ArrayList)instMap;
            Iterator iter = classList.iterator();
            while (iter.hasNext()) {
                CIMInstance cimInst = (CIMInstance)iter.next();
                CIMValue name = cimInst.getProperty(propName).getValue();
                if (!name.equals((Object)key)) continue;
                return cimInst;
            }
        } else {
            return (CIMInstance)instMap;
        }
        return null;
    }

    private void addInstancesToResponse(DataGeneratorResponse response, String simClassName, Object instance) {
        Object previousInst = response.getInstanceMap().get(simClassName);
        if (previousInst == null) {
            response.addInstances(simClassName, instance);
        } else if (previousInst instanceof List) {
            ((List)previousInst).add(instance);
            response.addInstances(simClassName, previousInst);
        } else if (previousInst instanceof CIMInstance) {
            ArrayList<Object> instanceList = new ArrayList<Object>();
            instanceList.add(previousInst);
            instanceList.add(instance);
            response.addInstances(simClassName, instanceList);
        }
    }
}

