/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.simulator.dbutil;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import javax.swing.JOptionPane;

public class CreateDatabase {
    public static final String DB2_CREATE_DB_COMMAND = "C:\\Program Files\\IBM\\SQLLIB\\bin\\db2cmd.exe -c -w -i db2 create database ";
    public static final String DB2_DROP_DB_COMMAND = "C:\\Program Files\\IBM\\SQLLIB\\bin\\db2cmd.exe -c -w -i db2 drop database ";
    public static final String DB2_CONNECT_DB_COMMAND = "C:\\Program Files\\IBM\\SQLLIB\\bin\\db2cmd.exe db2 CONNECT TO ";
    public static final String RUN_DDL_COMMAND = "C:\\Program Files\\IBM\\SQLLIB\\bin\\db2batch.exe -d {0} -a {1}/{2} -f {3}";

    private void createDatabase(String dbName) {
        this.executeCommand(DB2_CREATE_DB_COMMAND + dbName);
    }

    private void dropDatabase(String dbName) {
        this.executeCommand(DB2_DROP_DB_COMMAND + dbName);
    }

    private void connectDatabase(String dbName) {
        this.executeCommand(DB2_CONNECT_DB_COMMAND + dbName);
    }

    private void runDDLFile(String dbName, String fileName, String userName, String passwd) {
        String command = MessageFormat.format(RUN_DDL_COMMAND, dbName, userName, passwd, fileName);
        this.executeCommand(command);
    }

    private void executeCommand(String command) {
        try {
            Process process = Runtime.getRuntime().exec(command);
            new NullReader(process.getInputStream(), "Output").start();
            new NullReader(process.getErrorStream(), "Error").start();
            int retVal = process.waitFor();
            System.out.println("The return value is : " + retVal);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        CreateDatabase simdb = new CreateDatabase();
        String dbName = "SIMDB";
        System.out.println("============ Database Creation Starts ==========");
        System.out.println("Drop SIMDB");
        simdb.dropDatabase(dbName);
        System.out.println("Create SIMDB");
        simdb.createDatabase(dbName);
        System.out.println("Connect to SIMDB");
        simdb.connectDatabase(dbName);
        String userName = JOptionPane.showInputDialog("Enter DB2 Username: ", (Object)"db2admin");
        String passwd = JOptionPane.showInputDialog("Enter DB2 Password: ", (Object)"db2admin");
        System.out.println("Creating tables in SIMDB");
        simdb.runDDLFile(dbName, "SIM.ddl", userName, passwd);
        System.out.println("============ Database Creation Ends ==========");
    }

    private class NullReader
    extends Thread {
        private InputStream stream;
        private String name;

        public NullReader(InputStream stream, String name) {
            this.stream = stream;
            this.name = name;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            BufferedReader reader = null;
            try {
                String data;
                reader = new BufferedReader(new InputStreamReader(this.stream));
                while (null != (data = reader.readLine())) {
                    System.out.println(this.name + " " + data);
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            finally {
                if (null != reader) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }
}

