/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.simulator.ui;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.Properties;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.wbem.cim.CIMException;
import org.eclipse.aperi.simulator.ui.ConnectionUtility;
import org.eclipse.aperi.simulator.ui.RemoteCIMClient;
import org.eclipse.aperi.simulator.ui.TargetDeviceDBClient;
import org.eclipse.aperi.simulator.ui.TestDBConnection;
import org.eclipse.aperi.simulator.ui.TestWbemCimomConnection;

public final class ConnectionScreens
extends JFrame {
    private static final long serialVersionUID = 1L;
    private GridBagLayout layout = new GridBagLayout();
    private JTextField jtfCIMOMUrl;
    private JTextField jtfCIMOMNmSpace;
    private JTextField jtfCIMOMPort;
    private JTextField jtfCIMOMUserName;
    private JPasswordField jpfCIMOMPassword;
    private JComboBox jcbCIMOMProtocol;
    private JTextField jtfDBUrl;
    private JTextField jtfDBName;
    private JTextField jtfDBUid;
    private JPasswordField jtfDBPwd;
    private JList switchPortList;
    private JList portConnList;
    private JList otherDevicePortList;
    private JComboBox jcbSwitches;
    private JComboBox jcbOtherDevices;
    private JComboBox jcbSourcefabric;
    private JComboBox jcbDestFabric;
    private boolean deviceConncted = false;
    private JComboBox jcbSwitchOption;
    private JComboBox jcbStorageOption;
    private JComboBox jcbHostOption;
    private JRadioButton jrbSwitchToSwitch;
    private JRadioButton jrbSwitchToStorage;
    private JRadioButton jrbSwitchToHost;
    private boolean isConnectOptionSet;
    private boolean isSwitchDBConfig;
    private boolean isTargetDevcieDBConfig;
    private boolean isCIMOMConfig;
    private Logger logger = Logger.getLogger(ConnectionScreens.class.getName());

    public JPanel getConnectionOption() {
        JPanel jpMain = new JPanel(this.layout);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 2;
        constraints.anchor = 11;
        String[] optionsForStorage = new String[]{ConnectionUtility.DB_CLIENT, ConnectionUtility.CIM_CLIENT};
        String[] optionForSwitch = new String[]{ConnectionUtility.SWITCH_CLIENT};
        String[] optionForHost = new String[]{ConnectionUtility.DB_CLIENT, ConnectionUtility.CIM_CLIENT};
        JLabel jlTitle = new JLabel("<html><b>Please specify Device Connectivity</b><br><br> <br><br><br></html>", 2);
        jlTitle.setFont(new Font("Times New RomanSerif", 0, 12));
        jlTitle.setBorder(BorderFactory.createEtchedBorder());
        jlTitle.setHorizontalTextPosition(2);
        this.addComponent(jpMain, jlTitle, constraints, 0, 0, 1, 1);
        JPanel jpMiddle = new JPanel(this.layout);
        jpMiddle.setBorder(BorderFactory.createTitledBorder("Connect Option"));
        this.jrbSwitchToSwitch = new JRadioButton("Switch To Switch Connection");
        this.jrbSwitchToStorage = new JRadioButton("Switch To Storage Connection");
        this.jrbSwitchToHost = new JRadioButton("Switch To Host Connection");
        this.jrbSwitchToHost.setEnabled(false);
        ButtonGroup bgConnectOption = new ButtonGroup();
        bgConnectOption.add(this.jrbSwitchToSwitch);
        bgConnectOption.add(this.jrbSwitchToStorage);
        bgConnectOption.add(this.jrbSwitchToHost);
        this.jrbSwitchToSwitch.addItemListener(new RadioButtonHandler("ToSwitch"));
        this.jrbSwitchToStorage.addItemListener(new RadioButtonHandler("ToStorage"));
        this.jrbSwitchToHost.addItemListener(new RadioButtonHandler("ToHost"));
        this.jcbSwitchOption = new JComboBox<String>(optionForSwitch);
        this.jcbSwitchOption.setEnabled(false);
        this.jcbStorageOption = new JComboBox<String>(optionsForStorage);
        this.jcbStorageOption.setEnabled(false);
        this.jcbHostOption = new JComboBox<String>(optionForHost);
        this.jcbHostOption.setEnabled(false);
        constraints.insets.bottom = 10;
        constraints.insets.left = 10;
        this.addComponent(jpMiddle, this.jrbSwitchToSwitch, constraints, 0, 0, 1, 1);
        this.addComponent(jpMiddle, this.jcbSwitchOption, constraints, 0, 1, 1, 1);
        this.addComponent(jpMiddle, this.jrbSwitchToStorage, constraints, 1, 0, 1, 1);
        this.addComponent(jpMiddle, this.jcbStorageOption, constraints, 1, 1, 1, 1);
        this.addComponent(jpMiddle, this.jrbSwitchToHost, constraints, 2, 0, 1, 1);
        this.addComponent(jpMiddle, this.jcbHostOption, constraints, 2, 1, 1, 1);
        constraints.insets.bottom = 0;
        constraints.insets.left = 0;
        this.addComponent(jpMain, jpMiddle, constraints, 1, 0, 1, 1);
        if (this.isConnectOptionSet) {
            if (ConnectionUtility.profileConnection.equals(ConnectionUtility.SWITCH_TO_SWITCH)) {
                this.jrbSwitchToSwitch.doClick();
                this.jcbSwitchOption.setSelectedItem(ConnectionUtility.ConnectMedium);
            } else if (ConnectionUtility.profileConnection.equals(ConnectionUtility.SWITCH_TO_ARRAY)) {
                this.jrbSwitchToStorage.doClick();
                this.jcbStorageOption.setSelectedItem(ConnectionUtility.ConnectMedium);
            }
        }
        return jpMain;
    }

    public JPanel getDeviceConnected() {
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 2;
        JPanel jpMain = new JPanel(this.layout);
        JLabel jlTitle = new JLabel("<html><b>Please specify device Connectivity</b><br><br><br><br><br></html>", 2);
        jlTitle.setFont(new Font("Times New RomanSerif", 0, 12));
        jlTitle.setBorder(BorderFactory.createEtchedBorder());
        jlTitle.setHorizontalTextPosition(2);
        this.addComponent(jpMain, jlTitle, constraints, 0, 0, 1, 1);
        JPanel jpMiddle = new JPanel(this.layout);
        JLabel jlSFabric = new JLabel("Source Fabric");
        ConnectionUtility.initDeviceConnect();
        this.jcbSourcefabric = new JComboBox(ConnectionUtility.getFabricNames());
        this.jcbSourcefabric.setSelectedIndex(0);
        this.jcbSourcefabric.setPreferredSize(new Dimension(150, 20));
        this.jcbSourcefabric.addItemListener(new SourceFabricSelect());
        JLabel jlDFabric = new JLabel("Destination Fabric");
        this.jcbDestFabric = new JComboBox(ConnectionUtility.getFabricNames());
        this.jcbDestFabric.setEnabled(false);
        this.jcbDestFabric.setPreferredSize(new Dimension(150, 20));
        JLabel jlSwitch = new JLabel("Connect Switch");
        this.jcbSwitches = new JComboBox(ConnectionUtility.switchnamesVector);
        this.jcbSwitches.setPreferredSize(new Dimension(150, 20));
        this.jcbSwitches.setEnabled(false);
        JLabel jlOther = new JLabel("Target Device");
        this.jcbOtherDevices = new JComboBox(ConnectionUtility.otherDevicesvector);
        this.jcbOtherDevices.setPreferredSize(new Dimension(150, 20));
        this.jcbOtherDevices.setEnabled(false);
        this.jcbSwitches.addItemListener(new DeviceSelect());
        jpMiddle.setBorder(BorderFactory.createTitledBorder("Device Connection"));
        constraints.insets.top = 15;
        constraints.insets.bottom = 25;
        this.addComponent(jpMiddle, jlSFabric, constraints, 0, 0, 1, 1);
        constraints.insets.right = 20;
        this.addComponent(jpMiddle, this.jcbSourcefabric, constraints, 0, 1, 1, 1);
        constraints.insets.right = 0;
        this.addComponent(jpMiddle, jlDFabric, constraints, 0, 3, 1, 1);
        constraints.insets.right = 20;
        this.addComponent(jpMiddle, this.jcbDestFabric, constraints, 0, 4, 1, 1);
        this.addComponent(jpMiddle, jlSwitch, constraints, 1, 0, 1, 1);
        constraints.insets.right = 20;
        this.addComponent(jpMiddle, this.jcbSwitches, constraints, 1, 1, 1, 1);
        constraints.insets.right = 0;
        this.addComponent(jpMiddle, jlOther, constraints, 1, 3, 1, 1);
        constraints.insets.right = 0;
        this.addComponent(jpMiddle, this.jcbOtherDevices, constraints, 1, 4, 1, 1);
        constraints.insets.top = 0;
        constraints.insets.right = 0;
        this.addComponent(jpMain, jpMiddle, constraints, 1, 0, 1, 1);
        return jpMain;
    }

    public JPanel getDBInfoForSwitchScreen() {
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 2;
        JPanel jpMain = new JPanel(this.layout);
        JLabel jlTitle = new JLabel("<html><b>Enter the database details For Simulated Switch</b><br><br>If local database is used and current logged in user has admin permissions on the database, then \"User Name\" and \"Password\" fields can be left blank.<br>You can test the connection to the database using <b>\"Test DB Connection\"</b> button.<br></html>", 2);
        jlTitle.setFont(new Font("Times New RomanSerif", 0, 12));
        jlTitle.setBorder(BorderFactory.createEtchedBorder());
        jlTitle.setHorizontalTextPosition(2);
        this.addComponent(jpMain, jlTitle, constraints, 0, 0, 1, 1);
        JPanel jpMiddle = new JPanel(this.layout);
        jpMiddle.setBorder(BorderFactory.createTitledBorder("DB Inputs"));
        this.jtfDBUrl = new JTextField(20);
        JLabel jlDBUrl = new JLabel("DB URL");
        this.jtfDBUrl.setText("localhost");
        this.jtfDBName = new JTextField(20);
        JLabel jlDBName = new JLabel("DB Name");
        this.jtfDBName.setText("SIMDB");
        this.jtfDBName.setEditable(false);
        this.jtfDBUid = new JTextField(20);
        JLabel jlUid = new JLabel("User Name");
        this.jtfDBPwd = new JPasswordField(16);
        JLabel jlpwd = new JLabel("Password");
        JButton jbTest = new JButton("Test DB Connection");
        jbTest.setActionCommand("TestDB");
        jbTest.addActionListener(new ButtonListener());
        constraints.insets.top = 10;
        constraints.insets.bottom = 5;
        constraints.insets.left = 10;
        constraints.fill = 0;
        this.addComponent(jpMiddle, jlDBUrl, constraints, 0, 0, 1, 1);
        this.addComponent(jpMiddle, this.jtfDBUrl, constraints, 0, 1, 1, 1);
        this.addComponent(jpMiddle, jlDBName, constraints, 1, 0, 1, 1);
        this.addComponent(jpMiddle, this.jtfDBName, constraints, 1, 1, 1, 1);
        this.addComponent(jpMiddle, jlUid, constraints, 2, 0, 1, 1);
        this.addComponent(jpMiddle, this.jtfDBUid, constraints, 2, 1, 1, 1);
        this.addComponent(jpMiddle, jlpwd, constraints, 3, 0, 1, 1);
        this.addComponent(jpMiddle, this.jtfDBPwd, constraints, 3, 1, 1, 1);
        this.addComponent(jpMiddle, jbTest, constraints, 4, 1, 1, 1);
        constraints.insets.bottom = 0;
        constraints.insets.left = 0;
        constraints.insets.top = 0;
        constraints.fill = 2;
        this.addComponent(jpMain, jpMiddle, constraints, 1, 0, 1, 1);
        if (this.isSwitchDBConfig) {
            this.jtfDBUrl.setText(ConnectionUtility.switchDBUrl);
            this.jtfDBName.setText(ConnectionUtility.switchDBName);
            this.jtfDBUid.setText(ConnectionUtility.switchDBUserid);
            this.jtfDBPwd.setText(ConnectionUtility.switchDBPassword);
        }
        return jpMain;
    }

    public JPanel getDBInfoForTargetrDeviceScreen() {
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 2;
        JPanel jpMain = new JPanel(this.layout);
        JLabel jlTitle = new JLabel("<html><b>Enter the database details For Simulated Target Device</b><br><br>If local database is used and current logged in user has admin permissions on the database, then \"User Name\" and \"Password\" fields can be left blank.<br>You can test the connection to the database using <b>\"Test DB Connection\"</b> button.<br></html>", 2);
        jlTitle.setFont(new Font("Times New RomanSerif", 0, 12));
        jlTitle.setBorder(BorderFactory.createEtchedBorder());
        jlTitle.setHorizontalTextPosition(2);
        this.addComponent(jpMain, jlTitle, constraints, 0, 0, 1, 1);
        JPanel jpMiddle = new JPanel(this.layout);
        jpMiddle.setBorder(BorderFactory.createTitledBorder("DB Inputs"));
        this.jtfDBUrl = new JTextField(20);
        JLabel jlDBUrl = new JLabel("DB URL");
        this.jtfDBName = new JTextField(20);
        JLabel jlDBName = new JLabel("DB Name");
        this.jtfDBName.setText("SIMDB");
        this.jtfDBName.setEditable(false);
        this.jtfDBUid = new JTextField(20);
        JLabel jlUid = new JLabel("User Name");
        this.jtfDBPwd = new JPasswordField(16);
        JLabel jlpwd = new JLabel("Password");
        JButton jbTest = new JButton("Test DB Connection");
        jbTest.setActionCommand("TestDB");
        jbTest.addActionListener(new ButtonListener());
        constraints.insets.top = 10;
        constraints.insets.bottom = 5;
        constraints.insets.left = 10;
        constraints.fill = 0;
        this.addComponent(jpMiddle, jlDBUrl, constraints, 0, 0, 1, 1);
        this.addComponent(jpMiddle, this.jtfDBUrl, constraints, 0, 1, 1, 1);
        this.addComponent(jpMiddle, jlDBName, constraints, 1, 0, 1, 1);
        this.addComponent(jpMiddle, this.jtfDBName, constraints, 1, 1, 1, 1);
        this.addComponent(jpMiddle, jlUid, constraints, 2, 0, 1, 1);
        this.addComponent(jpMiddle, this.jtfDBUid, constraints, 2, 1, 1, 1);
        this.addComponent(jpMiddle, jlpwd, constraints, 3, 0, 1, 1);
        this.addComponent(jpMiddle, this.jtfDBPwd, constraints, 3, 1, 1, 1);
        this.addComponent(jpMiddle, jbTest, constraints, 4, 1, 1, 1);
        constraints.insets.bottom = 0;
        constraints.insets.left = 0;
        constraints.insets.top = 0;
        constraints.fill = 2;
        this.addComponent(jpMain, jpMiddle, constraints, 1, 0, 1, 1);
        if (this.isTargetDevcieDBConfig) {
            this.jtfDBUrl.setText(ConnectionUtility.targetDevcieDBUrl);
            this.jtfDBName.setText(ConnectionUtility.targetDevcieDBName);
            this.jtfDBUid.setText(ConnectionUtility.targetDevcieDBUserid);
            this.jtfDBPwd.setText(ConnectionUtility.targetDevcieDBPassword);
        }
        return jpMain;
    }

    public JPanel getCIMOMInfoScreen() {
        GridBagConstraints constraints = new GridBagConstraints();
        String[] protocols = new String[]{"http", "https"};
        constraints.fill = 2;
        JPanel jpMain = new JPanel(this.layout);
        JLabel jlTitle = new JLabel("<html><b>Please specify CIMOM Configuration</b><br><br><br><br><br></html>", 2);
        jlTitle.setFont(new Font("Times New RomanSerif", 0, 12));
        jlTitle.setBorder(BorderFactory.createEtchedBorder());
        jlTitle.setHorizontalTextPosition(2);
        this.addComponent(jpMain, jlTitle, constraints, 0, 0, 1, 1);
        JPanel jpMiddle = new JPanel(this.layout);
        jpMiddle.setBorder(BorderFactory.createTitledBorder("CIMOM Inputs"));
        this.jtfCIMOMUrl = new JTextField(20);
        JLabel jlUrl = new JLabel("Host URL");
        this.jtfCIMOMPort = new JTextField(20);
        JLabel jlPort = new JLabel("Port");
        this.jtfCIMOMUserName = new JTextField(20);
        JLabel jlUID = new JLabel("User Name");
        this.jpfCIMOMPassword = new JPasswordField(16);
        JLabel jlpwd = new JLabel("Password");
        this.jtfCIMOMNmSpace = new JTextField(20);
        JLabel jlNmSpace = new JLabel("NameSpace");
        this.jcbCIMOMProtocol = new JComboBox<String>(protocols);
        JLabel jlProtocol = new JLabel("Protocol");
        this.jcbCIMOMProtocol.setPreferredSize(new Dimension(166, 20));
        JButton jbTest = new JButton("Test CIMOM COnnection");
        jbTest.setActionCommand("TestCIMOM");
        jbTest.addActionListener(new ButtonListener());
        constraints.insets.top = 10;
        constraints.insets.bottom = 5;
        constraints.insets.left = 10;
        constraints.fill = 0;
        this.addComponent(jpMiddle, this.jtfCIMOMUrl, constraints, 0, 1, 1, 1);
        this.addComponent(jpMiddle, this.jtfCIMOMPort, constraints, 1, 1, 1, 1);
        this.addComponent(jpMiddle, this.jtfCIMOMUserName, constraints, 2, 1, 1, 1);
        this.addComponent(jpMiddle, this.jpfCIMOMPassword, constraints, 3, 1, 1, 1);
        this.addComponent(jpMiddle, this.jtfCIMOMNmSpace, constraints, 4, 1, 1, 1);
        this.addComponent(jpMiddle, this.jcbCIMOMProtocol, constraints, 5, 1, 1, 1);
        this.addComponent(jpMiddle, jlPort, constraints, 1, 0, 1, 1);
        this.addComponent(jpMiddle, jlUrl, constraints, 0, 0, 1, 1);
        this.addComponent(jpMiddle, jlUID, constraints, 2, 0, 1, 1);
        this.addComponent(jpMiddle, jlpwd, constraints, 3, 0, 1, 1);
        this.addComponent(jpMiddle, jlNmSpace, constraints, 4, 0, 1, 1);
        this.addComponent(jpMiddle, jlProtocol, constraints, 5, 0, 1, 1);
        this.addComponent(jpMiddle, jbTest, constraints, 6, 1, 1, 1);
        constraints.insets.bottom = 0;
        constraints.insets.left = 0;
        constraints.insets.top = 0;
        constraints.fill = 2;
        this.addComponent(jpMain, jpMiddle, constraints, 1, 0, 1, 1);
        if (this.isCIMOMConfig) {
            this.jtfCIMOMUrl.setText(ConnectionUtility.CIMOMHostUrl);
            this.jtfCIMOMPort.setText(ConnectionUtility.CIMOMPort);
            this.jtfCIMOMUserName.setText(ConnectionUtility.CIMOMUserName);
            this.jtfCIMOMNmSpace.setText(ConnectionUtility.CIMOMNameSpace);
            this.jpfCIMOMPassword.setText(ConnectionUtility.CIMOMPassword);
            this.jcbCIMOMProtocol.setSelectedItem(ConnectionUtility.CIMOMProtocol);
        }
        return jpMain;
    }

    public JPanel getPortConnection() {
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 2;
        JPanel jpMain = new JPanel(this.layout);
        JLabel jlTitle = new JLabel("<html><b>Please specify Port Connections between devices</b><br><br><br><br><br></html>", 2);
        jlTitle.setFont(new Font("Times New RomanSerif", 0, 12));
        jlTitle.setBorder(BorderFactory.createEtchedBorder());
        jlTitle.setHorizontalTextPosition(2);
        jlTitle.setBorder(BorderFactory.createEtchedBorder());
        this.addComponent(jpMain, jlTitle, constraints, 0, 0, 1, 1);
        JPanel jpMiddle = new JPanel(new FlowLayout());
        jpMiddle.setBorder(BorderFactory.createEtchedBorder());
        JPanel jpLeft = new JPanel(new FlowLayout());
        this.switchPortList = new JList(ConnectionUtility.getSwitchPorts());
        this.switchPortList.setVisibleRowCount(5);
        this.switchPortList.setSelectionMode(0);
        jpLeft.add(new JScrollPane(this.switchPortList, 20, 32));
        jpLeft.setBorder(BorderFactory.createTitledBorder("SwitchPorts"));
        jpMiddle.add(jpLeft);
        JPanel jpCenter = new JPanel(new FlowLayout());
        this.otherDevicePortList = new JList(ConnectionUtility.getTargetDevicePorts());
        this.otherDevicePortList.setVisibleRowCount(5);
        this.otherDevicePortList.setSelectionMode(0);
        jpCenter.add(new JScrollPane(this.otherDevicePortList, 22, 32));
        jpCenter.setBorder(BorderFactory.createTitledBorder("Other DevicePort"));
        jpMiddle.add(jpCenter);
        JPanel jpControl = new JPanel(this.layout);
        JButton jbCopy = new JButton("Add >");
        JButton jbDelete = new JButton("Remove <");
        jbCopy.setActionCommand("Add");
        jbDelete.setActionCommand("Remove");
        constraints.insets.top = 10;
        constraints.insets.bottom = 10;
        this.addComponent(jpControl, jbCopy, constraints, 2, 0, 1, 1);
        this.addComponent(jpControl, jbDelete, constraints, 4, 0, 1, 1);
        jpMiddle.add(jpControl);
        JPanel jpRight = new JPanel(new FlowLayout());
        this.portConnList = new JList(ConnectionUtility.getPortConnections());
        this.portConnList.setSelectionMode(0);
        this.portConnList.setVisibleRowCount(5);
        jpRight.setBorder(BorderFactory.createTitledBorder("Port Connections"));
        jpRight.add(new JScrollPane(this.portConnList));
        jbCopy.addActionListener(new ButtonListener());
        jbDelete.addActionListener(new ButtonListener());
        constraints.insets.top = 0;
        constraints.insets.bottom = 0;
        this.addComponent(jpMain, jpMiddle, constraints, 1, 0, 1, 1);
        this.addComponent(jpMain, jpRight, constraints, 2, 0, 1, 1);
        return jpMain;
    }

    private void addComponent(JPanel panel, Component component, GridBagConstraints constraints, int row, int column, int width, int height) {
        constraints.anchor = 18;
        constraints.gridx = column;
        constraints.gridy = row;
        constraints.gridwidth = width;
        constraints.gridheight = height;
        constraints.weightx = 1.0;
        constraints.weighty = 0.0;
        this.layout.setConstraints(component, constraints);
        panel.add(component);
    }

    private ConnectionScreens() {
        super("SAN Simulation Installer");
        this.setDefaultCloseOperation(3);
    }

    public boolean connectionConfigSet() {
        boolean isSet = false;
        if (this.jrbSwitchToSwitch.isSelected() || this.jrbSwitchToHost.isSelected() || this.jrbSwitchToStorage.isSelected()) {
            isSet = true;
        }
        return isSet;
    }

    public boolean isSwitchDBConfig() {
        boolean isConfig = true;
        if (this.jtfDBUrl.getText().equals("localhost") || this.jtfDBUrl.getText().equals("127.0.0.1")) {
            ConnectionUtility.isSwitchDBLocal = true;
            return isConfig;
        }
        String strDBUrl = this.jtfDBUrl.getText();
        String strDBName = this.jtfDBName.getText();
        String strDBUid = this.jtfDBUid.getText();
        String strDBPwd = new String(this.jtfDBPwd.getPassword());
        if (strDBUrl.equals("")) {
            isConfig = false;
        } else if (strDBName.equals("")) {
            isConfig = false;
        } else if (strDBUid.equals("")) {
            isConfig = false;
        } else if (strDBPwd.equals("")) {
            isConfig = false;
        }
        if (isConfig && !ConnectionUtility.isSwitchDBLocal) {
            if (new TestDBConnection().testConnection(strDBName, strDBUid, strDBPwd, strDBUrl) == 0) {
                JOptionPane.showMessageDialog(null, "Remote database does not exist ! Please create DB at remote machine first", "Remote DB Fail", 0);
                System.exit(0);
            } else {
                isConfig = true;
            }
        }
        return isConfig;
    }

    public boolean isTargetDevcieDBConfig() {
        boolean isConfig = true;
        if (this.jtfDBUrl.getText().equals("localhost") || this.jtfDBUrl.getText().equals("127.0.0.1")) {
            ConnectionUtility.isOtherDBLocal = true;
            return isConfig;
        }
        if (this.jtfDBUrl.getText().equals("")) {
            isConfig = false;
        } else if (this.jtfDBName.getText().equals("")) {
            isConfig = false;
        } else if (this.jtfDBUid.getText().equals("")) {
            isConfig = false;
        } else if (new String(this.jtfDBPwd.getPassword()).equals("")) {
            isConfig = false;
        }
        return isConfig;
    }

    public boolean isCIMOMConfig() {
        boolean isConfig = true;
        if (this.jtfCIMOMUrl.getText().equals("")) {
            isConfig = false;
        } else if (this.jtfCIMOMPort.getText().equals("")) {
            isConfig = false;
        } else if (this.jtfCIMOMNmSpace.getText().equals("")) {
            isConfig = false;
        } else if (this.jtfCIMOMUserName.getText().equals("")) {
            isConfig = false;
        } else if (new String(this.jpfCIMOMPassword.getPassword()).equals("")) {
            isConfig = false;
        }
        if (isConfig) {
            String url = this.jtfCIMOMUrl.getText();
            String port = this.jtfCIMOMPort.getText();
            String namespace = this.jtfCIMOMNmSpace.getText();
            String uid = this.jtfCIMOMUserName.getText();
            String pwd = new String(this.jpfCIMOMPassword.getPassword());
            String protocol = (String)this.jcbCIMOMProtocol.getSelectedItem();
            try {
                if (new TestWbemCimomConnection().testConnection(url, port, uid, pwd, namespace, protocol) == 0) {
                    JOptionPane.showMessageDialog(null, "CIMOM Connection Failed.Please Check CIMOM Configuration", "CIMOM Connection", 0);
                    this.logger.info("CIMOM Connection Falied");
                    isConfig = false;
                }
            }
            catch (CIMException e1) {
                this.logger.severe("CIMOM Test Connection Exception: " + (Object)((Object)e1));
            }
        }
        return isConfig;
    }

    public boolean deviceConfigSet() {
        boolean isSet = true;
        if (ConnectionUtility.isLocal) {
            return isSet;
        }
        if (this.jtfCIMOMUrl.getText() == "") {
            isSet = false;
        } else if (this.jtfCIMOMPort.getText() == "") {
            isSet = false;
        } else if (this.jtfCIMOMUserName.getText() == "") {
            isSet = false;
        } else if (this.jtfCIMOMNmSpace.getText() == "") {
            isSet = false;
        } else if (new String(this.jpfCIMOMPassword.getPassword()).equals("")) {
            isSet = false;
        }
        return isSet;
    }

    public boolean isPortConnected() {
        boolean isConnected = true;
        if (ConnectionUtility.portConnections.size() == 0) {
            isConnected = false;
        }
        return isConnected;
    }

    public boolean isDevcieConnected() {
        boolean isConnected = true;
        if (this.jcbSwitches.getSelectedItem() == "" || this.jcbOtherDevices.getSelectedItem() == "") {
            isConnected = false;
            this.deviceConncted = false;
        }
        return isConnected;
    }

    public void saveDeviceConnection() {
        ConnectionUtility.switchName = (String)this.jcbSwitches.getSelectedItem();
        ConnectionUtility.deviceName = (String)this.jcbOtherDevices.getSelectedItem();
        ConnectionUtility.sourceFabric = (String)this.jcbSourcefabric.getSelectedItem();
        ConnectionUtility.destFabric = (String)this.jcbDestFabric.getSelectedItem();
        this.deviceConncted = true;
        this.logger.info("Device Connectivity: " + ConnectionUtility.switchName + " " + ConnectionUtility.deviceName);
    }

    public void savePortConnections() {
        Iterator iter = ConnectionUtility.portConnections.iterator();
        while (iter.hasNext()) {
            String strConn = (String)iter.next();
            String[] portConnections = strConn.split(" --> ");
            String switchPort = portConnections[0];
            String otherPort = portConnections[1];
            ConnectionUtility.switchPortConnected.add(switchPort);
            ConnectionUtility.oDevicePortConnected.add(otherPort);
        }
    }

    public void saveConnectionConf() {
        ConnectionUtility.ConnectMedium = this.jrbSwitchToSwitch.isSelected() ? (String)this.jcbSwitchOption.getSelectedItem() : (this.jrbSwitchToStorage.isSelected() ? (String)this.jcbStorageOption.getSelectedItem() : (String)this.jcbHostOption.getSelectedItem());
        this.logger.info("Connection specified: " + ConnectionUtility.ConnectMedium);
        this.isConnectOptionSet = true;
    }

    public void saveSwitchDBConfiguration() {
        ConnectionUtility.switchDBUrl = this.jtfDBUrl.getText();
        ConnectionUtility.switchDBName = this.jtfDBName.getText();
        ConnectionUtility.switchDBUserid = this.jtfDBUid.getText();
        ConnectionUtility.switchDBPassword = new String(this.jtfDBPwd.getPassword());
        this.isSwitchDBConfig = true;
        this.logger.info("Switch DB Configuration: " + ConnectionUtility.switchDBUrl + " " + ConnectionUtility.switchDBName + " " + ConnectionUtility.switchDBUserid + " " + ConnectionUtility.switchDBPassword);
    }

    public void saveTargetDevcieDBConfiguration() {
        ConnectionUtility.targetDevcieDBUrl = this.jtfDBUrl.getText();
        ConnectionUtility.targetDevcieDBName = this.jtfDBName.getText();
        ConnectionUtility.targetDevcieDBUserid = this.jtfDBUid.getText();
        ConnectionUtility.targetDevcieDBPassword = new String(this.jtfDBPwd.getPassword());
        this.isTargetDevcieDBConfig = true;
        this.logger.info("Target Device DB Configuration: " + ConnectionUtility.targetDevcieDBUrl + " " + ConnectionUtility.targetDevcieDBName + " " + ConnectionUtility.targetDevcieDBUserid + " " + ConnectionUtility.targetDevcieDBPassword);
    }

    public void saveCIMOMConfiguration() {
        ConnectionUtility.CIMOMHostUrl = this.jtfCIMOMUrl.getText();
        ConnectionUtility.CIMOMPort = this.jtfCIMOMPort.getText();
        ConnectionUtility.CIMOMNameSpace = this.jtfCIMOMNmSpace.getText();
        ConnectionUtility.CIMOMUserName = this.jtfCIMOMUserName.getText();
        ConnectionUtility.CIMOMPassword = new String(this.jpfCIMOMPassword.getPassword());
        ConnectionUtility.CIMOMProtocol = (String)this.jcbCIMOMProtocol.getSelectedItem();
        this.logger.info("CIMOM Configuration specified: " + ConnectionUtility.CIMOMHostUrl + " " + ConnectionUtility.CIMOMPort + " " + ConnectionUtility.CIMOMUserName + " " + ConnectionUtility.CIMOMPassword + " " + ConnectionUtility.CIMOMNameSpace + ConnectionUtility.CIMOMProtocol);
        this.isCIMOMConfig = true;
    }

    public static ConnectionScreens getInstance() {
        return ConnectionScreenHandler.instance;
    }

    public void saveConnectionPropToFile() {
        try {
            FileOutputStream output = new FileOutputStream("resources" + File.separator + "ConnectionSimulation.Properties");
            Properties prop = new Properties();
            String sourceSwitch = "SWITCH[" + ConnectionUtility.switchName + "]";
            String targetDevice = null;
            if (ConnectionUtility.profileConnection.equals(ConnectionUtility.SWITCH_TO_SWITCH)) {
                targetDevice = "SWITCH[" + ConnectionUtility.deviceName + "]";
                prop.setProperty("SWITCH_CONNECTED_TO", "Switch");
            }
            prop.setProperty("SOURCE_FABRIC_ID", ConnectionUtility.sourceFabric);
            prop.setProperty("DESTINATION_FABRIC_ID", ConnectionUtility.destFabric);
            prop.setProperty("SWITCH_DB_NAME", ConnectionUtility.switchDBName);
            prop.setProperty("SWITCH_DB_URL", ConnectionUtility.switchDBUrl);
            if (!ConnectionUtility.switchDBPassword.equals("")) {
                prop.setProperty("SWITCH_DB_USERNAME", ConnectionUtility.switchDBUserid);
                prop.setProperty("SWITCH_DB_PASSWORD", ConnectionUtility.switchDBPassword);
            } else {
                prop.setProperty("SWITCH_DB_USERNAME", "Default");
                prop.setProperty("SWITCH_DB_PASSWORD", "Default");
            }
            if (ConnectionUtility.profileConnection.equals(ConnectionUtility.SWITCH_TO_ARRAY)) {
                prop.setProperty("SWITCH_CONNECTED_TO", "Storage");
                targetDevice = "STORAGE[" + ConnectionUtility.deviceName + "]";
                if (ConnectionUtility.ConnectMedium.equals(ConnectionUtility.CIM_CLIENT)) {
                    prop.setProperty("TARGET_DEVICE_CLIENT", "CIM Client");
                    prop.setProperty("STORAGE_DEVICE_CATEGORY", RemoteCIMClient.deviceType);
                    prop.setProperty("TARGET_DEVICE_CIMOM_URL", ConnectionUtility.CIMOMHostUrl);
                    prop.setProperty("TARGET_DEVICE_CIMOM_PORT", ConnectionUtility.CIMOMPort);
                    prop.setProperty("TARGET_DEVICE_CIMOM_USERNAME", ConnectionUtility.CIMOMUserName);
                    prop.setProperty("TARGET_DEVICE_CIMOM_PASSWORD", ConnectionUtility.CIMOMPassword);
                    prop.setProperty("TARGET_DEVICE_CIMOM_NAMESPACE", ConnectionUtility.CIMOMNameSpace);
                    prop.setProperty("TARGET_DEVICE_CIMOM_PROTOCOL", ConnectionUtility.CIMOMProtocol);
                } else if (ConnectionUtility.ConnectMedium.equals(ConnectionUtility.DB_CLIENT)) {
                    prop.setProperty("TARGET_DEVICE_CLIENT", "DB Client");
                    prop.setProperty("STORAGE_DEVICE_CATEGORY", TargetDeviceDBClient.storageDeviceCategory);
                    prop.setProperty("TARGET_DEVICE_DB_NAME", ConnectionUtility.targetDevcieDBName);
                    prop.setProperty("TARGET_DEVICE_DB_URL", ConnectionUtility.targetDevcieDBUrl);
                    if (!ConnectionUtility.targetDevcieDBPassword.equals("")) {
                        prop.setProperty("TARGET_DEVICE_DB_USERNAME", ConnectionUtility.targetDevcieDBUserid);
                        prop.setProperty("TARGET_DEVICE_DB_PASSWORD", ConnectionUtility.targetDevcieDBPassword);
                    } else {
                        prop.setProperty("TARGET_DEVICE_DB_USERNAME", "Default");
                        prop.setProperty("TARGET_DEVICE_DB_PASSWORD", "Default");
                    }
                }
            }
            String deviceConn = sourceSwitch + ":" + targetDevice;
            prop.setProperty("DEVICE_CONNECTIVTY", deviceConn);
            Iterator switchPort = ConnectionUtility.switchPortConnected.iterator();
            Iterator devciePort = ConnectionUtility.oDevicePortConnected.iterator();
            String portConnections = "";
            int tempCnt = 0;
            while (switchPort.hasNext() && devciePort.hasNext()) {
                if (tempCnt != 0) {
                    portConnections = portConnections + ",";
                }
                String sPort = (String)switchPort.next();
                String dPort = (String)devciePort.next();
                portConnections = portConnections + sPort + ":" + dPort;
                ++tempCnt;
            }
            prop.setProperty("PORT_CONNECTIVITY", portConnections);
            prop.store(output, "SAN Simulator Properties");
            output.close();
        }
        catch (IOException ioException) {
            ioException.printStackTrace();
        }
    }

    private static class ConnectionScreenHandler {
        private static ConnectionScreens instance = new ConnectionScreens();

        private ConnectionScreenHandler() {
        }
    }

    protected class ButtonListener
    implements ActionListener {
        protected ButtonListener() {
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getActionCommand() == "Add") {
                if (ConnectionScreens.this.switchPortList.isSelectionEmpty() || ConnectionScreens.this.otherDevicePortList.isSelectionEmpty()) {
                    JOptionPane.showMessageDialog(null, "Please select ports from both devices.", "Invalid Connection", 0);
                } else {
                    String connStr = ConnectionScreens.this.switchPortList.getSelectedValue() + " --> " + ConnectionScreens.this.otherDevicePortList.getSelectedValue();
                    ConnectionUtility.setPortConnections(connStr);
                    ConnectionUtility.switchPortAvailable.remove(ConnectionScreens.this.switchPortList.getSelectedValue());
                    ConnectionUtility.devicePortAvailable.remove(ConnectionScreens.this.otherDevicePortList.getSelectedValue());
                    ConnectionScreens.this.switchPortList.setListData(ConnectionUtility.switchPortAvailable);
                    ConnectionScreens.this.otherDevicePortList.setListData(ConnectionUtility.devicePortAvailable);
                    ConnectionScreens.this.portConnList.setListData(ConnectionUtility.getPortConnections());
                }
            } else if (e.getActionCommand() == "Remove") {
                String strConn = (String)ConnectionScreens.this.portConnList.getSelectedValue();
                String[] strPorts = strConn.split("-->");
                String switchPort = strPorts[0];
                String otherPort = strPorts[1];
                ConnectionUtility.switchPortAvailable.add(switchPort);
                ConnectionUtility.devicePortAvailable.add(otherPort);
                ConnectionScreens.this.switchPortList.setListData(ConnectionUtility.switchPortAvailable);
                ConnectionScreens.this.otherDevicePortList.setListData(ConnectionUtility.devicePortAvailable);
                ConnectionUtility.portConnections.remove(ConnectionScreens.this.portConnList.getSelectedValue());
                ConnectionScreens.this.portConnList.setListData(ConnectionUtility.getPortConnections());
            } else if (e.getActionCommand() == "TestDB") {
                ConnectionScreens.this.setCursor(Cursor.getPredefinedCursor(3));
                String dbUrl = ConnectionScreens.this.jtfDBUrl.getText();
                String dbname = ConnectionScreens.this.jtfDBName.getText();
                String dbuid = ConnectionScreens.this.jtfDBUid.getText();
                String dbpwd = new String(ConnectionScreens.this.jtfDBPwd.getPassword());
                if (dbuid.equals("")) {
                    dbuid = "Default";
                }
                if (dbpwd.equals("")) {
                    dbpwd = "Default";
                }
                if (new TestDBConnection().testConnection(dbname, dbuid, dbpwd, dbUrl) == 0) {
                    JOptionPane.showMessageDialog(null, "Database Connection Failed!", "DB Connection", 0);
                } else {
                    JOptionPane.showMessageDialog(null, "Databse Connection Successful", "DB Connection", 1);
                }
                ConnectionScreens.this.setCursor(Cursor.getDefaultCursor());
            } else if (e.getActionCommand() == "TestCIMOM") {
                ConnectionScreens.this.setCursor(Cursor.getPredefinedCursor(3));
                String cimUrl = ConnectionScreens.this.jtfCIMOMUrl.getText();
                String cimPort = ConnectionScreens.this.jtfCIMOMPort.getText();
                String cimUid = ConnectionScreens.this.jtfCIMOMUserName.getText();
                String cimNmspace = ConnectionScreens.this.jtfCIMOMNmSpace.getText();
                String cimProtocol = (String)ConnectionScreens.this.jcbCIMOMProtocol.getSelectedItem();
                String cimPwd = new String(ConnectionScreens.this.jpfCIMOMPassword.getPassword());
                try {
                    if (new TestWbemCimomConnection().testConnection(cimUrl, cimPort, cimUid, cimPwd, cimNmspace, cimProtocol) == 0) {
                        JOptionPane.showMessageDialog(null, "CIMOM Connection Failed", "CIMOM Connection", 0);
                        ConnectionScreens.this.logger.info("CIMOM Connection Falied");
                    } else {
                        JOptionPane.showMessageDialog(null, "CIMOM Connection Successful", "CIMOM Connection", 1);
                        ConnectionScreens.this.logger.info("CIMOM Connection Successful");
                    }
                }
                catch (CIMException e1) {
                    ConnectionScreens.this.logger.severe("CIMOM Test Connection Exception: " + e);
                }
                ConnectionScreens.this.setCursor(Cursor.getDefaultCursor());
            }
        }
    }

    protected class SourceFabricSelect
    implements ItemListener {
        protected SourceFabricSelect() {
        }

        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                String sourceFabricSelected = (String)ConnectionScreens.this.jcbSourcefabric.getSelectedItem();
                if (sourceFabricSelected != "") {
                    ConnectionScreens.this.jcbDestFabric.setEnabled(true);
                    ConnectionScreens.this.jcbDestFabric.setSelectedItem(sourceFabricSelected);
                    ConnectionScreens.this.jcbDestFabric.setEnabled(false);
                    ConnectionScreens.this.jcbSwitches.setEnabled(true);
                    ConnectionScreens.this.jcbOtherDevices.setEnabled(true);
                    ConnectionUtility.getSwitchNames(sourceFabricSelected);
                    ConnectionUtility.getDeviceToConnect();
                }
            } else {
                ConnectionUtility.resetSwitchNames();
                ConnectionUtility.resetOtherDeviceNames();
            }
        }
    }

    protected class DeviceSelect
    implements ItemListener {
        String prevSelected = null;

        protected DeviceSelect() {
        }

        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                ConnectionScreens.this.jcbOtherDevices.setSelectedIndex(0);
                String switchSelected = (String)ConnectionScreens.this.jcbSwitches.getSelectedItem();
                if (ConnectionUtility.profileConnection.equals(ConnectionUtility.SWITCH_TO_SWITCH)) {
                    if (switchSelected != "") {
                        ConnectionUtility.otherDevicesvector.remove(switchSelected);
                    }
                    if (this.prevSelected != null && this.prevSelected != "") {
                        ConnectionUtility.otherDevicesvector.add(this.prevSelected);
                    }
                }
                this.prevSelected = switchSelected;
                ConnectionScreens.this.jcbOtherDevices.repaint();
            }
        }
    }

    protected class RadioButtonHandler
    implements ItemListener {
        private String option;

        public RadioButtonHandler(String str) {
            this.option = str;
        }

        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                if (this.option.equals("ToSwitch")) {
                    ConnectionUtility.profileConnection = ConnectionUtility.SWITCH_TO_SWITCH;
                    ConnectionScreens.this.jcbStorageOption.setEnabled(false);
                    ConnectionScreens.this.jcbHostOption.setEnabled(false);
                    ConnectionScreens.this.jcbSwitchOption.setEnabled(true);
                } else if (this.option.equals("ToStorage")) {
                    ConnectionUtility.profileConnection = ConnectionUtility.SWITCH_TO_ARRAY;
                    ConnectionScreens.this.jcbStorageOption.setEnabled(true);
                    ConnectionScreens.this.jcbHostOption.setEnabled(false);
                    ConnectionScreens.this.jcbSwitchOption.setEnabled(false);
                } else if (this.option.equals("ToHost")) {
                    ConnectionUtility.profileConnection = ConnectionUtility.SWITCH_TO_HOST;
                    ConnectionScreens.this.jcbStorageOption.setEnabled(false);
                    ConnectionScreens.this.jcbHostOption.setEnabled(true);
                    ConnectionScreens.this.jcbSwitchOption.setEnabled(false);
                }
            }
        }
    }
}

