/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.wbem.cim;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Vector;
import org.sblim.wbem.cim.CIMElement;
import org.sblim.wbem.cim.CIMQualifier;
import org.sblim.wbem.util.Utils;

public abstract class CIMQualifiableElement
extends CIMElement
implements Serializable {
    protected Vector iQualifiers = new Vector(0);

    protected CIMQualifiableElement() {
    }

    protected CIMQualifiableElement(String pName) {
        super(pName);
    }

    public void addQualifier(CIMQualifier pQualifier) {
        if (pQualifier == null) {
            throw new IllegalArgumentException("null qualifier argument");
        }
        if (this.getQualifier(pQualifier.getName()) == null) {
            Utils.addSorted(this.iQualifiers, pQualifier);
        }
    }

    public CIMQualifier getQualifier(String pName) {
        if (pName == null) {
            throw new IllegalArgumentException("null qualifier name argument");
        }
        Iterator iter = this.iQualifiers.iterator();
        while (iter.hasNext()) {
            CIMQualifier qualifier = (CIMQualifier)iter.next();
            if (!qualifier.getName().equalsIgnoreCase(pName)) continue;
            return qualifier;
        }
        return null;
    }

    public void setQualifiers(Vector pQualifiers) {
        if (pQualifiers == null) {
            this.iQualifiers.setSize(0);
        } else {
            Utils.addSorted(this.iQualifiers, pQualifiers);
        }
    }

    public Vector getQualifiers() {
        return this.iQualifiers;
    }

    public boolean removeQualifier(String pName) {
        if (pName == null) {
            throw new IllegalArgumentException("null qualifier argument");
        }
        Iterator iter = this.iQualifiers.iterator();
        while (iter.hasNext()) {
            CIMQualifier qual = (CIMQualifier)iter.next();
            if (!qual.getName().equalsIgnoreCase(pName)) continue;
            iter.remove();
            return true;
        }
        return false;
    }
}

