/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.simulator.ui;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.text.MessageFormat;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import org.eclipse.aperi.simulator.ui.RestoreDB;
import org.eclipse.aperi.simulator.ui.SetupWizardUtility;

public class DatabaseUtility {
    private static final String DB_DRIVER = "com.ibm.db2.jcc.DB2Driver";
    private static final String CREATE_DB_COMMAND = "C:\\Program Files\\IBM\\SQLLIB\\bin\\db2cmd.exe -c -w -i db2 create DB {0}";
    private static final String RUN_DDL_COMMAND_WITH_CREDENTIAL = "C:\\Program Files\\IBM\\SQLLIB\\bin\\db2batch.exe -d {0} -a {1}/{2} -f {3}";
    private static final String DDL_FILE_PATH = "ddl" + File.separator + "SIM.DDL";
    private Logger logger = Logger.getLogger(DatabaseUtility.class.getName());

    public int CreateDatabase() {
        boolean restoreDBSet;
        String simulationMode = SetupWizardUtility.getProperty("SIMULATION_MODE");
        int retVal = 0;
        if (simulationMode.equals("Snapshot-based") && (restoreDBSet = SetupWizardUtility.getProperty("SNAPSHOT_SIMULATION_MODE").equals("Restore Backup DB"))) {
            if (this.restore()) {
                retVal = 2;
            } else {
                this.logger.severe("Error occurred during restoring DB");
                retVal = 0;
            }
            return retVal;
        }
        int createDB = this.TestDB();
        if (createDB == 0) {
            this.logger.info("Database does not exist!Create database !");
            if (this.create()) {
                retVal = 1;
            }
        } else if (createDB == 1) {
            retVal = 1;
        }
        return retVal;
    }

    private boolean restore() {
        RestoreDB restDB = new RestoreDB();
        boolean retVal = restDB.restore(SetupWizardUtility.getProperty("DB_NAME"), SetupWizardUtility.getProperty("BACK_UP_PATH"));
        if (retVal) {
            this.logger.info("Database restored successfully: " + retVal);
        } else {
            this.logger.info("Database restored failed: " + retVal);
        }
        return retVal;
    }

    private boolean create() {
        boolean retVal = false;
        String UserName = SetupWizardUtility.getProperty("DB_USER_NAME");
        String PassWord = SetupWizardUtility.getProperty("DB_PASSWORD");
        String DBName = SetupWizardUtility.getProperty("DB_NAME");
        if (UserName.equals("Default") || PassWord.equals("Default")) {
            UserName = JOptionPane.showInputDialog("Enter DB Username: ", (Object)"db2admin");
            PassWord = JOptionPane.showInputDialog("Enter DB Password: ", (Object)"db2admin");
            if (UserName == null || PassWord == null) {
                JOptionPane.showMessageDialog(null, "Database could not be created! So SetupWizard will abort", "DB Error", 0);
                System.exit(0);
            }
        }
        String command = MessageFormat.format(RUN_DDL_COMMAND_WITH_CREDENTIAL, DBName, UserName, PassWord, DDL_FILE_PATH);
        try {
            if (this.runDBCreate() && this.ConfigDB(command)) {
                retVal = true;
            }
        }
        catch (Exception e) {
            retVal = false;
            e.printStackTrace();
            this.logger.severe(e.getMessage() + e);
        }
        this.logger.info("Database created successfully: " + retVal);
        return retVal;
    }

    private boolean ConfigDB(String command) {
        boolean retVal = false;
        this.logger.info("DB Create Command: " + command);
        int val = this.executeCommand(command);
        retVal = val == 0;
        return retVal;
    }

    public boolean runDBCreate() throws Exception {
        String createCommand = MessageFormat.format(CREATE_DB_COMMAND, SetupWizardUtility.getProperty("DB_NAME"));
        this.logger.info("Create database command to execute: " + createCommand);
        return this.executeCommand(createCommand) == 0;
    }

    private int executeCommand(String command) {
        int retVal = -1;
        try {
            String data;
            Process process = Runtime.getRuntime().exec(command);
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while (null != (data = reader.readLine())) {
                this.logger.info("Database create Output: " + data);
            }
            reader.close();
            reader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
            while (null != (data = reader.readLine())) {
                this.logger.info("Database Error: " + data);
            }
            reader.close();
            retVal = process.waitFor();
        }
        catch (IOException e) {
            this.logger.severe(e.getMessage() + e);
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            this.logger.severe(e.getMessage() + e);
        }
        return retVal;
    }

    public int TestDB() {
        int flag = 0;
        try {
            Class.forName(DB_DRIVER);
            String UserName = SetupWizardUtility.getProperty("DB_USER_NAME");
            String PassWord = SetupWizardUtility.getProperty("DB_PASSWORD");
            String dbHostUrl = SetupWizardUtility.getProperty("DB_HOST_URL");
            if (dbHostUrl.equalsIgnoreCase("localhost")) {
                if (UserName.equals("Default") || PassWord.equals("Default")) {
                    String dbUrl = "jdbc:db2:" + SetupWizardUtility.getProperty("DB_NAME");
                    Connection con = DriverManager.getConnection(dbUrl);
                    this.logger.info("Database connection successful!");
                    con.close();
                } else {
                    String DBName = SetupWizardUtility.getProperty("DB_NAME");
                    String dbUrl = "jdbc:db2://localhost:50000/" + DBName;
                    this.logger.info("DB_URL is " + dbUrl);
                    Connection con = DriverManager.getConnection(dbUrl, UserName, PassWord);
                    this.logger.info("Database connection successful!");
                    con.close();
                }
                flag = 1;
            } else {
                flag = 1;
            }
        }
        catch (Exception e) {
            this.logger.info("Database with this name does not exist!");
        }
        return flag;
    }
}

