/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.simulator.cimom.brocade;

import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import javax.wbem.cim.CIMInstance;
import org.eclipse.aperi.simulator.cimom.common.DatabaseManager;
import org.eclipse.aperi.simulator.cimom.common.IDGenerator;
import org.eclipse.aperi.simulator.cimom.common.generator.DataGeneratorResponse;
import org.eclipse.aperi.simulator.cimom.common.generator.DeviceDataGenerator;
import org.eclipse.aperi.simulator.cimom.common.generator.PropertyParser;

public class BrocadeCIMOMDataGenerator {
    private static final String FABRIC_NAME_SUFFIX = "69101F9A";
    private static final String CONFIG_FILE = "conf/Brocade-requirement.config";
    private static final String BROCADE_ROOT_XML = "XML\\Brocade\\Switch\\Brocade_Root_Brocade1.xml";
    private static final String BROCADE_INTEROP_XML = "XML\\Brocade\\Switch\\Brocade_Interop.xml";
    private static final String NAMESPACE_ROOT_BROCADE1 = "/root/brocade1";
    private static final String NAMESPACE_INTEROP = "/interop";

    public void generateData() throws Exception {
        DatabaseManager dbManager = DatabaseManager.getDbManager();
        dbManager.insert_CIMOM_INFO(1, "Simulated Brocade CIMOM", "127.0.0.1", NAMESPACE_INTEROP, "administrator", "san46pass");
        int cimomId = dbManager.getMaxID("SIM.CIMOM_INFO");
        dbManager.insert_NS_INFO(cimomId, NAMESPACE_INTEROP);
        int interopNsID = dbManager.getMaxID("SIM.NS_INFO");
        dbManager.insert_NS_INFO(cimomId, NAMESPACE_ROOT_BROCADE1);
        int rootNsID = dbManager.getMaxID("SIM.NS_INFO");
        this.generateData(interopNsID, rootNsID);
    }

    private void generateData(int interopNsID, int rootNsID) throws Exception {
        DeviceDataGenerator interopDataGenerator = new DeviceDataGenerator(BROCADE_INTEROP_XML, CONFIG_FILE);
        DataGeneratorResponse interopResponse = interopDataGenerator.generateData(NAMESPACE_INTEROP);
        DeviceDataGenerator rootDataGenerator = new DeviceDataGenerator(BROCADE_ROOT_XML, CONFIG_FILE);
        DataGeneratorResponse rootResponse = rootDataGenerator.generateData(NAMESPACE_ROOT_BROCADE1);
        Properties confProperties = new Properties();
        confProperties.load(new FileInputStream(CONFIG_FILE));
        PropertyParser parser = new PropertyParser();
        Properties classProperties = parser.parse("conf" + File.separator + "ClassList.xml");
        int numberOfFabric = Integer.parseInt(confProperties.getProperty("NUMBER_OF_FABRIC"));
        int fabric = 10000060;
        int switchN = 10000060;
        ArrayList<CIMInstance> fabricInstances = new ArrayList<CIMInstance>();
        String currentFabricSuffix = Integer.toString(Integer.parseInt(FABRIC_NAME_SUFFIX, 16) + IDGenerator.getRandomKey("4"), 16).toUpperCase();
        for (int fabricCount = 0; fabricCount < numberOfFabric; ++fabricCount) {
            String fabricName;
            String fabricSuffix = Integer.toString(Integer.parseInt(currentFabricSuffix, 16) + 10 * fabricCount, 16).toUpperCase();
            String switchName = fabricName = fabric + fabricSuffix;
            interopDataGenerator.getConfProperties().setProperty("FABRIC_NAME", fabricName);
            rootDataGenerator.getConfProperties().setProperty("FABRIC_NAME", fabricName);
            rootDataGenerator.getConfProperties().setProperty("NUMBER_OF_FABRIC", Integer.toString(1));
            interopDataGenerator.getConfProperties().setProperty("NUMBER_OF_FABRIC", Integer.toString(1));
            String[] classArray = classProperties.getProperty("INTEROP_FABRIC_CLASS_LIST").split(",");
            LinkedList classList = new LinkedList();
            Collections.addAll(classList, classArray);
            interopDataGenerator.generateData(classList, interopResponse);
            String[] rootClassArray = classProperties.getProperty("FABRIC_CLASS_LIST").split(",");
            ArrayList rootClassList = new ArrayList();
            Collections.addAll(rootClassList, rootClassArray);
            rootDataGenerator.generateData(rootClassList, rootResponse);
            CIMInstance fabricInstance = (CIMInstance)rootResponse.getInstanceMap().get("/root/brocade1:Brocade_Fabric");
            int numberOfSwitch = Integer.parseInt(confProperties.getProperty("NUMBER_OF_SWITCHES"));
            classArray = classProperties.getProperty("INTEROP_SWITCH_CLASS_LIST").split(",");
            classList.clear();
            Collections.addAll(classList, classArray);
            rootClassArray = classProperties.getProperty("SWITCH_CLASS_LIST").split(",");
            rootClassList.clear();
            Collections.addAll(rootClassList, rootClassArray);
            rootDataGenerator.getConfProperties().setProperty("NUMBER_OF_SWITCHES", Integer.toString(1));
            interopDataGenerator.getConfProperties().setProperty("NUMBER_OF_SWITCHES", Integer.toString(1));
            int i = 0;
            while (i < numberOfSwitch) {
                String switchID = Integer.toString(1001 + i + 100 * fabricCount);
                interopDataGenerator.getConfProperties().setProperty("SWITCH_ID", switchID);
                interopDataGenerator.getConfProperties().setProperty("SWITCH_NAME", switchName);
                interopDataGenerator.getConfProperties().setProperty("SWITCH_ELEMENT_NAME", "SimulatedSwitch_" + switchID);
                interopDataGenerator.generateData(classList, interopResponse);
                rootDataGenerator.getConfProperties().setProperty("SWITCH_ID", switchID);
                rootDataGenerator.getConfProperties().setProperty("SWITCH_NAME", switchName);
                rootDataGenerator.getConfProperties().setProperty("SWITCH_ELEMENT_NAME", "SimulatedSwitch_" + switchID);
                rootDataGenerator.getConfProperties().setProperty("SWITCH_PORT_PREFIX", switchName.substring(4, switchName.length()));
                rootDataGenerator.generateData(rootClassList, rootResponse);
                switchName = switchN + ++i + 100 * fabricCount + fabricSuffix;
            }
            rootResponse.getInstanceMap().remove("/root/brocade1:Brocade_Fabric");
            fabricInstances.add(fabricInstance);
        }
        rootResponse.addInstances("/root/brocade1:Brocade_Fabric", fabricInstances);
        Map classMap = rootDataGenerator.getParserResponse().getClassMap();
        DatabaseManager.getDbManager().persistInstances(rootNsID, rootResponse.getInstanceMap(), classMap);
        classMap = interopDataGenerator.getParserResponse().getClassMap();
        DatabaseManager.getDbManager().persistInstances(interopNsID, interopResponse.getInstanceMap(), classMap);
    }

    public static void main(String[] args) throws Exception {
        System.out.println("Jai Baberi");
        BrocadeCIMOMDataGenerator test = new BrocadeCIMOMDataGenerator();
        test.generateData();
        System.out.println("Program Completed");
    }
}

