/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.simulator.ui;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.Logger;
import org.eclipse.aperi.simulator.cimom.DS4K.DS4KCimomDataGenerator;
import org.eclipse.aperi.simulator.cimom.DS6K.DS6KCimomDataGenerator;
import org.eclipse.aperi.simulator.cimom.DS8K.DS8KGenerator;
import org.eclipse.aperi.simulator.cimom.brocade.BrocadeCIMOMDataGenerator;
import org.eclipse.aperi.simulator.ui.SetupWizardUtility;

public class ConfigDataGenerator {
    private Logger logger = Logger.getLogger(ConfigDataGenerator.class.getName());

    public void generator(String FilePath, String deviceType) {
        Object test;
        if (deviceType.equalsIgnoreCase("DS6K_5.1.0.40")) {
            this.logger.info("Generating data for DS6K_5.1.0.40");
            test = new DS6KCimomDataGenerator();
            ((DS6KCimomDataGenerator)test).generateData(FilePath);
        }
        if (deviceType.equalsIgnoreCase("DS8K_5.1.0.40")) {
            this.logger.info("Generating data for DS8K_5.1.0.40");
            test = new DS8KGenerator();
            ((DS8KGenerator)test).generateData(FilePath);
        } else if (deviceType.equalsIgnoreCase("DS4K_9.16.G0.06")) {
            this.logger.info("Generating data for DS4K_9.16.G0.06");
            test = new DS4KCimomDataGenerator();
            ((DS4KCimomDataGenerator)test).generateData(FilePath);
        } else if (deviceType.equalsIgnoreCase("Brocade_110.4.0a")) {
            this.logger.info("Generating data for Brocade_110.4.0a");
            test = new BrocadeCIMOMDataGenerator();
            try {
                ((BrocadeCIMOMDataGenerator)test).generateData();
            }
            catch (Exception e) {
                this.logger.severe("Error in Data Generatiion for Brocade: " + e);
            }
        }
    }

    public void ConfigureDBForConfiguration() {
        Properties properties = new Properties();
        properties.setProperty("DATABASE", "db2");
        properties.setProperty("DB_NAME", SetupWizardUtility.getProperty("DB_NAME"));
        properties.setProperty("DB_USERNAME", SetupWizardUtility.getProperty("DB_USER_NAME"));
        properties.setProperty("DB_PASSWORD", SetupWizardUtility.getProperty("DB_PASSWORD"));
        properties.setProperty("DB_LOCATION", SetupWizardUtility.getProperty("DB_HOST_URL"));
        try {
            File temp = File.createTempFile("setupwizard", ".config");
            temp.deleteOnExit();
            properties.store(new FileOutputStream(temp), "SETUP WIZARD PROPERTIES");
            System.setProperty("SETUP_WIZARD_CONFIG_FILEPATH", temp.getAbsolutePath());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

