/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.simulator.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.wbem.cim.CIMException;
import org.eclipse.aperi.simulator.ui.CheckPreRequisites;
import org.eclipse.aperi.simulator.ui.SetupWizardUtility;
import org.eclipse.aperi.simulator.ui.TestDBConnection;
import org.eclipse.aperi.simulator.ui.TestWbemCimomConnection;

public class InputScreens {
    private static final String CREATE_DEVICE_MOF_VALUE = "Create device Mof";
    private static final String INTERACTIVE_VALUE = "Interactive";
    private static final String NON_INTERACTIVE_VALUE = "NonInteractive";
    private static final String SIMULATE_DEVICE_CHECK_VALUE = "Simulate Device";
    private static final String COMPILE_MOF_CHECK_VALUE = "Start CIMOM and Compile MOF files";
    private static final String CREATE_NEW_CIMOM_CHECK_VALUE = "Create New CIMOM";
    private GridBagLayout layout = new GridBagLayout();
    private GridBagConstraints constraints = new GridBagConstraints();
    private JButton jbBrowseDirPath;
    protected JTextField jtfdirName;
    private static final File DEFAULT_WBEM_DIR_PATH = new File("C:\\SAN_SIMULATOR");
    private static final File DEFAULT_PROPERTY_FILE_PATH = new File("C:\\SAN_SIMULATOR\\SANSimulator.Properties");
    private boolean wbemPropertiesSet;
    private String destinationPath;
    private File fileName;
    private JRadioButton jrbInterActive;
    private JRadioButton jrbNonInterActive;
    protected boolean nonInteractiveSetup;
    protected boolean interactiveSetup;
    protected boolean setupModeSet;
    protected boolean installModeClicked;
    private JRadioButton jrbSwitch;
    private JRadioButton jrbStorage;
    private JRadioButton jrbOthers;
    private JRadioButton jrbServer;
    private JComboBox jcbSwitch;
    private JComboBox jcbStorage;
    private JComboBox jcbOthers;
    private JComboBox jcbServer;
    protected boolean deviceClicked = false;
    private String[] switchTypes = new String[]{"Brocade_110.4.0a", "Cisco (Not Supported)", "McData (Not Supported)", "QLogic (Not Supported)"};
    private String[] storageTypes = new String[]{"DS4K_9.16.G0.06", "DS6K_5.1.0.40", "DS8K_5.1.0.40"};
    private String[] serverTypes = new String[]{"IBM AIX(Not Supported)", "Linux(Not Supported)", "Microsoft Windows(Not Supported)"};
    private String[] otherDevices = new String[]{"IBM Tape Library", "iSCSi Device(Not Supported)"};
    private ButtonGroup jbgradioGroup;
    private boolean devicePropSet;
    private boolean switchSelected;
    private boolean storageSelected;
    private boolean othersSelected;
    private boolean serverSelected;
    private String deviceCategory;
    private String deviceType = "Not Set";
    private JTextField jtfDBName;
    private JTextField jtfDBUserId;
    private JTextField jtfDBHostUrl;
    private JPasswordField jtfDBPasswd;
    private boolean databasePropSet;
    private String dbName;
    private String dbUserId;
    private String dbPassWord;
    private String dbHostUrl;
    private JComboBox jcbSimulation_mode;
    private String[] simulationTypes = new String[]{"Snapshot-based", "Configuaration-based"};
    private String simulationMode;
    private boolean simulationModeSet;
    private JRadioButton jrbFresh;
    private JRadioButton jrbRestore;
    protected boolean snapshotSetupMode = true;
    protected boolean restoreBackupDB;
    protected boolean startFreshSnapshot;
    protected boolean snapshotModeSet;
    protected boolean setupModeClicked;
    private JButton jbBrowseDBPath;
    protected boolean dbPathSet;
    protected JTextField jtfBackupDBPath;
    private String strdbPath;
    private String snapshot_type;
    private JTextField jtfCIMhost_url;
    private JTextField jtfCIMuid;
    private JTextField jtfCIMport;
    private JTextField jtfCIMnmspace;
    private JPasswordField jtfCIMpwd;
    private JComboBox jcbprotocols;
    private JComboBox jcbcimomTypes;
    private String[] cimomTypes = new String[]{"Sun WBEM", "SBLIM"};
    private String[] protocols = new String[]{"http", "https"};
    private String cimomHostUrl;
    private String cimomPort;
    private String cimomUid;
    private String cimomPwd;
    private String cimomNameSpace;
    private String cimomProtocol;
    private boolean cimomPropSet;
    private String cimomType;
    private JButton jbBrowseConfigFile;
    private boolean dbConnectionExist = false;
    private boolean dbConnectionTested = false;
    protected JTextField jtfConfigFilePath;
    private boolean configPropSet;
    private String strConfigFile;
    private File configFile;
    private JButton jbBrowsePropFile;
    protected JTextField jtfSANPropFilePath;
    private boolean nonInteractiveModeSet;
    protected static String SANPropPath;
    private File SANPropFile;
    protected JCheckBox jchbWbemInstall;
    private JCheckBox jchbCompileMof;
    private JCheckBox jchbSimulateDevice;
    private Logger logger = Logger.getLogger(InputScreens.class.getName());
    private JTextField jtfWbemInstallpathTxt;
    private JButton browseBt;
    private JTextField jtfCimomPathTxt;
    private JButton browseCimomDir;
    private JTextField jtfMofFilePathTxt;
    private JButton browseMofFile;
    private JCheckBox jchbCreateNewMof;
    private JButton browseMofLoc;
    private JTextField jtfMofFileTxt;

    protected JPanel createSetupModeSelectionScreen() {
        JPanel jpMain = new JPanel(new GridBagLayout());
        JLabel jlTitle = new JLabel("<html><b>Please select the mode of Setup</b><br><br> Experts can choose a <b>\"Non-interactive mode\"</b> where user can give all the inputs through a single file.<br> It is recommended that new users choose <b>\"Interactive mode\"</b>.<br></html>", 2);
        jlTitle.setBorder(BorderFactory.createEtchedBorder());
        jlTitle.setHorizontalTextPosition(2);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        jpMain.add((Component)jlTitle, gbc);
        GridBagConstraints gbcWidget = new GridBagConstraints();
        gbcWidget.anchor = 18;
        gbcWidget.fill = 2;
        gbcWidget.gridheight = 1;
        gbcWidget.gridwidth = 1;
        gbcWidget.gridx = 0;
        gbcWidget.gridy = 0;
        gbcWidget.weightx = 1.0;
        gbcWidget.weighty = 0.0;
        gbcWidget.insets.top = 15;
        gbcWidget.insets.bottom = 10;
        JPanel jpBottom = new JPanel(this.layout);
        this.jrbNonInterActive = new JRadioButton("Non-interactive Mode");
        gbcWidget.gridx = 0;
        gbcWidget.gridy = 1;
        jpBottom.add((Component)this.jrbNonInterActive, gbcWidget);
        this.jrbInterActive = new JRadioButton("Interactive Mode");
        gbcWidget.gridx = 0;
        gbcWidget.gridy = 2;
        jpBottom.add((Component)this.jrbInterActive, gbcWidget);
        ButtonGroup jbgInstallMode = new ButtonGroup();
        jbgInstallMode.add(this.jrbNonInterActive);
        jbgInstallMode.add(this.jrbInterActive);
        this.jrbInterActive.addItemListener(new InstallRadioHandler(INTERACTIVE_VALUE));
        this.jrbNonInterActive.addItemListener(new InstallRadioHandler(NON_INTERACTIVE_VALUE));
        gbc.gridx = 0;
        gbc.gridy = 1;
        jpBottom.setBorder(BorderFactory.createTitledBorder("Setup Mode"));
        jpMain.add((Component)jpBottom, gbc);
        JPanel jpMiddle = new JPanel(this.layout);
        Component l2 = jpMiddle.add(new JLabel("Select Option"));
        gbcWidget.gridx = 0;
        gbcWidget.gridy = 0;
        jpMiddle.add(l2, gbcWidget);
        this.jcbSimulation_mode = new JComboBox<String>(this.simulationTypes);
        gbcWidget.gridheight = 1;
        gbcWidget.gridwidth = 1;
        gbcWidget.gridx = 1;
        gbcWidget.gridy = 0;
        jpMiddle.add((Component)this.jcbSimulation_mode, gbcWidget);
        gbc.gridx = 0;
        gbc.gridy = 2;
        jpMiddle.setBorder(BorderFactory.createTitledBorder("Simulation Type"));
        jpMain.add((Component)jpMiddle, gbc);
        if (this.setupModeSet) {
            if (this.interactiveSetup) {
                this.jrbInterActive.doClick();
                if (this.snapshotSetupMode) {
                    this.jcbSimulation_mode.setSelectedIndex(0);
                } else {
                    this.jcbSimulation_mode.setSelectedIndex(1);
                }
            } else {
                this.jrbNonInterActive.doClick();
                this.jcbSimulation_mode.setEnabled(false);
            }
        } else {
            this.jrbInterActive.doClick();
        }
        return jpMain;
    }

    protected JPanel sanPropertyFilePathScreen() {
        JPanel jpMain = new JPanel(this.layout);
        JLabel jlTitle = new JLabel("<html><b>Properties File Path</b><br><br>Please specify the path for Properties file you want to use<br><br><br></html>", 2);
        jlTitle.setBorder(BorderFactory.createEtchedBorder());
        jlTitle.setHorizontalTextPosition(2);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        jpMain.add((Component)jlTitle, gbc);
        JPanel jpCenter = new JPanel();
        jpCenter.setLayout(this.layout);
        JLabel jlFilePath = new JLabel("<html>User Input File Path <html>");
        this.jtfSANPropFilePath = new JTextField(20);
        this.jbBrowsePropFile = new JButton("Browse");
        this.jbBrowsePropFile.setPreferredSize(new Dimension(30, 25));
        if (this.nonInteractiveModeSet) {
            this.jtfSANPropFilePath.setText(SANPropPath);
        }
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 0.0;
        this.constraints.fill = 0;
        this.constraints.anchor = 13;
        this.addComponent(jpCenter, jlFilePath, 0, 0, 1, 1);
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 0.0;
        this.constraints.fill = 2;
        this.addComponent(jpCenter, this.jtfSANPropFilePath, 0, 1, 1, 1);
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 0.0;
        this.constraints.fill = 2;
        this.addComponent(jpCenter, this.jbBrowsePropFile, 0, 2, 1, 1);
        jpCenter.setBorder(BorderFactory.createEtchedBorder());
        gbc.gridy = 3;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        jpMain.add((Component)jpCenter, gbc);
        SANPropbrowseButtonHandler handler = new SANPropbrowseButtonHandler();
        this.jbBrowsePropFile.addActionListener(handler);
        return jpMain;
    }

    protected JPanel wbemInstallPathScreen() {
        JPanel jpMain = new JPanel(this.layout);
        JLabel jlTitle = new JLabel("<html>&nbsp <b>WBEM Services Installation Path</b><br><br>Please specify the path where wbemservices directory will get installed<br><br><br></html>", 2);
        jlTitle.setBorder(BorderFactory.createEtchedBorder());
        jlTitle.setHorizontalTextPosition(2);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        jpMain.add((Component)jlTitle, gbc);
        JPanel jpCenter = new JPanel();
        jpCenter.setLayout(this.layout);
        JLabel jlDirPath = new JLabel("<html>Directory Path<html>");
        this.jtfdirName = new JTextField(20);
        this.jtfdirName.setText("C:\\SAN_SIMULATOR\\");
        this.jbBrowseDirPath = new JButton("Browse");
        this.jbBrowseDirPath.setPreferredSize(new Dimension(25, 25));
        if (this.wbemPropertiesSet) {
            this.jtfdirName.setText(this.destinationPath);
        }
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 0.0;
        this.constraints.anchor = 13;
        this.constraints.fill = 0;
        this.addComponent(jpCenter, jlDirPath, 0, 0, 1, 1);
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 0.0;
        this.constraints.fill = 2;
        this.addComponent(jpCenter, this.jtfdirName, 0, 1, 1, 1);
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 0.0;
        this.constraints.fill = 2;
        this.addComponent(jpCenter, this.jbBrowseDirPath, 0, 2, 1, 1);
        gbc.gridy = 3;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        jpCenter.setBorder(BorderFactory.createEtchedBorder());
        jpMain.add((Component)jpCenter, gbc);
        this.jbBrowseDirPath.addActionListener(new BrowseDirectoryListener(this.jtfdirName));
        return jpMain;
    }

    protected JPanel deviceSelectScreen() {
        JPanel jpMain = new JPanel(this.layout);
        JLabel jlTitle = new JLabel("<html><b>Device Selection</b><br><br>Please the device you want to simulate<br><br><br></html>", 2);
        jlTitle.setBorder(BorderFactory.createEtchedBorder());
        jlTitle.setHorizontalTextPosition(2);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        jpMain.add((Component)jlTitle, gbc);
        JPanel jpcenter = new JPanel(new BorderLayout());
        jpcenter.setLayout(new BoxLayout(jpcenter, 1));
        JPanel jpLabel = new JPanel(new FlowLayout(0, 5, 5));
        jpLabel.add(new JLabel("<html><br><br><b>Device Selection Option</b><html>"));
        jpcenter.add(jpLabel);
        JPanel jpOption1 = new JPanel(new FlowLayout(0, 5, 5));
        this.jrbSwitch = new JRadioButton("Switch");
        jpOption1.add(this.jrbSwitch);
        this.jcbSwitch = new JComboBox<String>(this.switchTypes);
        this.jrbSwitch.setPreferredSize(new Dimension(75, 30));
        this.jcbSwitch.setEnabled(false);
        this.jcbSwitch.setPreferredSize(new Dimension(130, 20));
        jpOption1.add(this.jcbSwitch);
        jpcenter.add(jpOption1);
        JPanel jpOption2 = new JPanel(new FlowLayout(0, 5, 5));
        this.jrbStorage = new JRadioButton("Storage");
        this.jrbStorage.setPreferredSize(new Dimension(75, 30));
        jpOption2.add(this.jrbStorage);
        this.jcbStorage = new JComboBox<String>(this.storageTypes);
        this.jcbStorage.setEnabled(false);
        this.jcbStorage.setPreferredSize(new Dimension(130, 20));
        jpOption2.add(this.jcbStorage);
        jpcenter.add(jpOption2);
        JPanel jpOption3 = new JPanel(new FlowLayout(0, 5, 5));
        this.jrbServer = new JRadioButton("Server");
        this.jrbServer.setPreferredSize(new Dimension(75, 30));
        jpOption3.add(this.jrbServer);
        this.jcbServer = new JComboBox<String>(this.serverTypes);
        this.jcbServer.setEnabled(false);
        this.jcbServer.setPreferredSize(new Dimension(130, 20));
        jpOption3.add(this.jcbServer);
        jpcenter.add(jpOption3);
        JPanel jpOption4 = new JPanel(new FlowLayout(0, 5, 5));
        this.jrbOthers = new JRadioButton("Others");
        this.jrbOthers.setPreferredSize(new Dimension(75, 30));
        jpOption4.add(this.jrbOthers);
        this.jcbOthers = new JComboBox<String>(this.otherDevices);
        this.jcbOthers.setEnabled(false);
        this.jcbOthers.setPreferredSize(new Dimension(130, 20));
        jpOption4.add(this.jcbOthers);
        jpcenter.add(jpOption4);
        gbc.gridy = 3;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        jpcenter.setBorder(BorderFactory.createEtchedBorder());
        jpMain.add((Component)jpcenter, gbc);
        this.jbgradioGroup = new ButtonGroup();
        this.jbgradioGroup.add(this.jrbSwitch);
        this.jbgradioGroup.add(this.jrbStorage);
        this.jbgradioGroup.add(this.jrbServer);
        this.jbgradioGroup.add(this.jrbOthers);
        this.jrbSwitch.addItemListener(new RadioButtonHandler("Switch"));
        this.jrbStorage.addItemListener(new RadioButtonHandler("Storage"));
        this.jrbServer.addItemListener(new RadioButtonHandler("Server"));
        this.jrbOthers.addItemListener(new RadioButtonHandler("Others"));
        this.jcbSwitch.addItemListener(new DeviceTypeHandler());
        this.jcbStorage.addItemListener(new DeviceTypeHandler());
        this.jcbOthers.addItemListener(new DeviceTypeHandler());
        this.jcbServer.addItemListener(new DeviceTypeHandler());
        if (this.devicePropSet) {
            if (this.switchSelected) {
                this.jrbSwitch.doClick();
                this.jcbSwitch.setSelectedItem(this.deviceType);
            }
            if (this.storageSelected) {
                this.jrbStorage.doClick();
                this.jcbStorage.setSelectedItem(this.deviceType);
            }
            if (this.serverSelected) {
                this.jrbServer.doClick();
                this.jcbServer.setSelectedItem(this.deviceType);
            }
            if (this.othersSelected) {
                this.jrbOthers.doClick();
                this.jcbOthers.setSelectedItem(this.deviceType);
            }
        }
        return jpMain;
    }

    protected JPanel dbInfoScreen() {
        JPanel jpMain = new JPanel(this.layout);
        JLabel jlTitle = new JLabel("<html><b>Enter the database details</b><br><br>If local database is used and current logged in user has admin permissions on the database, then \"User Name\" and \"Password\" fields can be left blank.<br>You can test the connection to the database using <b>\"Test DB Connection\"</b> button.<br></html>", 2);
        jlTitle.setBorder(BorderFactory.createEtchedBorder());
        jlTitle.setHorizontalTextPosition(2);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        jpMain.add((Component)jlTitle, gbc);
        JPanel jpCenter = new JPanel(new BorderLayout());
        jpCenter.setLayout(new BoxLayout(jpCenter, 1));
        JPanel jpField1 = new JPanel(new FlowLayout(0, 5, 10));
        JLabel jlDBUrl = new JLabel("Host URL");
        jlDBUrl.setPreferredSize(new Dimension(75, 10));
        jpField1.add(jlDBUrl);
        this.jtfDBHostUrl = new JTextField(10);
        this.jtfDBHostUrl.setText("localhost");
        this.jtfDBHostUrl.setPreferredSize(new Dimension(100, 20));
        jpField1.add(this.jtfDBHostUrl);
        jpCenter.add(jpField1);
        JPanel jpField2 = new JPanel(new FlowLayout(0, 5, 10));
        JLabel jlDbName = new JLabel("Databse name");
        jpField2.add(jlDbName);
        jlDbName.setPreferredSize(new Dimension(75, 20));
        this.jtfDBName = new JTextField(10);
        this.jtfDBName.setPreferredSize(new Dimension(100, 20));
        this.jtfDBName.setText("SIMDB");
        this.jtfDBName.setEditable(false);
        jpField2.add(this.jtfDBName);
        jpCenter.add(jpField2);
        JPanel jpField3 = new JPanel(new FlowLayout(0, 5, 10));
        JLabel jlDBUid = new JLabel("User ID");
        jlDBUid.setPreferredSize(new Dimension(75, 10));
        jpField3.add(jlDBUid);
        this.jtfDBUserId = new JTextField(10);
        this.jtfDBUserId.setPreferredSize(new Dimension(100, 20));
        jpField3.add(this.jtfDBUserId);
        jpCenter.add(jpField3);
        JPanel jpField4 = new JPanel(new FlowLayout(0, 5, 10));
        JLabel jlDBPwd = new JLabel("Password");
        jpField4.add(jlDBPwd);
        jlDBPwd.setPreferredSize(new Dimension(75, 10));
        this.jtfDBPasswd = new JPasswordField(8);
        this.jtfDBPasswd.setPreferredSize(new Dimension(100, 20));
        jpField4.add(this.jtfDBPasswd);
        jpCenter.add(jpField4);
        JButton TestDB2 = new JButton("Test DB Connection");
        TestDB2.addActionListener(new TestDB());
        jpCenter.add((Component)TestDB2, "Center");
        if (this.databasePropSet) {
            this.jtfDBName.setText(this.dbName);
            this.jtfDBUserId.setText(this.dbUserId);
            this.jtfDBPasswd.setText(this.dbPassWord);
            this.jtfDBHostUrl.setText(this.dbHostUrl);
        }
        gbc.gridy = 3;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        jpCenter.setBorder(BorderFactory.createEtchedBorder());
        jpMain.add((Component)jpCenter, gbc);
        return jpMain;
    }

    protected boolean isModeSelectedSet() {
        return this.installModeClicked;
    }

    protected boolean isPropertyFileSet() {
        return !this.jtfSANPropFilePath.getText().equals("");
    }

    protected boolean isDeviceSelected() {
        return this.deviceClicked;
    }

    protected boolean isDBConfigured() {
        boolean retVal = true;
        String strDBUrl = this.jtfDBHostUrl.getText();
        String strDBName = this.jtfDBName.getText();
        String strDBUid = this.jtfDBUserId.getText();
        String strDBPwd = new String(this.jtfDBPasswd.getPassword());
        if (strDBUrl.equals("localhost")) {
            return retVal;
        }
        if (this.dbConnectionTested && this.dbConnectionExist) {
            return retVal;
        }
        if (strDBUid.equals("") || strDBPwd.equals("")) {
            retVal = false;
        }
        if (retVal && new TestDBConnection().testConnection(strDBName, strDBUid, strDBPwd, strDBUrl) == 0) {
            JOptionPane.showMessageDialog(null, "Database instance titled SIMDB does not exist.\n\n Please go to the machine where DB2 is installed and copy the folder named DBUtility. Run CreateDb.bat to create the SIMDB instance.", "DB Configuration Failed", 0);
            System.exit(0);
        }
        return retVal;
    }

    protected boolean isWBEMPathSet() {
        return !this.jtfdirName.getText().equals("");
    }

    protected boolean isSnapshotModeSet() {
        return this.setupModeClicked;
    }

    protected boolean isConfigPathSet() {
        return !this.jtfConfigFilePath.getText().equals("");
    }

    protected boolean isBackupFilePathSet() {
        return !this.jtfBackupDBPath.getText().equals("");
    }

    protected JPanel simulationModeSelectScreen() {
        JPanel jpMain = new JPanel(new BorderLayout());
        JLabel jlTitle = new JLabel("<html><b>Please select the method of simulation</b><br><br> Snapshot based method requires details of the live CIMOM of selected device to take the snapshot.<br><br></html>", 2);
        jlTitle.setBorder(BorderFactory.createEtchedBorder());
        jlTitle.setHorizontalTextPosition(2);
        jpMain.add((Component)jlTitle, "North");
        JPanel jpCenter = new JPanel(new BorderLayout());
        jpCenter.setLayout(new BoxLayout(jpCenter, 1));
        JLabel l1 = new JLabel("<html><br><br><br></html>", 2);
        jpCenter.add(l1);
        JPanel jpOption = new JPanel(new FlowLayout(0, 0, 0));
        jpOption.add(new JLabel("<html>Select Option&nbsp&nbsp&nbsp<br><html>"));
        this.jcbSimulation_mode = new JComboBox<String>(this.simulationTypes);
        jpOption.add(this.jcbSimulation_mode);
        jpCenter.add(jpOption);
        JLabel l2 = new JLabel("<html><br><br><br></html>", 2);
        jpCenter.add(l2);
        this.jcbSimulation_mode.addItemListener(new SimulationModeHandler());
        JPanel jpWrap = new JPanel();
        jpWrap.setBorder(BorderFactory.createEtchedBorder());
        jpWrap.add(jpCenter);
        jpMain.add((Component)jpWrap, "Center");
        if (this.simulationModeSet) {
            this.jcbSimulation_mode.setSelectedItem(this.simulationMode);
        }
        return jpMain;
    }

    protected JPanel snapshotModeSelectScreen() {
        JPanel jpMain = new JPanel(new GridBagLayout());
        JLabel jlTitle = new JLabel("<html><b>Choose appropriate option for your snapshot</b><br><br> You can choose \"Restore Snapshot Backup\" if you already have snapshot image of the device you want to simulate. Otherwise you can take a new snapshot by choosing \"Start Fresh Snapshot\"</b>.<br></html>", 2);
        jlTitle.setBorder(BorderFactory.createEtchedBorder());
        jlTitle.setHorizontalTextPosition(2);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        jpMain.add((Component)jlTitle, gbc);
        JPanel jpCenter = new JPanel(this.layout);
        JLabel l1 = new JLabel("<html><br><br></html>", 2);
        jpCenter.add(l1);
        this.jrbRestore = new JRadioButton("Restore Snapshot Backup");
        this.jrbFresh = new JRadioButton("Start Fresh Snapshot");
        ButtonGroup jbgSnapshotMode = new ButtonGroup();
        jbgSnapshotMode.add(this.jrbRestore);
        jbgSnapshotMode.add(this.jrbFresh);
        this.jrbRestore.addItemListener(new SnapshotRadioHandler("Restore"));
        this.jrbFresh.addItemListener(new SnapshotRadioHandler("Fresh"));
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 0.0;
        this.constraints.fill = 2;
        this.constraints.insets.top = 40;
        this.constraints.insets.bottom = 20;
        this.constraints.insets.left = 5;
        this.addComponent(jpCenter, this.jrbRestore, 0, 0, 1, 1);
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 0.0;
        this.constraints.insets.top = 20;
        this.constraints.insets.left = 5;
        this.constraints.fill = 2;
        this.constraints.anchor = 18;
        this.addComponent(jpCenter, this.jrbFresh, 1, 0, 1, 1);
        jpCenter.setBorder(BorderFactory.createEtchedBorder());
        gbc.gridy = 3;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        jpMain.add((Component)jpCenter, gbc);
        if (this.snapshotModeSet) {
            if (this.restoreBackupDB) {
                this.jrbRestore.doClick();
            } else if (this.startFreshSnapshot) {
                this.jrbFresh.doClick();
            }
        }
        return jpMain;
    }

    protected JPanel snapshotCIMOMInfoScreen() {
        JPanel jpMain = new JPanel(this.layout);
        JLabel jlTitle = new JLabel("<html><b>Enter the live CIMOM information</b><br><br> You can test the connection to the CIMOM using the \"Test CIMOM Connect\" button.<br><br><br></html>", 2);
        jlTitle.setBorder(BorderFactory.createEtchedBorder());
        jlTitle.setHorizontalTextPosition(2);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        jpMain.add((Component)jlTitle, gbc);
        JPanel jpCenter = new JPanel();
        jpCenter.setLayout(new BoxLayout(jpCenter, 1));
        JPanel jpField1 = new JPanel(new FlowLayout(0, 5, 5));
        JLabel jlCimUrl = new JLabel("Host IP");
        jlCimUrl.setPreferredSize(new Dimension(100, 10));
        jpField1.add(jlCimUrl);
        this.jtfCIMhost_url = new JTextField(10);
        jpField1.add(this.jtfCIMhost_url);
        jpCenter.add(jpField1);
        JPanel jpField2 = new JPanel(new FlowLayout(0, 5, 5));
        JLabel jlCimPort = new JLabel("Port");
        jlCimPort.setPreferredSize(new Dimension(100, 10));
        jpField2.add(jlCimPort);
        this.jtfCIMport = new JTextField(10);
        this.jtfCIMport.setPreferredSize(new Dimension(100, 20));
        jpField2.add(this.jtfCIMport);
        jpCenter.add(jpField2);
        JPanel jpField3 = new JPanel(new FlowLayout(0, 5, 5));
        JLabel jlCimUid = new JLabel("User Name");
        jlCimUid.setPreferredSize(new Dimension(100, 10));
        jpField3.add(jlCimUid);
        this.jtfCIMuid = new JTextField(10);
        this.jtfCIMuid.setPreferredSize(new Dimension(100, 20));
        jpField3.add(this.jtfCIMuid);
        jpCenter.add(jpField3);
        JPanel jpField4 = new JPanel(new FlowLayout(0, 5, 5));
        JLabel jlCimPwd = new JLabel("Password");
        jlCimPwd.setPreferredSize(new Dimension(100, 10));
        jpField4.add(jlCimPwd);
        this.jtfCIMpwd = new JPasswordField(8);
        this.jtfCIMpwd.setPreferredSize(new Dimension(100, 20));
        jpField4.add(this.jtfCIMpwd);
        jpCenter.add(jpField4);
        JPanel jpField5 = new JPanel(new FlowLayout(0, 5, 5));
        JLabel jlCimNmspace = new JLabel("Interop Namespace");
        jlCimNmspace.setPreferredSize(new Dimension(100, 10));
        jpField5.add(jlCimNmspace);
        this.jtfCIMnmspace = new JTextField(10);
        this.jtfCIMnmspace.setPreferredSize(new Dimension(100, 20));
        jpField5.add(this.jtfCIMnmspace);
        jpCenter.add(jpField5);
        JPanel jpField6 = new JPanel(new FlowLayout(0, 5, 5));
        JLabel jlCimProtocol = new JLabel("Protocol");
        jlCimProtocol.setPreferredSize(new Dimension(100, 10));
        jpField6.add(jlCimProtocol);
        this.jcbprotocols = new JComboBox<String>(this.protocols);
        this.jcbprotocols.setPreferredSize(new Dimension(100, 20));
        jpField6.add(this.jcbprotocols);
        jpCenter.add(jpField6);
        JButton test = new JButton("Test CIMOM Connection");
        test.addActionListener(new TestCIMOM());
        jpCenter.add((Component)test, "Center");
        gbc.gridy = 3;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        jpCenter.setBorder(BorderFactory.createEtchedBorder());
        jpMain.add((Component)jpCenter, gbc);
        JPanel jpMofOption = new JPanel(this.layout);
        GridBagConstraints gbcWidget = new GridBagConstraints();
        gbcWidget.anchor = 18;
        gbcWidget.fill = 2;
        gbcWidget.gridheight = 1;
        gbcWidget.gridwidth = 1;
        gbcWidget.weightx = 1.0;
        gbcWidget.weighty = 0.0;
        this.jchbCreateNewMof = new JCheckBox();
        this.jchbCreateNewMof.setText("Create new MOF file for this device CIMOM");
        this.jchbCreateNewMof.setEnabled(true);
        this.jchbCreateNewMof.addItemListener(new checkBoxListener(CREATE_DEVICE_MOF_VALUE));
        gbcWidget.gridx = 0;
        gbcWidget.gridy = 0;
        jpMofOption.add((Component)this.jchbCreateNewMof, gbcWidget);
        JPanel jpCreateMof = new JPanel(new FlowLayout(0, 0, 0));
        jpCreateMof.add(new JLabel("Directory path for MOF destination:               "));
        this.jtfMofFileTxt = new JTextField(20);
        this.jtfMofFileTxt.setEnabled(false);
        jpCreateMof.add(this.jtfMofFileTxt);
        this.browseMofLoc = new JButton("Browse");
        this.browseMofLoc.addActionListener(new BrowseDirectoryListener(this.jtfMofFileTxt));
        this.browseMofLoc.setEnabled(false);
        jpCreateMof.add(this.browseMofLoc);
        gbcWidget.gridx = 0;
        gbcWidget.gridy = 2;
        gbcWidget.insets.left = 10;
        jpMofOption.add((Component)jpCreateMof, gbcWidget);
        gbc.gridx = 0;
        gbc.gridy = 4;
        jpMain.add((Component)jpMofOption, gbc);
        if (this.cimomPropSet) {
            this.jtfCIMhost_url.setText(this.cimomHostUrl);
            this.jtfCIMport.setText(this.cimomPort);
            this.jtfCIMuid.setText(this.cimomUid);
            this.jtfCIMpwd.setText(this.cimomPwd);
            this.jtfCIMnmspace.setText(this.cimomNameSpace);
            this.jcbprotocols.setSelectedItem(this.cimomProtocol);
            if (SetupWizardUtility.isCreateMof) {
                this.jchbCreateNewMof.doClick();
                this.jtfMofFileTxt.setText(SetupWizardUtility.strPathTosaveMofFile);
            }
        }
        return jpMain;
    }

    protected JPanel backupDBInfoScreen() {
        JPanel jpMain = new JPanel(new BorderLayout());
        JLabel jlTitle = new JLabel("<html><b>Enter Snapshot Backup Location</b><br><br>Please specify the path where you have your snapshot image stored. If your database name is SIMDB, enter the path of parent directory of SIMDB.0<br><br><br></html>", 2);
        jlTitle.setBorder(BorderFactory.createEtchedBorder());
        jlTitle.setHorizontalTextPosition(2);
        jpMain.add((Component)jlTitle, "North");
        JPanel jpCenter = new JPanel(new BorderLayout());
        jpCenter.setLayout(new BoxLayout(jpCenter, 1));
        JPanel jpPathField = new JPanel(new FlowLayout(0, 0, 0));
        jpPathField.add(new JLabel("<html><br><br><br>Snapshot Backup Path&nbsp&nbsp<br><br><br><br><html>"));
        this.jtfBackupDBPath = new JTextField(20);
        jpPathField.add(this.jtfBackupDBPath);
        this.jbBrowseDBPath = new JButton("Browse");
        jpPathField.add(this.jbBrowseDBPath);
        jpCenter.add(jpPathField);
        if (this.dbPathSet) {
            this.jtfBackupDBPath.setText(this.strdbPath);
        }
        JPanel jpWrap = new JPanel();
        jpWrap.add(jpCenter);
        jpWrap.setBorder(BorderFactory.createEtchedBorder());
        jpWrap.setSize(100, 100);
        jpMain.add((Component)jpWrap, "Center");
        this.jbBrowseDBPath.addActionListener(new BrowseDirectoryListener(this.jtfBackupDBPath));
        return jpMain;
    }

    protected boolean isCimomPropset() {
        if (this.jtfCIMhost_url.getText().equals("")) {
            return false;
        }
        if (this.jtfCIMuid.getText().equals("") || new String(this.jtfCIMpwd.getPassword()).equals("")) {
            return false;
        }
        if (this.jtfCIMport.getText().equals("") || this.jtfCIMnmspace.getText().equals("")) {
            return false;
        }
        return (!this.jchbCreateNewMof.isSelected() || !this.jtfMofFileTxt.getText().equals("")) && null != this.jtfMofFileTxt.getText();
    }

    protected boolean checkSimulationMode() {
        if (this.jcbSimulation_mode.getSelectedItem().equals("Snapshot-based")) {
            return true;
        }
        JOptionPane.showMessageDialog(null, "Sorry !Only Snapshot-based Simulation supported!", "SimulationMode Error", 1);
        return false;
    }

    protected JPanel configInfoScreen() {
        JPanel jpMain = new JPanel(new BorderLayout());
        JLabel jlTitle = new JLabel("<html><b>Configuration-based Simulation</b><br><br>Please specify the path of Configuration File<br><br><br></html>", 2);
        jlTitle.setBorder(BorderFactory.createEtchedBorder());
        jlTitle.setHorizontalTextPosition(2);
        jpMain.add((Component)jlTitle, "North");
        JPanel jpCenter = new JPanel(new BorderLayout());
        jpCenter.setLayout(new BoxLayout(jpCenter, 1));
        JPanel jpPathField = new JPanel(new FlowLayout(0, 0, 0));
        jpPathField.add(new JLabel("<html><br><br><br>Configuration File Path&nbsp&nbsp<br><br><br><br><html>"));
        this.jtfConfigFilePath = new JTextField(20);
        jpPathField.add(this.jtfConfigFilePath);
        this.jtfConfigFilePath.setText(this.getConfFilePath());
        this.jbBrowseConfigFile = new JButton("Browse");
        jpPathField.add(this.jbBrowseConfigFile);
        jpCenter.add(jpPathField);
        if (this.configPropSet) {
            this.jtfConfigFilePath.setText(this.strConfigFile);
        }
        JPanel jpWrap = new JPanel();
        jpWrap.add(jpCenter);
        jpWrap.setBorder(BorderFactory.createEtchedBorder());
        jpWrap.setSize(100, 100);
        jpMain.add((Component)jpWrap, "Center");
        ConfigbrowseButtonHandler handler = new ConfigbrowseButtonHandler();
        this.jbBrowseConfigFile.addActionListener(handler);
        return jpMain;
    }

    protected JPanel SimulationModeScreen() {
        if (this.snapshotSetupMode) {
            return this.snapshotModeSelectScreen();
        }
        return this.configInfoScreen();
    }

    public JPanel SetupSummaryPage() {
        JPanel jpMain = new JPanel(new BorderLayout());
        JLabel jlTitle = new JLabel("<html><b>Confirm Setup Parameters<br><br> </b>Please confirmed the Setup parameters and click <b>Setup</b> to proceed<br><br><br></html", 2);
        jlTitle.setBorder(BorderFactory.createEtchedBorder());
        jlTitle.setHorizontalTextPosition(2);
        jpMain.add((Component)jlTitle, "North");
        JPanel jpCenter = new JPanel();
        jpCenter.setLayout(this.layout);
        Properties properties = SetupWizardUtility.simulatorProperties;
        try {
            SetupWizardUtility.loadProperties();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        Set<Object> keyset = properties.keySet();
        Iterator<Object> iter = keyset.iterator();
        GridBagConstraints gbcWidget = new GridBagConstraints();
        gbcWidget.anchor = 18;
        gbcWidget.fill = 2;
        gbcWidget.gridheight = 1;
        gbcWidget.gridwidth = 1;
        gbcWidget.weightx = 1.0;
        gbcWidget.weighty = 0.0;
        gbcWidget.insets.top = 5;
        gbcWidget.insets.right = 10;
        gbcWidget.insets.left = 10;
        int counter = 0;
        while (iter.hasNext()) {
            Object simpProp = iter.next();
            String propName = simpProp.toString();
            if (!SetupWizardUtility.propToDisplay.contains(propName)) continue;
            String propvalue = properties.getProperty(propName);
            JLabel propNameLbl = new JLabel(propName);
            JLabel propValueLbl = new JLabel(propvalue);
            gbcWidget.gridx = 0;
            gbcWidget.gridy = counter++;
            jpCenter.add((Component)propNameLbl, gbcWidget);
            gbcWidget.gridx = 1;
            jpCenter.add((Component)propValueLbl, gbcWidget);
        }
        jpCenter.setBorder(BorderFactory.createTitledBorder("Setup Paramaters"));
        jpMain.add((Component)jpCenter, "Center");
        return jpMain;
    }

    protected void saveDbProperties() {
        this.dbName = this.jtfDBName.getText();
        this.dbPassWord = new String(this.jtfDBPasswd.getPassword()).equals("") ? "Default" : new String(this.jtfDBPasswd.getPassword());
        this.dbUserId = this.jtfDBUserId.getText().equals("") ? "Default" : this.jtfDBUserId.getText();
        this.dbHostUrl = this.jtfDBHostUrl.getText();
        this.databasePropSet = true;
        this.logger.info("Database Information ");
        this.logger.info("Database Name: " + this.dbName + " DB Password: " + this.dbPassWord + " DB UID: " + this.dbUserId + " DB Url: " + this.dbHostUrl);
    }

    protected void saveDeviceProperties() {
        this.devicePropSet = true;
        if (this.switchSelected) {
            this.deviceType = (String)this.jcbSwitch.getSelectedItem();
            this.deviceCategory = "Switch";
        }
        if (this.storageSelected) {
            this.deviceType = (String)this.jcbStorage.getSelectedItem();
            this.deviceCategory = "Storage";
        }
        if (this.othersSelected) {
            this.deviceType = (String)this.jcbOthers.getSelectedItem();
            this.deviceCategory = "Others";
        }
        this.logger.info("Device Category Selected: " + this.deviceCategory + " DeviceType Selected: " + this.deviceType);
    }

    protected void saveSModeProperties() {
        this.simulationMode = this.jcbSimulation_mode.getSelectedItem().toString();
        this.logger.info("Simulation Mode Selected: " + this.simulationMode);
        this.snapshotSetupMode = this.simulationMode.equals("Snapshot-based");
        this.simulationModeSet = true;
        this.setupModeSet = true;
    }

    protected void saveSnapshotModeProperties() {
        this.snapshotModeSet = true;
        if (this.restoreBackupDB) {
            this.startFreshSnapshot = false;
            this.snapshot_type = "Restore Backup DB";
        } else if (this.startFreshSnapshot) {
            this.snapshot_type = "Fresh Snapshot";
            this.restoreBackupDB = false;
        }
        this.logger.info("For snapshot based simulation");
        this.logger.info("Snapshot Mode Selected: " + this.snapshot_type);
    }

    protected void saveCIMOMProperties() {
        this.cimomHostUrl = this.jtfCIMhost_url.getText();
        this.cimomPort = this.jtfCIMport.getText();
        this.cimomUid = this.jtfCIMuid.getText();
        this.cimomPwd = new String(this.jtfCIMpwd.getPassword());
        this.cimomNameSpace = this.jtfCIMnmspace.getText();
        this.cimomProtocol = this.jcbprotocols.getSelectedItem().toString();
        this.cimomPropSet = true;
        if (this.jchbCreateNewMof.isSelected()) {
            SetupWizardUtility.isCreateMof = true;
            SetupWizardUtility.strPathTosaveMofFile = this.jtfMofFileTxt.getText();
        } else {
            SetupWizardUtility.isCreateMof = false;
            SetupWizardUtility.strPathTosaveMofFile = null;
        }
        this.logger.info("CIMOM Host URL: " + this.cimomHostUrl + " CIMOMPort: " + this.cimomPort + " CIMOM Namespace: " + this.cimomNameSpace + " CIMOM Protocol: " + this.cimomProtocol);
    }

    protected void saveDBPathProperties() {
        this.dbPathSet = true;
        this.strdbPath = this.jtfBackupDBPath.getText();
        this.logger.info("Restore DB Path specified: " + this.dbPathSet);
    }

    protected void saveInstallMode() {
        this.setupModeSet = true;
        if (this.nonInteractiveSetup) {
            this.logger.info("Install Mode Seletced: NonIntercative");
            this.interactiveSetup = false;
        } else if (this.interactiveSetup) {
            this.logger.info("Install Mode Seletced: Intercative");
            this.nonInteractiveSetup = false;
        }
    }

    protected void saveProperties() {
        SetupWizardUtility.setProperty("WBEM_INSTALL_PATH", this.destinationPath);
        SetupWizardUtility.setProperty("DEVICE_CATEGORY", this.deviceCategory);
        SetupWizardUtility.setProperty("DEVICE_TYPE", this.deviceType);
        SetupWizardUtility.setProperty("DB_NAME", this.dbName);
        SetupWizardUtility.setProperty("DB_USER_NAME", this.dbUserId);
        SetupWizardUtility.setProperty("DB_PASSWORD", this.dbPassWord);
        SetupWizardUtility.setProperty("DB_HOST_URL", this.dbHostUrl);
        SetupWizardUtility.setProperty("SIMULATION_MODE", this.simulationMode);
        if (this.snapshotSetupMode && this.startFreshSnapshot) {
            SetupWizardUtility.setProperty("SNAPSHOT_SIMULATION_MODE", this.snapshot_type);
            SetupWizardUtility.setProperty("CIMOM_HOST_URL", this.cimomHostUrl);
            SetupWizardUtility.setProperty("CIMOM_PORT", this.cimomPort);
            SetupWizardUtility.setProperty("CIMOM_USER_ID", this.cimomUid);
            SetupWizardUtility.setProperty("CIMOM_PASSWORD", this.cimomPwd);
            SetupWizardUtility.setProperty("CIMOM_NAMESPACE", this.cimomNameSpace);
            SetupWizardUtility.setProperty("CIMOM_PROTOCOL", this.cimomProtocol);
            SetupWizardUtility.setProperty("CIMOM_TYPE", this.cimomType);
        } else if (this.snapshotSetupMode && this.restoreBackupDB) {
            SetupWizardUtility.setProperty("SNAPSHOT_SIMULATION_MODE", this.snapshot_type);
            SetupWizardUtility.setProperty("BACK_UP_PATH", this.strdbPath);
        } else {
            SetupWizardUtility.setProperty("CONFIG_FILE_PATH", this.strConfigFile);
        }
        SetupWizardUtility.savePropToFile();
    }

    public void saveSnapshotInteractiveToFile() {
        SetupWizardUtility.simulatorProperties.clear();
        SetupWizardUtility.setProperty("DB_NAME", this.dbName);
        SetupWizardUtility.setProperty("DB_USER_NAME", this.dbUserId);
        SetupWizardUtility.setProperty("DB_PASSWORD", this.dbPassWord);
        SetupWizardUtility.setProperty("DB_HOST_URL", this.dbHostUrl);
        SetupWizardUtility.setProperty("CIMOM_HOST_URL", this.cimomHostUrl);
        SetupWizardUtility.setProperty("CIMOM_PORT", this.cimomPort);
        SetupWizardUtility.setProperty("CIMOM_USER_ID", this.cimomUid);
        SetupWizardUtility.setProperty("CIMOM_PASSWORD", this.cimomPwd);
        SetupWizardUtility.setProperty("CIMOM_NAMESPACE", this.cimomNameSpace);
        SetupWizardUtility.setProperty("CIMOM_PROTOCOL", this.cimomProtocol);
        SetupWizardUtility.interactive = this.interactiveSetup;
        SetupWizardUtility.setProperty("SIMULATION_MODE", "SNAPSHOT_MODE");
        SetupWizardUtility.setProperty("IS_CREATE_MOF", new Boolean(SetupWizardUtility.isCreateMof).toString());
        SetupWizardUtility.setProperty("IS_INSTALL_CIMOM", new Boolean(SetupWizardUtility.isInstallCIMOM).toString());
        SetupWizardUtility.setProperty("IS_COMPILE_CIMOM", new Boolean(SetupWizardUtility.isCompileMof).toString());
        SetupWizardUtility.setProperty("IS_SIMULATE_DEVICE", new Boolean(SetupWizardUtility.isSimulateDevice).toString());
        if (SetupWizardUtility.isCompileMof) {
            SetupWizardUtility.setProperty("DIRECTORY_LOCATION_TO_INSTALL_CIMOM", SetupWizardUtility.cimomInstalledLocation);
            SetupWizardUtility.setProperty("MOF_FILE_PATH", SetupWizardUtility.mofFilePath);
        }
        if (SetupWizardUtility.isInstallCIMOM) {
            SetupWizardUtility.setProperty("DIRECTORY_LOCATION_TO_INSTALL_CIMOM", SetupWizardUtility.dirLocationToInstallCIMOM);
        }
        if (SetupWizardUtility.isCreateMof) {
            SetupWizardUtility.setProperty("LOCATION_TO_SAVE_MOF", SetupWizardUtility.strPathTosaveMofFile);
        }
        SetupWizardUtility.savePropToFile();
    }

    protected void SaveSetupParameterToFile() {
        if (this.snapshotSetupMode) {
            SetupWizardUtility.setProperty("SIMULATION_MODE", "SNAPSHOT_MODE");
        } else {
            SetupWizardUtility.setProperty("SIMULATION_MODE", "CONFIGURATION_MODE");
        }
        SetupWizardUtility.setProperty("IS_CREATE_MOF", new Boolean(SetupWizardUtility.isCreateMof).toString());
        SetupWizardUtility.setProperty("IS_INSTALL_CIMOM", new Boolean(SetupWizardUtility.isInstallCIMOM).toString());
        SetupWizardUtility.setProperty("IS_COMPILE_CIMOM", new Boolean(SetupWizardUtility.isCompileMof).toString());
        SetupWizardUtility.setProperty("IS_SIMULATE_DEVICE", new Boolean(SetupWizardUtility.isSimulateDevice).toString());
        if (SetupWizardUtility.isCompileMof) {
            SetupWizardUtility.setProperty("DIRECTORY_LOCATION_TO_INSTALL_CIMOM", SetupWizardUtility.cimomInstalledLocation);
            SetupWizardUtility.setProperty("MOF_FILE_PATH", SetupWizardUtility.mofFilePath);
        }
        if (SetupWizardUtility.isInstallCIMOM) {
            SetupWizardUtility.setProperty("DIRECTORY_LOCATION_TO_INSTALL_CIMOM", SetupWizardUtility.dirLocationToInstallCIMOM);
        }
        if (SetupWizardUtility.isCreateMof) {
            SetupWizardUtility.setProperty("LOCATION_TO_SAVE_MOF", SetupWizardUtility.strPathTosaveMofFile);
        }
        SetupWizardUtility.savePropToFile();
    }

    public void saveConfigurationInteractiveToFile() {
        SetupWizardUtility.simulatorProperties.clear();
        SetupWizardUtility.setProperty("DB_NAME", this.dbName);
        SetupWizardUtility.setProperty("DB_USER_NAME", this.dbUserId);
        SetupWizardUtility.setProperty("DB_PASSWORD", this.dbPassWord);
        SetupWizardUtility.setProperty("DB_HOST_URL", this.dbHostUrl);
        SetupWizardUtility.setProperty("DEVICE_CATEGORY", this.deviceCategory);
        SetupWizardUtility.setProperty("DEVICE_TYPE", this.deviceType);
        SetupWizardUtility.setProperty("CONFIG_FILE_PATH", this.strConfigFile);
        SetupWizardUtility.interactive = this.interactiveSetup;
        SetupWizardUtility.setProperty("SIMULATION_MODE", "CONFIGURATION_MODE");
        SetupWizardUtility.setProperty("IS_CREATE_MOF", new Boolean(SetupWizardUtility.isCreateMof).toString());
        SetupWizardUtility.setProperty("IS_INSTALL_CIMOM", new Boolean(SetupWizardUtility.isInstallCIMOM).toString());
        SetupWizardUtility.setProperty("IS_COMPILE_CIMOM", new Boolean(SetupWizardUtility.isCompileMof).toString());
        SetupWizardUtility.setProperty("IS_SIMULATE_DEVICE", new Boolean(SetupWizardUtility.isSimulateDevice).toString());
        if (SetupWizardUtility.isCompileMof) {
            SetupWizardUtility.setProperty("DIRECTORY_LOCATION_TO_INSTALL_CIMOM", SetupWizardUtility.cimomInstalledLocation);
            SetupWizardUtility.setProperty("MOF_FILE_PATH", SetupWizardUtility.mofFilePath);
        }
        if (SetupWizardUtility.isInstallCIMOM) {
            SetupWizardUtility.setProperty("DIRECTORY_LOCATION_TO_INSTALL_CIMOM", SetupWizardUtility.dirLocationToInstallCIMOM);
        }
        if (SetupWizardUtility.isCreateMof) {
            SetupWizardUtility.setProperty("LOCATION_TO_SAVE_MOF", SetupWizardUtility.strPathTosaveMofFile);
        }
        SetupWizardUtility.savePropToFile();
    }

    public void saveNonInteractiveToFile() {
    }

    protected void saveDirPath() {
        this.destinationPath = this.jtfdirName.getText();
        this.logger.info("WBEM Install Path specified: " + this.destinationPath);
        this.wbemPropertiesSet = true;
    }

    protected void saveConfigProp() {
        this.strConfigFile = this.jtfConfigFilePath.getText();
        this.logger.info("Configuration File Path mentioned: " + this.strConfigFile);
        this.configPropSet = true;
    }

    protected void saveSANPathProp() {
        SANPropPath = this.SANPropFile.toString();
        this.logger.info("SAN Property File path specified: " + SANPropPath);
    }

    private File opendir() {
        JFileChooser dirPath = new JFileChooser();
        dirPath.setFileSelectionMode(1);
        int result = dirPath.showOpenDialog(this.deviceSelectScreen());
        if (result == 1) {
            return DEFAULT_WBEM_DIR_PATH;
        }
        this.fileName = dirPath.getSelectedFile();
        return this.fileName;
    }

    private File openfile() {
        JFileChooser dirPath = new JFileChooser();
        dirPath.setFileSelectionMode(0);
        int result = dirPath.showOpenDialog(this.deviceSelectScreen());
        if (result == 1) {
            return DEFAULT_PROPERTY_FILE_PATH;
        }
        this.configFile = dirPath.getSelectedFile();
        return this.configFile;
    }

    private String getConfFilePath() {
        String filePath = null;
        if (this.deviceCategory.equals("Switch")) {
            filePath = "conf\\Brocade-requirement.config";
        } else if (this.deviceCategory.equals("Storage")) {
            if (this.deviceType.equals("DS4K_9.16.G0.06")) {
                filePath = "conf\\DS4K-requirement.config";
            } else if (this.deviceType.equals("DS6K_5.1.0.40")) {
                filePath = "conf\\DS6K-requirement.config";
            } else if (this.deviceType.equals("DS8K_5.1.0.40")) {
                filePath = "conf\\DS8K-requirement.config";
            }
        }
        return filePath;
    }

    private void addComponent(JPanel container, Component component, int row, int column, int width, int height) {
        this.constraints.gridx = column;
        this.constraints.gridy = row;
        this.constraints.gridwidth = width;
        this.constraints.gridheight = height;
        this.layout.setConstraints(component, this.constraints);
        container.add(component);
    }

    public JPanel customSetupOptions() {
        JPanel jpMain = new JPanel(this.layout);
        JLabel jlTitle = new JLabel("<html><b>Choose your custom setup options</b><br><br> If you are a first time user of the \"SAN Simulator\", we recommend you should select all the options. .<br></html>", 2);
        jlTitle.setBorder(BorderFactory.createEtchedBorder());
        jlTitle.setHorizontalTextPosition(2);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.anchor = 18;
        gbc.fill = 2;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 0.0;
        jpMain.add((Component)jlTitle, gbc);
        JPanel jpMiddle = new JPanel(this.layout);
        GridBagConstraints gbcWidget = new GridBagConstraints();
        gbcWidget.fill = 2;
        gbcWidget.gridheight = 1;
        gbcWidget.gridwidth = 1;
        gbcWidget.weightx = 1.0;
        gbcWidget.weighty = 0.0;
        gbcWidget.insets.left = 10;
        gbcWidget.insets.top = 10;
        this.jchbWbemInstall = new JCheckBox();
        this.jchbWbemInstall.setText(CREATE_NEW_CIMOM_CHECK_VALUE);
        this.jchbWbemInstall.setEnabled(true);
        this.jchbWbemInstall.addItemListener(new checkBoxListener(CREATE_NEW_CIMOM_CHECK_VALUE));
        gbcWidget.gridx = 0;
        gbcWidget.gridy = 0;
        jpMiddle.add((Component)this.jchbWbemInstall, gbcWidget);
        JPanel jpInstallCimom = new JPanel(new FlowLayout(0, 0, 0));
        jpInstallCimom.add(new JLabel("Directory path of installed CIMOM:               "));
        this.jtfWbemInstallpathTxt = new JTextField(20);
        this.jtfWbemInstallpathTxt.setEnabled(false);
        jpInstallCimom.add(this.jtfWbemInstallpathTxt);
        this.browseBt = new JButton("Browse");
        this.browseBt.addActionListener(new BrowseDirectoryListener(this.jtfWbemInstallpathTxt));
        this.browseBt.setEnabled(false);
        jpInstallCimom.add(this.browseBt);
        gbcWidget.gridx = 0;
        gbcWidget.gridy = 1;
        gbcWidget.insets.top = 0;
        gbcWidget.insets.bottom = 0;
        gbcWidget.insets.left = 20;
        jpMiddle.add((Component)jpInstallCimom, gbcWidget);
        this.jchbCompileMof = new JCheckBox();
        this.jchbCompileMof.setEnabled(true);
        this.jchbCompileMof.setText(COMPILE_MOF_CHECK_VALUE);
        this.jchbCompileMof.addItemListener(new checkBoxListener(COMPILE_MOF_CHECK_VALUE));
        gbcWidget.gridx = 0;
        gbcWidget.gridy = 2;
        gbcWidget.insets.left = 10;
        gbcWidget.fill = 2;
        jpMiddle.add((Component)this.jchbCompileMof, gbcWidget);
        JPanel jpCimomDir = new JPanel(new FlowLayout(0, 0, 0));
        jpCimomDir.add(new JLabel("Directory path for CIMOM destination:         "));
        this.jtfCimomPathTxt = new JTextField(20);
        this.jtfCimomPathTxt.setEnabled(false);
        jpCimomDir.add(this.jtfCimomPathTxt);
        this.browseCimomDir = new JButton("Browse");
        this.browseCimomDir.addActionListener(new BrowseDirectoryListener(this.jtfCimomPathTxt));
        this.browseCimomDir.setEnabled(false);
        jpCimomDir.add(this.browseCimomDir);
        gbcWidget.gridx = 0;
        gbcWidget.gridy = 3;
        gbcWidget.insets.left = 20;
        jpMiddle.add((Component)jpCimomDir, gbcWidget);
        JPanel jpMofFileDir = new JPanel(new FlowLayout(0, 0, 0));
        JLabel mofFileLbl = new JLabel("Directory path of MOF files to compile:         ");
        jpMofFileDir.add(mofFileLbl);
        this.jtfMofFilePathTxt = new JTextField(20);
        this.jtfMofFilePathTxt.setEnabled(false);
        jpMofFileDir.add(this.jtfMofFilePathTxt);
        this.browseMofFile = new JButton("Browse");
        this.browseMofFile.addActionListener(new BrowseDirectoryListener(this.jtfMofFilePathTxt));
        this.browseMofFile.setEnabled(false);
        jpMofFileDir.add(this.browseMofFile);
        gbcWidget.gridx = 0;
        gbcWidget.gridy = 4;
        gbcWidget.insets.left = 20;
        jpMiddle.add((Component)jpMofFileDir, gbcWidget);
        JCheckBox jchbCompileNewMof = new JCheckBox();
        jchbCompileNewMof.setText("Compile Newly created MOF");
        jchbCompileNewMof.setEnabled(false);
        jchbCompileNewMof.addItemListener(new checkBoxListener(SIMULATE_DEVICE_CHECK_VALUE));
        gbcWidget.gridx = 0;
        gbcWidget.gridy = 5;
        gbcWidget.insets.left = 10;
        jpMiddle.add((Component)jchbCompileNewMof, gbcWidget);
        this.jchbSimulateDevice = new JCheckBox();
        this.jchbSimulateDevice.setText("Generate Configuration/Snapshot based simulation data");
        this.jchbSimulateDevice.addItemListener(new checkBoxListener(SIMULATE_DEVICE_CHECK_VALUE));
        gbcWidget.gridx = 0;
        gbcWidget.gridy = 6;
        gbcWidget.insets.left = 10;
        jpMiddle.add((Component)this.jchbSimulateDevice, gbcWidget);
        jpMiddle.setBorder(BorderFactory.createTitledBorder("Customize Setup"));
        gbc.gridx = 0;
        gbc.gridy = 1;
        jpMain.add((Component)jpMiddle, gbcWidget);
        if (SetupWizardUtility.isCustomSetup) {
            if (SetupWizardUtility.isCompileMof) {
                this.jchbCompileMof.doClick();
                this.jtfCimomPathTxt.setText(SetupWizardUtility.cimomInstalledLocation);
                this.jtfMofFilePathTxt.setText(SetupWizardUtility.mofFilePath);
            }
            if (SetupWizardUtility.isInstallCIMOM) {
                this.jchbWbemInstall.doClick();
                this.jtfWbemInstallpathTxt.setText(SetupWizardUtility.dirLocationToInstallCIMOM);
            }
            if (SetupWizardUtility.isSimulateDevice) {
                this.jchbSimulateDevice.doClick();
            }
        }
        return jpMain;
    }

    private String getDeviceMOf() {
        String filePath = null;
        if (this.deviceCategory.equals("Switch")) {
            filePath = "SAN_Mof\\Brocade_110.4.0a";
        } else if (this.deviceCategory.equals("Storage")) {
            if (this.deviceType.equals("DS4K_9.16.G0.06")) {
                filePath = "SAN_Mof\\DS4K";
            } else if (this.deviceType.equals("DS6K_5.1.0.40")) {
                filePath = "SAN_Mof\\DS6K";
            } else if (this.deviceType.equals("DS8K_5.1.0.40")) {
                filePath = "SAN_Mof\\DS8K";
            }
        }
        return filePath;
    }

    protected void saveCustomSetupOtions() {
        SetupWizardUtility.isCustomSetup = true;
        if (this.jchbWbemInstall.isSelected()) {
            SetupWizardUtility.isInstallCIMOM = true;
            SetupWizardUtility.dirLocationToInstallCIMOM = this.jtfWbemInstallpathTxt.getText();
        } else {
            SetupWizardUtility.isInstallCIMOM = false;
            SetupWizardUtility.dirLocationToInstallCIMOM = null;
        }
        if (this.jchbSimulateDevice.isSelected()) {
            SetupWizardUtility.isSimulateDevice = true;
        }
        if (this.jchbCompileMof.isSelected()) {
            SetupWizardUtility.isCompileMof = true;
            SetupWizardUtility.cimomInstalledLocation = this.jtfCimomPathTxt.getText();
            SetupWizardUtility.mofFilePath = this.jtfMofFilePathTxt.getText();
        } else {
            SetupWizardUtility.isCompileMof = false;
            SetupWizardUtility.cimomInstalledLocation = null;
            SetupWizardUtility.mofFilePath = null;
        }
    }

    protected boolean isSetupParametersSet() {
        if (this.jchbWbemInstall.isSelected() && (this.jtfWbemInstallpathTxt.getText().equals("") || null == this.jtfWbemInstallpathTxt.getText())) {
            return false;
        }
        return !this.jchbCompileMof.isSelected() || !(this.jtfCimomPathTxt.isEnabled() ? this.jtfCimomPathTxt.getText().equals("") || null == this.jtfCimomPathTxt.getText() || this.jtfMofFilePathTxt.getText().equals("") || null == this.jtfMofFilePathTxt.getText() : this.jtfMofFilePathTxt.getText().equals("") || null == this.jtfMofFilePathTxt.getText());
    }

    protected boolean isSetupModeSet() {
        return this.installModeClicked;
    }

    protected void createSetuFile() {
    }

    private class BrowseDirectoryListener
    implements ActionListener {
        JTextField textField;

        public BrowseDirectoryListener(JTextField textToFill) {
            this.textField = textToFill;
        }

        public void actionPerformed(ActionEvent e) {
            this.textField.setText(InputScreens.this.opendir().toString());
        }
    }

    private class checkBoxListener
    implements ItemListener {
        private String jchbclicked;

        public checkBoxListener(String str) {
            this.jchbclicked = str;
        }

        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                if (this.jchbclicked.equals(InputScreens.CREATE_NEW_CIMOM_CHECK_VALUE)) {
                    this.setCIMOMPort();
                    InputScreens.this.jtfWbemInstallpathTxt.setEnabled(true);
                    if (InputScreens.this.jtfCimomPathTxt.isEnabled()) {
                        InputScreens.this.jtfCimomPathTxt.setEnabled(false);
                    }
                    InputScreens.this.browseBt.setEnabled(true);
                } else if (this.jchbclicked.equals(InputScreens.COMPILE_MOF_CHECK_VALUE)) {
                    if (InputScreens.this.jtfWbemInstallpathTxt.isEnabled()) {
                        InputScreens.this.jtfMofFilePathTxt.setEnabled(true);
                        InputScreens.this.browseMofFile.setEnabled(true);
                        if (!InputScreens.this.snapshotSetupMode) {
                            InputScreens.this.jtfMofFilePathTxt.setText(InputScreens.this.getDeviceMOf());
                        }
                    } else {
                        InputScreens.this.jtfCimomPathTxt.setEnabled(true);
                        InputScreens.this.browseCimomDir.setEnabled(true);
                        InputScreens.this.jtfMofFilePathTxt.setEnabled(true);
                        InputScreens.this.browseMofFile.setEnabled(true);
                    }
                } else if (this.jchbclicked.equals(InputScreens.CREATE_DEVICE_MOF_VALUE)) {
                    InputScreens.this.jtfMofFileTxt.setEnabled(true);
                    InputScreens.this.browseMofLoc.setEnabled(true);
                }
            } else if (e.getStateChange() == 2) {
                if (this.jchbclicked.equals(InputScreens.CREATE_NEW_CIMOM_CHECK_VALUE)) {
                    InputScreens.this.jtfWbemInstallpathTxt.setEnabled(false);
                    InputScreens.this.browseBt.setEnabled(false);
                    if (InputScreens.this.snapshotSetupMode && InputScreens.this.jtfMofFilePathTxt.isEnabled()) {
                        InputScreens.this.jtfCimomPathTxt.setEnabled(true);
                    }
                } else if (this.jchbclicked.equals(InputScreens.COMPILE_MOF_CHECK_VALUE)) {
                    InputScreens.this.jtfCimomPathTxt.setEnabled(false);
                    InputScreens.this.browseCimomDir.setEnabled(false);
                    InputScreens.this.jtfMofFilePathTxt.setEnabled(false);
                    InputScreens.this.browseMofFile.setEnabled(false);
                } else if (this.jchbclicked.equals(InputScreens.CREATE_DEVICE_MOF_VALUE)) {
                    InputScreens.this.jtfMofFileTxt.setEnabled(false);
                    InputScreens.this.browseMofLoc.setEnabled(false);
                }
            }
        }

        private void setCIMOMPort() {
            while (true) {
                String portNo = JOptionPane.showInputDialog("Enter Port number for CIMOM to run", (Object)"5988");
                InputScreens.this.logger.info("Port Number Entered: " + portNo);
                if (portNo == null) continue;
                if (new CheckPreRequisites().CheckPort(Integer.parseInt(portNo))) break;
                JOptionPane.showMessageDialog(null, "This port is currently in use", "Port Busy", 0);
            }
        }
    }

    private class RadioButtonHandler
    implements ItemListener {
        private String jrbt;

        public RadioButtonHandler(String jrb) {
            this.jrbt = jrb;
        }

        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                InputScreens.this.deviceClicked = true;
                if (this.jrbt.equals("Switch")) {
                    InputScreens.this.switchSelected = true;
                    InputScreens.this.storageSelected = false;
                    InputScreens.this.othersSelected = false;
                    InputScreens.this.serverSelected = false;
                    InputScreens.this.jcbServer.setEnabled(false);
                    InputScreens.this.jcbSwitch.setEnabled(true);
                    InputScreens.this.jcbStorage.setEnabled(false);
                    InputScreens.this.jcbOthers.setEnabled(false);
                    if (InputScreens.this.deviceType.equalsIgnoreCase("Not Set")) {
                        InputScreens.this.deviceType = "Brocade_110.4.0a";
                    }
                }
                if (this.jrbt.equals("Storage")) {
                    InputScreens.this.switchSelected = false;
                    InputScreens.this.storageSelected = true;
                    InputScreens.this.othersSelected = false;
                    InputScreens.this.serverSelected = false;
                    InputScreens.this.jcbServer.setEnabled(false);
                    InputScreens.this.jcbSwitch.setEnabled(false);
                    InputScreens.this.jcbStorage.setEnabled(true);
                    InputScreens.this.jcbOthers.setEnabled(false);
                    if (InputScreens.this.deviceType.equalsIgnoreCase("Not Set")) {
                        InputScreens.this.deviceType = "DS4K_9.16.G0.06";
                    }
                }
                if (this.jrbt.equals("Others")) {
                    InputScreens.this.switchSelected = false;
                    InputScreens.this.storageSelected = false;
                    InputScreens.this.othersSelected = true;
                    InputScreens.this.serverSelected = false;
                    InputScreens.this.jcbServer.setEnabled(false);
                    InputScreens.this.jcbSwitch.setEnabled(false);
                    InputScreens.this.jcbStorage.setEnabled(false);
                    InputScreens.this.jcbOthers.setEnabled(true);
                    InputScreens.this.deviceType = "IBM Tape Library";
                }
                if (this.jrbt.equals("Server")) {
                    InputScreens.this.switchSelected = false;
                    InputScreens.this.storageSelected = false;
                    InputScreens.this.othersSelected = false;
                    InputScreens.this.serverSelected = false;
                    InputScreens.this.jcbSwitch.setEnabled(false);
                    InputScreens.this.jcbStorage.setEnabled(false);
                    InputScreens.this.jcbOthers.setEnabled(false);
                    InputScreens.this.jrbSwitch.doClick();
                    JOptionPane.showMessageDialog(null, "Sorry! Server Simulation is yet not supported", "Invalid", 1);
                    InputScreens.this.deviceType = "Not Supported";
                }
            }
        }
    }

    private class SnapshotRadioHandler
    implements ItemListener {
        private String SnapshotMode;

        public SnapshotRadioHandler(String Mode) {
            this.SnapshotMode = Mode;
        }

        public void itemStateChanged(ItemEvent event) {
            InputScreens.this.setupModeClicked = true;
            if (this.SnapshotMode.equals("Restore")) {
                InputScreens.this.restoreBackupDB = true;
                InputScreens.this.startFreshSnapshot = false;
            } else if (this.SnapshotMode.equals("Fresh")) {
                InputScreens.this.restoreBackupDB = false;
                InputScreens.this.startFreshSnapshot = true;
            }
        }
    }

    private class InstallRadioHandler
    implements ItemListener {
        private String InstallMode;

        public InstallRadioHandler(String Mode) {
            this.InstallMode = Mode;
        }

        public void itemStateChanged(ItemEvent event) {
            InputScreens.this.installModeClicked = true;
            if (this.InstallMode.equals(InputScreens.NON_INTERACTIVE_VALUE)) {
                InputScreens.this.nonInteractiveSetup = true;
                InputScreens.this.interactiveSetup = false;
                InputScreens.this.jcbSimulation_mode.setEnabled(false);
            } else if (this.InstallMode.equals(InputScreens.INTERACTIVE_VALUE)) {
                InputScreens.this.nonInteractiveSetup = false;
                InputScreens.this.interactiveSetup = true;
                InputScreens.this.jcbSimulation_mode.setEnabled(true);
            }
        }
    }

    private class DeviceTypeHandler
    implements ItemListener {
        public void itemStateChanged(ItemEvent event) {
            if (event.getStateChange() == 1) {
                if (InputScreens.this.switchSelected) {
                    if (event.getItem().equals("Brocade_110.4.0a")) {
                        InputScreens.this.deviceType = event.getItem().toString();
                        InputScreens.this.logger.info("Device type: " + InputScreens.this.deviceType);
                    } else {
                        String strSelected = event.getItem().toString();
                        strSelected = strSelected.substring(0, strSelected.indexOf(" "));
                        JOptionPane.showMessageDialog(null, "Sorry! Switch -> " + strSelected + " simulation currently not supported.", "Invalid", 0);
                        InputScreens.this.jcbSwitch.setSelectedIndex(0);
                    }
                } else if (InputScreens.this.othersSelected) {
                    String strSelected = event.getItem().toString();
                    if (strSelected.equals("IBM Tape Library")) {
                        InputScreens.this.deviceType = event.getItem().toString();
                        InputScreens.this.logger.info("Device type: " + InputScreens.this.deviceType);
                    } else {
                        JOptionPane.showMessageDialog(null, "Sorry! Others -> iSCSI simulation not supported yet", "Invalid", 0);
                        InputScreens.this.jcbOthers.setSelectedIndex(0);
                    }
                } else if (InputScreens.this.storageSelected) {
                    InputScreens.this.deviceType = event.getItem().toString();
                    InputScreens.this.logger.info("Device type: " + InputScreens.this.deviceType);
                } else {
                    InputScreens.this.deviceType = "Not Sopported";
                }
            }
        }
    }

    private class SimulationModeHandler
    implements ItemListener {
        public void itemStateChanged(ItemEvent event) {
            if (event.getItem().equals("Configuaration-based")) {
                InputScreens.this.logger.info("Simulation Mode Selected: " + event.getItem());
                if (InputScreens.this.deviceType.equals("IBM Tape Library")) {
                    JOptionPane.showMessageDialog(null, "Configuration Simuation approach not supported for IBM Tape Library currently", "Invalid", 0);
                    InputScreens.this.jcbSimulation_mode.setSelectedIndex(0);
                }
                InputScreens.this.snapshotSetupMode = false;
            } else {
                InputScreens.this.logger.info("SImulation Mode Selected: " + event.getItem());
                InputScreens.this.snapshotSetupMode = true;
            }
        }
    }

    private class TestDB
    implements ActionListener {
        private String hosturl;
        private String userid;
        private String dbname;
        private String password;

        private TestDB() {
        }

        public void actionPerformed(ActionEvent event) {
            InputScreens.this.dbConnectionTested = true;
            TestDBConnection testDB = new TestDBConnection();
            this.dbname = InputScreens.this.jtfDBName.getText();
            this.password = new String(InputScreens.this.jtfDBPasswd.getPassword()).equals("") ? "Default" : new String(InputScreens.this.jtfDBPasswd.getPassword());
            this.userid = InputScreens.this.jtfDBUserId.getText().equals("") ? "Default" : InputScreens.this.jtfDBUserId.getText();
            this.hosturl = InputScreens.this.jtfDBHostUrl.getText();
            InputScreens.this.logger.info("Parameters Passed for DB test: " + this.dbname + "  " + this.password + "   " + this.userid + "  " + this.hosturl);
            int flag = testDB.testConnection(this.dbname, this.userid, this.password, this.hosturl);
            if (flag == 1) {
                JOptionPane.showMessageDialog(null, "Database Connection successful", "Test DB Conncetion", 1);
                InputScreens.this.dbConnectionExist = true;
            } else {
                JOptionPane.showMessageDialog(null, "Databse Conncetion failed", "Test DB Conncetion", 0);
                InputScreens.this.dbConnectionExist = false;
            }
        }
    }

    private class TestCIMOM
    implements ActionListener {
        private String cimomurl;
        private String cimomuserid;
        private String cimompasswd;
        private String cimomnmspace;
        private String cimomprotocol;
        private String cimomport;

        private TestCIMOM() {
        }

        public void actionPerformed(ActionEvent event) {
            int flag = 0;
            this.cimomurl = InputScreens.this.jtfCIMhost_url.getText();
            this.cimomport = InputScreens.this.jtfCIMport.getText();
            this.cimomuserid = InputScreens.this.jtfCIMuid.getText();
            this.cimompasswd = new String(InputScreens.this.jtfCIMpwd.getPassword());
            this.cimomnmspace = InputScreens.this.jtfCIMnmspace.getText();
            this.cimomprotocol = InputScreens.this.jcbprotocols.getSelectedItem().toString();
            TestWbemCimomConnection testWbem = new TestWbemCimomConnection();
            InputScreens.this.logger.info("Sun WBEM CIMOM to connect");
            try {
                flag = testWbem.testConnection(this.cimomurl, this.cimomport, this.cimomuserid, this.cimompasswd, this.cimomnmspace, this.cimomprotocol);
            }
            catch (CIMException e) {
                e.printStackTrace();
            }
            if (flag == 1) {
                JOptionPane.showMessageDialog(null, "Connection Successful !", "Test CIMOM Connection", 1);
                InputScreens.this.logger.info("CIMOM Connection successful!");
            } else if (flag == 0) {
                JOptionPane.showMessageDialog(null, "Connection Refused !", "Test CIMOM Connection", 0);
                InputScreens.this.logger.info("Connection to CIMOM refused!");
            }
        }
    }

    private class SANPropbrowseButtonHandler
    implements ActionListener {
        private SANPropbrowseButtonHandler() {
        }

        public void actionPerformed(ActionEvent event) {
            InputScreens.this.SANPropFile = InputScreens.this.openfile();
            InputScreens.this.jtfSANPropFilePath.setText(InputScreens.this.SANPropFile.toString());
        }
    }

    private class ConfigbrowseButtonHandler
    implements ActionListener {
        private ConfigbrowseButtonHandler() {
        }

        public void actionPerformed(ActionEvent event) {
            InputScreens.this.jtfConfigFilePath.setText(InputScreens.this.openfile().toString());
        }
    }
}

