/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.simulator.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.eclipse.aperi.simulator.ui.ButtonsPanel;
import org.eclipse.aperi.simulator.ui.ConnectionScreens;
import org.eclipse.aperi.simulator.ui.ConnectionUtility;
import org.eclipse.aperi.simulator.ui.InputScreens;
import org.eclipse.aperi.simulator.ui.SetupProcess;

public class MainScreen
extends JFrame {
    private static final long serialVersionUID = 1L;
    private Container container = this.getContentPane();
    private GridBagLayout layout = new GridBagLayout();
    private GridBagConstraints constraints = new GridBagConstraints();
    int curPosScreen = 0;
    private boolean isCheckDone = false;
    private JPanel inputPanel;
    private InputScreens screenObj = new InputScreens();
    private SetupProcess instProc = new SetupProcess();
    private JPanel jpMain = new JPanel(new BorderLayout());
    private ButtonsPanel jpButton = new ButtonsPanel();

    public MainScreen() {
        super("SAN Simulator Setup Wizard");
        this.setDefaultCloseOperation(3);
        this.showSetupPanel();
    }

    private JPanel getDeviceSimulationScreen() {
        if (this.curPosScreen == 1) {
            this.jpButton.setBackVisible(true);
            this.jpButton.setNextVisible(true);
            return this.screenObj.createSetupModeSelectionScreen();
        }
        if (this.screenObj.interactiveSetup) {
            this.screenObj.saveSModeProperties();
            if (this.screenObj.snapshotSetupMode) {
                if (this.curPosScreen == 2) {
                    return this.screenObj.dbInfoScreen();
                }
                if (this.curPosScreen == 3) {
                    this.screenObj.saveDbProperties();
                    return this.screenObj.snapshotCIMOMInfoScreen();
                }
                if (this.curPosScreen == 4) {
                    this.screenObj.saveCIMOMProperties();
                    this.jpButton.setNextVisible(true);
                    this.jpButton.setInstallVisisble(false);
                    return this.screenObj.customSetupOptions();
                }
                if (this.curPosScreen == 5) {
                    this.screenObj.saveCustomSetupOtions();
                    this.screenObj.saveSnapshotInteractiveToFile();
                    this.jpButton.setNextVisible(false);
                    this.jpButton.setInstallVisisble(true);
                    return this.screenObj.SetupSummaryPage();
                }
            } else {
                if (this.curPosScreen == 2) {
                    this.jpButton.setBackVisible(true);
                    return this.screenObj.deviceSelectScreen();
                }
                if (this.curPosScreen == 3) {
                    this.screenObj.saveDeviceProperties();
                    return this.screenObj.dbInfoScreen();
                }
                if (this.curPosScreen == 4) {
                    this.screenObj.saveDbProperties();
                    return this.screenObj.configInfoScreen();
                }
                if (this.curPosScreen == 5) {
                    this.screenObj.saveConfigProp();
                    this.jpButton.setNextVisible(true);
                    this.jpButton.setInstallVisisble(false);
                    return this.screenObj.customSetupOptions();
                }
                if (this.curPosScreen == 6) {
                    this.screenObj.saveCustomSetupOtions();
                    this.screenObj.saveConfigurationInteractiveToFile();
                    this.jpButton.setNextVisible(false);
                    this.jpButton.setInstallVisisble(true);
                    return this.screenObj.SetupSummaryPage();
                }
            }
        } else {
            if (this.curPosScreen == 2) {
                this.jpButton.setNextVisible(true);
                this.jpButton.setInstallVisisble(false);
                this.screenObj.saveSModeProperties();
                return this.screenObj.sanPropertyFilePathScreen();
            }
            if (this.curPosScreen == 3) {
                this.screenObj.saveSANPathProp();
                this.screenObj.saveNonInteractiveToFile();
                this.jpButton.setNextVisible(false);
                this.jpButton.setInstallVisisble(true);
                return this.screenObj.SetupSummaryPage();
            }
        }
        return null;
    }

    private JPanel getConnectionSimulationScreen() {
        if (this.curPosScreen == 1) {
            this.jpButton.setBackVisible(true);
            this.jpButton.setNextVisible(true);
            return ConnectionScreens.getInstance().getConnectionOption();
        }
        if (this.curPosScreen == 2) {
            return ConnectionScreens.getInstance().getDBInfoForSwitchScreen();
        }
        if (ConnectionUtility.profileConnection.equals(ConnectionUtility.SWITCH_TO_SWITCH)) {
            if (this.curPosScreen == 3) {
                this.jpButton.setNextVisible(true);
                this.jpButton.setConnectVisible(false);
                return ConnectionScreens.getInstance().getDeviceConnected();
            }
            if (this.curPosScreen == 4) {
                this.jpButton.setNextVisible(false);
                this.jpButton.setConnectVisible(true);
                return ConnectionScreens.getInstance().getPortConnection();
            }
        } else if (ConnectionUtility.profileConnection.equals(ConnectionUtility.SWITCH_TO_ARRAY)) {
            if (this.curPosScreen == 3) {
                if (ConnectionUtility.ConnectMedium.equals(ConnectionUtility.DB_CLIENT)) {
                    return ConnectionScreens.getInstance().getDBInfoForTargetrDeviceScreen();
                }
                if (ConnectionUtility.ConnectMedium.equals(ConnectionUtility.CIM_CLIENT)) {
                    return ConnectionScreens.getInstance().getCIMOMInfoScreen();
                }
            } else {
                if (this.curPosScreen == 4) {
                    this.jpButton.setNextVisible(true);
                    this.jpButton.setConnectVisible(false);
                    return ConnectionScreens.getInstance().getDeviceConnected();
                }
                if (this.curPosScreen == 5) {
                    this.jpButton.setNextVisible(false);
                    this.jpButton.setConnectVisible(true);
                    return ConnectionScreens.getInstance().getPortConnection();
                }
            }
        }
        return null;
    }

    private void showSetupPanel() {
        this.container = this.getContentPane();
        this.container.setLayout(this.layout);
        ButtonHandler handler = new ButtonHandler();
        this.jpButton.jbBack.addActionListener(handler);
        this.jpButton.jbNext.addActionListener(handler);
        this.jpButton.jbCancel.addActionListener(handler);
        this.jpButton.jbConnect.addActionListener(handler);
        this.jpButton.jbInstall.addActionListener(handler);
        this.inputPanel = this.getStartUpScreen();
        this.jpMain.add((Component)this.inputPanel, "North");
        ImageIcon iIcon = new ImageIcon("resources" + File.separator + "logo2_mm.gif");
        JLabel lSanLogo = new JLabel("", iIcon, 2);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridheight = 5;
        gbc.gridwidth = 1;
        gbc.fill = 3;
        this.layout.setConstraints(lSanLogo, gbc);
        this.container.add(lSanLogo);
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 1.0;
        this.constraints.fill = 1;
        this.jpMain.setBorder(BorderFactory.createEtchedBorder());
        gbc.gridx = 1;
        gbc.gridy = 0;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        gbc.fill = 1;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        this.layout.setConstraints(this.jpMain, gbc);
        this.container.add(this.jpMain);
        this.constraints.weightx = 0.0;
        this.constraints.weighty = 0.0;
        this.constraints.fill = 1;
        gbc.gridx = 1;
        gbc.gridy = 4;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.fill = 1;
        gbc.gridheight = 1;
        gbc.gridwidth = 1;
        this.layout.setConstraints(this.jpButton, gbc);
        this.container.add(this.jpButton);
        this.setSize(600, 450);
        this.setLocation(150, 150);
        this.setVisible(true);
    }

    private void addComponent(JPanel panel, Component component, int row, int column, int width, int height) {
        this.constraints.anchor = 18;
        this.constraints.fill = 2;
        this.constraints.gridx = column;
        this.constraints.gridy = row;
        this.constraints.gridwidth = width;
        this.constraints.gridheight = height;
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 0.0;
        this.layout.setConstraints(component, this.constraints);
        panel.add(component);
    }

    private JPanel getStartUpScreen() {
        JPanel jpMainPanel = new JPanel(this.layout);
        JLabel jlTitle = new JLabel("<html><b>Select your setup action</b><br><br><b>\"Simulate Device\"</b> will allow you to simulate any CIM compliant device. <b>\"Simulate Connection\"</b> will connect two simulated/live SAN devices.</b>.<br><br></html>", 2);
        jlTitle.setBorder(BorderFactory.createEtchedBorder());
        jlTitle.setHorizontalTextPosition(2);
        this.constraints.insets.top = 0;
        this.constraints.insets.bottom = 0;
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 0.0;
        this.addComponent(jpMainPanel, jlTitle, 0, 0, 1, 1);
        JPanel jpMiddle = new JPanel(this.layout);
        jpMiddle.setBorder(BorderFactory.createTitledBorder("Simulation Option"));
        JRadioButton simConnection = new JRadioButton("Simulate Connection");
        JRadioButton simDevice = new JRadioButton("Simulate Device");
        ButtonGroup simOption = new ButtonGroup();
        simConnection.addItemListener(new RadioButtonHandler("Connection"));
        simDevice.addItemListener(new RadioButtonHandler("Device"));
        simOption.add(simDevice);
        simOption.add(simConnection);
        this.constraints.insets.top = 25;
        this.constraints.insets.bottom = 10;
        this.constraints.insets.left = 5;
        this.addComponent(jpMiddle, simDevice, 0, 0, 1, 1);
        this.constraints.insets.top = 25;
        this.constraints.insets.left = 5;
        this.addComponent(jpMiddle, simConnection, 1, 0, 1, 1);
        this.constraints.insets.top = 0;
        this.constraints.insets.bottom = 0;
        this.constraints.insets.left = 0;
        this.addComponent(jpMainPanel, jpMiddle, 1, 0, 1, 1);
        this.jpButton.setBackVisible(false);
        if (ConnectionUtility.simulateOption != null) {
            if (ConnectionUtility.simulateOption.equalsIgnoreCase("Connection")) {
                simConnection.doClick();
            } else if (ConnectionUtility.simulateOption.equalsIgnoreCase("Device")) {
                simDevice.doClick();
            }
        } else {
            simDevice.doClick();
        }
        return jpMainPanel;
    }

    private boolean PreviousPropSet() {
        if (this.curPosScreen == 0) {
            return this.SimEntitySet();
        }
        if (ConnectionUtility.isSimConnection) {
            if (this.curPosScreen == 1) {
                ConnectionUtility.closeConnection();
                if (ConnectionScreens.getInstance().connectionConfigSet()) {
                    ConnectionScreens.getInstance().saveConnectionConf();
                    return true;
                }
                return false;
            }
            if (this.curPosScreen == 2) {
                if (ConnectionScreens.getInstance().isSwitchDBConfig()) {
                    ConnectionScreens.getInstance().saveSwitchDBConfiguration();
                    return true;
                }
                return false;
            }
            if (ConnectionUtility.profileConnection.equals(ConnectionUtility.SWITCH_TO_SWITCH)) {
                if (this.curPosScreen == 3) {
                    if (ConnectionScreens.getInstance().isDevcieConnected()) {
                        ConnectionScreens.getInstance().saveDeviceConnection();
                        return true;
                    }
                    return false;
                }
                if (this.curPosScreen == 4) {
                    if (ConnectionScreens.getInstance().isPortConnected()) {
                        ConnectionScreens.getInstance().savePortConnections();
                        ConnectionScreens.getInstance().saveConnectionPropToFile();
                        return true;
                    }
                    return false;
                }
            } else {
                if (this.curPosScreen == 3) {
                    if (ConnectionUtility.ConnectMedium.equals(ConnectionUtility.DB_CLIENT)) {
                        if (ConnectionScreens.getInstance().isTargetDevcieDBConfig()) {
                            ConnectionScreens.getInstance().saveTargetDevcieDBConfiguration();
                            return true;
                        }
                        return false;
                    }
                    if (ConnectionUtility.ConnectMedium.equals(ConnectionUtility.CIM_CLIENT)) {
                        if (ConnectionScreens.getInstance().isCIMOMConfig()) {
                            ConnectionScreens.getInstance().saveCIMOMConfiguration();
                            if (!ConnectionUtility.isCIMOMConnected) {
                                ConnectionUtility.connectToCIMOM();
                            }
                            return true;
                        }
                        return false;
                    }
                    return false;
                }
                if (this.curPosScreen == 4) {
                    if (ConnectionScreens.getInstance().isDevcieConnected()) {
                        ConnectionScreens.getInstance().saveDeviceConnection();
                        return true;
                    }
                    return false;
                }
                if (this.curPosScreen == 5) {
                    if (ConnectionScreens.getInstance().isPortConnected()) {
                        ConnectionScreens.getInstance().savePortConnections();
                        ConnectionScreens.getInstance().saveConnectionPropToFile();
                        return true;
                    }
                    return false;
                }
            }
        } else if (!ConnectionUtility.isSimConnection) {
            if (this.curPosScreen == 1) {
                return this.screenObj.isSetupModeSet();
            }
            if (this.screenObj.interactiveSetup) {
                if (this.screenObj.snapshotSetupMode) {
                    if (this.curPosScreen == 2) {
                        return this.screenObj.isDBConfigured();
                    }
                    if (this.curPosScreen == 3) {
                        return this.screenObj.isCimomPropset();
                    }
                    if (this.curPosScreen == 4) {
                        return this.screenObj.isSetupParametersSet();
                    }
                } else {
                    if (this.curPosScreen == 2) {
                        return this.screenObj.isDeviceSelected();
                    }
                    if (this.curPosScreen == 3) {
                        return this.screenObj.isDBConfigured();
                    }
                    if (this.curPosScreen == 4) {
                        return this.screenObj.isConfigPathSet();
                    }
                    if (this.curPosScreen == 5) {
                        return this.screenObj.isSetupParametersSet();
                    }
                }
            } else if (this.screenObj.nonInteractiveSetup && this.curPosScreen == 1) {
                return this.screenObj.isPropertyFileSet();
            }
        }
        return true;
    }

    private boolean SimEntitySet() {
        return ConnectionUtility.simulateOption != null;
    }

    protected class RadioButtonHandler
    implements ItemListener {
        private String option;

        public RadioButtonHandler(String str) {
            this.option = str;
        }

        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                if (this.option.equals("Connection")) {
                    ConnectionUtility.simulateOption = "Connection";
                    ConnectionUtility.isSimConnection = true;
                } else if (this.option.equals("Device")) {
                    ConnectionUtility.simulateOption = "Device";
                    ConnectionUtility.isSimConnection = false;
                }
            }
        }
    }

    protected class ButtonHandler
    implements ActionListener {
        protected ButtonHandler() {
        }

        public void actionPerformed(ActionEvent event) {
            if (event.getActionCommand() == "Cancel") {
                int result = JOptionPane.showConfirmDialog(null, "If you Cancel the setup now, SAN Simulator will not be installed. Are you sure you want to exit?", "Cancel", 1);
                if (result == 0) {
                    JOptionPane.showMessageDialog(null, "Please close (if any) all the Open Command Windows to exit setup !", "Cancel", 1);
                    MainScreen.this.dispose();
                    System.exit(0);
                } else if (result == 1 || result == 2) {
                    // empty if block
                }
            }
            if (event.getActionCommand() == "Next") {
                MainScreen.this.container.setCursor(Cursor.getPredefinedCursor(3));
                if (MainScreen.this.PreviousPropSet()) {
                    ++MainScreen.this.curPosScreen;
                    MainScreen.this.jpMain.remove(MainScreen.this.inputPanel);
                    if (ConnectionUtility.isSimConnection) {
                        MainScreen.this.inputPanel = MainScreen.this.getConnectionSimulationScreen();
                    } else {
                        MainScreen.this.inputPanel = MainScreen.this.getDeviceSimulationScreen();
                    }
                    MainScreen.this.jpMain.add((Component)MainScreen.this.inputPanel, "North");
                    MainScreen.this.jpMain.repaint();
                    MainScreen.this.container.setCursor(Cursor.getDefaultCursor());
                    MainScreen.this.setVisible(true);
                } else {
                    JOptionPane.showMessageDialog(null, "Please fill the correct Information before you proceed!", "Error", 0);
                    MainScreen.this.container.setCursor(Cursor.getDefaultCursor());
                }
            }
            if (event.getActionCommand() == "Back") {
                --MainScreen.this.curPosScreen;
                MainScreen.this.container.setCursor(Cursor.getPredefinedCursor(3));
                MainScreen.this.jpMain.remove(MainScreen.this.inputPanel);
                if (MainScreen.this.curPosScreen == 0) {
                    MainScreen.this.inputPanel = MainScreen.this.getStartUpScreen();
                } else if (ConnectionUtility.simulateOption.equalsIgnoreCase("Connection")) {
                    MainScreen.this.inputPanel = MainScreen.this.getConnectionSimulationScreen();
                } else if (ConnectionUtility.simulateOption.equalsIgnoreCase("Device")) {
                    MainScreen.this.inputPanel = MainScreen.this.getDeviceSimulationScreen();
                }
                MainScreen.this.jpMain.add((Component)MainScreen.this.inputPanel, "North");
                MainScreen.this.jpMain.repaint();
                MainScreen.this.container.setCursor(Cursor.getDefaultCursor());
                MainScreen.this.setVisible(true);
            }
            if (event.getActionCommand() == "Install") {
                MainScreen.this.screenObj.createSetuFile();
                MainScreen.this.setVisible(true);
                MainScreen.this.instProc.start();
                MainScreen.this.dispose();
            }
            if (event.getActionCommand() == "Connect") {
                if (MainScreen.this.PreviousPropSet()) {
                    MainScreen.this.setVisible(true);
                    MainScreen.this.instProc.start();
                    MainScreen.this.dispose();
                } else {
                    JOptionPane.showMessageDialog(null, "Please fill all the required Information before you proceed!", "Error", 0);
                }
            }
        }
    }
}

