/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.wbem.cim;

import java.util.Calendar;
import org.sblim.wbem.cim.CIMDateTime;

public class CIMSimpleDateTime
extends CIMDateTime {
    private static final long serialVersionUID = -5855212374146014403L;

    public CIMSimpleDateTime() {
        this.iDateString = "00000000000000.000000-000";
        this.iInterval = false;
        this.iPresicion = 12;
    }

    public CIMSimpleDateTime(String pDateString) {
        if (pDateString.indexOf(58) > -1) {
            throw new IllegalArgumentException("simple date time must not be used to define intervals: " + pDateString);
        }
        this.iInterval = false;
        CIMSimpleDateTime.valueOf(this, pDateString);
    }

    public CIMSimpleDateTime(Calendar pCalendar) {
        if (pCalendar == null) {
            throw new IllegalArgumentException("null calendar argument");
        }
        Calendar calendar = (Calendar)pCalendar.clone();
        this.iOffsetMinute = calendar.get(15) / 60000;
        this.iYear = calendar.get(1);
        this.iMonth = calendar.get(2) - calendar.getMinimum(2) + 1;
        this.iDay = calendar.get(5) - calendar.getMinimum(5) + 1;
        this.iHour = calendar.get(11) - calendar.getMinimum(11);
        this.iMinute = calendar.get(12) - calendar.getMinimum(12);
        this.iSecond = calendar.get(13) - calendar.getMinimum(13);
        this.iMillisecond = calendar.get(14) - calendar.getMinimum(14);
        this.iPresicion = 12;
    }

    public int getMonth() {
        return this.iMonth;
    }

    public int getYear() {
        return this.iYear;
    }

    public void setDay(int pDay) {
        if (pDay < 1 || pDay > 31) {
            throw new IllegalArgumentException("invalid value of offset minute:" + pDay);
        }
        this.iCalendar = null;
        this.iDay = pDay;
    }

    public void setMonth(int pMonth) {
        if (pMonth < 1 || pMonth > 12) {
            throw new IllegalArgumentException("invalid value of month [1-12]:" + pMonth);
        }
        this.iCalendar = null;
        this.iMonth = pMonth;
    }

    public void setYear(int pYear) {
        this.iCalendar = null;
        this.iYear = pYear;
    }

    public Object clone() {
        return super.clone(new CIMSimpleDateTime());
    }

    public static void main(String[] args) {
        CIMSimpleDateTime date = new CIMSimpleDateTime("20040405130342.000000+060");
        System.out.println(date);
        System.out.println(date.getCalendar());
    }
}

