/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.wbem.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.Provider;
import java.security.Security;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.SocketFactory;

public class SessionProperties
extends Properties
implements Cloneable {
    private static final long serialVersionUID = -5658419976348651048L;
    public static final int PULL_PARSER = 0;
    public static final int SAX_PARSER = 1;
    public static final int DOM_PARSER = 2;
    public static final String WWW_AUTHENTICATION = (class$org$sblim$wbem$http$WwwAuthInfo == null ? (class$org$sblim$wbem$http$WwwAuthInfo = SessionProperties.class$("org.sblim.wbem.http.WwwAuthInfo")) : class$org$sblim$wbem$http$WwwAuthInfo).getName();
    public static final String PEGASUS_LOCAL_AUTHENTICATION = (class$org$sblim$wbem$http$PegasusLocalAuthInfo == null ? (class$org$sblim$wbem$http$PegasusLocalAuthInfo = SessionProperties.class$("org.sblim.wbem.http.PegasusLocalAuthInfo")) : class$org$sblim$wbem$http$PegasusLocalAuthInfo).getName();
    private static final String KEY_AUTHENTICATION = "http.authentication";
    private static final String KEY_HTTP_TIME_OUT = "http.timeout";
    private static final String KEY_HTTP_CONNECTION_POOL_SIZE = "http.pool.size";
    private static final String KEY_TRUSTSTORE = "https.truststore.path";
    private static final String KEY_TRUSTSTORE_PASSWORD = "https.truststore.password";
    private static final String KEY_KEYSTORE = "https.keystore.path";
    private static final String KEY_KEYSTORE_TYPE = "https.keystore.type";
    private static final String KEY_KEYSTORE_PASSWORD = "https.keystore.password";
    private static final String KEY_JSSE_PROVIDER = "https.jsse.provider";
    private static final String KEY_JSSE_CERTIFICATE = "https.jsse.certificate";
    private static final String KEY_XML_PARSER = "xml.parser";
    private static final String KEY_DEBUG_HTTP_POOL = "debug.http.pool";
    private static final String KEY_DEBUG_ISTREAM = "debug.istream";
    private static final String KEY_DEBUG_ISTREAM_OUTPUT = "debug.istream.output";
    private static final String KEY_DEBUG_XML_INPUT = "debug.xml.input";
    private static final String KEY_DEBUG_XML_OUTPUT = "debug.xml.output";
    private static final String KEY_LOGGER = "logger";
    private static final String KEY_LOGGER_NAMESPACE = "logger.namespace";
    private static final String KEY_LOGGER_OUTPUT = "log.output";
    private static final String KEY_LOGGER_CONSOLE_LEVEL = "log.console.level";
    private static final String KEY_LOGGER_FILE_LEVEL = "log.file.level";
    private static final String KEY_CREDENTIALS_DEFAULT_ENABLED = "default.authorization.enabled";
    private static final String KEY_DEFAULT_PRINCIPAL = "default.principal";
    private static final String KEY_DEFAULT_CREDENTIAL = "default.credential";
    private static final String KEY_RETRIES_NUMBER = "retries.number";
    private static final String KEY_RETRIES_CONTENT_ENABLE = "retries.content.enable";
    private static final String KEY_RETRIES_CONTENT_LENGTH = "retries.content.lenght";
    private static final String FILE_CIMCLIENT_PROPERTIES = "cimclient.properties";
    private static final String FILE_DEFAULT_PROPERTIES = "cim.defaults";
    private static final String LINUX_SBLIM_CIM_CLIENT_PROPERTIES = "/etc/java/sblim-cim-client.properties";
    private static final int DEFAULT_HTTP_TIME_OUT = 0;
    private static final int DEFAULT_HTTP_CONNECTION_POOL_SIZE = 16;
    private static final String DEFAULT_TRUSTSTORE = "truststore";
    private static final char[] DEFAULT_TRUSTSTORE_PASSWORD = null;
    private static final String DEFAULT_KEYSTORE = "keystore";
    private static final String DEFAULT_KEYSTORE_TYPE = "JKS";
    private static final char[] DEFAULT_KEYSTORE_PASSWORD = null;
    private static final String DEFAULT_JSSE_PROVIDER = "com.ibm.jsse.IBMJSSEProvider";
    private static final String DEFAULT_JSSE_CERTIFICATE = "IbmX509";
    private static final int DEFAULT_XML_PARSER = 0;
    private static final boolean DEFAULT_DEBUG_HTTP_POOL = false;
    private static final boolean DEFAULT_DEBUG_ISTREAM = false;
    private static final String DEFAULT_DEBUG_ISTREAM_OUTPUT = "stdout";
    private static final boolean DEFAULT_DEBUG_XML_INPUT = false;
    private static final boolean DEFAULT_DEBUG_XML_OUTPUT = false;
    private static final boolean DEFAULT_LOGGER = false;
    private static final String DEFAULT_LOGGER_NAMESPACE = "org.sblim.wbem.cimclient";
    private static final String DEFAULT_LOGGER_OUTPUT = "cimclient.log";
    private static final Level DEFAULT_LOGGER_CONSOLE_LEVEL = Level.WARNING;
    private static final Level DEFAULT_LOGGER_FILE_LEVEL = Level.WARNING;
    private static final boolean DEFAULT_CREDENTIALS_DEFAULT_ENABLED = false;
    private static final String DEFAULT_PRINCIPAL_VALUE = "default";
    private static final String DEFAULT_CREDENTIALS_VALUE = "default";
    private static final int DEFAULT_RETRIES_NUMBER = 1;
    private static final boolean DEFAULT_RETRIES_CONTENT_ENABLE = false;
    private static final int DEFAULT_RETRIES_CONTENT_LENGTH = 50;
    private static final String DEFAULT_AUTHENTICATION = WWW_AUTHENTICATION;
    private int value_httpTimeOut;
    private int value_connectionPoolSize;
    private String value_truststore;
    private char[] value_truststore_password;
    private String value_keystore;
    private String value_keystore_type;
    private char[] value_keystore_password;
    private String value_jsseProvider;
    private String value_jsseCertificate;
    private int value_xmlParser;
    private boolean value_debugHttpPool;
    private boolean value_debugInputStream;
    private OutputStream value_debugInputStreamOutput;
    private boolean value_debugXMLInput;
    private boolean value_debugXMLOutput;
    private boolean value_credentialsDefaultEnabled;
    private String value_defaultPrincipal;
    private String value_defaultCredentials;
    private int value_retries_number;
    private boolean value_retries_content_enable;
    private int value_retries_content_length;
    private String value_http_authentication;
    private boolean isGlobal = false;
    private String propertyFile = null;
    private SocketFactory value_socketFactory = null;
    private static boolean value_logger_enabled;
    private static String value_loggerNameSpace;
    private static String value_loggerOutputFile;
    private static Level value_loggerFileLevel;
    private static Level value_loggerConsoleLevel;
    private static Logger logger;
    private static FileHandler fileHandler;
    private static ConsoleHandler consoleHandler;
    private static SessionProperties globalProperties;
    private static final HashMap defaultPropertyMap;
    static /* synthetic */ Class class$org$sblim$wbem$http$WwwAuthInfo;
    static /* synthetic */ Class class$org$sblim$wbem$http$PegasusLocalAuthInfo;

    private static void setDefault(String pKey, Object pValue) {
        defaultPropertyMap.put(pKey, pValue.toString());
    }

    private static void setDefault(String pKey, int pValue) {
        defaultPropertyMap.put(pKey, String.valueOf(pValue));
    }

    private static void setDefault(String pKey, boolean pValue) {
        defaultPropertyMap.put(pKey, String.valueOf(pValue));
    }

    private static String detectDefaultJsseProvider() {
        Provider[] providers = Security.getProviders("SSLContext.SSL");
        if (providers.length > 0) {
            return providers[0].getClass().getName();
        }
        return DEFAULT_JSSE_PROVIDER;
    }

    private static String detectDefaultJsseCertificate() {
        String certificate = Security.getProperty("ssl.KeyManagerFactory.algorithm");
        return certificate != null ? certificate : DEFAULT_JSSE_CERTIFICATE;
    }

    public static SessionProperties getGlobalProperties() {
        return globalProperties;
    }

    public static SessionProperties getLibraryDefaults() {
        SessionProperties result = new SessionProperties();
        return result;
    }

    public static SessionProperties getEnvironmentDefaults() {
        SessionProperties result = new SessionProperties();
        result.loadProperties();
        return result;
    }

    public SessionProperties() {
        this.defaults = new Properties();
        this.defaults.putAll((Map<?, ?>)defaultPropertyMap);
    }

    private void setProperties() {
        this.value_httpTimeOut = this.getIntProperty(KEY_HTTP_TIME_OUT, 0);
        if (this.value_httpTimeOut < 0) {
            if (logger != null && logger.isLoggable(Level.WARNING)) {
                logger.log(Level.WARNING, "The value for the key http.timeout is outside of the range. Using its default value.");
            } else {
                System.err.println("The value for the key http.timeout is outside of the range. Using its default value.");
            }
            this.value_httpTimeOut = 0;
        }
        this.value_connectionPoolSize = this.getIntProperty(KEY_HTTP_CONNECTION_POOL_SIZE, 16);
        if (this.value_connectionPoolSize < -1) {
            if (logger != null && logger.isLoggable(Level.WARNING)) {
                logger.log(Level.WARNING, "The value for the key http.pool.size is outside of the range. Using its default value.");
            } else {
                System.err.println("The value for the key http.pool.size is outside of the range. Using its default value.");
            }
            this.value_connectionPoolSize = 16;
        }
        this.value_truststore = this.getStringProperty(KEY_TRUSTSTORE, DEFAULT_TRUSTSTORE);
        String truststorePass = this.getStringProperty(KEY_TRUSTSTORE_PASSWORD, DEFAULT_TRUSTSTORE_PASSWORD != null ? DEFAULT_TRUSTSTORE_PASSWORD.toString() : null);
        if (truststorePass != null) {
            this.value_truststore_password = truststorePass.toCharArray();
        }
        this.value_keystore = this.getStringProperty(KEY_KEYSTORE, DEFAULT_KEYSTORE);
        this.value_keystore_type = this.getStringProperty(KEY_KEYSTORE_TYPE, DEFAULT_KEYSTORE_TYPE);
        String keystorePass = this.getStringProperty(KEY_KEYSTORE_PASSWORD, DEFAULT_KEYSTORE_PASSWORD != null ? DEFAULT_KEYSTORE_PASSWORD.toString() : null);
        if (keystorePass != null) {
            this.value_keystore_password = keystorePass.toCharArray();
        }
        this.value_jsseProvider = this.getStringProperty(KEY_JSSE_PROVIDER, SessionProperties.detectDefaultJsseProvider());
        this.value_jsseCertificate = this.getStringProperty(KEY_JSSE_CERTIFICATE, SessionProperties.detectDefaultJsseCertificate());
        this.value_xmlParser = this.getIntProperty(KEY_XML_PARSER, 0);
        if (this.value_xmlParser < 0 || this.value_xmlParser > 2) {
            if (logger != null && logger.isLoggable(Level.WARNING)) {
                logger.log(Level.WARNING, "The value for the key xml.parser is outside of the range. Using its default value.");
            } else {
                System.err.println("The value for the key xml.parser is outside of the range. Using its default value.");
            }
            this.value_xmlParser = 0;
        }
        this.value_debugHttpPool = this.getBooleanProperty(KEY_DEBUG_HTTP_POOL, false);
        this.value_debugInputStream = this.getBooleanProperty(KEY_DEBUG_ISTREAM, false);
        String dbgIStreamOutputStream = this.getStringProperty(KEY_DEBUG_ISTREAM_OUTPUT, DEFAULT_DEBUG_ISTREAM_OUTPUT);
        if (DEFAULT_DEBUG_ISTREAM_OUTPUT.equalsIgnoreCase(dbgIStreamOutputStream)) {
            this.value_debugInputStreamOutput = System.out;
        } else if ("stderr".equalsIgnoreCase(dbgIStreamOutputStream)) {
            this.value_debugInputStreamOutput = System.err;
        } else {
            try {
                this.value_debugInputStreamOutput = new FileOutputStream(new File(dbgIStreamOutputStream));
            }
            catch (IOException e) {
                this.value_debugInputStreamOutput = System.out;
            }
        }
        this.value_debugXMLInput = this.getBooleanProperty(KEY_DEBUG_XML_INPUT, false);
        this.value_debugXMLOutput = this.getBooleanProperty(KEY_DEBUG_XML_OUTPUT, false);
        this.value_credentialsDefaultEnabled = this.getBooleanProperty(KEY_CREDENTIALS_DEFAULT_ENABLED, false);
        this.value_defaultPrincipal = this.getStringProperty(KEY_DEFAULT_PRINCIPAL, "default");
        this.value_defaultCredentials = this.getStringProperty(KEY_DEFAULT_CREDENTIAL, "default");
        this.value_retries_number = this.getIntProperty(KEY_RETRIES_NUMBER, 1);
        this.value_retries_content_enable = this.getBooleanProperty(KEY_RETRIES_CONTENT_ENABLE, false);
        this.value_retries_content_length = this.getIntProperty(KEY_RETRIES_CONTENT_LENGTH, 50);
        this.value_http_authentication = this.getStringProperty(KEY_AUTHENTICATION, DEFAULT_AUTHENTICATION);
    }

    private void setGlobalProperties() {
        value_logger_enabled = this.getBooleanProperty(KEY_LOGGER, false);
        value_loggerNameSpace = this.getStringProperty(KEY_LOGGER_NAMESPACE, DEFAULT_LOGGER_NAMESPACE);
        value_loggerOutputFile = this.getStringProperty(KEY_LOGGER_OUTPUT, DEFAULT_LOGGER_OUTPUT);
        value_loggerConsoleLevel = this.getLevelProperty(KEY_LOGGER_CONSOLE_LEVEL, DEFAULT_LOGGER_CONSOLE_LEVEL);
        value_loggerFileLevel = this.getLevelProperty(KEY_LOGGER_FILE_LEVEL, DEFAULT_LOGGER_FILE_LEVEL);
        try {
            logger = Logger.getLogger(this.getLoggerNameSpace());
            this.setUpLoggingFramework();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Enumeration<?> properties = super.propertyNames();
        while (properties.hasMoreElements()) {
            String name = (String)properties.nextElement();
            if (!name.startsWith("net.slp.")) continue;
            System.setProperty(name, super.getProperty(name));
        }
    }

    private void setUpLoggingFramework() {
        logger.setUseParentHandlers(false);
        if (this.isLoggingEnabled()) {
            if (consoleHandler == null) {
                consoleHandler = new ConsoleHandler();
                logger.addHandler(consoleHandler);
            }
            consoleHandler.setLevel(this.getLoggerConsoleLevel());
            logger.setLevel(Level.ALL);
            if (!value_loggerFileLevel.equals(Level.OFF)) {
                try {
                    if (fileHandler == null) {
                        fileHandler = new FileHandler(this.getLoggerOutputFile());
                        logger.addHandler(fileHandler);
                    }
                    fileHandler.setLevel(this.getLoggerFileLevel());
                }
                catch (Exception e) {
                    logger.log(Level.INFO, "Logging into file " + value_loggerOutputFile + "could not be exhausted.");
                }
            }
        } else {
            Handler[] handlers = logger.getHandlers();
            for (int i = 0; i < handlers.length; ++i) {
                handlers[i].setLevel(Level.OFF);
            }
            logger.setLevel(Level.OFF);
        }
    }

    public String getStringProperty(String key, String defaultValue) {
        return this.getProperty(key, defaultValue);
    }

    public int getIntProperty(String key, int defaultValue) {
        int value;
        block2: {
            value = defaultValue;
            String property = this.getProperty(key, Integer.toString(defaultValue));
            try {
                value = Integer.parseInt(property);
            }
            catch (Exception e) {
                if (logger == null || !logger.isLoggable(Level.WARNING)) break block2;
                logger.log(Level.WARNING, "Unable to parse value of property " + key + ". Using default value " + defaultValue, e);
            }
        }
        return value;
    }

    public boolean getBooleanProperty(String key, boolean defaultValue) {
        String property = this.getProperty(key, Boolean.toString(defaultValue));
        if (property.equalsIgnoreCase("true") || property.equalsIgnoreCase("yes") || property.equalsIgnoreCase("on")) {
            return true;
        }
        if (property.equalsIgnoreCase("false") || property.equalsIgnoreCase("no") || property.equalsIgnoreCase("off")) {
            return false;
        }
        if (logger != null && logger.isLoggable(Level.WARNING)) {
            logger.log(Level.WARNING, "Unable to parse value of property " + key + ". Using default value " + defaultValue);
        }
        return defaultValue;
    }

    public Level getLevelProperty(String key, Level defaultValue) {
        String property = this.getProperty(key, defaultValue.getName());
        if (property == null || property.trim().length() == 0) {
            return defaultValue;
        }
        if (property.equalsIgnoreCase(Level.OFF.getName())) {
            return Level.OFF;
        }
        if (property.equalsIgnoreCase(Level.SEVERE.getName())) {
            return Level.SEVERE;
        }
        if (property.equalsIgnoreCase(Level.WARNING.getName())) {
            return Level.WARNING;
        }
        if (property.equalsIgnoreCase(Level.INFO.getName())) {
            return Level.INFO;
        }
        if (property.equalsIgnoreCase(Level.CONFIG.getName())) {
            return Level.CONFIG;
        }
        if (property.equalsIgnoreCase(Level.FINE.getName())) {
            return Level.FINE;
        }
        if (property.equalsIgnoreCase(Level.FINER.getName())) {
            return Level.FINER;
        }
        if (property.equalsIgnoreCase(Level.FINEST.getName())) {
            return Level.FINEST;
        }
        if (property.equalsIgnoreCase(Level.ALL.getName())) {
            return Level.ALL;
        }
        if (logger != null && logger.isLoggable(Level.WARNING)) {
            logger.log(Level.WARNING, "Unable to parse value of property " + key + ". Using default value " + defaultValue);
        }
        return defaultValue;
    }

    public OutputStream getDebugOutputStream() {
        return this.value_debugInputStreamOutput;
    }

    public void setDebugOutputStream(OutputStream outputStream) {
        this.setProperty(KEY_DEBUG_ISTREAM_OUTPUT, outputStream.toString());
        this.value_debugInputStreamOutput = outputStream;
    }

    public String getKeystore() {
        return this.value_keystore;
    }

    public void setKeystore(String keystore) {
        this.setProperty(KEY_KEYSTORE, keystore);
        this.value_keystore = keystore;
    }

    public String getKeystoreType() {
        return this.value_keystore_type;
    }

    public void setKeystoreType(String type) {
        this.setProperty(KEY_KEYSTORE_TYPE, type);
        this.value_keystore_type = type;
    }

    public String getTruststore() {
        return this.value_truststore;
    }

    public void setTruststore(String truststore) {
        this.setProperty(KEY_TRUSTSTORE, truststore);
        this.value_truststore = truststore;
    }

    public String getTruststore_password() {
        if (this.value_truststore_password != null) {
            return new String(this.value_truststore_password);
        }
        return null;
    }

    public char[] getTruststorePassword() {
        if (this.value_truststore_password != null) {
            return (char[])this.value_truststore_password.clone();
        }
        return null;
    }

    public void setTruststore_password(String newPassword) {
        this.setProperty(KEY_TRUSTSTORE_PASSWORD, newPassword);
        if (newPassword != null) {
            if (this.value_truststore_password != null) {
                for (int i = 0; i < this.value_truststore_password.length; ++i) {
                    this.value_truststore_password[i] = '\u0000';
                }
            }
            this.value_truststore_password = newPassword.toCharArray();
        } else {
            if (this.value_truststore_password != null) {
                for (int i = 0; i < this.value_truststore_password.length; ++i) {
                    this.value_truststore_password[i] = '\u0000';
                }
            }
            this.value_truststore_password = null;
        }
    }

    public void setTruststore_password(char[] newPassword) {
        int i;
        this.setProperty(KEY_TRUSTSTORE_PASSWORD, newPassword.toString());
        if (this.value_truststore_password != null) {
            for (i = 0; i < this.value_truststore_password.length; ++i) {
                this.value_truststore_password[i] = '\u0000';
            }
        }
        if (newPassword != null) {
            this.value_truststore_password = new char[newPassword.length];
            for (i = 0; i < this.value_truststore_password.length; ++i) {
                this.value_truststore_password[i] = newPassword[i];
            }
        } else {
            this.value_truststore_password = newPassword;
        }
    }

    public char[] getKeystorePassword() {
        if (this.value_keystore_password != null) {
            return (char[])this.value_keystore_password.clone();
        }
        return null;
    }

    public void setKeystore_password(char[] newPassword) {
        int i;
        this.setProperty(KEY_KEYSTORE_PASSWORD, newPassword.toString());
        if (this.value_keystore_password != null) {
            for (i = 0; i < this.value_keystore_password.length; ++i) {
                this.value_keystore_password[i] = '\u0000';
            }
        }
        if (newPassword != null) {
            this.value_keystore_password = new char[newPassword.length];
            for (i = 0; i < this.value_keystore_password.length; ++i) {
                this.value_keystore_password[i] = newPassword[i];
            }
        } else {
            this.value_keystore_password = newPassword;
        }
    }

    public int getXmlParser() {
        return this.value_xmlParser;
    }

    public void setXmlParser(int parsingMode) {
        if (parsingMode < 0 || parsingMode > 2) {
            throw new IllegalArgumentException("invalid time out value: " + parsingMode);
        }
        this.setProperty(KEY_XML_PARSER, Integer.toString(parsingMode));
        this.value_xmlParser = parsingMode;
    }

    public int getHttpTimeOut() {
        return this.value_httpTimeOut;
    }

    public void setHttpTimeOut(int timeOut) {
        if (timeOut < 0) {
            throw new IllegalArgumentException("invalid time out value: " + timeOut);
        }
        this.setProperty(KEY_HTTP_TIME_OUT, Integer.toString(timeOut));
        this.value_httpTimeOut = timeOut;
    }

    public boolean isDebugXMLInput() {
        return this.value_debugXMLInput;
    }

    public void setDebugXMLInput(boolean enableDebugXMLInput) {
        this.setProperty(KEY_DEBUG_XML_INPUT, Boolean.toString(enableDebugXMLInput));
        this.value_debugXMLInput = enableDebugXMLInput;
    }

    public boolean isDebugXMLOutput() {
        return this.value_debugXMLOutput;
    }

    public void setDebugXMLOutput(boolean enableDebugXMLOutput) {
        this.setProperty(KEY_DEBUG_XML_OUTPUT, Boolean.toString(enableDebugXMLOutput));
        this.value_debugXMLOutput = enableDebugXMLOutput;
    }

    public boolean isDebugInputStream() {
        return this.value_debugInputStream;
    }

    public void setDebugInputStream(boolean enableDebugInputStream) {
        this.setProperty(KEY_DEBUG_ISTREAM, Boolean.toString(enableDebugInputStream));
        this.value_debugInputStream = enableDebugInputStream;
    }

    public int getConnectionPoolSize() {
        return this.value_connectionPoolSize;
    }

    public void setConnectionPoolSize(int poolSize) {
        if (poolSize < -1) {
            throw new IllegalArgumentException("invalid poolSize value: " + poolSize);
        }
        this.setProperty(KEY_HTTP_CONNECTION_POOL_SIZE, Integer.toString(poolSize));
        this.value_connectionPoolSize = poolSize;
    }

    public boolean isDebugHttpConnectionPool() {
        return this.value_debugHttpPool;
    }

    public void setDebugHttpConnectionPool(boolean enableDebugHTTPPool) {
        this.setProperty(KEY_DEBUG_HTTP_POOL, Boolean.toString(enableDebugHTTPPool));
        this.value_debugHttpPool = enableDebugHTTPPool;
    }

    public String getJSSEProvider() {
        return this.value_jsseProvider;
    }

    public void setJSSEProvider(String providerClassName) {
        this.setProperty(KEY_JSSE_PROVIDER, providerClassName);
        this.value_jsseProvider = providerClassName;
    }

    public SocketFactory getSocketFactory() {
        return this.value_socketFactory;
    }

    public void setSocketFactory(SocketFactory factory) {
        this.value_socketFactory = factory;
    }

    public String getJSSECertificate() {
        return this.value_jsseCertificate;
    }

    public void setJSSECertificate(String jsseCertificateMgr) {
        this.setProperty(KEY_JSSE_CERTIFICATE, jsseCertificateMgr);
        this.value_jsseCertificate = jsseCertificateMgr;
    }

    public Logger getLogger() {
        return logger;
    }

    public void setLogger(Logger newLogger) {
        if (!this.isGlobal()) {
            throw new IllegalStateException("Logger settings can be changed via the global properties instance only.");
        }
        this.setProperty(KEY_LOGGER_NAMESPACE, logger.getName());
        this.setProperty(KEY_LOGGER, logger.getLevel().intValue() < Level.OFF.intValue() ? Boolean.toString(true) : Boolean.toString(false));
        logger = newLogger;
    }

    public boolean isLoggingEnabled() {
        return value_logger_enabled;
    }

    public void setLoggingEnabled(boolean enableLogging) {
        if (!this.isGlobal()) {
            throw new IllegalStateException("Logger settings can be changed via the global properties instance only.");
        }
        this.setProperty(KEY_LOGGER, Boolean.toString(enableLogging));
        value_logger_enabled = enableLogging;
        this.setUpLoggingFramework();
    }

    public Level getLoggerConsoleLevel() {
        return value_loggerConsoleLevel;
    }

    public void setLoggerConsoleLevel(Level loggerConsoleLevel) {
        if (!this.isGlobal()) {
            throw new IllegalStateException("Logger settings can be changed via the global properties instance only.");
        }
        this.setProperty(KEY_LOGGER_CONSOLE_LEVEL, loggerConsoleLevel.getName());
        value_loggerConsoleLevel = loggerConsoleLevel;
        this.setUpLoggingFramework();
    }

    public Level getLoggerFileLevel() {
        return value_loggerFileLevel;
    }

    public void setLoggerFileLevel(Level loggerFileLevel) {
        if (!this.isGlobal()) {
            throw new IllegalStateException("Logger settings can be changed via the global properties instance only.");
        }
        this.setProperty(KEY_LOGGER_FILE_LEVEL, loggerFileLevel.getName());
        value_loggerFileLevel = loggerFileLevel;
        this.setUpLoggingFramework();
    }

    public String getLoggerNameSpace() {
        return value_loggerNameSpace;
    }

    public void setLoggerNameSpace(String loggerNameSpace) {
        if (!this.isGlobal()) {
            throw new IllegalStateException("Logger settings can be changed via the global properties instance only.");
        }
        this.setProperty(KEY_LOGGER_NAMESPACE, logger.getName());
        value_loggerNameSpace = loggerNameSpace;
        logger.removeHandler(consoleHandler);
        logger.removeHandler(fileHandler);
        consoleHandler = null;
        fileHandler = null;
        logger = Logger.getLogger(value_loggerNameSpace);
        this.setUpLoggingFramework();
    }

    public String getLoggerOutputFile() {
        return value_loggerOutputFile;
    }

    public void setLoggerOutputFile(String loggerOutputFile) {
        if (!this.isGlobal()) {
            throw new IllegalStateException("Logger settings can be changed via the global properties instance only.");
        }
        this.setProperty(KEY_LOGGER_OUTPUT, loggerOutputFile);
        value_loggerOutputFile = loggerOutputFile;
        logger.removeHandler(fileHandler);
        fileHandler = null;
        this.setUpLoggingFramework();
    }

    public boolean isCredentialsDefaultEnabled() {
        return this.value_credentialsDefaultEnabled;
    }

    public void setCredentialsDefaultEnabled(boolean credentialsDefaultEnabled) {
        this.setProperty(KEY_CREDENTIALS_DEFAULT_ENABLED, Boolean.toString(credentialsDefaultEnabled));
        this.value_credentialsDefaultEnabled = credentialsDefaultEnabled;
    }

    public String getDefaultCredentials() {
        return this.value_defaultCredentials;
    }

    public void setDefaultCredentials(String credentialsPassword) {
        this.setProperty(KEY_DEFAULT_CREDENTIAL, credentialsPassword);
        this.value_defaultCredentials = credentialsPassword;
    }

    public String getDefaultPrincipal() {
        return this.value_defaultPrincipal;
    }

    public void setDefaultPrincipal(String credentialsUser) {
        this.setProperty(KEY_DEFAULT_PRINCIPAL, credentialsUser);
        this.value_defaultPrincipal = credentialsUser;
    }

    public int getRetriesNumber() {
        return this.value_retries_number;
    }

    public void setRetriesNumber(int retries) {
        this.setProperty(KEY_RETRIES_NUMBER, Integer.toString(retries));
        this.value_retries_number = retries;
    }

    public boolean isContentLengthRetryEnabled() {
        return this.value_retries_content_enable;
    }

    public void setContentLengthRetry(boolean enableContentCheck) {
        this.setProperty(KEY_RETRIES_CONTENT_ENABLE, Boolean.toString(enableContentCheck));
        this.value_retries_content_enable = enableContentCheck;
    }

    public int getContentLength() {
        return this.value_retries_content_length;
    }

    public void setContentLength(int contentLength) {
        this.setProperty(KEY_RETRIES_CONTENT_LENGTH, Integer.toString(contentLength));
        this.value_retries_content_length = contentLength;
    }

    public String getHttpAuthenticationModule() {
        return this.value_http_authentication;
    }

    public void setHttpAuthenticationModule(String pAuthenticationModule) {
        this.setProperty(KEY_AUTHENTICATION, pAuthenticationModule);
        this.value_http_authentication = pAuthenticationModule;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadProperties(Properties properties) {
        block6: {
            try {
                if (properties != null) {
                    Enumeration<Object> keyEnumeration = properties.keys();
                    while (keyEnumeration.hasMoreElements()) {
                        Object keyProperty = keyEnumeration.nextElement();
                        if (this.containsKey(keyProperty)) {
                            this.setProperty(keyProperty.toString(), properties.getProperty(keyProperty.toString()));
                            continue;
                        }
                        this.put(keyProperty.toString(), properties.getProperty(keyProperty.toString()));
                    }
                    break block6;
                }
                throw new IllegalArgumentException("null argument");
            }
            finally {
                this.setProperties();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadProperties() {
        File file;
        if (System.getProperty("os.name").equalsIgnoreCase("Linux")) {
            try {
                file = new File(LINUX_SBLIM_CIM_CLIENT_PROPERTIES).getAbsoluteFile();
                if (file.exists()) {
                    this.load(new FileInputStream(file));
                    this.propertyFile = LINUX_SBLIM_CIM_CLIENT_PROPERTIES;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        file = new File(FILE_DEFAULT_PROPERTIES).getAbsoluteFile();
        try {
            if (file.exists()) {
                this.load(new FileInputStream(file));
                this.propertyFile = FILE_DEFAULT_PROPERTIES;
                boolean bl = true;
                return bl;
            }
            file = new File(FILE_CIMCLIENT_PROPERTIES).getAbsoluteFile();
            if (file.exists()) {
                this.load(new FileInputStream(file));
                this.propertyFile = FILE_CIMCLIENT_PROPERTIES;
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception e) {
            System.err.println("Failed to load file " + file.getName());
            e.printStackTrace();
        }
        finally {
            this.setProperties();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadProperties(String pPropertyFile) {
        try {
            File file = new File(pPropertyFile).getAbsoluteFile();
            if (file.exists()) {
                this.load(new FileInputStream(file));
                this.propertyFile = pPropertyFile;
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception e) {
            if (logger != null && logger.isLoggable(Level.WARNING)) {
                logger.log(Level.WARNING, "Failed to load file " + pPropertyFile);
            } else {
                System.err.println("Failed to load file " + pPropertyFile);
            }
        }
        finally {
            this.setProperties();
        }
        return false;
    }

    public synchronized Object clone() {
        SessionProperties clone = new SessionProperties();
        clone.setConnectionPoolSize(this.getConnectionPoolSize());
        clone.setContentLength(this.getContentLength());
        clone.setContentLengthRetry(this.isContentLengthRetryEnabled());
        clone.setCredentialsDefaultEnabled(this.isCredentialsDefaultEnabled());
        clone.setDebugHttpConnectionPool(this.isDebugHttpConnectionPool());
        clone.setDebugInputStream(this.isDebugInputStream());
        clone.setDebugOutputStream(this.getDebugOutputStream());
        clone.setDebugXMLInput(this.isDebugXMLInput());
        clone.setDebugXMLOutput(this.isDebugXMLOutput());
        clone.setDefaultCredentials(this.getDefaultCredentials());
        clone.setDefaultCredentials(this.getDefaultCredentials());
        clone.setHttpTimeOut(this.getHttpTimeOut());
        clone.setJSSECertificate(this.getJSSECertificate());
        clone.setJSSEProvider(this.getJSSEProvider());
        clone.setKeystore(this.getKeystore());
        clone.setKeystore_password(this.getKeystorePassword());
        clone.setRetriesNumber(this.getRetriesNumber());
        clone.setTruststore(this.getTruststore());
        clone.setTruststore_password(this.getTruststorePassword());
        clone.setXmlParser(this.getXmlParser());
        clone.setSocketFactory(this.getSocketFactory());
        clone.setHttpAuthenticationModule(this.getHttpAuthenticationModule());
        return clone;
    }

    public boolean isGlobal() {
        return this.isGlobal;
    }

    private void setGlobal(boolean pIsGlobal) {
        this.isGlobal = pIsGlobal;
        this.setGlobalProperties();
    }

    public String getPropertyFile() {
        return this.propertyFile;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        defaultPropertyMap = new HashMap();
        SessionProperties.setDefault(KEY_HTTP_TIME_OUT, 0);
        SessionProperties.setDefault(KEY_HTTP_CONNECTION_POOL_SIZE, 16);
        SessionProperties.setDefault(KEY_TRUSTSTORE, DEFAULT_TRUSTSTORE);
        SessionProperties.setDefault(KEY_TRUSTSTORE_PASSWORD, DEFAULT_TRUSTSTORE_PASSWORD != null ? DEFAULT_TRUSTSTORE_PASSWORD.toString() : "");
        SessionProperties.setDefault(KEY_KEYSTORE, DEFAULT_KEYSTORE);
        SessionProperties.setDefault(KEY_KEYSTORE_TYPE, DEFAULT_KEYSTORE_TYPE);
        SessionProperties.setDefault(KEY_KEYSTORE_PASSWORD, DEFAULT_KEYSTORE_PASSWORD != null ? DEFAULT_KEYSTORE_PASSWORD.toString() : "");
        SessionProperties.setDefault(KEY_JSSE_PROVIDER, SessionProperties.detectDefaultJsseProvider());
        SessionProperties.setDefault(KEY_JSSE_CERTIFICATE, SessionProperties.detectDefaultJsseCertificate());
        SessionProperties.setDefault(KEY_XML_PARSER, 0);
        SessionProperties.setDefault(KEY_DEBUG_HTTP_POOL, false);
        SessionProperties.setDefault(KEY_DEBUG_ISTREAM, false);
        SessionProperties.setDefault(KEY_DEBUG_ISTREAM_OUTPUT, DEFAULT_DEBUG_ISTREAM_OUTPUT);
        SessionProperties.setDefault(KEY_DEBUG_XML_INPUT, false);
        SessionProperties.setDefault(KEY_DEBUG_XML_OUTPUT, false);
        SessionProperties.setDefault(KEY_LOGGER, false);
        SessionProperties.setDefault(KEY_LOGGER_NAMESPACE, DEFAULT_LOGGER_NAMESPACE);
        SessionProperties.setDefault(KEY_LOGGER_OUTPUT, DEFAULT_LOGGER_OUTPUT);
        SessionProperties.setDefault(KEY_LOGGER_CONSOLE_LEVEL, DEFAULT_LOGGER_CONSOLE_LEVEL.toString());
        SessionProperties.setDefault(KEY_LOGGER_FILE_LEVEL, DEFAULT_LOGGER_FILE_LEVEL.toString());
        SessionProperties.setDefault(KEY_CREDENTIALS_DEFAULT_ENABLED, false);
        SessionProperties.setDefault(KEY_DEFAULT_PRINCIPAL, "default");
        SessionProperties.setDefault(KEY_DEFAULT_CREDENTIAL, "default");
        SessionProperties.setDefault(KEY_RETRIES_NUMBER, 1);
        SessionProperties.setDefault(KEY_RETRIES_CONTENT_ENABLE, false);
        SessionProperties.setDefault(KEY_RETRIES_CONTENT_LENGTH, 50);
        SessionProperties.setDefault(KEY_AUTHENTICATION, DEFAULT_AUTHENTICATION);
        globalProperties = SessionProperties.getEnvironmentDefaults();
        globalProperties.setGlobal(true);
    }
}

