/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.simulator.cimom.common.base;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.aperi.simulator.cimom.common.CIMOM;

public abstract class BaseMOFGenerator {
    protected static final String PROVIDER_QUALIFIER_STRING = "Provider";
    protected static final String PROVIDER_NAME_QUALIFIER_STRING = "ProviderName";
    protected static final String SIMULATOR_PROVIDER = "java:org.eclipse.aperi.simulator.cimom.sunwbem.provider.Provider";
    protected static final String ASSOCIATION_QUALIFIER_NAME = "ASSOCIATION ( true ),";
    protected static final String PROVIDER_QUALIFIER_NAME = "Provider ( \"java:org.eclipse.aperi.simulator.cimom.sunwbem.provider.Provider\" ),";
    protected static final String DATETIME_DATATYPE_STRING = "datetime";
    protected CIMOM cimom;
    private BufferedWriter writer;
    protected boolean isOnlyLeaf = false;

    public BaseMOFGenerator(CIMOM cimom) {
        this.cimom = cimom;
        this.initialize();
    }

    protected void initialize() {
        String url = this.cimom.getServiceURL();
        String user = this.cimom.getUserID();
        String password = this.cimom.getPassword();
        String namespace = this.cimom.getNamespace();
        this.createCIMClient(url, user, password, namespace);
    }

    protected abstract void createCIMClient(String var1, String var2, String var3, String var4);

    public void generateMOFData(String filePath) throws Exception {
        ArrayList<String> namespaces = new ArrayList<String>();
        namespaces.add(this.cimom.getNamespace());
        this.generateData(filePath, namespaces);
    }

    public abstract void generateDataForNameSpace(String var1, String var2) throws Exception;

    protected abstract void generateData(String var1, ArrayList var2) throws Exception;

    public boolean isOnlyLeaf() {
        return this.isOnlyLeaf;
    }

    public void setOnlyLeaf(boolean isOnlyLeaf) {
        this.isOnlyLeaf = isOnlyLeaf;
    }

    protected String createNewWriter(String namespace, String filePath) throws IOException {
        String fileName = this.getFileName(namespace);
        this.writer = new BufferedWriter(new FileWriter(filePath + File.separator + fileName));
        return fileName;
    }

    protected String removeBracketsWithNoQualifiers(String data) {
        if (data.startsWith("\t[]\n")) {
            String tempData;
            data = tempData = data.replace("\t[]\n", "");
        }
        return data;
    }

    protected String makeAssociationAsFirstQualifier(String data) {
        if (data.contains(ASSOCIATION_QUALIFIER_NAME) || data.contains("Association ( true )")) {
            String tempData = data.replace(ASSOCIATION_QUALIFIER_NAME, "");
            tempData = tempData.replace("Association ( true ),", "");
            String strAssociation = "[ASSOCIATION ( true ),";
            tempData = strAssociation.concat(tempData);
            data = tempData.replace(",[", ", ");
            data = data.replace(",\t[", ", ");
        }
        return data;
    }

    protected String makeProviderAsFirstQualifier(String data) {
        if (data.contains(PROVIDER_QUALIFIER_NAME)) {
            String tempData = data.replace(PROVIDER_QUALIFIER_NAME, "");
            String strProvider = "[Provider ( \"java:org.eclipse.aperi.simulator.cimom.sunwbem.provider.Provider\" ),";
            tempData = strProvider.concat(tempData);
            data = tempData.replace(",\t[", ", ");
        }
        return data;
    }

    protected void writeDataToFile(String data) throws IOException {
        data = this.removeBracketsWithNoQualifiers(data);
        data = this.makeProviderAsFirstQualifier(data);
        data = this.makeAssociationAsFirstQualifier(data);
        this.writer.newLine();
        this.writer.write(data);
        this.writer.newLine();
        this.writer.flush();
    }

    protected void closeFile() throws IOException {
        if (null != this.writer) {
            this.writer.flush();
            this.writer.close();
        }
        this.writer = null;
    }

    private String getFileName(String namespace) {
        StringBuffer fileName = new StringBuffer();
        String[] array = namespace.split("/");
        for (int i = 0; i < array.length; ++i) {
            if (array[i].trim().length() <= 0) continue;
            if (fileName.length() > 0) {
                fileName.append("_");
            }
            fileName.append(array[i]);
        }
        return fileName.toString() + ".mof";
    }
}

