/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.simulator.cimom.common.generator;

import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Vector;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMNameSpace;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.client.CIMClient;
import javax.wbem.client.PasswordCredential;
import javax.wbem.client.UserPrincipal;
import javax.xml.transform.TransformerException;
import org.eclipse.aperi.simulator.cimom.common.CIMOM;
import org.eclipse.aperi.simulator.cimom.common.base.BaseClassXMLBuilder;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class ClassXMLBuilder
extends BaseClassXMLBuilder {
    private CIMClient cimClient;

    public void parse(InputSource input) throws SAXException {
        if (null == this.handler) {
            System.out.println("The handler is null");
            System.exit(1);
        } else if (null == this.cimom) {
            System.out.println("The cimom object is null");
            System.exit(1);
        }
        this.initCimClient();
        this.handler.startDocument();
        this.addIndent(INDENT0);
        this.handler.startElement("", "SAN_Simulator", "SAN_Simulator", null);
        try {
            this.generateForNamespace(this.cimom.getNamespace());
        }
        catch (CIMException e) {
            e.printStackTrace();
        }
        this.addIndent(INDENT0);
        this.handler.endElement("", "SAN_Simulator", "SAN_Simulator");
        this.handler.endDocument();
    }

    private void generateForNamespace(String namespace) throws CIMException {
        CIMObjectPath path = new CIMObjectPath();
        Enumeration enumeration = this.cimClient.enumerateClasses(path, true, false, false, true);
        block2: while (enumeration.hasMoreElements()) {
            CIMClass cimClass = (CIMClass)enumeration.nextElement();
            String classNameToGetData = cimClass.getName();
            Iterator iter = this.cimom.getLeafClassNamePrefixes().iterator();
            while (iter.hasNext()) {
                if (!classNameToGetData.startsWith((String)iter.next())) continue;
                try {
                    this.generateForClass(cimClass, namespace);
                    continue block2;
                }
                catch (Exception e) {
                    System.err.println("Error in class : " + classNameToGetData);
                    e.printStackTrace();
                }
            }
        }
        this.cimClient.close();
    }

    private void generateForClass(CIMClass cimClass, String namespace) throws SAXException, CIMException {
        AttributesImpl attrs = new AttributesImpl();
        attrs.addAttribute("", "Name", "Name", "", cimClass.getName());
        attrs.addAttribute("", "Namespace", "Namespace", "", namespace);
        attrs.addAttribute("", "NOI", "NOI", "", "");
        if (this.isAssociation(cimClass)) {
            attrs.addAttribute("", "Association", "Association", "", "true");
            this.addIndent(INDENT1);
            this.handler.startElement("", "Class", "Class", attrs);
            this.generateAssociationClassData(cimClass.getName(), namespace);
        } else {
            this.addIndent(INDENT1);
            this.handler.startElement("", "Class", "Class", attrs);
            this.generateClassData(cimClass.getName());
        }
        this.addIndent(INDENT1);
        this.handler.endElement("", "Class", "Class");
    }

    private void generateClassData(String className) throws CIMException, SAXException {
        CIMObjectPath cimOP = new CIMObjectPath(className);
        Enumeration enumeration = this.cimClient.enumerateInstances(cimOP, true, false, false, true, null);
        System.out.println("Generated data for : " + className);
        if (enumeration.hasMoreElements()) {
            CIMInstance instance = (CIMInstance)enumeration.nextElement();
            Vector properties = instance.getProperties();
            Iterator iter = properties.iterator();
            while (iter.hasNext()) {
                CIMProperty property = (CIMProperty)iter.next();
                this.generatePropertyData(property);
            }
        }
    }

    private void generateAssociationClassData(String cimClassName, String namespace) throws SAXException, CIMException {
        CIMObjectPath cimOP = new CIMObjectPath(cimClassName);
        Enumeration enumeration = this.cimClient.enumerateInstances(cimOP, true, false, false, true, null);
        System.out.println("Generated data for : " + cimClassName);
        if (enumeration.hasMoreElements()) {
            CIMInstance instance = (CIMInstance)enumeration.nextElement();
            Vector properties = instance.getProperties();
            CIMProperty antecedent = (CIMProperty)properties.get(0);
            CIMProperty dependent = (CIMProperty)properties.get(1);
            AttributesImpl attrs = new AttributesImpl();
            attrs.addAttribute("", "Name", "Name", "", antecedent.getName());
            attrs.addAttribute("", "ClassName", "ClassName", "", antecedent.getType().getRefClassName());
            attrs.addAttribute("", "Namespace", "Namespace", "", namespace);
            if (antecedent.isKey()) {
                attrs.addAttribute("", "Key", "Key", "", "true");
            }
            this.addIndent(INDENT2);
            this.handler.startElement("", "Antecedent", "Antecedent", attrs);
            this.addIndent(INDENT2);
            this.handler.endElement("", "Antecedent", "Antecedent");
            attrs.clear();
            attrs.addAttribute("", "Name", "Name", "", dependent.getName());
            attrs.addAttribute("", "ClassName", "ClassName", "", dependent.getType().getRefClassName());
            attrs.addAttribute("", "Namespace", "Namespace", "", namespace);
            if (dependent.isKey()) {
                attrs.addAttribute("", "Key", "Key", "", "true");
            }
            this.addIndent(INDENT2);
            this.handler.startElement("", "Dependent", "Dependent", attrs);
            this.addIndent(INDENT2);
            this.handler.endElement("", "Dependent", "Dependent");
            for (int i = 2; i < properties.size(); ++i) {
                CIMProperty property = (CIMProperty)properties.get(i);
                this.generatePropertyData(property);
            }
        }
    }

    private void generatePropertyData(CIMProperty property) throws SAXException {
        AttributesImpl attrs = new AttributesImpl();
        attrs.addAttribute("", "Name", "Name", "", property.getName());
        String type = property.getType().isArrayType() ? property.getType().toString() + "[]" : property.getType().toString();
        attrs.addAttribute("", "Type", "Type", "", type);
        attrs.addAttribute("", "Random", "Random", "", "false");
        if (property.isKey()) {
            attrs.addAttribute("", "Key", "Key", "", "true");
        }
        this.addIndent(INDENT2);
        this.handler.startElement("", "Property", "Property", attrs);
        if (null != property.getValue()) {
            this.addIndent(INDENT3);
            this.handler.startElement("", "Value", "Value", null);
            char[] value = property.getValue().getValue().toString().toCharArray();
            this.handler.characters(value, 0, value.length);
            this.addIndent(INDENT3);
            this.handler.endElement("", "Value", "Value");
        }
        this.addIndent(INDENT2);
        this.handler.endElement("", "Property", "Property");
    }

    private boolean isAssociation(CIMClass cimClass) {
        Iterator iter = cimClass.getAllProperties().iterator();
        while (iter.hasNext()) {
            CIMProperty cimProperty = (CIMProperty)iter.next();
            if (!cimProperty.isReference()) continue;
            return true;
        }
        return false;
    }

    private void initCimClient() {
        try {
            String url = this.cimom.getServiceURL();
            String user = this.cimom.getUserID();
            String password = this.cimom.getPassword();
            String namespace = this.cimom.getNamespace();
            UserPrincipal principal = null;
            PasswordCredential credential = null;
            if (url != null && namespace != null) {
                try {
                    CIMNameSpace cimNamespace = new CIMNameSpace(url, namespace);
                    if (user != null) {
                        principal = new UserPrincipal(user);
                    }
                    if (password != null) {
                        credential = new PasswordCredential(password);
                    }
                    this.cimClient = new CIMClient(cimNamespace, (Principal)principal, (Object)credential);
                }
                catch (Exception e) {
                    System.out.println("Unable To Connect to CIMOM [" + url + "]" + e.getMessage());
                }
            } else {
                System.out.println("Given CIMOM URL AND/OR Namespace is NULL");
            }
            if (this.cimClient == null) {
                System.exit(-1);
            }
        }
        catch (Exception e) {
            System.out.println("Some error occured while creating cimom object");
            e.printStackTrace();
        }
    }

    public static void main(String[] args) throws IOException, TransformerException {
        ClassXMLBuilder builder = new ClassXMLBuilder();
        ArrayList<String> leafClasses = new ArrayList<String>();
        leafClasses.add("Brocade");
        CIMOM cimom = new CIMOM("9.182.193.140", "administrator", "san26pass", "/interop", "Switch", "Sun Java WBEM CIMOM", leafClasses);
        builder.generateXML(cimom, "Abc.xml");
    }
}

