/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.simulator.cimom.connection;

import java.security.Principal;
import java.util.Enumeration;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMNameSpace;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMValue;
import javax.wbem.client.CIMClient;
import javax.wbem.client.PasswordCredential;
import javax.wbem.client.UserPrincipal;
import org.eclipse.aperi.simulator.cimom.connection.ConnectionConfig;
import org.eclipse.aperi.simulator.cimom.connection.TargetConnection;

public class TargetCIMConnection
implements TargetConnection {
    private CIMClient cimClient;
    private String HostUrl;
    private String NameSpace;
    private String Protocol;
    private String UserName;
    private String PassWord;
    private String Port;
    private String deviceType;

    private void initArguments() {
        this.HostUrl = ConnectionConfig.getProperty("TARGET_DEVICE_CIMOM_URL");
        this.Port = ConnectionConfig.getProperty("TARGET_DEVICE_CIMOM_PORT");
        this.UserName = ConnectionConfig.getProperty("TARGET_DEVICE_CIMOM_USERNAME");
        this.PassWord = ConnectionConfig.getProperty("TARGET_DEVICE_CIMOM_PASSWORD");
        this.NameSpace = ConnectionConfig.getProperty("TARGET_DEVICE_CIMOM_NAMESPACE");
        this.Protocol = ConnectionConfig.getProperty("TARGET_DEVICE_CIMOM_PROTOCOL");
        this.connect(this.HostUrl, this.Port, this.NameSpace, this.PassWord, this.NameSpace, this.Protocol);
    }

    public void init() {
        this.initArguments();
        try {
            this.findDevicetype();
            this.connectToCIMClient();
        }
        catch (CIMException e) {
            e.printStackTrace();
        }
    }

    public void connect(String HostUrl, String Port, String UserName, String PassWord, String NameSpace, String Protocol) {
        UserPrincipal principal = null;
        PasswordCredential credential = null;
        try {
            if (HostUrl != null && NameSpace != null) {
                try {
                    CIMNameSpace cimNamespace = new CIMNameSpace(Protocol + "://" + HostUrl + ":" + Port, NameSpace);
                    if (UserName != null) {
                        principal = new UserPrincipal(UserName);
                    }
                    if (PassWord != null) {
                        credential = new PasswordCredential(PassWord);
                    }
                    this.cimClient = new CIMClient(cimNamespace, (Principal)principal, (Object)credential);
                    System.out.println("CIMOM connection successful");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    System.out.println("Unable To Connect to CIMOM [" + HostUrl + "]" + e.getMessage());
                }
            } else {
                System.out.println("Given CIMOM URL AND/OR Namespace is NULL");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public CIMValue getDeviceID(CIMValue destPort, String storageArrayName) throws CIMException {
        CIMObjectPath objectPath = new CIMObjectPath("CIM_FCPort");
        CIMInstance instance = null;
        boolean flag = false;
        Enumeration enum_inst = this.cimClient.enumerateInstances(objectPath, true, false, true);
        while (enum_inst.hasMoreElements()) {
            CIMValue portNo;
            instance = (CIMInstance)enum_inst.nextElement();
            CIMValue systemname = instance.getProperty("SystemName").getValue();
            if (!systemname.getValue().equals(storageArrayName) || !(portNo = instance.getProperty("PermanentAddress").getValue()).equals((Object)destPort)) continue;
            flag = true;
            break;
        }
        if (flag) {
            CIMValue deviceId = instance.getProperty("DeviceID").getValue();
            return deviceId;
        }
        return null;
    }

    private void connectToCIMClient() throws CIMException {
        this.cimClient.close();
        if (this.deviceType.equals("DS4K")) {
            this.connect(this.HostUrl, this.Port, this.NameSpace, this.PassWord, "/root/lsissi11", this.Protocol);
        } else {
            System.out.println("Host name: " + this.HostUrl);
            this.connect(this.HostUrl, this.Port, this.UserName, this.PassWord, "/root/ibm", this.Protocol);
        }
    }

    private void findDevicetype() throws CIMException {
        this.deviceType = ConnectionConfig.getProperty("STORAGE_DEVICE_CATEGORY");
    }
}

