/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.simulator.ui;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.logging.Logger;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMNameSpace;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMValue;
import javax.wbem.client.CIMClient;
import javax.wbem.client.PasswordCredential;
import javax.wbem.client.UserPrincipal;
import org.eclipse.aperi.simulator.cimom.common.DatabaseManager;
import org.eclipse.aperi.simulator.cimom.sunwbem.util.DiscoveryUtil;
import org.eclipse.aperi.simulator.ui.ConnectionUtility;

public class RemoteCIMClient {
    private static CIMClient cimClient;
    public static String deviceType;
    private static List sanPClassList;
    private static Logger logger;

    public static Vector getFreePortsForSelectedDevice() {
        Vector<String> freePorts = new Vector<String>();
        int dummyPortNo = 1;
        Iterator SANProtocolIterator = null;
        try {
            sanPClassList = DatabaseManager.getDbManager().enumerateInstances("/root/brocade1", "Brocade_SANProtocolEndPoint");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Iterator portIterator = RemoteCIMClient.getAllPortsForSelectedDevice().iterator();
        while (portIterator.hasNext()) {
            boolean isPortBusy = false;
            CIMInstance inst1 = (CIMInstance)portIterator.next();
            CIMValue otherFCDeviceId = inst1.getProperty("DeviceID").getValue();
            SANProtocolIterator = sanPClassList.iterator();
            while (SANProtocolIterator.hasNext()) {
                CIMInstance inst2 = (CIMInstance)SANProtocolIterator.next();
                CIMValue sanPName = inst2.getProperty("Name").getValue();
                if (!sanPName.equals((Object)otherFCDeviceId)) continue;
                isPortBusy = true;
                break;
            }
            if (isPortBusy) continue;
            CIMValue portNumber = inst1.getProperty("PortNumber").getValue();
            String portNo = portNumber != null ? portNumber.getValue().toString() : Integer.toString(dummyPortNo++);
            String portWWN = inst1.getProperty("PermanentAddress").getValue().getValue().toString();
            freePorts.add("" + portNo + " (" + portWWN + ")");
        }
        return freePorts;
    }

    public static void connect(String HostUrl, String Port, String UserName, String PassWord, String NameSpace, String Protocol) {
        UserPrincipal principal = null;
        PasswordCredential credential = null;
        try {
            if (HostUrl != null && NameSpace != null) {
                try {
                    CIMNameSpace cimNamespace = new CIMNameSpace(Protocol + "://" + HostUrl + ":" + Port, NameSpace);
                    if (UserName != null) {
                        principal = new UserPrincipal(UserName);
                    }
                    if (PassWord != null) {
                        credential = new PasswordCredential(PassWord);
                    }
                    cimClient = new CIMClient(cimNamespace, (Principal)principal, (Object)credential);
                    System.out.println("CIMOM connection successful");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    logger.severe("Unable To Connect to CIMOM [" + HostUrl + "]" + e.getMessage());
                }
            } else {
                logger.severe("Given CIMOM URL AND/OR Namespace is NULL");
            }
        }
        catch (Exception e) {
            logger.severe(e.getMessage() + e);
        }
    }

    public static void configureConnection() {
        try {
            RemoteCIMClient.findDevicetype();
            logger.info("Target Device Type Found: " + deviceType);
            ConnectionUtility.targetDevcieType = deviceType;
            RemoteCIMClient.changeCIMClient();
        }
        catch (CIMException e) {
            logger.severe(e.getMessage() + (Object)((Object)e));
        }
        logger.info("CIM Client changed");
    }

    private static void changeCIMClient() throws CIMException {
        cimClient.close();
        if (deviceType.equals("Switch")) {
            RemoteCIMClient.connect(ConnectionUtility.CIMOMHostUrl, ConnectionUtility.CIMOMPort, ConnectionUtility.CIMOMUserName, ConnectionUtility.CIMOMPassword, "/root/brocade1", ConnectionUtility.CIMOMProtocol);
        } else if (deviceType.equals("DS4K")) {
            RemoteCIMClient.connect(ConnectionUtility.CIMOMHostUrl, ConnectionUtility.CIMOMPort, ConnectionUtility.CIMOMUserName, ConnectionUtility.CIMOMPassword, "/root/lsissi11", ConnectionUtility.CIMOMProtocol);
        } else if (deviceType.equals("DS6K")) {
            RemoteCIMClient.connect(ConnectionUtility.CIMOMHostUrl, ConnectionUtility.CIMOMPort, ConnectionUtility.CIMOMUserName, ConnectionUtility.CIMOMPassword, "/root/ibm", ConnectionUtility.CIMOMProtocol);
        }
    }

    private static void findDevicetype() throws CIMException {
        ArrayList namespaces = new ArrayList();
        namespaces.add(ConnectionUtility.CIMOMNameSpace);
        try {
            namespaces = DiscoveryUtil.getNamespaces(cimClient, namespaces, "Array");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        deviceType = namespaces.contains("/root/brocade1") ? "Switch" : (namespaces.contains("/root/lsissi11") ? "DS4K" : (namespaces.contains("/root/ibm") ? "DS6K" : "Unknown"));
    }

    public static void closeConnection() {
        if (cimClient != null) {
            try {
                cimClient.close();
            }
            catch (CIMException e) {
                e.printStackTrace();
            }
        }
    }

    private static List getAllPortsForSelectedDevice() {
        Enumeration enumPortClass = null;
        Enumeration enumSystemClass = null;
        ArrayList<CIMInstance> allPortList = new ArrayList<CIMInstance>();
        try {
            CIMObjectPath fcPort = new CIMObjectPath("CIM_FCPort");
            enumPortClass = cimClient.enumerateInstances(fcPort, true, false, true);
            CIMObjectPath computerSystems = new CIMObjectPath("CIM_ComputerSystem");
            enumSystemClass = cimClient.enumerateInstances(computerSystems, true, false, true);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.severe("Error in enumerating ComputerSystem " + e);
        }
        while (enumSystemClass.hasMoreElements()) {
            CIMInstance systemInst = (CIMInstance)enumSystemClass.nextElement();
            CIMValue instDeviceName = systemInst.getProperty("Name").getValue();
            String deviceName = ConnectionUtility.deviceName.split("_")[1];
            if (!instDeviceName.getValue().toString().equalsIgnoreCase(deviceName)) continue;
            CIMValue name = systemInst.getProperty("Name").getValue();
            while (enumPortClass.hasMoreElements()) {
                CIMInstance fcPortInst = (CIMInstance)enumPortClass.nextElement();
                CIMValue systemName = fcPortInst.getProperty("SystemName").getValue();
                if (!name.equals((Object)systemName)) continue;
                allPortList.add(fcPortInst);
            }
            break block2;
        }
        return allPortList;
    }

    public static Vector enumerateTargetDevcieNames() {
        CIMObjectPath objectPath = null;
        Enumeration enumTargetSystem = null;
        Vector<String> deviceVector = new Vector<String>();
        objectPath = new CIMObjectPath("CIM_ComputerSystem");
        try {
            enumTargetSystem = cimClient.enumerateInstances(objectPath, true, false, true);
        }
        catch (CIMException e) {
            e.printStackTrace();
            logger.severe("Error in Enumerating Device Names: " + (Object)((Object)e));
        }
        while (enumTargetSystem.hasMoreElements()) {
            CIMInstance inst = (CIMInstance)enumTargetSystem.nextElement();
            CIMValue valDedicated = inst.getProperty("Dedicated").getValue();
            if (valDedicated == null) continue;
            String targetDeviceElementName = inst.getProperty("ElementName").getValue().getValue().toString();
            String targetDeviceName = inst.getProperty("Name").getValue().getValue().toString();
            targetDeviceElementName = "DS";
            deviceVector.add(targetDeviceElementName + "_" + targetDeviceName);
        }
        return deviceVector;
    }

    static {
        logger = Logger.getLogger(RemoteCIMClient.class.getName());
    }
}

