/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.simulator.ui;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.Logger;
import org.eclipse.aperi.simulator.cimom.common.GenericSnapshotmaker;
import org.eclipse.aperi.simulator.ui.SetupWizardUtility;

public class TakeSnapshot {
    private Logger logger = Logger.getLogger(TakeSnapshot.class.getName());

    public void ConfigureDBForSnapshot() {
        Properties properties = new Properties();
        properties.setProperty("DATABASE", "db2");
        properties.setProperty("DB_NAME", SetupWizardUtility.getProperty("DB_NAME"));
        properties.setProperty("DB_USER", SetupWizardUtility.getProperty("DB_USER_NAME"));
        properties.setProperty("DB_PASSWORD", SetupWizardUtility.getProperty("DB_PASSWORD"));
        properties.setProperty("DB_LOCATION", SetupWizardUtility.getProperty("DB_HOST_URL"));
        try {
            File temp = File.createTempFile("setupwizard", ".config");
            temp.deleteOnExit();
            properties.store(new FileOutputStream(temp), "SETUP WIZARD PROPERTIES");
            System.setProperty("SETUP_WIZARD_CONFIG_FILEPATH", temp.getAbsolutePath());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void startSnapshot() {
        try {
            String cimomUrl = SetupWizardUtility.getProperty("CIMOM_PROTOCOL") + "://" + SetupWizardUtility.getProperty("CIMOM_HOST_URL") + ":" + SetupWizardUtility.getProperty("CIMOM_PORT");
            String userId = SetupWizardUtility.getProperty("CIMOM_USER_ID");
            String passWd = SetupWizardUtility.getProperty("CIMOM_PASSWORD");
            String nameSpace = SetupWizardUtility.getProperty("CIMOM_NAMESPACE");
            System.out.println(cimomUrl + " " + userId + " " + passWd + " " + nameSpace);
            this.logger.info("CIMOM URL form for Snapshotting -> " + cimomUrl + " " + userId + " " + passWd + " " + nameSpace);
            GenericSnapshotmaker snapper = new GenericSnapshotmaker(cimomUrl, nameSpace, userId, passWd);
            snapper.startSnapshotMaker();
            long startTime = System.currentTimeMillis();
            long endTime = System.currentTimeMillis();
            this.logger.info("Time taken to snapshot this CIMOM = " + (endTime - startTime) / 1000L + " Seconds");
            System.out.println("Time Taken to snapshot this CIMOM = " + (endTime - startTime) / 1000L + " Seconds");
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.info(e.getMessage() + e);
        }
    }
}

