--
-- /****************************************** {COPYRIGHT-TOP} **
-- * Aperi Storage Manager
-- * (C) Copyright IBM Corp. 2007
-- * All rights reserved. This program and the accompanying materials
-- * are made available under the terms of the Eclipse Public License v1.0
-- * which accompanies this distribution, and is available at
-- * http://www.eclipse.org/legal/epl-v10.html
-- ******************************************* {COPYRIGHT-END} **/
--
-- @author:  Ramani Routray,     IBM Almaden Research Center
-- @author:  Pallavi Galgali,    IBM Pune Lab
-- @author:  Amit Modi,          IBM Pune Lab
-- @contact: Sandeep Gopisetty,  IBM Almaden Research Center
--
-- NAME:
-- CLASS DESCRIPTION:
-- USAGE:
--
-- Change History
-- Change Flag  Date     Prog    Description
--------------------------------------------------------------------------------
--
--

CREATE SCHEMA SIM;

SET SCHEMA = SIM;

DROP TABLE CIMOM_INFO;
CREATE TABLE CIMOM_INFO (
	ID					INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1) PRIMARY KEY,
	CIMOM_TYPE			INTEGER,
	DETAILS				VARCHAR(30),
	URL					VARCHAR(100),
	INTOP_NS			VARCHAR(30),
	USERID				VARCHAR(30),
	PWDID				VARCHAR(30)
);

DROP TABLE NS_INFO;
CREATE TABLE NS_INFO (
	ID					INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1) PRIMARY KEY,
	CIMOM_INFO_ID		INTEGER,
	NAMESPACE			VARCHAR(30),
	CONSTRAINT			FK2 FOREIGN KEY (CIMOM_INFO_ID) REFERENCES CIMOM_INFO (ID) ON DELETE CASCADE
);


DROP TABLE CIM_CLASS;
CREATE TABLE CIM_CLASS (
	ID					INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1) PRIMARY KEY,
	NS_INFO_ID			INTEGER,
	CLASS_NAME			VARCHAR(100),
	CONSTRAINT			FK3 FOREIGN KEY (NS_INFO_ID) REFERENCES NS_INFO (ID) ON DELETE CASCADE
);


DROP TABLE CIM_DATA;
CREATE TABLE CIM_DATA (
	ID					INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1) PRIMARY KEY,
	CIM_CLASS_ID		INTEGER,
	CIM_OP				BLOB(3K),
	CIM_INST			BLOB(10K),
	CONSTRAINT			FK4 FOREIGN KEY (CIM_CLASS_ID) REFERENCES CIM_CLASS (ID) ON DELETE CASCADE	
);

DROP TABLE CIM_ASC;
CREATE TABLE CIM_ASC (
	ID					INTEGER NOT NULL GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1) PRIMARY KEY,
	CIM_DATA_ASC_ID		INTEGER,
	CIM_DATA_FRM_ID		INTEGER,
	CIM_DATA_TO_ID		INTEGER,
	CONSTRAINT			FK5 FOREIGN KEY (CIM_DATA_FRM_ID) REFERENCES CIM_DATA (ID) ON DELETE CASCADE,
	CONSTRAINT			FK6 FOREIGN KEY (CIM_DATA_TO_ID) REFERENCES CIM_DATA (ID) ON DELETE CASCADE,
	CONSTRAINT			FK7 FOREIGN KEY (CIM_DATA_ASC_ID) REFERENCES CIM_DATA (ID) ON DELETE CASCADE
);

COMMIT;

CONNECT RESET;
