/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.simulator.cimom.sblim.util;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import org.eclipse.aperi.simulator.cimom.common.CIMOM;
import org.eclipse.aperi.simulator.cimom.common.base.BaseMOFGenerator;
import org.eclipse.aperi.simulator.cimom.sblim.util.DiscoveryUtil;
import org.sblim.wbem.cim.CIMClass;
import org.sblim.wbem.cim.CIMDataType;
import org.sblim.wbem.cim.CIMException;
import org.sblim.wbem.cim.CIMMethod;
import org.sblim.wbem.cim.CIMNameSpace;
import org.sblim.wbem.cim.CIMObjectPath;
import org.sblim.wbem.cim.CIMParameter;
import org.sblim.wbem.cim.CIMProperty;
import org.sblim.wbem.cim.CIMQualifier;
import org.sblim.wbem.cim.CIMQualifierType;
import org.sblim.wbem.cim.CIMValue;
import org.sblim.wbem.client.CIMClient;
import org.sblim.wbem.client.PasswordCredential;
import org.sblim.wbem.client.UserPrincipal;

public class MOFGenerator
extends BaseMOFGenerator {
    private UserPrincipal principal;
    private PasswordCredential credential;
    private CIMClient cimClient;

    public MOFGenerator(CIMOM cimom) {
        super(cimom);
    }

    public void generateDataForNameSpace(String namespace, String filePath) throws Exception {
        this.cimClient = null;
        CIMNameSpace cimNamespace = new CIMNameSpace(this.cimom.getServiceURL(), namespace);
        this.cimClient = new CIMClient(cimNamespace, (Principal)this.principal, (Object)this.credential);
        CIMObjectPath path = new CIMObjectPath();
        Enumeration en = this.cimClient.enumerateClasses(path, true, false, false, true);
        ArrayList classList = new ArrayList();
        ArrayList qualifierList = new ArrayList();
        block0: while (en.hasMoreElements()) {
            CIMClass cimCls = (CIMClass)en.nextElement();
            String className = cimCls.getName();
            this.addQualifiersToList(qualifierList, cimCls.getQualifiers());
            if (classList.contains(className)) continue;
            if (this.isOnlyLeaf) {
                Iterator iter = this.cimom.getLeafClassNamePrefixes().iterator();
                while (iter.hasNext()) {
                    if (!className.startsWith((String)iter.next())) continue;
                    this.addClassWithReferences(classList, cimCls, qualifierList);
                    continue block0;
                }
                continue;
            }
            this.addClassWithReferences(classList, cimCls, qualifierList);
        }
        this.printData(namespace, filePath, classList, qualifierList);
        this.cimClient.close();
        this.cimClient = null;
    }

    private void printData(String namespace, String filePath, List classList, List qualifierList) throws IOException {
        CIMClass cimCls = new CIMClass();
        String fileName = this.createNewWriter(namespace, filePath);
        System.out.println("File created for namespace : " + namespace + " is : " + fileName);
        this.writeDataToFile("#pragma namespace (\"" + namespace + "\")");
        this.writeDataToFile("#pragma Locale (\"en-US\")");
        HashMap qualifierDatatypeHashMap = this.getQualifierDatatype();
        this.printQualifierData(qualifierList, qualifierDatatypeHashMap);
        CIMObjectPath op = null;
        int length = classList.size();
        for (int idx = 0; idx < length; ++idx) {
            try {
                op = new CIMObjectPath((String)classList.get(idx));
                cimCls = this.cimClient.getClass(op);
                this.doAdditionalChanges(cimCls);
                this.writeDataToFile("// " + cimCls.getName());
                this.writeDataToFile(cimCls.toString());
                continue;
            }
            catch (Exception e) {
                System.out.println("Error for class " + op);
                this.writeDataToFile("// " + cimCls.getName());
                this.writeDataToFile(cimCls.toString());
                System.out.println(e.getMessage());
            }
        }
        this.closeFile();
    }

    private void doAdditionalChanges(CIMClass cimCls) {
        String className = cimCls.getName();
        Vector v = cimCls.getQualifiers();
        Iterator<Object> iter = v.iterator();
        if (cimCls.getQualifier("Provider") != null) {
            cimCls.removeQualifier("Provider");
        }
        Iterator tempIter = this.cimom.getLeafClassNamePrefixes().iterator();
        while (tempIter.hasNext()) {
            if (!className.startsWith((String)tempIter.next())) continue;
            CIMQualifier tempQualifier = new CIMQualifier("Provider");
            tempQualifier.setValue(new CIMValue((Object)"java:org.eclipse.aperi.simulator.cimom.sunwbem.provider.Provider", new CIMDataType(8)));
            cimCls.addQualifier(tempQualifier);
        }
        CIMClass tmpCIMClass = new CIMClass();
        tmpCIMClass.setName(cimCls.getName());
        tmpCIMClass.setObjectPath(cimCls.getObjectPath());
        tmpCIMClass.setProperties(cimCls.getProperties());
        tmpCIMClass.setQualifiers(cimCls.getQualifiers());
        tmpCIMClass.setIsAssociation(cimCls.isAssociation());
        tmpCIMClass.setSuperClass(cimCls.getSuperClass());
        Vector methodVector = cimCls.getAllMethods();
        for (int idxMethod = 0; idxMethod < methodVector.size(); ++idxMethod) {
            CIMMethod method = (CIMMethod)methodVector.get(idxMethod);
            Vector parameterVector = method.getParameters();
            for (int idx = 0; idx < parameterVector.size(); ++idx) {
                CIMParameter tmpParameter = (CIMParameter)parameterVector.get(idx);
                if (!tmpParameter.getType().isArrayType() && !tmpParameter.getType().toString().contains("[]")) continue;
                if (tmpParameter.getType().toString().contains("ref")) {
                    System.out.println(tmpParameter.toString());
                    CIMDataType cDT = new CIMDataType(tmpParameter.getType().toString().replace("[] ref", ""));
                    tmpParameter.setType(cDT);
                } else {
                    tmpParameter.setType(new CIMDataType(CIMDataType.findSimpleType((int)tmpParameter.getType().getType())));
                }
                tmpParameter.setName(tmpParameter.getName() + "[]");
            }
            tmpCIMClass.addMethod(method);
        }
        cimCls.equals((Object)tmpCIMClass);
        Vector propertiesVector = cimCls.getAllProperties();
        iter = propertiesVector.iterator();
        while (iter.hasNext()) {
            CIMProperty property = (CIMProperty)iter.next();
            if (property.getType().getStringType().equalsIgnoreCase("datetime")) {
                property.setValue(null);
                continue;
            }
            if (!property.isReference()) continue;
            property.setValue(null);
        }
        String overrideFilePath = "conf/remove_override.txt";
        Properties properties = new Properties();
        ArrayList<String> classListToModify = new ArrayList<String>();
        try {
            properties.load(new FileInputStream("conf/remove_override.txt"));
            Set<Object> keyset = properties.keySet();
            iter = keyset.iterator();
            while (iter.hasNext()) {
                String tmpClassName = (String)iter.next();
                classListToModify.add(tmpClassName);
            }
            if (classListToModify.contains(cimCls.getName())) {
                String strVals = properties.getProperty(cimCls.getName());
                String[] str = strVals.split(",");
                for (int tmpCtr = 0; tmpCtr < str.length; ++tmpCtr) {
                    CIMProperty tmpProperty = cimCls.getProperty(str[tmpCtr]);
                    tmpProperty.removeQualifier("Override");
                }
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String keyFilePath = "conf/remove_key.txt";
        properties = new Properties();
        classListToModify = new ArrayList();
        try {
            properties.load(new FileInputStream("conf/remove_key.txt"));
            Set<Object> keyset = properties.keySet();
            iter = keyset.iterator();
            while (iter.hasNext()) {
                String tmpClassName = (String)iter.next();
                classListToModify.add(tmpClassName);
            }
            if (classListToModify.contains(cimCls.getName())) {
                String strVals = properties.getProperty(cimCls.getName());
                String[] str = strVals.split(",");
                for (int tmpCtr = 0; tmpCtr < str.length; ++tmpCtr) {
                    CIMProperty tmpProperty = cimCls.getProperty(str[tmpCtr]);
                    tmpProperty.removeQualifier("Key");
                }
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (cimCls.getName().equalsIgnoreCase("IBMTSDS_StorageReplicationCapabilities")) {
            CIMValue tmpValue = new CIMValue((Object)"SupportedAsynchronousActions");
            cimCls.getProperty("SupportedAsynchronousActions").getQualifier("Override").setValue(tmpValue);
        }
        if (cimCls.getName().equalsIgnoreCase("IBMTSDS_StorageConfigurationService")) {
            cimCls.getProperty("SystemName").removeQualifier("Propogated");
        }
    }

    private void printAdditional6kQualifiers() throws IOException {
        String providerQualifier = "Qualifier Provider : String = null,\n\tScope( any\n);";
        String octetStringQualifier = "Qualifier Octetstring : boolean = false,\n\tScope( property,\n\t method,\n\t parameter\n),\n\tFlavor(\tDisableOverride\n);";
        String associationQualifier = "Qualifier Association : boolean = false,\n\tScope(association), \n\tFlavor(DisableOverride);";
        String aggregateQualifier = "Qualifier Aggregate : boolean = false,\n\tScope( reference\n),\n\tFlavor(\tDisableOverride\n);";
        String aggregationQualifier = "Qualifier Aggregation : boolean = false,\n\tScope( association\n),\n\tFlavor(\tDisableOverride\n);";
        String maxQualifier = "Qualifier Max : uint32 = null,\n\tScope( reference\n);";
        String minQualifier = "Qualifier Min : uint32 = null,\n\tScope( reference\n);";
        String indicationQualifier = "Qualifier Indication : boolean = false,\n\tScope( class,\n\tindication\n),\n\tFlavor(\tDisableOverride\n);";
        String exceptionQualifier = "Qualifier Exception : boolean = false,\n\tScope( class,\n\tindication\n),\n\tFlavor(\tDisableOverride,\n\ttosubclass\n);";
        String compositionQualifier = "Qualifier Composition : boolean = false,\n\tScope( association\n),\n\tFlavor(\tDisableOverride\n);";
        String embeddedObjectQualifier = "Qualifier EmbeddedObject : boolean = false,\n\tScope( property,\n\t method,\n\t parameter\n),\n\tFlavor(\tDisableOverride\n);";
        String weakQualifier = "Qualifier Weak : boolean = false,\n\tScope( reference\n),\n\tFlavor(\tDisableOverride,\n\ttosubclass\n);";
        this.writeDataToFile("//Provider");
        this.writeDataToFile("Qualifier Provider : String = null,\n\tScope( any\n);");
        this.writeDataToFile("//Octetstring");
        this.writeDataToFile("Qualifier Octetstring : boolean = false,\n\tScope( property,\n\t method,\n\t parameter\n),\n\tFlavor(\tDisableOverride\n);");
        this.writeDataToFile("//Association");
        this.writeDataToFile("Qualifier Association : boolean = false,\n\tScope(association), \n\tFlavor(DisableOverride);");
        this.writeDataToFile("//Aggregate");
        this.writeDataToFile("Qualifier Aggregate : boolean = false,\n\tScope( reference\n),\n\tFlavor(\tDisableOverride\n);");
        this.writeDataToFile("//Aggregation");
        this.writeDataToFile("Qualifier Aggregation : boolean = false,\n\tScope( association\n),\n\tFlavor(\tDisableOverride\n);");
        this.writeDataToFile("//Max");
        this.writeDataToFile("Qualifier Max : uint32 = null,\n\tScope( reference\n);");
        this.writeDataToFile("//Min");
        this.writeDataToFile("Qualifier Min : uint32 = null,\n\tScope( reference\n);");
        this.writeDataToFile("//Indication");
        this.writeDataToFile("Qualifier Indication : boolean = false,\n\tScope( class,\n\tindication\n),\n\tFlavor(\tDisableOverride\n);");
        this.writeDataToFile("//Exception");
        this.writeDataToFile("Qualifier Exception : boolean = false,\n\tScope( class,\n\tindication\n),\n\tFlavor(\tDisableOverride,\n\ttosubclass\n);");
        this.writeDataToFile("//Composotion");
        this.writeDataToFile("Qualifier Composition : boolean = false,\n\tScope( association\n),\n\tFlavor(\tDisableOverride\n);");
        this.writeDataToFile("//EmbedddObject");
        this.writeDataToFile("Qualifier EmbeddedObject : boolean = false,\n\tScope( property,\n\t method,\n\t parameter\n),\n\tFlavor(\tDisableOverride\n);");
        this.writeDataToFile("//Weak");
        this.writeDataToFile("Qualifier Weak : boolean = false,\n\tScope( reference\n),\n\tFlavor(\tDisableOverride,\n\ttosubclass\n);");
    }

    private void printQualifierData(List qualifierList, HashMap qualifierDatatypeHM) {
        Collections.sort(qualifierList);
        String qualifierName = null;
        StringBuffer buffer = new StringBuffer();
        boolean requiredQualifierFlag = false;
        int length = qualifierList.size();
        for (int idx = 0; idx < length; ++idx) {
            buffer.setLength(0);
            try {
                qualifierName = (String)qualifierList.get(idx);
                CIMObjectPath op = new CIMObjectPath(qualifierName);
                CIMQualifierType type = this.cimClient.getQualifierType(op);
                String qualifierDef = type.toString();
                String qualifierDatatype = qualifierDatatypeHM.get(qualifierName.toUpperCase()).toString();
                qualifierDef = qualifierDef.replace(": ,", ": " + qualifierDatatype + ',');
                if (qualifierDef.indexOf(91, qualifierDef.indexOf("Scope(")) != -1) {
                    buffer.append(qualifierDef.substring(0, qualifierDef.indexOf("Scope(") + "Scope(".length()));
                    qualifierDef = qualifierDef.substring(qualifierDef.indexOf("Scope(") + "Scope(".length() + 1);
                    qualifierDef = qualifierDef.replace('[', ' ');
                    qualifierDef = qualifierDef.replace(']', ' ');
                    if (qualifierDef.indexOf(91, qualifierDef.indexOf("Flavor(")) != -1) {
                        buffer.append(qualifierDef.substring(0, qualifierDef.indexOf("Flavor(") + "Flavor(".length()));
                        qualifierDef = qualifierDef.substring(qualifierDef.indexOf("Flavor(") + "Flavor(".length() + 1);
                        qualifierDef = qualifierDef.replace('[', ' ');
                        qualifierDef = qualifierDef.replace(']', ' ');
                    }
                    buffer.append(qualifierDef);
                } else {
                    buffer.append(qualifierDef);
                }
                if (requiredQualifierFlag && qualifierName.toUpperCase().equals("REQUIRED")) continue;
                this.writeDataToFile("// " + qualifierName);
                this.writeDataToFile(buffer.toString());
                if (!qualifierName.toUpperCase().equals("REQUIRED")) continue;
                requiredQualifierFlag = true;
                continue;
            }
            catch (Exception e) {
                System.out.println("Error for qualifier " + qualifierName);
                System.out.println(e.getMessage());
            }
        }
        try {
            this.printAdditional6kQualifiers();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private HashMap getQualifierDatatype() throws IOException {
        FileInputStream tempFIS = new FileInputStream("conf//datatype.txt");
        InputStreamReader tempISR = new InputStreamReader(tempFIS);
        BufferedReader tempBR = new BufferedReader(tempISR);
        String tempString = tempBR.readLine();
        HashMap<String, String> tempQualifierMap = new HashMap<String, String>();
        while (tempString != null) {
            String temp2 = tempString.substring(tempString.indexOf(32) + 1, tempString.indexOf(58) - 1);
            String temp1 = tempString.substring(tempString.indexOf(32, tempString.indexOf(58)), tempString.indexOf(44));
            tempQualifierMap.put(temp2.toUpperCase(), temp1);
            tempString = tempBR.readLine();
        }
        tempBR.close();
        tempISR.close();
        tempFIS.close();
        return tempQualifierMap;
    }

    private void addClassWithReferences(List classList, CIMClass cimCls, List qualifierList) throws CIMException {
        String className;
        String superClass = cimCls.getSuperClass();
        if (superClass != null && !superClass.trim().equals("") && !classList.contains(superClass)) {
            CIMObjectPath op = new CIMObjectPath(superClass);
            this.addClassWithReferences(classList, this.cimClient.getClass(op), qualifierList);
        }
        Vector properties = cimCls.getAllProperties();
        Iterator iterator = properties.iterator();
        while (iterator.hasNext()) {
            CIMProperty property = (CIMProperty)iterator.next();
            this.addQualifiersToList(qualifierList, property.getQualifiers());
            if (!property.isReference() || classList.contains(className = property.getType().getRefClassName())) continue;
            try {
                this.addClassWithReferences(classList, this.cimClient.getClass(new CIMObjectPath(className)), qualifierList);
            }
            catch (Exception e) {
                classList.add(cimCls.getName());
            }
        }
        this.addClassQualifier(cimCls, qualifierList);
        if (this.isOnlyLeaf) {
            Iterator iter = this.cimom.getLeafClassNamePrefixes().iterator();
            className = cimCls.getName();
            while (iter.hasNext()) {
                if (!className.startsWith((String)iter.next())) continue;
                classList.add(className);
                break;
            }
        } else {
            classList.add(cimCls.getName());
        }
    }

    private void addClassQualifier(CIMClass cimCls, List qualifierList) {
        this.addQualifiersToList(qualifierList, cimCls.getQualifiers());
        Vector methods = cimCls.getAllMethods();
        Iterator iter = methods.iterator();
        while (iter.hasNext()) {
            CIMMethod cimMethod = (CIMMethod)iter.next();
            this.addMethodQualifier(cimMethod, qualifierList);
        }
    }

    private void addMethodQualifier(CIMMethod cimMethod, List qualifierList) {
        this.addQualifiersToList(qualifierList, cimMethod.getQualifiers());
        Vector parameters = cimMethod.getParameters();
        Iterator iter = parameters.iterator();
        while (iter.hasNext()) {
            CIMParameter parameter = (CIMParameter)iter.next();
            this.addQualifiersToList(qualifierList, parameter.getQualifiers());
        }
    }

    private void addQualifiersToList(List qualifierList, Vector qualifiers) {
        Iterator iter = qualifiers.iterator();
        while (iter.hasNext()) {
            CIMQualifier qualifier = (CIMQualifier)iter.next();
            if (qualifierList.contains(qualifier.getName())) continue;
            qualifierList.add(qualifier.getName());
        }
    }

    protected void createCIMClient(String url, String user, String password, String namespace) {
        try {
            if (url != null && namespace != null) {
                CIMNameSpace cimNamespace = new CIMNameSpace(url, namespace);
                if (user != null) {
                    this.principal = new UserPrincipal(user);
                }
                if (password != null) {
                    this.credential = new PasswordCredential(password.toCharArray());
                }
                this.cimClient = new CIMClient(cimNamespace, (Principal)this.principal, (Object)this.credential);
            } else {
                System.err.println("Given CIMOM URL AND/OR Namespace is NULL");
            }
        }
        catch (CIMException e) {
            e.printStackTrace();
        }
    }

    protected void generateData(String filePath, ArrayList namespaces) throws Exception {
        DiscoveryUtil.getNamespaces(this.cimClient, namespaces, this.cimom.getCimomType());
        for (int idx = 0; idx < namespaces.size(); ++idx) {
            this.generateDataForNameSpace((String)namespaces.get(idx), filePath);
        }
        if (this.cimClient != null) {
            try {
                this.cimClient.close();
            }
            catch (CIMException e) {
                e.printStackTrace();
            }
        }
        this.cimClient = null;
    }
}

