/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.simulator.cimom.sunwbem.util;

import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMDataType;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMMethod;
import javax.wbem.cim.CIMNameSpace;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMParameter;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMQualifier;
import javax.wbem.cim.CIMQualifierType;
import javax.wbem.cim.CIMValue;
import javax.wbem.client.CIMClient;
import javax.wbem.client.PasswordCredential;
import javax.wbem.client.UserPrincipal;
import org.eclipse.aperi.simulator.cimom.common.CIMOM;
import org.eclipse.aperi.simulator.cimom.common.base.BaseMOFGenerator;
import org.eclipse.aperi.simulator.cimom.sunwbem.util.DiscoveryUtil;

public class MOFGenerator
extends BaseMOFGenerator {
    private UserPrincipal principal;
    private PasswordCredential credential;
    private CIMClient cimClient;

    public MOFGenerator(CIMOM cimom) {
        super(cimom);
    }

    public void generateDataForNameSpace(String namespace, String filePath) throws Exception {
        this.cimClient = null;
        CIMNameSpace cimNamespace = new CIMNameSpace(this.cimom.getServiceURL(), namespace);
        this.cimClient = new CIMClient(cimNamespace, (Principal)this.principal, (Object)this.credential);
        CIMObjectPath path = new CIMObjectPath();
        Enumeration en = this.cimClient.enumerateClasses(path, true, false, false, true);
        ArrayList classList = new ArrayList();
        ArrayList qualifierList = new ArrayList();
        block0: while (en.hasMoreElements()) {
            CIMClass cimCls = (CIMClass)en.nextElement();
            String className = cimCls.getName();
            if (classList.contains(className)) continue;
            if (this.isOnlyLeaf) {
                Iterator iter = this.cimom.getLeafClassNamePrefixes().iterator();
                while (iter.hasNext()) {
                    if (!className.startsWith((String)iter.next())) continue;
                    this.addClassWithReferences(classList, cimCls, qualifierList);
                    continue block0;
                }
                continue;
            }
            this.addClassWithReferences(classList, cimCls, qualifierList);
        }
        this.printData(namespace, filePath, classList, qualifierList);
        this.cimClient.close();
        this.cimClient = null;
    }

    private void printData(String namespace, String filePath, List classList, List qualifierList) throws IOException {
        String fileName = this.createNewWriter(namespace, filePath);
        System.out.println("File created for namespace : " + namespace + " is : " + fileName);
        this.writeDataToFile("#pragma namespace (\"" + namespace + "\")");
        this.writeDataToFile("#pragma Locale (\"en-US\")");
        this.printQualifierData(qualifierList);
        CIMObjectPath op = null;
        int length = classList.size();
        for (int idx = 0; idx < length; ++idx) {
            try {
                op = new CIMObjectPath((String)classList.get(idx));
                CIMClass cimCls = this.cimClient.getClass(op);
                this.doAdditionalChanges(cimCls);
                this.writeDataToFile("// " + cimCls.getName());
                this.writeDataToFile(cimCls.toString());
                continue;
            }
            catch (Exception e) {
                System.out.println("Error for class " + op);
                this.writeDataToFile("class " + op.getObjectName() + " {");
                this.writeDataToFile("};");
                System.out.println(e.getMessage());
                e.printStackTrace();
            }
        }
        this.closeFile();
    }

    private void doAdditionalChanges(CIMClass cimCls) {
        String className = cimCls.getName();
        Vector v = cimCls.getQualifiers();
        Vector<CIMQualifier> qualifierVector = new Vector<CIMQualifier>();
        Iterator iter = v.iterator();
        int count = 0;
        while (iter.hasNext()) {
            CIMQualifier qualifier = (CIMQualifier)iter.next();
            if (qualifier.getName().equalsIgnoreCase("Provider") || qualifier.getName().equalsIgnoreCase("ProviderName")) {
                Iterator tempIter = this.cimom.getLeafClassNamePrefixes().iterator();
                boolean isDone = false;
                while (tempIter.hasNext()) {
                    if (!className.startsWith((String)tempIter.next())) continue;
                    qualifier.setValue(new CIMValue((Object)"java:org.eclipse.aperi.simulator.cimom.sunwbem.provider.Provider", new CIMDataType(8)));
                    qualifierVector.add(count++, qualifier);
                    isDone = true;
                    break;
                }
                if (isDone) continue;
                qualifierVector.add(count++, qualifier);
                continue;
            }
            if (qualifier.getName().equalsIgnoreCase("ASSOCIATION ( true ),")) {
                qualifierVector.add(0, qualifier);
                continue;
            }
            qualifierVector.add(count++, qualifier);
        }
        cimCls.setQualifiers(qualifierVector);
        Vector propertiesVector = cimCls.getAllProperties();
        iter = propertiesVector.iterator();
        while (iter.hasNext()) {
            CIMProperty property = (CIMProperty)iter.next();
            if (property.getType().getType() == 12) {
                property.setValue(null);
                continue;
            }
            if (!property.isReference()) continue;
            property.setValue(null);
        }
    }

    private void printQualifierData(List qualifierList) {
        Collections.sort(qualifierList);
        String qualifierName = null;
        StringBuffer buffer = new StringBuffer();
        int length = qualifierList.size();
        for (int idx = 0; idx < length; ++idx) {
            buffer.setLength(0);
            try {
                qualifierName = (String)qualifierList.get(idx);
                CIMObjectPath op = new CIMObjectPath(qualifierName);
                CIMQualifierType type = this.cimClient.getQualifierType(op);
                String qualifierDef = type.toString();
                if (qualifierDef.indexOf(91, qualifierDef.indexOf("Scope(")) != -1) {
                    buffer.append(qualifierDef.substring(0, qualifierDef.indexOf("Scope(") + "Scope(".length()));
                    qualifierDef = qualifierDef.substring(qualifierDef.indexOf("Scope(") + "Scope(".length() + 1);
                    qualifierDef = qualifierDef.replace('[', ' ');
                    qualifierDef = qualifierDef.replace(']', ' ');
                    if (qualifierDef.indexOf(91, qualifierDef.indexOf("Flavor(")) != -1) {
                        buffer.append(qualifierDef.substring(0, qualifierDef.indexOf("Flavor(") + "Flavor(".length()));
                        qualifierDef = qualifierDef.substring(qualifierDef.indexOf("Flavor(") + "Flavor(".length() + 1);
                        qualifierDef = qualifierDef.replace('[', ' ');
                        qualifierDef = qualifierDef.replace(']', ' ');
                    }
                    buffer.append(qualifierDef);
                } else {
                    buffer.append(qualifierDef);
                }
                this.writeDataToFile("// " + qualifierName);
                this.writeDataToFile(buffer.toString());
                continue;
            }
            catch (Exception e) {
                System.out.println("Error for qualifier " + qualifierName);
                System.out.println(e.getMessage());
            }
        }
    }

    private void addClassWithReferences(List classList, CIMClass cimCls, List qualifierList) throws CIMException {
        String className;
        String superClass = cimCls.getSuperClass();
        if (superClass != null && !superClass.trim().equals("") && !classList.contains(superClass)) {
            CIMObjectPath op = new CIMObjectPath(superClass);
            this.addClassWithReferences(classList, this.cimClient.getClass(op), qualifierList);
        }
        Vector properties = cimCls.getAllProperties();
        Iterator iterator = properties.iterator();
        while (iterator.hasNext()) {
            CIMProperty property = (CIMProperty)iterator.next();
            this.addQualifiersToList(qualifierList, property.getQualifiers());
            if (!property.isReference() || classList.contains(className = property.getType().getRefClassName())) continue;
            try {
                this.addClassWithReferences(classList, this.cimClient.getClass(new CIMObjectPath(className)), qualifierList);
            }
            catch (Exception e) {
                classList.add(cimCls.getName());
            }
        }
        this.addClassQualifier(cimCls, qualifierList);
        if (this.isOnlyLeaf) {
            Iterator iter = this.cimom.getLeafClassNamePrefixes().iterator();
            className = cimCls.getName();
            while (iter.hasNext()) {
                if (!className.startsWith((String)iter.next())) continue;
                classList.add(className);
                break;
            }
        } else {
            classList.add(cimCls.getName());
        }
    }

    private void addClassQualifier(CIMClass cimCls, List qualifierList) {
        this.addQualifiersToList(qualifierList, cimCls.getQualifiers());
        Vector methods = cimCls.getAllMethods();
        Iterator iter = methods.iterator();
        while (iter.hasNext()) {
            CIMMethod cimMethod = (CIMMethod)iter.next();
            this.addMethodQualifier(cimMethod, qualifierList);
        }
    }

    private void addMethodQualifier(CIMMethod cimMethod, List qualifierList) {
        this.addQualifiersToList(qualifierList, cimMethod.getQualifiers());
        Vector parameters = cimMethod.getParameters();
        Iterator iter = parameters.iterator();
        while (iter.hasNext()) {
            CIMParameter parameter = (CIMParameter)iter.next();
            this.addQualifiersToList(qualifierList, parameter.getQualifiers());
        }
    }

    private void addQualifiersToList(List qualifierList, Vector qualifiers) {
        Iterator iter = qualifiers.iterator();
        while (iter.hasNext()) {
            CIMQualifier qualifier = (CIMQualifier)iter.next();
            if (qualifierList.contains(qualifier.getName())) continue;
            qualifierList.add(qualifier.getName());
        }
    }

    protected void createCIMClient(String url, String user, String password, String namespace) {
        try {
            if (url != null && namespace != null) {
                CIMNameSpace cimNamespace = new CIMNameSpace(url, namespace);
                if (user != null) {
                    this.principal = new UserPrincipal(user);
                }
                if (password != null) {
                    this.credential = new PasswordCredential(password);
                }
                this.cimClient = new CIMClient(cimNamespace, (Principal)this.principal, (Object)this.credential);
            } else {
                System.err.println("Given CIMOM URL AND/OR Namespace is NULL");
            }
        }
        catch (CIMException e) {
            e.printStackTrace();
        }
    }

    protected void generateData(String filePath, ArrayList namespaces) throws Exception {
        DiscoveryUtil.getNamespaces(this.cimClient, namespaces, this.cimom.getCimomType());
        for (int idx = 0; idx < namespaces.size(); ++idx) {
            this.generateDataForNameSpace((String)namespaces.get(idx), filePath);
        }
        if (this.cimClient != null) {
            try {
                this.cimClient.close();
            }
            catch (CIMException e) {
                e.printStackTrace();
            }
        }
        this.cimClient = null;
    }
}

