/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.simulator.ui;

import java.security.Principal;
import java.util.logging.Logger;
import org.sblim.wbem.cim.CIMNameSpace;
import org.sblim.wbem.cim.CIMObjectPath;
import org.sblim.wbem.client.CIMClient;
import org.sblim.wbem.client.PasswordCredential;
import org.sblim.wbem.client.UserPrincipal;

public class TestSblimCIMOMConnection {
    private CIMClient cimClient;
    private CIMNameSpace cimNamespace;
    private UserPrincipal principal;
    private PasswordCredential credential;
    private Logger logger = Logger.getLogger(TestSblimCIMOMConnection.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int testConnection(String HostUrl, String Port, String UserName, String PassWord, String NameSpace, String Protocol) {
        int tag = 0;
        try {
            if (HostUrl != null && NameSpace != null) {
                try {
                    this.cimNamespace = new CIMNameSpace(Protocol + "://" + HostUrl + ":" + Port, NameSpace);
                    if (UserName != null) {
                        this.principal = new UserPrincipal(UserName);
                    }
                    if (PassWord != null) {
                        this.credential = new PasswordCredential(PassWord.toCharArray());
                    }
                    this.cimClient = new CIMClient(this.cimNamespace, (Principal)this.principal, (Object)this.credential);
                    CIMObjectPath path = new CIMObjectPath();
                    this.cimClient.enumerateClasses(path, true, false, false, true);
                    this.logger.info("The SBLIM CIMOM Connection is Successfull!");
                    tag = 1;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.logger.severe("Unable To Connect to CIMOM [" + HostUrl + "]" + e.getMessage());
                    this.logger.severe(e.getMessage() + e);
                }
            } else {
                this.logger.severe("Given CIMOM URL AND/OR Namespace is NULL");
            }
        }
        finally {
            if (this.cimClient != null) {
                this.cimClient.close();
            }
            this.cimClient = null;
        }
        return tag;
    }
}

