/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.simulator.dbutil;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.eclipse.aperi.simulator.dbutil.CreateDatabase;

public class DBInputUtility
extends JFrame {
    private static final long serialVersionUID = 1L;
    private static final String CREATE_DB = "Create DB";
    private static final String CANCEL = "Cancel";

    public static void main(String[] args) {
        DBInputUtility inputPanel = new DBInputUtility();
        inputPanel.showInputPanel();
    }

    private void showInputPanel() {
        Container container = this.getContentPane();
        JPanel jpInputPanel = new JPanel(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 12;
        constraints.fill = 2;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.gridheight = 1;
        constraints.gridwidth = 1;
        constraints.insets.top = 10;
        constraints.insets.left = 5;
        JLabel jlDbName = new JLabel("DB Name: ");
        constraints.gridx = 0;
        constraints.gridy = 0;
        jpInputPanel.add((Component)jlDbName, constraints);
        final JTextField jtfDBName = new JTextField();
        constraints.gridx = 1;
        constraints.gridy = 0;
        jpInputPanel.add((Component)jtfDBName, constraints);
        JLabel jlUserName = new JLabel("Username: ");
        constraints.gridx = 0;
        constraints.gridy = 1;
        jpInputPanel.add((Component)jlUserName, constraints);
        final JTextField jtfDBUserName = new JTextField();
        constraints.gridx = 1;
        constraints.gridy = 1;
        jpInputPanel.add((Component)jtfDBUserName, constraints);
        JLabel jlDbPassword = new JLabel("Password: ");
        constraints.gridx = 0;
        constraints.gridy = 2;
        jpInputPanel.add((Component)jlDbPassword, constraints);
        final JPasswordField jtfDBPassword = new JPasswordField();
        constraints.gridx = 1;
        constraints.gridy = 2;
        jpInputPanel.add((Component)jtfDBPassword, constraints);
        JButton jbCreateDb = new JButton(CREATE_DB);
        jbCreateDb.setActionCommand(CREATE_DB);
        jbCreateDb.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DBInputUtility.this.getContentPane().setCursor(Cursor.getPredefinedCursor(3));
                String dbName = jtfDBName.getText();
                String dbUsername = jtfDBUserName.getText();
                String dbPassword = new String(jtfDBPassword.getPassword());
                CreateDatabase dbInstance = new CreateDatabase(dbName, dbUsername, dbPassword);
                dbInstance.createDB();
                DBInputUtility.this.getContentPane().setCursor(Cursor.getDefaultCursor());
                DBInputUtility.this.getContentPane().removeAll();
                JOptionPane.showMessageDialog(null, "Database created Successfully!", "DB Creation", 1);
                DBInputUtility.this.dispose();
            }
        });
        constraints.gridx = 0;
        constraints.gridy = 3;
        jpInputPanel.add((Component)jbCreateDb, constraints);
        JButton jbCancel = new JButton(CANCEL);
        jbCancel.setActionCommand(CANCEL);
        jbCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int option = JOptionPane.showConfirmDialog(null, "Are you want to quit! ", DBInputUtility.CANCEL, 0);
                if (option == 0) {
                    DBInputUtility.this.dispose();
                    System.exit(0);
                }
            }
        });
        constraints.gridx = 1;
        constraints.gridy = 3;
        jpInputPanel.add((Component)jbCancel, constraints);
        container.add(jpInputPanel);
        this.setSize(300, 200);
        this.setLocation(400, 400);
        this.setVisible(true);
        this.setDefaultCloseOperation(3);
    }
}

