/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.simulator.cimom.DS6K;

import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import javax.wbem.cim.CIMArgument;
import javax.wbem.cim.CIMDataType;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.cim.UnsignedInt16;
import javax.wbem.cim.UnsignedInt64;
import org.eclipse.aperi.simulator.cimom.common.DatabaseManager;
import org.eclipse.aperi.simulator.cimom.common.IDGenerator;
import org.eclipse.aperi.simulator.cimom.common.generator.DataGeneratorResponse;
import org.eclipse.aperi.simulator.cimom.common.generator.DeviceDataGenerator;
import org.eclipse.aperi.simulator.cimom.sunwbem.provider.methods.DS6K5_2ExtrinsicMethods;

public class DS6K5_2CimomDataGenerator {
    private static final String ROOT_IBM_XML = "XML\\Storage\\IBM\\DS6K\\DS6K5_2_Root_IBM.xml";
    private static final String NAMESPACE_ROOT_IBM = "/root/ibm";
    private String configFile = "conf/DS6K5_2-requirement.config";
    private static final String STANDARD_VOL_SIZE = "1073741824";

    public void generateData(String confFile) {
        String storageSystemName = "1750-" + IDGenerator.getRandomKey("7");
        if (null != confFile) {
            this.configFile = confFile;
        }
        DatabaseManager dbManager = DatabaseManager.getDbManager();
        try {
            LinkedList classListAssoc;
            String[] classArray;
            int idx;
            dbManager.insert_CIMOM_INFO(1, "Sun Java WBEM CIMOM", "", NAMESPACE_ROOT_IBM, "", "");
            int cimomId = dbManager.getMaxID("SIM.CIMOM_INFO");
            dbManager.insert_NS_INFO(cimomId, NAMESPACE_ROOT_IBM);
            int root_ibm_NsID = dbManager.getMaxID("SIM.NS_INFO");
            DeviceDataGenerator dataGenerator = new DeviceDataGenerator(ROOT_IBM_XML, this.configFile);
            dataGenerator.getConfProperties().setProperty("STORAGE_SYSTEM_NAME", storageSystemName);
            DataGeneratorResponse root_ibm_Response = dataGenerator.generateData(NAMESPACE_ROOT_IBM);
            Properties confProperties = new Properties();
            confProperties.load(new FileInputStream("conf/classlist.properties"));
            int numberOfStoragePool = Integer.parseInt(dataGenerator.getConfProperties().getProperty("NUMBER_OF_POOLS"));
            String[] poolData = dataGenerator.getConfProperties().getProperty("MAPPING_ARRAYSITE_TO_POOL").split(" ");
            String[] volData = dataGenerator.getConfProperties().getProperty("MAPPING_POOL_TO_VOLUME").split(" ");
            String raidLevel = dataGenerator.getConfProperties().getProperty("RAID_LEVEL");
            int numberOfArraySiteExtent = 0;
            for (int i = 0; i < poolData.length; ++i) {
                numberOfArraySiteExtent += Integer.parseInt(poolData[i]);
            }
            int numberOfPorts = Integer.parseInt(dataGenerator.getConfProperties().getProperty("NUMBER_OF_PORTS"));
            for (idx = 0; idx < numberOfPorts; ++idx) {
                classArray = confProperties.getProperty("DS6K_NEW_FCPORT_LIST").split(",");
                classListAssoc = new LinkedList();
                Collections.addAll(classListAssoc, classArray);
                dataGenerator.getConfProperties().setProperty("SCSI_PROTOCOL_ENDPOINT_NAME", "" + IDGenerator.getRandomKey("8") + IDGenerator.getRandomKey("8"));
                dataGenerator.getConfProperties().setProperty("FCPORT_NAME", "0" + (100 + idx));
                root_ibm_Response = dataGenerator.generateData(classListAssoc, root_ibm_Response);
            }
            for (idx = 0; idx < numberOfArraySiteExtent; ++idx) {
                classArray = confProperties.getProperty("DS6K_NEW_ARRAY_SITE_LIST").split(",");
                classListAssoc = new LinkedList();
                Collections.addAll(classListAssoc, classArray);
                dataGenerator.getConfProperties().setProperty("ARRAY_SITE_INSTANCE_ID", "IBMTSDS:IBM." + storageSystemName + "-S" + (idx + 1));
                dataGenerator.getConfProperties().setProperty("ARRAY_SITE_ELEMENT_NAME", "Arraysite " + (idx + 1) + " on IBM." + storageSystemName);
                dataGenerator.getConfProperties().setProperty("ARRAY_SITE_CAPABILITIES_ELEMENT_NAME", "Capabilities for ArraySite IBM. " + storageSystemName + "-" + (idx + 1));
                root_ibm_Response = dataGenerator.generateData(classListAssoc, root_ibm_Response);
            }
            int numberOfDiskExtents = numberOfArraySiteExtent * 4;
            for (int idx2 = 0; idx2 < numberOfDiskExtents; ++idx2) {
                String[] classArray2 = confProperties.getProperty("DS6K_NEW_EXTENT_LIST").split(",");
                LinkedList classListAssoc2 = new LinkedList();
                Collections.addAll(classListAssoc2, classArray2);
                dataGenerator.getConfProperties().setProperty("DISK_EXTENT_DEVICE_ID", "8000" + IDGenerator.getRandomKey("9") + "0D");
                dataGenerator.getConfProperties().setProperty("DISK_DRIVE_ELEMENT_NAME", "Disk Drive " + idx2 % 4 + " on " + (idx2 / 4 + 1));
                dataGenerator.getConfProperties().setProperty("DISK_DRIVE_LOCATION", "U1750511." + storageSystemName.substring(5, 12) + "-P1-D" + (idx2 + 1));
                root_ibm_Response = dataGenerator.generateData(classListAssoc2, root_ibm_Response);
            }
            DataGeneratorResponse tempresponse = dataGenerator.generateData(NAMESPACE_ROOT_IBM);
            String antecedentClass = "IBMTSDS_DiskExtent";
            String dependentClass = "IBMTSDS_ArraySiteExtent";
            int antecedentClassCnt = 0;
            int dependentClassCnt = 0;
            String[] classArray3 = confProperties.getProperty("ARRAYSITE_DISKEXTENT_ASSOCIATION").split(",");
            LinkedList classListAssoc3 = new LinkedList();
            Collections.addAll(classListAssoc3, classArray3);
            for (int idx3 = 0; idx3 < numberOfArraySiteExtent; ++idx3) {
                ++dependentClassCnt;
                int mapCnt = 4;
                ArrayList<Object> antecedentList = new ArrayList<Object>();
                Object antInst = null;
                for (int i = 0; i < mapCnt; ++i) {
                    antInst = this.getInstanceFromMap(root_ibm_Response, antecedentClass, ++antecedentClassCnt);
                    antecedentList.add(antInst);
                }
                tempresponse.addInstances("/root/ibm:" + antecedentClass, antecedentList);
                Object depInst = this.getInstanceFromMap(root_ibm_Response, dependentClass, dependentClassCnt);
                tempresponse.addInstances("/root/ibm:" + dependentClass, depInst);
                tempresponse = dataGenerator.generateData(classListAssoc3, tempresponse);
                tempresponse.getInstanceMap().remove("/root/ibm:" + antecedentClass);
                tempresponse.getInstanceMap().remove("/root/ibm:" + dependentClass);
            }
            List associationclassList = (List)tempresponse.getInstanceMap().get("/root/ibm:IBMTSDS_ArraySiteBasedOnDiskExtent");
            root_ibm_Response.addInstances("/root/ibm:IBMTSDS_ArraySiteBasedOnDiskExtent", associationclassList);
            dbManager.persistInstances(root_ibm_NsID, root_ibm_Response.getInstanceMap(), dataGenerator.getParserResponse().getClassMap());
            for (int idx4 = 0; idx4 < 4; ++idx4) {
                String storageID = "" + IDGenerator.getRandomKey("8") + IDGenerator.getRandomKey("8");
                Vector<CIMArgument> inArgs = new Vector<CIMArgument>();
                CIMArgument argument1 = new CIMArgument("ElementName");
                argument1.setValue(null);
                inArgs.add(argument1);
                CIMArgument argument2 = new CIMArgument("StorageID");
                argument2.setValue(new CIMValue((Object)storageID, CIMDataType.getPredefinedType((int)8)));
                inArgs.add(argument2);
                UnsignedInt16 idType = new UnsignedInt16(2);
                CIMArgument argument3 = new CIMArgument("IDType");
                argument3.setValue(new CIMValue((Object)idType, CIMDataType.getPredefinedType((int)2)));
                inArgs.add(argument3);
                CIMArgument argument4 = new CIMArgument("OtherIDType");
                argument4.setValue(null);
                inArgs.add(argument4);
                CIMArgument argument5 = new CIMArgument("Setting");
                argument5.setValue(null);
                inArgs.add(argument5);
                CIMObjectPath hardwareIDOp = this.getDefaultHardwareIDOp(storageSystemName, storageID);
                CIMArgument argument6 = new CIMArgument("HardwareID");
                argument6.setValue(new CIMValue((Object)hardwareIDOp, new CIMDataType(hardwareIDOp.getObjectName())));
                inArgs.add(argument6);
                CIMArgument[] inArray = new CIMArgument[inArgs.size()];
                inArgs.toArray(inArray);
                CIMObjectPath serviceOP = null;
                CIMInstance serviceInst = (CIMInstance)root_ibm_Response.getInstanceMap().get("/root/ibm:IBMTSDS_StorageHardwareIDManagementService");
                serviceOP = serviceInst.getObjectPath();
                DS6K5_2ExtrinsicMethods.createStorageHardwareID(serviceOP, inArray, null);
            }
            List storageSysList = DatabaseManager.getDbManager().enumerateInstances(NAMESPACE_ROOT_IBM, "IBMTSDS_StorageSystem");
            Iterator sysIter = storageSysList.iterator();
            CIMObjectPath storageSysOp = null;
            while (sysIter.hasNext()) {
                CIMInstance sysInst = (CIMInstance)sysIter.next();
                String sysName = sysInst.getProperty("Name").getValue().getValue().toString();
                if (!sysName.contains(storageSystemName)) continue;
                storageSysOp = sysInst.getObjectPath();
                break;
            }
            List configServList = DatabaseManager.getDbManager().associators(NAMESPACE_ROOT_IBM, "IBMTSDS_HostedStorageConfigurationService", storageSysOp);
            Iterator iter = configServList.iterator();
            CIMObjectPath storageConfigDerviceOP = null;
            if (iter.hasNext()) {
                storageConfigDerviceOP = ((CIMInstance)iter.next()).getObjectPath();
            }
            List allArraySitePools = DatabaseManager.getDbManager().associators(NAMESPACE_ROOT_IBM, "IBMTSDS_HostedArraySitePool", storageSysOp);
            iter = allArraySitePools.iterator();
            ArrayList<CIMObjectPath> finalArraySitePools = new ArrayList<CIMObjectPath>();
            while (iter.hasNext()) {
                CIMObjectPath aSPOp = ((CIMInstance)iter.next()).getObjectPath();
                CIMInstance aSPInst = DatabaseManager.getDbManager().getInstance(aSPOp);
                String instanceID = (String)aSPInst.getProperty("InstanceID").getValue().getValue();
                if (!instanceID.contains(storageSystemName)) continue;
                finalArraySitePools.add(aSPOp);
            }
            int arraySiteToBeUsedNum = -1;
            CIMValue ret = null;
            for (int i = 0; i < poolData.length; ++i) {
                Vector<String> rankPoolOPS = new Vector<String>();
                int numOfArraySiteToPoolCnt = Integer.parseInt(poolData[i]);
                for (int idx5 = 0; idx5 < numOfArraySiteToPoolCnt; ++idx5) {
                    Vector<CIMArgument> inArgsPool = new Vector<CIMArgument>();
                    Vector<CIMArgument> outArgsPool = new Vector<CIMArgument>();
                    String poolName = "" + ++arraySiteToBeUsedNum;
                    CIMArgument inArg1Pool = new CIMArgument("ElementName");
                    inArg1Pool.setValue(new CIMValue((Object)poolName, CIMDataType.getPredefinedType((int)8)));
                    inArgsPool.add(inArg1Pool);
                    CIMArgument inArg2Pool = new CIMArgument("Goal");
                    List raidSetting = DatabaseManager.getDbManager().enumerateInstanceNames(NAMESPACE_ROOT_IBM, "IBMTSDS_RAIDSetting");
                    iter = raidSetting.iterator();
                    while (iter.hasNext()) {
                        CIMObjectPath raidSettingOP = (CIMObjectPath)iter.next();
                        String instanceID = raidSettingOP.getKey("InstanceID").getValue().getValue().toString();
                        if (!instanceID.contains(raidLevel)) continue;
                        inArg2Pool.setValue(new CIMValue((Object)raidSettingOP, new CIMDataType(raidSettingOP.getObjectName())));
                    }
                    inArgsPool.add(inArg2Pool);
                    CIMArgument inArg3Pool = new CIMArgument("InExtents");
                    inArgsPool.add(inArg3Pool);
                    CIMArgument inArg4Pool = new CIMArgument("InPools");
                    Vector<String> inPools = new Vector<String>();
                    inPools.add(finalArraySitePools.get(arraySiteToBeUsedNum).toString());
                    inArg4Pool.setValue(new CIMValue(inPools, CIMDataType.getPredefinedType((int)22)));
                    inArgsPool.add(inArg4Pool);
                    UnsignedInt64 inArg5ParamPool = new UnsignedInt64("292000000000");
                    CIMArgument inArg5Pool = new CIMArgument("Size");
                    inArg5Pool.setValue(new CIMValue((Object)inArg5ParamPool, CIMDataType.getPredefinedType((int)6)));
                    inArgsPool.add(inArg5Pool);
                    CIMArgument inArg6Pool = new CIMArgument("Pool");
                    inArgsPool.add(inArg6Pool);
                    CIMArgument outArg1Pool = new CIMArgument("Job");
                    outArgsPool.add(outArg1Pool);
                    outArgsPool.add(inArg5Pool);
                    outArgsPool.add(inArg6Pool);
                    CIMArgument[] inArrayPool = new CIMArgument[inArgsPool.size()];
                    inArgsPool.toArray(inArrayPool);
                    CIMArgument[] outArrayPool = new CIMArgument[outArgsPool.size()];
                    outArgsPool.toArray(outArrayPool);
                    ret = DS6K5_2ExtrinsicMethods.createOrModifyStoragePool(storageConfigDerviceOP, inArrayPool, outArrayPool);
                    if (((UnsignedInt16)ret.getValue()).intValue() != 0) continue;
                    inArgsPool = new Vector();
                    outArgsPool = new Vector();
                    inArg1Pool = new CIMArgument("ElementName");
                    inArg1Pool.setValue(new CIMValue((Object)poolName, CIMDataType.getPredefinedType((int)8)));
                    inArgsPool.add(inArg1Pool);
                    inArg2Pool = new CIMArgument("Goal");
                    raidSetting = DatabaseManager.getDbManager().enumerateInstanceNames(NAMESPACE_ROOT_IBM, "IBMTSDS_RAIDSetting");
                    iter = raidSetting.iterator();
                    while (iter.hasNext()) {
                        CIMObjectPath raidSettingOP = (CIMObjectPath)iter.next();
                        String instanceID = raidSettingOP.getKey("InstanceID").getValue().getValue().toString();
                        if (!instanceID.contains(raidLevel)) continue;
                        inArg2Pool.setValue(new CIMValue((Object)raidSettingOP, new CIMDataType(raidSettingOP.getObjectName())));
                    }
                    inArgsPool.add(inArg2Pool);
                    inArg3Pool = new CIMArgument("InExtents");
                    inArgsPool.add(inArg3Pool);
                    inArg4Pool = new CIMArgument("InPools");
                    inPools = new Vector();
                    inPools.add(((CIMObjectPath)outArrayPool[2].getValue().getValue()).toString());
                    inArg4Pool.setValue(new CIMValue(inPools, CIMDataType.getPredefinedType((int)22)));
                    inArgsPool.add(inArg4Pool);
                    inArg5ParamPool = raidLevel.equals("5") ? new UnsignedInt64("135291469824") : new UnsignedInt64("67645734912");
                    inArg5Pool = new CIMArgument("Size");
                    inArg5Pool.setValue(new CIMValue((Object)inArg5ParamPool, CIMDataType.getPredefinedType((int)6)));
                    inArgsPool.add(inArg5Pool);
                    inArg6Pool = new CIMArgument("Pool");
                    inArgsPool.add(inArg6Pool);
                    outArg1Pool = new CIMArgument("Job");
                    outArgsPool.add(outArg1Pool);
                    outArgsPool.add(inArg5Pool);
                    outArgsPool.add(inArg6Pool);
                    inArrayPool = new CIMArgument[inArgsPool.size()];
                    inArgsPool.toArray(inArrayPool);
                    outArrayPool = new CIMArgument[outArgsPool.size()];
                    outArgsPool.toArray(outArrayPool);
                    ret = DS6K5_2ExtrinsicMethods.createOrModifyStoragePool(storageConfigDerviceOP, inArrayPool, outArrayPool);
                    rankPoolOPS.add(((CIMObjectPath)outArrayPool[2].getValue().getValue()).toString());
                }
                if (((UnsignedInt16)ret.getValue()).intValue() != 0) continue;
                Vector<CIMArgument> inArgsPool = new Vector<CIMArgument>();
                Vector<CIMArgument> outArgsPool = new Vector<CIMArgument>();
                inArgsPool = new Vector();
                outArgsPool = new Vector();
                String poolName = "" + i;
                CIMArgument inArg1Pool = new CIMArgument("ElementName");
                inArg1Pool.setValue(new CIMValue((Object)poolName, CIMDataType.getPredefinedType((int)8)));
                inArgsPool.add(inArg1Pool);
                CIMArgument inArg2Pool = new CIMArgument("Goal");
                inArgsPool.add(inArg2Pool);
                CIMArgument inArg3Pool = new CIMArgument("InExtents");
                inArgsPool.add(inArg3Pool);
                CIMArgument inArg4Pool = new CIMArgument("InPools");
                inArg4Pool.setValue(new CIMValue(rankPoolOPS, CIMDataType.getPredefinedType((int)22)));
                inArgsPool.add(inArg4Pool);
                UnsignedInt64 inArg5ParamPool = new UnsignedInt64("0");
                for (int sizeCnt = 0; sizeCnt < rankPoolOPS.size(); ++sizeCnt) {
                    inArg5ParamPool = raidLevel.equals("5") ? new UnsignedInt64(inArg5ParamPool.bigIntValue().add(new UnsignedInt64("135291469824").bigIntValue())) : new UnsignedInt64(inArg5ParamPool.bigIntValue().add(new UnsignedInt64("67645734912").bigIntValue()));
                }
                CIMArgument inArg5Pool = new CIMArgument("Size");
                inArg5Pool.setValue(new CIMValue((Object)inArg5ParamPool, CIMDataType.getPredefinedType((int)6)));
                inArgsPool.add(inArg5Pool);
                CIMArgument inArg6Pool = new CIMArgument("Pool");
                inArgsPool.add(inArg6Pool);
                CIMArgument outArg1Pool = new CIMArgument("Job");
                outArgsPool.add(outArg1Pool);
                outArgsPool.add(inArg5Pool);
                outArgsPool.add(inArg6Pool);
                CIMArgument[] inArrayPool = new CIMArgument[inArgsPool.size()];
                inArgsPool.toArray(inArrayPool);
                CIMArgument[] outArrayPool = new CIMArgument[outArgsPool.size()];
                outArgsPool.toArray(outArrayPool);
                ret = DS6K5_2ExtrinsicMethods.createOrModifyStoragePool(storageConfigDerviceOP, inArrayPool, outArrayPool);
                if (((UnsignedInt16)ret.getValue()).intValue() != 0) continue;
                CIMObjectPath poolOp = (CIMObjectPath)outArrayPool[2].getValue().getValue();
                for (int j = 0; j < new Integer(volData[i]); ++j) {
                    Vector<CIMArgument> inArgsVol = new Vector<CIMArgument>();
                    Vector<CIMArgument> outArgsVol = new Vector<CIMArgument>();
                    String volumeName = "pool" + i + "vol" + j;
                    CIMArgument intArg1Vol = new CIMArgument("ElementName");
                    intArg1Vol.setValue(new CIMValue((Object)volumeName, CIMDataType.getPredefinedType((int)8)));
                    inArgsVol.add(intArg1Vol);
                    UnsignedInt16 inArg2ParamVol = new UnsignedInt16(2);
                    CIMArgument inArg2Vol = new CIMArgument("ElementType");
                    inArg2Vol.setValue(new CIMValue((Object)inArg2ParamVol, CIMDataType.getPredefinedType((int)2)));
                    inArgsVol.add(inArg2Vol);
                    CIMArgument inArg3Vol = new CIMArgument("Goal");
                    inArgsVol.add(inArg3Vol);
                    CIMArgument inArg4Vol = new CIMArgument("InPool");
                    inArg4Vol.setValue(new CIMValue((Object)poolOp, new CIMDataType(poolOp.getObjectName())));
                    inArgsVol.add(inArg4Vol);
                    UnsignedInt64 inArg5ParamVol = new UnsignedInt64(STANDARD_VOL_SIZE);
                    CIMArgument inArg5Vol = new CIMArgument("Size");
                    inArg5Vol.setValue(new CIMValue((Object)inArg5ParamVol, CIMDataType.getPredefinedType((int)6)));
                    inArgsVol.add(inArg5Vol);
                    CIMArgument outArg1Vol = new CIMArgument("Job");
                    outArgsVol.add(outArg1Vol);
                    outArgsVol.add(inArg5Vol);
                    CIMArgument outArg2Vol = new CIMArgument("TheElement");
                    outArg2Vol.setType(CIMDataType.getPredefinedType((int)29));
                    outArgsVol.add(outArg2Vol);
                    CIMArgument[] inArrayVol = new CIMArgument[inArgsVol.size()];
                    inArgsVol.toArray(inArrayVol);
                    CIMArgument[] outArrayVol = new CIMArgument[outArgsVol.size()];
                    outArgsVol.toArray(outArrayVol);
                    DS6K5_2ExtrinsicMethods.createOrModifyElementFromStoragePool(storageConfigDerviceOP, inArrayVol, outArrayVol);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private CIMObjectPath getDefaultHardwareIDOp(String storageSystemName, String storageID) {
        CIMObjectPath hardwareIDOp = new CIMObjectPath();
        hardwareIDOp.setObjectName("IBMTSDS_StorageHardwareID");
        hardwareIDOp.setNameSpace(NAMESPACE_ROOT_IBM);
        CIMProperty cimProperty = new CIMProperty("InstanceID");
        cimProperty.setName("InstanceID");
        cimProperty.setType(CIMDataType.getPredefinedType((int)8));
        cimProperty.setKey(true);
        String instanceIDValue = "IBMTSDS:IBM." + storageSystemName + "-" + storageID + "-1";
        cimProperty.setValue(new CIMValue((Object)instanceIDValue));
        Vector<CIMProperty> propVector = new Vector<CIMProperty>();
        propVector.add(cimProperty);
        hardwareIDOp.setKeys(propVector);
        return hardwareIDOp;
    }

    private Object getInstanceFromMap(DataGeneratorResponse rootCimv2Response, String className, int classNo) {
        Set ketSet = rootCimv2Response.getInstanceMap().keySet();
        Map instanceMap = rootCimv2Response.getInstanceMap();
        Iterator itertor = ketSet.iterator();
        CIMInstance retInst = null;
        while (itertor.hasNext()) {
            Object simInst = itertor.next();
            String simClass = simInst.toString();
            Object instance = instanceMap.get(simClass);
            String classname = simClass.substring(simClass.indexOf(58) + 1);
            if (!classname.equals(className) || null == instance) continue;
            if (instance instanceof List) {
                List Tinstance = (List)instance;
                retInst = (CIMInstance)Tinstance.get(classNo - 1);
                break;
            }
            retInst = (CIMInstance)instance;
            break;
        }
        return retInst;
    }

    public static void main(String[] args) {
        DS6K5_2CimomDataGenerator test = new DS6K5_2CimomDataGenerator();
        test.generateData(null);
    }
}

