/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.simulator.cimom.DS8K;

import java.io.FileInputStream;
import java.net.InetAddress;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.wbem.cim.CIMDataType;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.cim.UnsignedInt16;
import javax.wbem.cim.UnsignedInt32;
import javax.wbem.cim.UnsignedInt64;
import javax.wbem.cim.UnsignedInt8;
import org.eclipse.aperi.simulator.SimulatorConfig;
import org.eclipse.aperi.simulator.cimom.common.IDGenerator;

public class DS8KCIMOMDataGenerator {
    public static final String CONFIG_FILE = "c:\\DRPlanner\\Simulator\\conf\\DS8K-requirement.config";
    private static final int NUM_CLUSTERS = 2;
    private static final int NUM_FCPORTS = 16;
    private static final int NUM_PHYSICAL_PACKAGE = 4;
    private static final int NUM_STORAGE_PROCESSOR_CARD = 2;
    private static final int NUM_STORAGE_CLIENT_SETTING_DATA = 33;
    private String subsystemName = null;
    private String subsystemNameWithModel = null;
    private String ipAddressCIMOM = null;
    private String ipAddressSubsystem = null;
    private String wwn = null;
    private String machineSignature = null;
    private String[] hostAdapters = null;
    private String[] deviceAdapters = null;
    private String pools = null;
    private String extents = null;
    private String volumes = null;

    public DS8KCIMOMDataGenerator() throws Exception {
        this.initialize();
        CIMInstance ibmtsessStorageSystemInst = this.get_ibmtsess_storage_system();
        System.out.println("Instance = " + ibmtsessStorageSystemInst);
        this.populateProfiles(ibmtsessStorageSystemInst);
    }

    private void initialize() throws Exception {
        this.subsystemName = IDGenerator.generateStorageSystemName(1);
        this.subsystemNameWithModel = IDGenerator.generateStorageSystemNameWithModel(this.subsystemName);
        this.ipAddressCIMOM = IDGenerator.generateIPAddress(20);
        this.ipAddressSubsystem = IDGenerator.generateIPAddress(20);
        this.wwn = IDGenerator.generateWWN();
        this.machineSignature = IDGenerator.generateMachineSignature(1);
        this.hostAdapters = IDGenerator.generateHostAdapters(4);
        this.deviceAdapters = new String[2];
        this.deviceAdapters[0] = this.hostAdapters[0];
        this.deviceAdapters[0] = this.deviceAdapters[0].substring(0, this.deviceAdapters[0].length() - 1) + "3";
        this.deviceAdapters[1] = this.hostAdapters[1];
        this.deviceAdapters[1] = this.deviceAdapters[1].substring(0, this.deviceAdapters[1].length() - 1) + "6";
        Properties props = new Properties();
        props.load(new FileInputStream(CONFIG_FILE));
        String subsystemType = props.getProperty("SUBSYSTEM");
        if (subsystemType != null && subsystemType.equals("DS8K")) {
            this.pools = props.getProperty("STORAGE_POOLS");
            this.extents = props.getProperty("STORAGE_EXTENTS");
            this.volumes = props.getProperty("STORAGE_VOLUMES");
            System.out.println("p=" + this.pools + ", e=" + this.extents + ", v=" + this.volumes);
        }
    }

    private void populateProfiles(CIMInstance cimInstanceStorageSystem) throws Exception {
        int idx;
        CIMInstance ibmtsRegProfInst = this.get_ibmts_registered_profile();
        System.out.println("Instance = " + ibmtsRegProfInst);
        CIMInstance ibmtsessRegProfInst = this.get_ibmtsess_registered_profile();
        System.out.println("Instance = " + ibmtsessRegProfInst);
        CIMInstance[] ibmtsessRegSubProfInsts = this.get_ibmtsess_registered_sub_profile();
        for (int idx2 = 0; idx2 < ibmtsessRegSubProfInsts.length; ++idx2) {
            System.out.println("Instance = " + ibmtsessRegSubProfInsts[idx2]);
        }
        CIMInstance ibmtsObjectManagerInst = this.get_ibmts_object_manager();
        System.out.println("Instance = " + ibmtsObjectManagerInst);
        CIMInstance ibmtsNamespaceInst = this.get_ibmts_namespace();
        System.out.println("Instance = " + ibmtsNamespaceInst);
        CIMInstance ibmtsAccountInst = this.get_ibmts_account();
        System.out.println("Instance = " + ibmtsAccountInst);
        CIMInstance ibmtsAccountManagementServiceInst = this.get_ibmts_account_management_service();
        System.out.println("Instance = " + ibmtsAccountManagementServiceInst);
        CIMInstance ibmtsSystemInst = this.get_ibmts_system();
        System.out.println("Instance = " + ibmtsSystemInst);
        CIMInstance ibmtsCertificateInst = this.get_ibmts_certificate();
        System.out.println("Instance = " + ibmtsCertificateInst);
        if (ibmtsCertificateInst != null) {
            // empty if block
        }
        CIMInstance ibmtsCertificateSettingInst = this.get_certificate_setting();
        System.out.println("Instance = " + ibmtsCertificateSettingInst);
        CIMInstance ibmtsCcommunicationMechInst = this.get_cimxml_communication_mechanism();
        System.out.println("Instance = " + ibmtsCcommunicationMechInst);
        CIMInstance[] ibmtsIndicationFilterInsts = this.get_indication_filter();
        for (int idx3 = 0; idx3 < ibmtsIndicationFilterInsts.length; ++idx3) {
            System.out.println("Instance = " + ibmtsIndicationFilterInsts[idx3]);
        }
        CIMInstance ibmtsTruststoreInst = this.get_ibmts_truststore();
        System.out.println("Instance = " + ibmtsTruststoreInst);
        if (ibmtsTruststoreInst != null) {
            // empty if block
        }
        CIMInstance ibmtsTruststoreMgmtSvcInst = this.get_ibmts_truststore_management_service();
        System.out.println("Instance = " + ibmtsTruststoreMgmtSvcInst);
        if (ibmtsTruststoreMgmtSvcInst != null) {
            // empty if block
        }
        CIMInstance ibmtsessProviderInst = this.get_ibmtsess_provider();
        System.out.println("Instance = " + ibmtsessProviderInst);
        if (ibmtsessProviderInst != null) {
            // empty if block
        }
        CIMInstance ibmtsNamespaceInManagerInst = this.get_ibmts_namespace_in_manager(ibmtsObjectManagerInst, ibmtsNamespaceInst);
        System.out.println("Instance = " + ibmtsNamespaceInManagerInst);
        if (ibmtsNamespaceInManagerInst != null) {
            // empty if block
        }
        CIMInstance ibmtsAccountManagementServiceForSystemInst = this.get_ibmts_account_management_service_for_system(ibmtsAccountManagementServiceInst, ibmtsObjectManagerInst);
        System.out.println("Instance = " + ibmtsAccountManagementServiceForSystemInst);
        if (ibmtsAccountManagementServiceForSystemInst != null) {
            // empty if block
        }
        CIMInstance ibmtsAccountOnCIMOMInst = this.get_ibmts_account_on_cimom(ibmtsObjectManagerInst, ibmtsAccountInst);
        System.out.println("Instance = " + ibmtsAccountOnCIMOMInst);
        if (ibmtsAccountOnCIMOMInst != null) {
            // empty if block
        }
        CIMInstance ibmtsCommMechanismForManagerInst = this.get_ibmts_comm_mechanism_for_manager(ibmtsObjectManagerInst, ibmtsCcommunicationMechInst);
        System.out.println("Instance = " + ibmtsCommMechanismForManagerInst);
        if (ibmtsCommMechanismForManagerInst != null) {
            // empty if block
        }
        CIMInstance ibmtsHostedAccessPointInst = this.get_ibmts_hosted_access_point(ibmtsSystemInst, ibmtsCcommunicationMechInst);
        System.out.println("Instance = " + ibmtsHostedAccessPointInst);
        if (ibmtsHostedAccessPointInst != null) {
            // empty if block
        }
        CIMInstance ibmtsElementConformsToProfileInst = this.get_ibmts_element_conforms_to_profile(ibmtsRegProfInst, ibmtsObjectManagerInst);
        System.out.println("Instance = " + ibmtsElementConformsToProfileInst);
        if (ibmtsElementConformsToProfileInst != null) {
            // empty if block
        }
        CIMInstance ibmtsHostedServiceInst = this.get_ibmts_hosted_service(ibmtsSystemInst, ibmtsObjectManagerInst);
        System.out.println("Instance = " + ibmtsHostedServiceInst);
        if (ibmtsHostedServiceInst != null) {
            // empty if block
        }
        for (idx = 0; idx < ibmtsIndicationFilterInsts.length; ++idx) {
            CIMInstance ibmtsIndicationFiltersConformsToProfileInst = this.get_ibmts_indication_filters_conforms_to_profile(ibmtsRegProfInst, ibmtsIndicationFilterInsts[idx]);
            System.out.println("Instance = " + ibmtsIndicationFiltersConformsToProfileInst);
            if (ibmtsIndicationFiltersConformsToProfileInst == null) continue;
        }
        for (idx = 0; idx < ibmtsessRegSubProfInsts.length; ++idx) {
            CIMInstance ibmtsessSubProfileRequiresProfileInst = this.get_ibmtsess_sub_profile_requires_profile(ibmtsessRegProfInst, ibmtsessRegSubProfInsts[idx]);
            System.out.println("Instance = " + ibmtsessSubProfileRequiresProfileInst);
            if (ibmtsessSubProfileRequiresProfileInst == null) continue;
        }
        CIMInstance[] ibmtsessStorageClusterInsts = new CIMInstance[2];
        for (int idx4 = 0; idx4 < 2; ++idx4) {
            String clusterID = "";
            switch (idx4) {
                case 0: {
                    clusterID = "00";
                    break;
                }
                case 1: {
                    clusterID = "01";
                }
            }
            ibmtsessStorageClusterInsts[idx4] = this.get_ibmtsess_storage_cluster(clusterID);
            System.out.println("Instance = " + ibmtsessStorageClusterInsts[idx4]);
        }
        CIMInstance[] ibmtsessComponentCSInsts = new CIMInstance[2];
        for (int idx5 = 0; idx5 < 2; ++idx5) {
            ibmtsessComponentCSInsts[idx5] = this.get_ibmtsess_component_cs(cimInstanceStorageSystem, ibmtsessStorageClusterInsts[idx5]);
            System.out.println("Instance = " + ibmtsessComponentCSInsts[idx5]);
        }
        CIMInstance[] ibmtsessFCPortInsts = new CIMInstance[16];
        for (int idx6 = 0; idx6 < 16; ++idx6) {
            ibmtsessFCPortInsts[idx6] = this.get_ibmtsess_fcport(idx6);
            System.out.println("Instance = " + ibmtsessFCPortInsts[idx6]);
        }
        CIMInstance ibmtsessProductInst = this.get_ibmtsess_product();
        System.out.println("Instance = " + ibmtsessProductInst);
        CIMInstance ibmtsessChassisInst = this.get_ibmtsess_chassis();
        System.out.println("Instance = " + ibmtsessChassisInst);
        CIMInstance ibmtsessLocationInst = this.get_ibmtsess_location();
        System.out.println("Instance = " + ibmtsessLocationInst);
        CIMInstance[] ibmtsessPhysicalPackageInsts = new CIMInstance[4];
        for (int idx7 = 0; idx7 < 4; ++idx7) {
            ibmtsessPhysicalPackageInsts[idx7] = this.get_ibmtsess_physical_package(idx7);
            System.out.println("Instance = " + ibmtsessPhysicalPackageInsts[idx7]);
        }
        CIMInstance ibmtsessSoftwareIdentityInst = this.get_ibmtsess_software_identity();
        System.out.println("Instance = " + ibmtsessSoftwareIdentityInst);
        CIMInstance ibmtsessComputerSystemPackageInst = this.get_ibmtsess_computer_system_package(ibmtsessChassisInst, cimInstanceStorageSystem);
        System.out.println("Instance = " + ibmtsessComputerSystemPackageInst);
        CIMInstance[] ibmtsessStorageProcessorCardInsts = new CIMInstance[2];
        for (int idx8 = 0; idx8 < 2; ++idx8) {
            ibmtsessStorageProcessorCardInsts[idx8] = this.get_ibmtsess_storage_processor_card(idx8);
            System.out.println("Instance = " + ibmtsessStorageProcessorCardInsts[idx8]);
        }
        CIMInstance[] ibmtsessComputerSystemPackageCardInsts = new CIMInstance[2];
        for (int idx9 = 0; idx9 < 2; ++idx9) {
            ibmtsessComputerSystemPackageCardInsts[idx9] = this.get_ibmtsess_computer_system_package_card(ibmtsessStorageProcessorCardInsts[idx9], cimInstanceStorageSystem);
            System.out.println("Instance = " + ibmtsessStorageProcessorCardInsts[idx9]);
        }
        CIMInstance[] ibmtsessComputerSystemPhysicalPackageInsts = new CIMInstance[4];
        for (int idx10 = 0; idx10 < 4; ++idx10) {
            ibmtsessComputerSystemPhysicalPackageInsts[idx10] = this.get_ibmtsess_computer_system_physical_package(ibmtsessPhysicalPackageInsts[idx10], cimInstanceStorageSystem);
            System.out.println("Instance = " + ibmtsessComputerSystemPhysicalPackageInsts[idx10]);
        }
        CIMInstance ibmtsessControllerConfigurationSvcInst = this.get_ibmtsess_controller_configuration_service();
        System.out.println("Instance = " + ibmtsessControllerConfigurationSvcInst);
        CIMInstance ibmtsessDeviceMaskingCapabilitiesInst = this.get_ibmtsess_device_masking_capabilities();
        System.out.println("Instance = " + ibmtsessDeviceMaskingCapabilitiesInst);
        CIMInstance[] ibmtsessStorageSystemToPortInsts = new CIMInstance[16];
        for (int idx11 = 0; idx11 < 16; ++idx11) {
            ibmtsessStorageSystemToPortInsts[idx11] = this.get_ibmtsess_storage_system_to_port(cimInstanceStorageSystem, ibmtsessFCPortInsts[idx11]);
            System.out.println("Instance = " + ibmtsessStorageSystemToPortInsts[idx11]);
        }
        CIMInstance ibmtsessStorageCapabilitiesInst = this.get_ibmtsess_storage_capabilities();
        System.out.println("Instance = " + ibmtsessStorageCapabilitiesInst);
        CIMInstance[] ibmtsessStorageClientSettingDataInsts = new CIMInstance[33];
        for (int idx12 = 0; idx12 < 33; ++idx12) {
            ibmtsessStorageClientSettingDataInsts[idx12] = this.get_ibmtsess_storage_client_setting_data(idx12);
            System.out.println("Instance = " + ibmtsessStorageClientSettingDataInsts[idx12]);
        }
        CIMInstance ibmtsessElementCapabilitiesMaskingInst = this.get_ibmtsess_element_capabilities_masking(ibmtsessDeviceMaskingCapabilitiesInst, ibmtsessControllerConfigurationSvcInst);
        System.out.println("Instance = " + ibmtsessElementCapabilitiesMaskingInst);
        CIMInstance ibmtsessElementConformsToProfileInst = this.get_ibmtsess_element_conforms_to_profile(ibmtsessRegProfInst, cimInstanceStorageSystem);
        System.out.println("Instance = " + ibmtsessElementCapabilitiesMaskingInst);
        CIMInstance ibmtsessRemoteServiceAccessPointInst = this.get_ibmtsess_remote_service_access_point();
        System.out.println("Instance = " + ibmtsessRemoteServiceAccessPointInst);
        CIMInstance ibmtsessHostedAccessPointInst = this.get_ibmtsess_hosted_access_point(ibmtsSystemInst, ibmtsessRemoteServiceAccessPointInst);
        System.out.println("Instance = " + ibmtsessHostedAccessPointInst);
        CIMInstance ibmtsessStorageConfigurationServiceInst = this.get_ibmtsess_storage_configuration_service();
        System.out.println("Instance = " + ibmtsessStorageConfigurationServiceInst);
        CIMInstance ibmtsessHostedServiceInst = this.get_ibmtsess_hosted_service(cimInstanceStorageSystem, ibmtsessStorageConfigurationServiceInst);
        System.out.println("Instance = " + ibmtsessHostedAccessPointInst);
        CIMInstance ibmtsessLunMaskPrivilegeServiceInst = this.get_ibmtsess_lun_mask_privilege_service();
        System.out.println("Instance = " + ibmtsessLunMaskPrivilegeServiceInst);
        CIMInstance ibmtsessHostedService2Inst = this.get_ibmtsess_hosted_service2(cimInstanceStorageSystem, ibmtsessLunMaskPrivilegeServiceInst);
        System.out.println("Instance = " + ibmtsessHostedService2Inst);
        CIMInstance ibmtsessPerformanceStatisticsServiceInst = this.get_ibmtsess_performance_statistics_service();
        System.out.println("Instance = " + ibmtsessPerformanceStatisticsServiceInst);
        CIMInstance ibmtsessStorageConfigurationCapabilitiesInst = this.get_ibmtsess_storage_configuration_capabilities();
        System.out.println("Instance = " + ibmtsessStorageConfigurationCapabilitiesInst);
        CIMInstance ibmtsessStorageHardwareIDManagementSvcInst = this.get_ibmtsess_storage_hardware_id_management_service();
        System.out.println("Instance = " + ibmtsessStorageHardwareIDManagementSvcInst);
        CIMInstance ibmtsessStgConfigSrvEltCapabilitiesInst = this.get_ibmtsess_stg_config_srv_elt_capabilities(ibmtsessStorageConfigurationCapabilitiesInst, ibmtsessStorageConfigurationServiceInst);
        System.out.println("Instance = " + ibmtsessStgConfigSrvEltCapabilitiesInst);
        CIMInstance ibmtsessHostedService3Inst = this.get_ibmtsess_hosted_service3(cimInstanceStorageSystem, ibmtsessStorageHardwareIDManagementSvcInst);
        System.out.println("Instance = " + ibmtsessHostedService3Inst);
        CIMInstance ibmtsessHostedService4Inst = this.get_ibmtsess_hosted_service4(cimInstanceStorageSystem, ibmtsessControllerConfigurationSvcInst);
        System.out.println("Instance = " + ibmtsessHostedService4Inst);
        CIMInstance ibmtsessHostedService6Inst = this.get_ibmtsess_hosted_service6(cimInstanceStorageSystem, ibmtsessPerformanceStatisticsServiceInst);
        System.out.println("Instance = " + ibmtsessHostedService6Inst);
        CIMInstance ibmtsessInstalledSoftwareIdentityInst = this.get_ibmtsess_installed_software_identity(ibmtsessSoftwareIdentityInst, cimInstanceStorageSystem);
        System.out.println("Instance = " + ibmtsessInstalledSoftwareIdentityInst);
        CIMInstance ibmtsessProtocolControllerMaskingCapabilitiesInst = this.get_ibmtsess_protocol_controller_masking_capabilities();
        System.out.println("Instance = " + ibmtsessProtocolControllerMaskingCapabilitiesInst);
        CIMInstance ibmtsesspcmEltCapabilitiesInst = this.get_ibmtsess_pcm_elt_capabilities(ibmtsessProtocolControllerMaskingCapabilitiesInst, cimInstanceStorageSystem);
        System.out.println("Instance = " + ibmtsesspcmEltCapabilitiesInst);
        CIMInstance ibmtsessProductPhysicalComponentInst = this.get_ibmtsess_product_physical_component(ibmtsessProductInst, ibmtsessChassisInst);
        System.out.println("Instance = " + ibmtsessProductPhysicalComponentInst);
        CIMInstance ibmtsessSAPAvailableForElementInst = this.get_ibmtsess_SAP_available_for_element(ibmtsessProductInst, cimInstanceStorageSystem);
        System.out.println("Instance = " + ibmtsessSAPAvailableForElementInst);
        int numExtents = this.count(this.extents);
        for (int idx1 = 0; idx1 < numExtents; ++idx1) {
            for (int idx2 = 0; idx2 < 8; ++idx2) {
                CIMInstance ibmtsessDiskDriveInst = this.get_ibmtsess_disk_drive(idx1, idx2);
                System.out.println("Instance = " + ibmtsessDiskDriveInst);
            }
            CIMInstance ibmtsessV8PackInst = this.get_ibmtsess_v8_pack(idx1);
            CIMInstance ibmtsessStorageExtentInst = this.get_ibmtsess_storage_extent(idx1);
        }
    }

    private int count(String propValue) {
        int count = 0;
        StringTokenizer stz = new StringTokenizer(propValue, " ");
        while (stz.hasMoreTokens()) {
            String[] tokens = stz.nextToken().split("\\,");
            count += tokens.length;
        }
        return count;
    }

    private CIMInstance get_ibmtsess_volume(int poolNumber, int extentNumber, int volumeNumber) throws Exception {
        CIMInstance cimInstance = new CIMInstance();
        cimInstance.setClassName("IBMTSESS_Volume");
        cimInstance.setName("IBMTSESS_Volume");
        Vector<CIMProperty> v = new Vector<CIMProperty>();
        int NUM_PROPERTIES = 59;
        CIMProperty[] props = new CIMProperty[NUM_PROPERTIES];
        props[0] = new CIMProperty("Access");
        props[0].setName("Access");
        props[0].setType(CIMDataType.getPredefinedType((int)2));
        Object prop0Val = null;
        props[0].setValue(new CIMValue(prop0Val));
        props[1] = new CIMProperty("AdditionalAvailability");
        props[1].setName("AdditionalAvailability");
        props[1].setType(CIMDataType.getPredefinedType((int)16));
        Vector prop1Val = new Vector();
        props[1].setValue(new CIMValue(prop1Val));
        props[2] = new CIMProperty("Availability");
        props[2].setName("Availability");
        props[2].setType(CIMDataType.getPredefinedType((int)2));
        Object prop2Val = null;
        props[2].setValue(new CIMValue(prop2Val));
        props[3] = new CIMProperty("BlockSize");
        props[3].setName("BlockSize");
        props[3].setType(CIMDataType.getPredefinedType((int)6));
        UnsignedInt64 prop3Val = new UnsignedInt64("512");
        props[3].setValue(new CIMValue((Object)prop3Val));
        props[4] = new CIMProperty("Caption");
        props[4].setName("Caption");
        props[4].setType(CIMDataType.getPredefinedType((int)8));
        Object prop4Val = null;
        props[4].setValue(new CIMValue(prop4Val));
        props[5] = new CIMProperty("ConfigState");
        props[5].setName("ConfigState");
        props[5].setType(CIMDataType.getPredefinedType((int)8));
        String prop5Val = "Normal";
        props[5].setValue(new CIMValue((Object)prop5Val));
        props[6] = new CIMProperty("ConsumableBlocks");
        props[6].setName("ConsumableBlocks");
        props[6].setType(CIMDataType.getPredefinedType((int)6));
        UnsignedInt64 prop6Val = new UnsignedInt64("0");
        props[6].setValue(new CIMValue((Object)prop6Val));
        props[7] = new CIMProperty("Controlled");
        props[7].setName("Controlled");
        props[7].setType(CIMDataType.getPredefinedType((int)9));
        Boolean prop7Val = new Boolean(true);
        props[7].setValue(new CIMValue((Object)prop7Val));
        props[8] = new CIMProperty("CreationClassName");
        props[8].setName("CreationClassName");
        props[8].setType(CIMDataType.getPredefinedType((int)8));
        props[8].setKey(true);
        props[8].setValue(new CIMValue((Object)"IBMTSESS_Volume"));
        props[9] = new CIMProperty("DataOrganization");
        props[9].setName("DataOrganization");
        props[9].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 prop9Val = new UnsignedInt16(2);
        props[9].setValue(new CIMValue((Object)prop9Val));
        props[10] = new CIMProperty("DataRedundancy");
        props[10].setName("DataRedundancy");
        props[10].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 prop10Val = new UnsignedInt16(1);
        props[10].setValue(new CIMValue((Object)prop10Val));
        props[11] = new CIMProperty("DeltaReservation");
        props[11].setName("DeltaReservation");
        props[11].setType(CIMDataType.getPredefinedType((int)0));
        UnsignedInt8 port11Val = new UnsignedInt8("100");
        props[11].setValue(new CIMValue((Object)port11Val));
        props[12] = new CIMProperty("DataState");
        props[12].setName("DataState");
        props[12].setType(CIMDataType.getPredefinedType((int)8));
        String prop12Val = "Normal";
        props[12].setValue(new CIMValue((Object)prop12Val));
        props[13] = new CIMProperty("DeltaReservation");
        props[13].setName("DeltaReservation");
        props[13].setType(CIMDataType.getPredefinedType((int)0));
        UnsignedInt8 prop13Val = new UnsignedInt8("100");
        props[13].setValue(new CIMValue((Object)prop13Val));
        props[14] = new CIMProperty("Description");
        props[14].setName("Description");
        props[14].setType(CIMDataType.getPredefinedType((int)8));
        Object prop14Val = null;
        props[14].setValue(new CIMValue(prop14Val));
        props[15] = new CIMProperty("DeviceID");
        props[15].setName("DeviceID");
        props[15].setType(CIMDataType.getPredefinedType((int)8));
        props[15].setKey(true);
        String prop15Val = Integer.toString(volumeNumber);
        props[15].setValue(new CIMValue((Object)prop15Val));
        props[16] = new CIMProperty("ElementName");
        props[16].setName("ElementName");
        props[16].setType(CIMDataType.getPredefinedType((int)8));
        String prop16Val = Integer.toString(poolNumber) + Integer.toString(volumeNumber);
        props[16].setValue(new CIMValue((Object)prop16Val));
        props[17] = new CIMProperty("EnabledDefault");
        props[17].setName("EnabledDefault");
        props[17].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 prop17Val = new UnsignedInt16(2);
        props[17].setValue(new CIMValue((Object)prop17Val));
        props[18] = new CIMProperty("EnabledState");
        props[18].setName("EnabledState");
        props[18].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 prop18Val = new UnsignedInt16(2);
        props[18].setValue(new CIMValue((Object)prop18Val));
        props[19] = new CIMProperty("ErrorCleared");
        props[19].setName("ErrorCleared");
        props[19].setType(CIMDataType.getPredefinedType((int)9));
        Object prop19Val = null;
        props[19].setValue(new CIMValue(prop19Val));
        props[20] = new CIMProperty("ErrorDescription");
        props[20].setName("ErrorDescription");
        props[20].setType(CIMDataType.getPredefinedType((int)16));
        Object prop20Val = null;
        props[20].setValue(new CIMValue(prop20Val));
        props[21] = new CIMProperty("ErrorMethodology");
        props[21].setName("ErrorMethodology");
        props[21].setType(CIMDataType.getPredefinedType((int)8));
        Object prop21Val = null;
        props[21].setValue(new CIMValue(prop21Val));
        props[22] = new CIMProperty("ExtentStatus");
        props[22].setName("ExtentStatus");
        props[22].setType(CIMDataType.getPredefinedType((int)16));
        Vector<UnsignedInt16> prop22V = new Vector<UnsignedInt16>();
        prop22V.add(new UnsignedInt16(2));
        props[22].setValue(new CIMValue(prop22V));
        props[23] = new CIMProperty("IdentifyingDescriptions");
        props[23].setName("IdentifyingDescriptions");
        props[23].setType(CIMDataType.getPredefinedType((int)22));
        Vector<String> prop23V = new Vector<String>();
        prop23V.add("Serial");
        props[23].setValue(new CIMValue(prop23V));
        props[24] = new CIMProperty("InstallDate");
        props[24].setName("InstallDate");
        props[24].setType(CIMDataType.getPredefinedType((int)12));
        Object prop24Val = null;
        props[24].setValue(new CIMValue(prop24Val));
        props[25] = new CIMProperty("IsBasedOnUnderlyingRedundancy");
        props[25].setName("IsBasedOnUnderlyingRedundancy");
        props[25].setType(CIMDataType.getPredefinedType((int)9));
        Boolean prop25Val = new Boolean(true);
        props[25].setValue(new CIMValue((Object)prop25Val));
        props[26] = new CIMProperty("LastErrorCode");
        props[26].setName("LastErrorCode");
        props[26].setType(CIMDataType.getPredefinedType((int)4));
        Object prop26Val = null;
        props[26].setValue(new CIMValue(prop26Val));
        props[27] = new CIMProperty("MaxQuiesceTime");
        props[27].setName("MaxQuiesceTime");
        props[27].setType(CIMDataType.getPredefinedType((int)6));
        Object prop27Val = null;
        props[27].setValue(new CIMValue(prop27Val));
        props[28] = new CIMProperty("Name");
        props[28].setName("Name");
        props[28].setType(CIMDataType.getPredefinedType((int)8));
        String prop28Val = Integer.toString(volumeNumber);
        props[28].setValue(new CIMValue((Object)prop28Val));
        props[29] = new CIMProperty("NameFormat");
        props[29].setName("NameFormat");
        props[29].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 prop29Val = new UnsignedInt16(6);
        props[29].setValue(new CIMValue((Object)prop29Val));
        props[30] = new CIMProperty("NameNamespace");
        props[30].setName("NameNamespace");
        props[30].setType(CIMDataType.getPredefinedType((int)2));
        Object prop30Val = null;
        props[30].setValue(new CIMValue(prop30Val));
        props[31] = new CIMProperty("NoSinglePointOfFailure");
        props[31].setName("NoSinglePointOfFailure");
        props[31].setType(CIMDataType.getPredefinedType((int)9));
        Boolean prop31Val = new Boolean(true);
        props[31].setValue(new CIMValue((Object)prop31Val));
        props[32] = new CIMProperty("NumberOfBlocks");
        props[32].setName("NumberOfBlocks");
        props[32].setType(CIMDataType.getPredefinedType((int)6));
        UnsignedInt64 prop32Val = new UnsignedInt64("2097152");
        props[32].setValue(new CIMValue((Object)prop32Val));
        props[33] = new CIMProperty("OperationalStatus");
        props[33].setName("OperationalStatus");
        props[33].setType(CIMDataType.getPredefinedType((int)16));
        Vector<UnsignedInt16> prop33V = new Vector<UnsignedInt16>();
        prop33V.add(new UnsignedInt16(2));
        props[33].setValue(new CIMValue(prop33V));
        props[34] = new CIMProperty("OtherEnabledState");
        props[34].setName("OtherEnabledState");
        props[34].setType(CIMDataType.getPredefinedType((int)8));
        Object prop34Val = null;
        props[34].setValue(new CIMValue(prop34Val));
        props[35] = new CIMProperty("OtherIdentifyingInfo");
        props[35].setName("OtherIdentifyingInfo");
        props[35].setType(CIMDataType.getPredefinedType((int)22));
        Vector<String> prop35V = new Vector<String>();
        prop35V.add("13002714600");
        props[35].setValue(new CIMValue(prop35V));
        props[36] = new CIMProperty("OtherNameFormat");
        props[36].setName("OtherNameFormat");
        props[36].setType(CIMDataType.getPredefinedType((int)8));
        Object prop36Val = null;
        props[36].setValue(new CIMValue(prop36Val));
        props[37] = new CIMProperty("OtherNameNamespace");
        props[37].setName("OtherNameNamespace");
        props[37].setType(CIMDataType.getPredefinedType((int)8));
        Object prop37Val = null;
        props[37].setValue(new CIMValue(prop37Val));
        props[38] = new CIMProperty("PackageRedundancy");
        props[38].setName("PackageRedundancy");
        props[38].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 prop38Val = new UnsignedInt16(1);
        props[38].setValue(new CIMValue((Object)prop38Val));
        props[39] = new CIMProperty("PowerManagementCapabilities");
        props[39].setName("PowerManagementCapabilities");
        props[39].setType(CIMDataType.getPredefinedType((int)16));
        Vector prop39V = new Vector();
        props[39].setValue(new CIMValue(prop39V));
        props[40] = new CIMProperty("PowerManagementSupported");
        props[40].setName("PowerManagementSupported");
        props[40].setType(CIMDataType.getPredefinedType((int)9));
        Object prop40Val = null;
        props[40].setValue(new CIMValue(prop40Val));
        props[41] = new CIMProperty("PowerOnHours");
        props[41].setName("PowerOnHours");
        props[41].setType(CIMDataType.getPredefinedType((int)6));
        Object prop41Val = null;
        props[41].setValue(new CIMValue(prop41Val));
        props[42] = new CIMProperty("Primordial");
        props[42].setName("Primordial");
        props[42].setType(CIMDataType.getPredefinedType((int)9));
        Boolean prop42Val = new Boolean(false);
        props[42].setValue(new CIMValue((Object)prop42Val));
        props[43] = new CIMProperty("Purpose");
        props[43].setName("Purpose");
        props[43].setType(CIMDataType.getPredefinedType((int)8));
        Object prop43Val = null;
        props[43].setValue(new CIMValue(prop43Val));
        props[44] = new CIMProperty("RequestedState");
        props[44].setName("RequestedState");
        props[44].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 prop44Val = new UnsignedInt16(2);
        props[44].setValue(new CIMValue((Object)prop44Val));
        props[45] = new CIMProperty("SequentialAccess");
        props[45].setName("SequentialAccess");
        props[45].setType(CIMDataType.getPredefinedType((int)9));
        Boolean prop45Val = new Boolean(false);
        props[45].setValue(new CIMValue((Object)prop45Val));
        props[46] = new CIMProperty("SpindleRedundancy");
        props[46].setName("SpindleRedundancy");
        props[46].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 prop46Val = new UnsignedInt16(2);
        props[46].setValue(new CIMValue((Object)prop46Val));
        props[47] = new CIMProperty("StatusDescriptions");
        props[47].setName("StatusDescriptions");
        props[47].setType(CIMDataType.getPredefinedType((int)22));
        Vector<String> prop47V = new Vector<String>();
        prop47V.add("OK");
        props[47].setValue(new CIMValue(prop47V));
        props[48] = new CIMProperty("StatusInfo");
        props[48].setName("StatusInfo");
        props[48].setType(CIMDataType.getPredefinedType((int)2));
        Object prop48Val = null;
        props[48].setValue(new CIMValue(prop48Val));
        props[49] = new CIMProperty("SystemCreationClassName");
        props[49].setName("SystemCreationClassName");
        props[49].setType(CIMDataType.getPredefinedType((int)8));
        props[49].setKey(true);
        props[49].setValue(new CIMValue((Object)"IBMTSESS_StorageSystem"));
        props[50] = new CIMProperty("SystemName");
        props[50].setName("SystemName");
        props[50].setType(CIMDataType.getPredefinedType((int)8));
        props[50].setKey(true);
        props[50].setValue(new CIMValue((Object)this.subsystemNameWithModel));
        props[51] = new CIMProperty("TimeOfLastStateChange");
        props[51].setName("TimeOfLastStateChange");
        props[51].setType(CIMDataType.getPredefinedType((int)12));
        Object prop51Val = null;
        props[51].setValue(new CIMValue((Object)this.subsystemNameWithModel));
        props[52] = new CIMProperty("TotalPowerOnHours");
        props[52].setName("TotalPowerOnHours");
        props[52].setType(CIMDataType.getPredefinedType((int)6));
        Object prop52Val = null;
        props[52].setValue(new CIMValue((Object)this.subsystemNameWithModel));
        props[53] = new CIMProperty("cap");
        props[53].setName("cap");
        props[53].setType(CIMDataType.getPredefinedType((int)10));
        Float prop53Val = new Float(1.07374182E9);
        props[53].setValue(new CIMValue((Object)prop53Val));
        props[54] = new CIMProperty("format");
        props[54].setName("format");
        props[54].setType(CIMDataType.getPredefinedType((int)8));
        String prop54Val = "Block512";
        props[54].setValue(new CIMValue((Object)prop54Val));
        props[55] = new CIMProperty("lss");
        props[55].setName("lss");
        props[55].setType(CIMDataType.getPredefinedType((int)8));
        String prop55Val = "11";
        props[55].setValue(new CIMValue((Object)prop55Val));
        props[56] = new CIMProperty("ss");
        props[56].setName("ss");
        props[56].setType(CIMDataType.getPredefinedType((int)8));
        String prop56Val = "FF11";
        props[56].setValue(new CIMValue((Object)prop56Val));
        props[57] = new CIMProperty("status");
        props[57].setName("status");
        props[57].setType(CIMDataType.getPredefinedType((int)8));
        Object prop57Val = null;
        props[57].setValue(new CIMValue(prop57Val));
        props[58] = new CIMProperty("unit");
        props[58].setName("unit");
        props[58].setType(CIMDataType.getPredefinedType((int)8));
        String prop58Val = "bytes";
        props[58].setValue(new CIMValue((Object)prop58Val));
        props[59] = new CIMProperty("vs");
        props[59].setName("vs");
        props[59].setType(CIMDataType.getPredefinedType((int)8));
        String prop59Val = "vs" + poolNumber;
        props[59].setValue(new CIMValue((Object)prop59Val));
        for (int idx = 0; idx < NUM_PROPERTIES; ++idx) {
            v.add(props[idx]);
        }
        cimInstance.setProperties(v);
        return cimInstance;
    }

    private CIMInstance get_ibmtsess_volume_space(int poolNumber) throws Exception {
        CIMInstance cimInstance = new CIMInstance();
        cimInstance.setClassName("IBMTSESS_VolumeSpace");
        cimInstance.setName("IBMTSESS_VolumeSpace");
        Vector<CIMProperty> v = new Vector<CIMProperty>();
        int NUM_PROPERTIES = 27;
        CIMProperty[] props = new CIMProperty[NUM_PROPERTIES];
        props[0] = new CIMProperty("Caption");
        props[0].setName("Caption");
        props[0].setType(CIMDataType.getPredefinedType((int)8));
        Object prop0Val = null;
        props[0].setValue(new CIMValue(prop0Val));
        props[1] = new CIMProperty("Description");
        props[1].setName("Description");
        props[1].setType(CIMDataType.getPredefinedType((int)8));
        Object prop1V = null;
        props[1].setValue(new CIMValue(prop1V));
        props[2] = new CIMProperty("ElementName");
        props[2].setName("ElementName");
        props[2].setType(CIMDataType.getPredefinedType((int)8));
        String prop2Val = "VS" + Integer.toString(poolNumber);
        props[2].setValue(new CIMValue((Object)prop2Val));
        props[3] = new CIMProperty("InstallDate");
        props[3].setName("InstallDate");
        props[3].setType(CIMDataType.getPredefinedType((int)12));
        Object prop3Val = null;
        props[3].setValue(new CIMValue(prop3Val));
        props[4] = new CIMProperty("InstanceID");
        props[4].setName("InstanceID");
        props[4].setType(CIMDataType.getPredefinedType((int)8));
        String prop4Val = this.subsystemNameWithModel + "-vs" + poolNumber;
        props[4].setValue(new CIMValue((Object)prop4Val));
        props[5] = new CIMProperty("Name");
        props[5].setName("Name");
        props[5].setType(CIMDataType.getPredefinedType((int)8));
        Object prop5Val = null;
        props[5].setValue(new CIMValue(prop5Val));
        props[6] = new CIMProperty("NumOfvols");
        props[6].setName("NumOfvols");
        props[6].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 prop6Val = new UnsignedInt16(0);
        props[6].setValue(new CIMValue((Object)prop6Val));
        props[7] = new CIMProperty("NumRanks");
        props[7].setName("NumRanks");
        props[7].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 prop7Val = new UnsignedInt16(1);
        props[7].setValue(new CIMValue((Object)"IBMTSESS_StorageExtent"));
        props[8] = new CIMProperty("OperationalStatus");
        props[8].setName("OperationalStatus");
        props[8].setType(CIMDataType.getPredefinedType((int)16));
        Vector<UnsignedInt16> prop8V = new Vector<UnsignedInt16>();
        prop8V.add(new UnsignedInt16(2));
        props[8].setValue(new CIMValue(prop8V));
        props[9] = new CIMProperty("PoolID");
        props[9].setName("PoolID");
        props[9].setType(CIMDataType.getPredefinedType((int)8));
        String prop9Val = "vs" + poolNumber;
        props[9].setValue(new CIMValue((Object)prop9Val));
        props[10] = new CIMProperty("PoolName");
        props[10].setName("PoolName");
        props[10].setType(CIMDataType.getPredefinedType((int)8));
        Object prop10Val = null;
        props[10].setValue(new CIMValue(prop10Val));
        props[11] = new CIMProperty("Primordial");
        props[11].setName("Primordial");
        props[11].setType(CIMDataType.getPredefinedType((int)9));
        Boolean port11Val = new Boolean(false);
        props[11].setValue(new CIMValue((Object)port11Val));
        props[12] = new CIMProperty("RankID");
        props[12].setName("RankID");
        props[12].setType(CIMDataType.getPredefinedType((int)22));
        Vector<String> prop12V = new Vector<String>();
        prop12V.add("0");
        props[12].setValue(new CIMValue(prop12V));
        props[13] = new CIMProperty("RemainingManagedSpace");
        props[13].setName("RemainingManagedSpace");
        props[13].setType(CIMDataType.getPredefinedType((int)6));
        Object prop13Val = null;
        props[13].setValue(new CIMValue(prop13Val));
        props[14] = new CIMProperty("ReservedManagedSpace");
        props[14].setName("ReservedManagedSpace");
        props[14].setType(CIMDataType.getPredefinedType((int)6));
        UnsignedInt64 prop14Val = new UnsignedInt64("0");
        props[14].setValue(new CIMValue((Object)prop14Val));
        props[15] = new CIMProperty("Status");
        props[15].setName("Status");
        props[15].setType(CIMDataType.getPredefinedType((int)8));
        String prop15Val = "Operational";
        props[15].setValue(new CIMValue((Object)prop15Val));
        props[16] = new CIMProperty("StatusDescriptions");
        props[16].setName("StatusDescriptions");
        props[16].setType(CIMDataType.getPredefinedType((int)22));
        Vector prop16V = new Vector();
        props[16].setValue(new CIMValue(prop16V));
        props[17] = new CIMProperty("StorageType");
        props[17].setName("StorageType");
        props[17].setType(CIMDataType.getPredefinedType((int)8));
        String prop17Val = "FB";
        props[17].setValue(new CIMValue((Object)prop17Val));
        props[18] = new CIMProperty("SystemName");
        props[18].setName("SystemName");
        props[18].setType(CIMDataType.getPredefinedType((int)8));
        props[18].setValue(new CIMValue((Object)this.subsystemNameWithModel));
        props[19] = new CIMProperty("TotalManagedSpace");
        props[19].setName("TotalManagedSpace");
        props[19].setType(CIMDataType.getPredefinedType((int)6));
        UnsignedInt64 prop19Val = new UnsignedInt64("1254130450432");
        props[19].setValue(new CIMValue((Object)prop19Val));
        props[20] = new CIMProperty("basedon");
        props[20].setName("basedon");
        props[20].setType(CIMDataType.getPredefinedType((int)22));
        Vector prop20V = new Vector();
        props[20].setValue(new CIMValue(prop20V));
        props[21] = new CIMProperty("format");
        props[21].setName("format");
        props[21].setType(CIMDataType.getPredefinedType((int)8));
        String prop21Val = "FB";
        props[21].setValue(new CIMValue((Object)prop21Val));
        props[22] = new CIMProperty("logicalCap");
        props[22].setName("logicalCap");
        props[22].setType(CIMDataType.getPredefinedType((int)6));
        UnsignedInt64 prop22Val = new UnsignedInt64("836444880896");
        props[22].setValue(new CIMValue((Object)prop22Val));
        props[23] = new CIMProperty("logicalFree");
        props[23].setName("logicalFree");
        props[23].setType(CIMDataType.getPredefinedType((int)6));
        UnsignedInt64 prop23Val = new UnsignedInt64("4294967296");
        props[23].setValue(new CIMValue((Object)prop23Val));
        props[24] = new CIMProperty("lss");
        props[24].setName("lss");
        props[24].setType(CIMDataType.getPredefinedType((int)8));
        Object prop24Val = null;
        props[24].setValue(new CIMValue(prop24Val));
        props[25] = new CIMProperty("redundancy");
        props[25].setName("redundancy");
        props[25].setType(CIMDataType.getPredefinedType((int)22));
        Vector<String> prop25V = new Vector<String>();
        prop25V.add("raid5");
        props[25].setValue(new CIMValue(prop25V));
        props[26] = new CIMProperty("ssID");
        props[26].setName("ssID");
        props[26].setType(CIMDataType.getPredefinedType((int)8));
        String prop26Val = "";
        props[26].setValue(new CIMValue((Object)prop26Val));
        for (int idx = 0; idx < NUM_PROPERTIES; ++idx) {
            v.add(props[idx]);
        }
        cimInstance.setProperties(v);
        return cimInstance;
    }

    private CIMInstance get_ibmtsess_storage_extent(int extentNumber) throws Exception {
        CIMInstance cimInstance = new CIMInstance();
        cimInstance.setClassName("IBMTSESS_StorageExtent");
        cimInstance.setName("IBMTSESS_StorageExtent");
        Vector<CIMProperty> v = new Vector<CIMProperty>();
        int NUM_PROPERTIES = 54;
        CIMProperty[] props = new CIMProperty[NUM_PROPERTIES];
        props[0] = new CIMProperty("Access");
        props[0].setName("Access");
        props[0].setType(CIMDataType.getPredefinedType((int)2));
        Object prop0Val = null;
        props[0].setValue(new CIMValue(prop0Val));
        props[1] = new CIMProperty("AdditionalAvailability");
        props[1].setName("AdditionalAvailability");
        props[1].setType(CIMDataType.getPredefinedType((int)16));
        Vector prop1V = new Vector();
        props[1].setValue(new CIMValue(prop1V));
        props[2] = new CIMProperty("ArrayIDs");
        props[2].setName("ArrayIDs");
        props[2].setType(CIMDataType.getPredefinedType((int)22));
        Vector<String> prop2V = new Vector<String>();
        prop2V.add(Integer.toString(extentNumber));
        props[2].setValue(new CIMValue(prop2V));
        props[3] = new CIMProperty("Availability");
        props[3].setName("Availability");
        props[3].setType(CIMDataType.getPredefinedType((int)2));
        Object prop3Val = null;
        props[3].setValue(new CIMValue(prop3Val));
        props[4] = new CIMProperty("BlockSize");
        props[4].setName("BlockSize");
        props[4].setType(CIMDataType.getPredefinedType((int)6));
        UnsignedInt64 prop4Val = new UnsignedInt64("1");
        props[4].setValue(new CIMValue((Object)prop4Val));
        props[5] = new CIMProperty("Caption");
        props[5].setName("Caption");
        props[5].setType(CIMDataType.getPredefinedType((int)8));
        Object prop5Val = null;
        props[5].setValue(new CIMValue(prop5Val));
        props[6] = new CIMProperty("ConsumableBlocks");
        props[6].setName("ConsumableBlocks");
        props[6].setType(CIMDataType.getPredefinedType((int)6));
        UnsignedInt64 prop6Val = new UnsignedInt64("0");
        props[6].setValue(new CIMValue((Object)prop6Val));
        props[7] = new CIMProperty("CreationClassName");
        props[7].setName("CreationClassName");
        props[7].setType(CIMDataType.getPredefinedType((int)8));
        props[7].setKey(true);
        props[7].setValue(new CIMValue((Object)"IBMTSESS_StorageExtent"));
        props[8] = new CIMProperty("DAPairs");
        props[8].setName("DAPairs");
        props[8].setType(CIMDataType.getPredefinedType((int)8));
        Vector<String> prop8V = new Vector<String>();
        prop8V.add(Integer.toString(extentNumber));
        props[8].setValue(new CIMValue(prop8V));
        props[9] = new CIMProperty("DataOrganization");
        props[9].setName("DataOrganization");
        props[9].setType(CIMDataType.getPredefinedType((int)2));
        Object prop9Val = null;
        props[9].setValue(new CIMValue(prop9Val));
        props[10] = new CIMProperty("DataRedundancy");
        props[10].setName("DataRedundancy");
        props[10].setType(CIMDataType.getPredefinedType((int)2));
        Object prop10Val = null;
        props[10].setValue(new CIMValue(prop10Val));
        props[11] = new CIMProperty("DeltaReservation");
        props[11].setName("DeltaReservation");
        props[11].setType(CIMDataType.getPredefinedType((int)0));
        Object port11Val = null;
        props[11].setValue(new CIMValue(port11Val));
        props[12] = new CIMProperty("Description");
        props[12].setName("Description");
        props[12].setType(CIMDataType.getPredefinedType((int)8));
        Object prop12Val = null;
        props[12].setValue(new CIMValue(prop12Val));
        props[13] = new CIMProperty("DeviceID");
        props[13].setName("DeviceID");
        props[13].setType(CIMDataType.getPredefinedType((int)8));
        props[13].setKey(true);
        props[13].setValue(new CIMValue((Object)Integer.toString(extentNumber)));
        props[14] = new CIMProperty("ElementName");
        props[14].setName("ElementName");
        props[14].setType(CIMDataType.getPredefinedType((int)8));
        String prop14Val = "Rank " + Integer.toString(extentNumber);
        props[14].setValue(new CIMValue((Object)prop14Val));
        props[15] = new CIMProperty("EnabledDefault");
        props[15].setName("EnabledDefault");
        props[15].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 prop15Val = new UnsignedInt16(2);
        props[15].setValue(new CIMValue((Object)prop15Val));
        props[16] = new CIMProperty("EnabledState");
        props[16].setName("EnabledState");
        props[16].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 prop16Val = new UnsignedInt16(5);
        props[16].setValue(new CIMValue((Object)prop16Val));
        props[17] = new CIMProperty("ErrorCleared");
        props[17].setName("ErrorCleared");
        props[17].setType(CIMDataType.getPredefinedType((int)9));
        Object prop17Val = null;
        props[17].setValue(new CIMValue(prop17Val));
        props[18] = new CIMProperty("ErrorDescription");
        props[18].setName("ErrorDescription");
        props[18].setType(CIMDataType.getPredefinedType((int)8));
        Object prop18Val = null;
        props[18].setValue(new CIMValue(prop18Val));
        props[19] = new CIMProperty("ErrorMethodology");
        props[19].setName("ErrorMethodology");
        props[19].setType(CIMDataType.getPredefinedType((int)8));
        Object prop19Val = null;
        props[19].setValue(new CIMValue(prop19Val));
        props[20] = new CIMProperty("ExtentStatus");
        props[20].setName("ExtentStatus");
        props[20].setType(CIMDataType.getPredefinedType((int)16));
        Vector<UnsignedInt16> prop20V = new Vector<UnsignedInt16>();
        prop20V.add(new UnsignedInt16(2));
        props[20].setValue(new CIMValue(prop20V));
        props[21] = new CIMProperty("IdentifyingDescriptions");
        props[21].setName("IdentifyingDescriptions");
        props[21].setType(CIMDataType.getPredefinedType((int)22));
        Vector prop21Val = new Vector();
        props[21].setValue(new CIMValue(prop21Val));
        props[22] = new CIMProperty("InstallDate");
        props[22].setName("InstallDate");
        props[22].setType(CIMDataType.getPredefinedType((int)12));
        Object prop22Val = null;
        props[22].setValue(new CIMValue(prop22Val));
        props[23] = new CIMProperty("IsBasedOnUnderlyingRedundancy");
        props[23].setName("IsBasedOnUnderlyingRedundancy");
        props[23].setType(CIMDataType.getPredefinedType((int)9));
        Object prop23Val = null;
        props[23].setValue(new CIMValue(prop23Val));
        props[24] = new CIMProperty("LastErrorCode");
        props[24].setName("LastErrorCode");
        props[24].setType(CIMDataType.getPredefinedType((int)4));
        Object prop24Val = null;
        props[24].setValue(new CIMValue(prop24Val));
        props[25] = new CIMProperty("MaxQuiesceTime");
        props[25].setName("MaxQuiesceTime");
        props[25].setType(CIMDataType.getPredefinedType((int)6));
        Object prop25Val = null;
        props[25].setValue(new CIMValue(prop25Val));
        props[26] = new CIMProperty("Name");
        props[26].setName("Name");
        props[26].setType(CIMDataType.getPredefinedType((int)8));
        String prop26Val = "Rank " + Integer.toString(extentNumber);
        props[26].setValue(new CIMValue((Object)prop26Val));
        props[27] = new CIMProperty("NoSinglePointOfFailure");
        props[27].setName("NoSinglePointOfFailure");
        props[27].setType(CIMDataType.getPredefinedType((int)9));
        Object prop27Val = null;
        props[27].setValue(new CIMValue(prop27Val));
        props[28] = new CIMProperty("SKU");
        props[28].setName("SKU");
        props[28].setType(CIMDataType.getPredefinedType((int)8));
        Object prop28Val = null;
        props[28].setValue(new CIMValue(prop28Val));
        props[29] = new CIMProperty("NumOfDataDisks");
        props[29].setName("NumOfDataDisks");
        props[29].setType(CIMDataType.getPredefinedType((int)16));
        Vector<UnsignedInt16> prop29V = new Vector<UnsignedInt16>();
        prop29V.add(new UnsignedInt16(6));
        props[29].setValue(new CIMValue(prop29V));
        props[30] = new CIMProperty("NumberOfBlocks");
        props[30].setName("NumberOfBlocks");
        props[30].setType(CIMDataType.getPredefinedType((int)6));
        UnsignedInt64 prop30Val = new UnsignedInt64("836444880896");
        props[30].setValue(new CIMValue((Object)prop30Val));
        props[31] = new CIMProperty("OperationalStatus");
        props[31].setName("OperationalStatus");
        props[31].setType(CIMDataType.getPredefinedType((int)16));
        Vector<UnsignedInt16> prop31V = new Vector<UnsignedInt16>();
        prop31V.add(new UnsignedInt16(2));
        props[31].setValue(new CIMValue(prop31V));
        props[32] = new CIMProperty("OtherEnabledState");
        props[32].setName("OtherEnabledState");
        props[32].setType(CIMDataType.getPredefinedType((int)8));
        Object prop32Val = null;
        props[32].setValue(new CIMValue(prop32Val));
        props[33] = new CIMProperty("OtherIdentifyingInfo");
        props[33].setName("OtherIdentifyingInfo");
        props[33].setType(CIMDataType.getPredefinedType((int)22));
        Vector prop33V = new Vector();
        props[33].setValue(new CIMValue(prop33V));
        props[34] = new CIMProperty("PackageRedundancy");
        props[34].setName("PackageRedundancy");
        props[34].setType(CIMDataType.getPredefinedType((int)2));
        Object prop34Val = null;
        props[34].setValue(new CIMValue(prop34Val));
        props[35] = new CIMProperty("PowerManagementCapabilities");
        props[35].setName("PowerManagementCapabilities");
        props[35].setType(CIMDataType.getPredefinedType((int)16));
        Vector prop35V = new Vector();
        props[35].setValue(new CIMValue(prop35V));
        props[36] = new CIMProperty("PowerManagementSupported");
        props[36].setName("PowerManagementSupported");
        props[36].setType(CIMDataType.getPredefinedType((int)9));
        Object prop36Val = null;
        props[36].setValue(new CIMValue(prop36Val));
        props[37] = new CIMProperty("PowerOnHours");
        props[37].setName("PowerOnHours");
        props[37].setType(CIMDataType.getPredefinedType((int)6));
        Object prop37Val = null;
        props[37].setValue(new CIMValue(prop37Val));
        props[38] = new CIMProperty("Primordial");
        props[38].setName("Primordial");
        props[38].setType(CIMDataType.getPredefinedType((int)9));
        Boolean prop38Val = new Boolean(false);
        props[38].setValue(new CIMValue((Object)prop38Val));
        props[39] = new CIMProperty("Purpose");
        props[39].setName("Purpose");
        props[39].setType(CIMDataType.getPredefinedType((int)8));
        Object prop39Val = null;
        props[39].setValue(new CIMValue(prop39Val));
        props[40] = new CIMProperty("RankGroup");
        props[40].setName("RankGroup");
        props[40].setType(CIMDataType.getPredefinedType((int)8));
        String prop40Val = Integer.toString(extentNumber);
        props[40].setValue(new CIMValue((Object)prop40Val));
        props[41] = new CIMProperty("Redundancy");
        props[41].setName("Redundancy");
        props[41].setType(CIMDataType.getPredefinedType((int)8));
        String prop41Val = "raid5";
        props[41].setValue(new CIMValue((Object)prop41Val));
        props[42] = new CIMProperty("RequestedState");
        props[42].setName("RequestedState");
        props[42].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 prop42Val = new UnsignedInt16(5);
        props[42].setValue(new CIMValue((Object)prop42Val));
        props[43] = new CIMProperty("SequentialAccess");
        props[43].setName("SequentialAccess");
        props[43].setType(CIMDataType.getPredefinedType((int)9));
        Object prop43Val = null;
        props[43].setValue(new CIMValue(prop43Val));
        props[44] = new CIMProperty("Status");
        props[44].setName("Status");
        props[44].setType(CIMDataType.getPredefinedType((int)8));
        Object prop44Val = null;
        props[44].setValue(new CIMValue(prop44Val));
        props[45] = new CIMProperty("StatusDescriptions");
        props[45].setName("StatusDescriptions");
        props[45].setType(CIMDataType.getPredefinedType((int)22));
        Vector prop45Val = new Vector();
        props[45].setValue(new CIMValue(prop45Val));
        props[46] = new CIMProperty("StatusInfo");
        props[46].setName("StatusInfo");
        props[46].setType(CIMDataType.getPredefinedType((int)2));
        Object prop46Val = null;
        props[46].setValue(new CIMValue(prop46Val));
        props[47] = new CIMProperty("StoragePoolNumber");
        props[47].setName("StoragePoolNumber");
        props[47].setType(CIMDataType.getPredefinedType((int)8));
        String prop47Val = "0";
        props[47].setValue(new CIMValue((Object)prop47Val));
        props[48] = new CIMProperty("StorageType");
        props[48].setName("StorageType");
        props[48].setType(CIMDataType.getPredefinedType((int)8));
        String prop48Val = "FB";
        props[48].setValue(new CIMValue((Object)prop48Val));
        props[49] = new CIMProperty("SystemCreationClassName");
        props[49].setName("SystemCreationClassName");
        props[49].setType(CIMDataType.getPredefinedType((int)8));
        props[49].setKey(true);
        props[49].setValue(new CIMValue((Object)"IBMTSESS_StorageSystem"));
        props[50] = new CIMProperty("SystemName");
        props[50].setName("SystemName");
        props[50].setType(CIMDataType.getPredefinedType((int)8));
        props[50].setKey(true);
        props[50].setValue(new CIMValue((Object)this.subsystemNameWithModel));
        props[51] = new CIMProperty("TimeOfLastStateChange");
        props[51].setName("TimeOfLastStateChange");
        props[51].setType(CIMDataType.getPredefinedType((int)12));
        Object prop51Val = null;
        props[51].setValue(new CIMValue((Object)this.subsystemNameWithModel));
        props[52] = new CIMProperty("TotalPowerOnHours");
        props[52].setName("TotalPowerOnHours");
        props[52].setType(CIMDataType.getPredefinedType((int)6));
        Object prop52Val = null;
        props[52].setValue(new CIMValue((Object)this.subsystemNameWithModel));
        props[53] = new CIMProperty("Volumes");
        props[53].setName("Volumes");
        props[53].setType(CIMDataType.getPredefinedType((int)22));
        Vector prop53V = new Vector();
        props[53].setValue(new CIMValue(prop53V));
        props[54] = new CIMProperty("diskGrpStatus");
        props[54].setName("diskGrpStatus");
        props[54].setType(CIMDataType.getPredefinedType((int)8));
        String prop54Val = "Normal";
        props[54].setValue(new CIMValue((Object)prop54Val));
        for (int idx = 0; idx < NUM_PROPERTIES; ++idx) {
            v.add(props[idx]);
        }
        cimInstance.setProperties(v);
        return cimInstance;
    }

    private CIMInstance get_ibmtsess_v8_pack(int v8PackNumber) throws Exception {
        CIMInstance cimInstance = new CIMInstance();
        cimInstance.setClassName("IBMTSESS_V8Pack");
        cimInstance.setName("IBMTSESS_V8Pack");
        Vector<CIMProperty> v = new Vector<CIMProperty>();
        int NUM_PROPERTIES = 41;
        CIMProperty[] props = new CIMProperty[NUM_PROPERTIES];
        props[0] = new CIMProperty("CanBeFRUed");
        props[0].setName("CanBeFRUed");
        props[0].setType(CIMDataType.getPredefinedType((int)9));
        Boolean prop0Val = new Boolean(true);
        props[0].setValue(new CIMValue((Object)prop0Val));
        props[1] = new CIMProperty("Capacity");
        props[1].setName("Capacity");
        props[1].setType(CIMDataType.getPredefinedType((int)6));
        Object prop1Val = null;
        props[1].setValue(new CIMValue(prop1Val));
        props[2] = new CIMProperty("CleanerMedia");
        props[2].setName("CleanerMedia");
        props[2].setType(CIMDataType.getPredefinedType((int)9));
        Object prop2Val = null;
        props[2].setValue(new CIMValue(prop2Val));
        props[3] = new CIMProperty("CreationClassName");
        props[3].setName("CreationClassName");
        props[3].setKey(true);
        props[3].setType(CIMDataType.getPredefinedType((int)8));
        props[3].setValue(new CIMValue((Object)"IBMTSESS_V8Pack"));
        props[4] = new CIMProperty("Description");
        props[4].setName("Description");
        props[4].setType(CIMDataType.getPredefinedType((int)8));
        Object prop4Val = null;
        props[4].setValue(new CIMValue(prop4Val));
        props[5] = new CIMProperty("DualSided");
        props[5].setName("DualSided");
        props[5].setType(CIMDataType.getPredefinedType((int)9));
        Object prop5Val = null;
        props[5].setValue(new CIMValue(prop5Val));
        props[6] = new CIMProperty("ElementName");
        props[6].setName("ElementName");
        props[6].setType(CIMDataType.getPredefinedType((int)8));
        Object prop6Val = null;
        props[6].setValue(new CIMValue((Object)"CreationClassName"));
        props[7] = new CIMProperty("HotSwappable");
        props[7].setName("HotSwappable");
        props[7].setType(CIMDataType.getPredefinedType((int)9));
        Boolean prop7Val = new Boolean(false);
        props[7].setValue(new CIMValue((Object)prop7Val));
        props[8] = new CIMProperty("InstallDate");
        props[8].setName("InstallDate");
        props[8].setType(CIMDataType.getPredefinedType((int)12));
        Object prop8Val = null;
        props[8].setValue(new CIMValue(prop8Val));
        props[9] = new CIMProperty("LabelFormats");
        props[9].setName("LabelFormats");
        props[9].setType(CIMDataType.getPredefinedType((int)16));
        Vector prop9V = new Vector();
        props[9].setValue(new CIMValue(prop9V));
        props[10] = new CIMProperty("LabelStates");
        props[10].setName("LabelStates");
        props[10].setType(CIMDataType.getPredefinedType((int)16));
        Vector prop10V = new Vector();
        props[10].setValue(new CIMValue(prop10V));
        props[11] = new CIMProperty("ManufactureDate");
        props[11].setName("ManufactureDate");
        props[11].setType(CIMDataType.getPredefinedType((int)12));
        Object port11Val = null;
        props[11].setValue(new CIMValue(port11Val));
        props[12] = new CIMProperty("Manufacturer");
        props[12].setName("Manufacturer");
        props[12].setType(CIMDataType.getPredefinedType((int)8));
        props[12].setValue(new CIMValue((Object)"IBM"));
        props[13] = new CIMProperty("MaxMounts");
        props[13].setName("MaxMounts");
        props[13].setType(CIMDataType.getPredefinedType((int)6));
        Object prop13Val = null;
        props[13].setValue(new CIMValue(prop13Val));
        props[14] = new CIMProperty("MediaDescription");
        props[14].setName("MediaDescription");
        props[14].setType(CIMDataType.getPredefinedType((int)8));
        Object prop14Val = null;
        props[14].setValue(new CIMValue(prop14Val));
        props[15] = new CIMProperty("MediaSize");
        props[15].setName("MediaSize");
        props[15].setType(CIMDataType.getPredefinedType((int)10));
        Object prop15Val = null;
        props[15].setValue(new CIMValue(prop15Val));
        props[16] = new CIMProperty("MediaType");
        props[16].setName("MediaType");
        props[16].setType(CIMDataType.getPredefinedType((int)2));
        Object prop16Val = null;
        props[16].setValue(new CIMValue(prop16Val));
        props[17] = new CIMProperty("Model");
        props[17].setName("Model");
        props[17].setType(CIMDataType.getPredefinedType((int)8));
        Object prop17Val = null;
        props[17].setValue(new CIMValue(prop17Val));
        props[18] = new CIMProperty("MountCount");
        props[18].setName("MountCount");
        props[18].setType(CIMDataType.getPredefinedType((int)6));
        Object prop18V = null;
        props[18].setValue(new CIMValue(prop18V));
        props[19] = new CIMProperty("Name");
        props[19].setName("Name");
        props[19].setType(CIMDataType.getPredefinedType((int)8));
        Object prop19Val = null;
        props[19].setValue(new CIMValue(prop19Val));
        props[20] = new CIMProperty("OperationalStatus");
        props[20].setName("OperationalStatus");
        props[20].setType(CIMDataType.getPredefinedType((int)16));
        Vector prop20V = new Vector();
        props[20].setValue(new CIMValue(prop20V));
        props[21] = new CIMProperty("OtherIdentifyingInfo");
        props[21].setName("OtherIdentifyingInfo");
        props[21].setType(CIMDataType.getPredefinedType((int)8));
        Object prop21Val = null;
        props[21].setValue(new CIMValue(prop21Val));
        props[22] = new CIMProperty("PartNumber");
        props[22].setName("PartNumber");
        props[22].setType(CIMDataType.getPredefinedType((int)8));
        Object prop22Val = null;
        props[22].setValue(new CIMValue(prop22Val));
        props[23] = new CIMProperty("PhysicalLabels");
        props[23].setName("PhysicalLabels");
        props[23].setType(CIMDataType.getPredefinedType((int)22));
        Object prop23V = null;
        props[23].setValue(new CIMValue(prop23V));
        props[24] = new CIMProperty("PoweredOn");
        props[24].setName("PoweredOn");
        props[24].setType(CIMDataType.getPredefinedType((int)9));
        Boolean prop24Val = new Boolean(true);
        props[24].setValue(new CIMValue((Object)prop24Val));
        props[25] = new CIMProperty("Removable");
        props[25].setName("Removable");
        props[25].setType(CIMDataType.getPredefinedType((int)9));
        Boolean prop25Val = new Boolean(false);
        props[25].setValue(new CIMValue((Object)prop25Val));
        props[26] = new CIMProperty("RemovalConditions");
        props[26].setName("RemovalConditions");
        props[26].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 prop26Val = new UnsignedInt16(2);
        props[26].setValue(new CIMValue((Object)prop26Val));
        props[27] = new CIMProperty("Replaceable");
        props[27].setName("Replaceable");
        props[27].setType(CIMDataType.getPredefinedType((int)9));
        Boolean prop27Val = new Boolean(false);
        props[27].setValue(new CIMValue((Object)prop27Val));
        props[28] = new CIMProperty("SKU");
        props[28].setName("SKU");
        props[28].setType(CIMDataType.getPredefinedType((int)8));
        Object prop28Val = null;
        props[28].setValue(new CIMValue(prop28Val));
        props[29] = new CIMProperty("SerialNumber");
        props[29].setName("SerialNumber");
        props[29].setType(CIMDataType.getPredefinedType((int)8));
        Object prop29Val = null;
        props[29].setValue(new CIMValue(prop29Val));
        props[30] = new CIMProperty("Status");
        props[30].setName("Status");
        props[30].setType(CIMDataType.getPredefinedType((int)8));
        Object prop30Val = null;
        props[30].setValue(new CIMValue(prop30Val));
        props[31] = new CIMProperty("StatusDescriptions");
        props[31].setName("StatusDescriptions");
        props[31].setType(CIMDataType.getPredefinedType((int)22));
        Vector prop31V = new Vector();
        props[31].setValue(new CIMValue(prop31V));
        props[32] = new CIMProperty("SystemCreationClassName");
        props[32].setName("SystemCreationClassName");
        props[32].setType(CIMDataType.getPredefinedType((int)8));
        Object prop32Val = null;
        props[32].setValue(new CIMValue(prop32Val));
        props[33] = new CIMProperty("Tag");
        props[33].setName("Tag");
        props[33].setType(CIMDataType.getPredefinedType((int)8));
        props[33].setKey(true);
        String prop33Val = this.subsystemNameWithModel + "-" + v8PackNumber;
        props[33].setValue(new CIMValue((Object)prop33Val));
        props[34] = new CIMProperty("TimeOfLastMount");
        props[34].setName("TimeOfLastMount");
        props[34].setType(CIMDataType.getPredefinedType((int)12));
        Object prop34Val = null;
        props[34].setValue(new CIMValue(prop34Val));
        props[35] = new CIMProperty("TotalMountTime");
        props[35].setName("TotalMountTime");
        props[35].setType(CIMDataType.getPredefinedType((int)6));
        Object prop35Val = null;
        props[35].setValue(new CIMValue(prop35Val));
        props[36] = new CIMProperty("UserTracking");
        props[36].setName("UserTracking");
        props[36].setType(CIMDataType.getPredefinedType((int)8));
        Object prop36Val = null;
        props[36].setValue(new CIMValue(prop36Val));
        props[37] = new CIMProperty("VendorEquipmentType");
        props[37].setName("VendorEquipmentType");
        props[37].setType(CIMDataType.getPredefinedType((int)8));
        Object prop37Val = null;
        props[37].setValue(new CIMValue(prop37Val));
        props[38] = new CIMProperty("version");
        props[38].setName("version");
        props[38].setType(CIMDataType.getPredefinedType((int)8));
        Object prop38Val = null;
        props[38].setValue(new CIMValue(prop38Val));
        props[39] = new CIMProperty("WriteProtectOn");
        props[39].setName("WriteProtectOn");
        props[39].setType(CIMDataType.getPredefinedType((int)9));
        Object prop39Val = null;
        props[39].setValue(new CIMValue(prop39Val));
        props[40] = new CIMProperty("Caption");
        props[40].setName("Caption");
        props[40].setType(CIMDataType.getPredefinedType((int)8));
        Object prop40Val = null;
        props[40].setValue(new CIMValue(prop40Val));
        for (int idx = 0; idx < NUM_PROPERTIES; ++idx) {
            v.add(props[idx]);
        }
        cimInstance.setProperties(v);
        return cimInstance;
    }

    private CIMInstance get_ibmtsess_disk_drive(int v8Pack, int diskNumber) throws Exception {
        CIMInstance cimInstance = new CIMInstance();
        cimInstance.setClassName("IBMTSESS_DiskDrive");
        cimInstance.setName("IBMTSESS_DiskDrive");
        Vector<CIMProperty> v = new Vector<CIMProperty>();
        int NUM_PROPERTIES = 59;
        CIMProperty[] props = new CIMProperty[NUM_PROPERTIES];
        props[0] = new CIMProperty("AdditionalAvailability");
        props[0].setName("AdditionalAvailability");
        props[0].setType(CIMDataType.getPredefinedType((int)2));
        Object prop0Val = null;
        props[0].setValue(new CIMValue(prop0Val));
        props[1] = new CIMProperty("Availability");
        props[1].setName("Availability");
        props[1].setType(CIMDataType.getPredefinedType((int)2));
        Object prop1Val = null;
        props[1].setValue(new CIMValue(prop1Val));
        props[2] = new CIMProperty("Capabilities");
        props[2].setName("Capabilities");
        props[2].setType(CIMDataType.getPredefinedType((int)16));
        Vector<UnsignedInt16> prop2V = new Vector<UnsignedInt16>();
        prop2V.add(new UnsignedInt16(3));
        props[2].setValue(new CIMValue(prop2V));
        props[3] = new CIMProperty("CapabilityDescriptions");
        props[3].setName("CapabilityDescriptions");
        props[3].setType(CIMDataType.getPredefinedType((int)22));
        Vector<String> prop3V = new Vector<String>();
        prop3V.add("146 GB Disk Drive");
        props[3].setValue(new CIMValue(prop3V));
        props[4] = new CIMProperty("Caption");
        props[4].setName("Caption");
        props[4].setType(CIMDataType.getPredefinedType((int)8));
        Object prop4Val = null;
        props[4].setValue(new CIMValue(prop4Val));
        props[5] = new CIMProperty("CompressionMethod");
        props[5].setName("CompressionMethod");
        props[5].setType(CIMDataType.getPredefinedType((int)8));
        Object prop5Val = null;
        props[5].setValue(new CIMValue(prop5Val));
        props[6] = new CIMProperty("CreationClassName");
        props[6].setName("CreationClassName");
        props[6].setType(CIMDataType.getPredefinedType((int)8));
        props[6].setKey(true);
        Object prop6Val = null;
        props[6].setValue(new CIMValue((Object)"CreationClassName"));
        props[7] = new CIMProperty("DefaultBlockSize");
        props[7].setName("DefaultBlockSize");
        props[7].setType(CIMDataType.getPredefinedType((int)6));
        UnsignedInt64 prop7Val = new UnsignedInt64("512");
        props[7].setValue(new CIMValue((Object)prop7Val));
        props[8] = new CIMProperty("Description");
        props[8].setName("Description");
        props[8].setType(CIMDataType.getPredefinedType((int)8));
        Object prop8Val = null;
        props[8].setValue(new CIMValue(prop8Val));
        props[9] = new CIMProperty("DeviceID");
        props[9].setName("DeviceID");
        props[9].setKey(true);
        props[9].setType(CIMDataType.getPredefinedType((int)8));
        String prop9Val = IDGenerator.generateWWN();
        props[9].setValue(new CIMValue((Object)prop9Val));
        props[10] = new CIMProperty("ECLevel");
        props[10].setName("ECLevel");
        props[10].setType(CIMDataType.getPredefinedType((int)8));
        String prop10Val = "H24353";
        props[10].setValue(new CIMValue((Object)prop10Val));
        props[11] = new CIMProperty("ElementName");
        props[11].setName("ElementName");
        props[11].setType(CIMDataType.getPredefinedType((int)8));
        String port11Val = "DiskDrive" + v8Pack + " on " + diskNumber;
        props[11].setValue(new CIMValue((Object)port11Val));
        props[12] = new CIMProperty("EnabledDefault");
        props[12].setName("EnabledDefault");
        props[12].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 prop12Val = new UnsignedInt16(2);
        props[12].setValue(new CIMValue((Object)prop12Val));
        props[13] = new CIMProperty("EnabledState");
        props[13].setName("EnabledState");
        props[13].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 prop13Val = new UnsignedInt16(5);
        props[13].setValue(new CIMValue((Object)prop13Val));
        props[14] = new CIMProperty("ErrorCleared");
        props[14].setName("ErrorCleared");
        props[14].setType(CIMDataType.getPredefinedType((int)9));
        Object prop14Val = null;
        props[14].setValue(new CIMValue(prop14Val));
        props[15] = new CIMProperty("ErrorDescription");
        props[15].setName("ErrorDescription");
        props[15].setType(CIMDataType.getPredefinedType((int)8));
        Object prop15Val = null;
        props[15].setValue(new CIMValue(prop15Val));
        props[16] = new CIMProperty("ErrorMethodology");
        props[16].setName("ErrorMethodology");
        props[16].setType(CIMDataType.getPredefinedType((int)8));
        Object prop16Val = null;
        props[16].setValue(new CIMValue(prop16Val));
        props[17] = new CIMProperty("FirmwareLevel");
        props[17].setName("FirmwareLevel");
        props[17].setType(CIMDataType.getPredefinedType((int)8));
        String prop17Val = "3603";
        props[17].setValue(new CIMValue((Object)prop17Val));
        props[18] = new CIMProperty("IdentifyingDescriptions");
        props[18].setName("IdentifyingDescriptions");
        props[18].setType(CIMDataType.getPredefinedType((int)22));
        Vector prop18V = new Vector();
        props[18].setValue(new CIMValue(prop18V));
        props[19] = new CIMProperty("InstallDate");
        props[19].setName("InstallDate");
        props[19].setType(CIMDataType.getPredefinedType((int)12));
        Object prop19Val = null;
        props[19].setValue(new CIMValue(prop19Val));
        props[20] = new CIMProperty("LastCleaned");
        props[20].setName("LastCleaned");
        props[20].setType(CIMDataType.getPredefinedType((int)12));
        Object prop20Val = null;
        props[20].setValue(new CIMValue(prop20Val));
        props[21] = new CIMProperty("LastErrorCode");
        props[21].setName("LastErrorCode");
        props[21].setType(CIMDataType.getPredefinedType((int)4));
        Object prop21Val = null;
        props[21].setValue(new CIMValue(prop21Val));
        props[22] = new CIMProperty("LoadTime");
        props[22].setName("LoadTime");
        props[22].setType(CIMDataType.getPredefinedType((int)6));
        Object prop22Val = null;
        props[22].setValue(new CIMValue(prop22Val));
        props[23] = new CIMProperty("Manufacturer");
        props[23].setName("Manufacturer");
        props[23].setType(CIMDataType.getPredefinedType((int)8));
        String prop23Val = "Seagate";
        props[23].setValue(new CIMValue((Object)prop23Val));
        props[24] = new CIMProperty("MaxAccessTime");
        props[24].setName("MaxAccessTime");
        props[24].setType(CIMDataType.getPredefinedType((int)6));
        Object prop24Val = null;
        props[24].setValue(new CIMValue(prop24Val));
        props[25] = new CIMProperty("MaxBlockSize");
        props[25].setName("MaxBlockSize");
        props[25].setType(CIMDataType.getPredefinedType((int)6));
        UnsignedInt64 prop25Val = new UnsignedInt64("512");
        props[25].setValue(new CIMValue((Object)prop25Val));
        props[26] = new CIMProperty("MaxMediaSize");
        props[26].setName("MaxMediaSize");
        props[26].setType(CIMDataType.getPredefinedType((int)6));
        UnsignedInt64 prop26Val = new UnsignedInt64("146000000");
        props[26].setValue(new CIMValue((Object)prop26Val));
        props[27] = new CIMProperty("MaxQuiesceTime");
        props[27].setName("MaxQuiesceTime");
        props[27].setType(CIMDataType.getPredefinedType((int)6));
        Object prop27Val = null;
        props[27].setValue(new CIMValue(prop27Val));
        props[28] = new CIMProperty("MaxUnitsBeforeCleaning");
        props[28].setName("MaxUnitsBeforeCleaning");
        props[28].setType(CIMDataType.getPredefinedType((int)6));
        Object prop28Val = null;
        props[28].setValue(new CIMValue(prop28Val));
        props[29] = new CIMProperty("MediaIsLocked");
        props[29].setName("MediaIsLocked");
        props[29].setType(CIMDataType.getPredefinedType((int)9));
        Boolean prop29Val = new Boolean(false);
        props[29].setValue(new CIMValue((Object)prop29Val));
        props[30] = new CIMProperty("MinBlockSize");
        props[30].setName("MinBlockSize");
        props[30].setType(CIMDataType.getPredefinedType((int)6));
        UnsignedInt64 prop30Val = new UnsignedInt64("512");
        props[30].setValue(new CIMValue((Object)prop30Val));
        props[31] = new CIMProperty("Model");
        props[31].setName("Model");
        props[31].setType(CIMDataType.getPredefinedType((int)8));
        String prop31Val = "S0AE146";
        props[31].setValue(new CIMValue((Object)prop31Val));
        props[32] = new CIMProperty("MountCount");
        props[32].setName("MountCount");
        props[32].setType(CIMDataType.getPredefinedType((int)6));
        Object prop32Val = null;
        props[32].setValue(new CIMValue(prop32Val));
        props[33] = new CIMProperty("Name");
        props[33].setName("Name");
        props[33].setType(CIMDataType.getPredefinedType((int)8));
        String prop33Val = "Disk Drive " + prop9Val;
        props[33].setValue(new CIMValue((Object)prop33Val));
        props[34] = new CIMProperty("NeedsCleaning");
        props[34].setName("NeedsCleaning");
        props[34].setType(CIMDataType.getPredefinedType((int)9));
        Boolean prop34Val = new Boolean(false);
        props[34].setValue(new CIMValue((Object)prop34Val));
        props[35] = new CIMProperty("NumberOfMediaSupported");
        props[35].setName("NumberOfMediaSupported");
        props[35].setType(CIMDataType.getPredefinedType((int)4));
        UnsignedInt32 prop35Val = new UnsignedInt32("1");
        props[35].setValue(new CIMValue((Object)prop35Val));
        props[36] = new CIMProperty("OperationalStatus");
        props[36].setName("OperationalStatus");
        props[36].setType(CIMDataType.getPredefinedType((int)16));
        Vector<UnsignedInt32> prop36V = new Vector<UnsignedInt32>();
        prop36V.add(new UnsignedInt32(2L));
        props[36].setValue(new CIMValue(prop36V));
        props[37] = new CIMProperty("OtherEnabledState");
        props[37].setName("OtherEnabledState");
        props[37].setType(CIMDataType.getPredefinedType((int)8));
        Object prop37Val = null;
        props[37].setValue(new CIMValue(prop37Val));
        props[38] = new CIMProperty("OtherIdentifyingInfo");
        props[38].setName("OtherIdentifyingInfo");
        props[38].setType(CIMDataType.getPredefinedType((int)22));
        Vector prop38Val = new Vector();
        props[38].setValue(new CIMValue(prop38Val));
        props[39] = new CIMProperty("PowerManagementCapabilities");
        props[39].setName("PowerManagementCapabilities");
        props[39].setType(CIMDataType.getPredefinedType((int)16));
        Vector prop39Val = new Vector();
        props[39].setValue(new CIMValue(prop39Val));
        props[40] = new CIMProperty("PowerManagementSupported");
        props[40].setName("PowerManagementSupported");
        props[40].setType(CIMDataType.getPredefinedType((int)9));
        Object prop40Val = null;
        props[40].setValue(new CIMValue(prop40Val));
        props[41] = new CIMProperty("PowerOnHours");
        props[41].setName("PowerOnHours");
        props[41].setType(CIMDataType.getPredefinedType((int)6));
        Object prop41Val = null;
        props[41].setValue(new CIMValue(prop41Val));
        props[42] = new CIMProperty("RankID");
        props[42].setName("RankID");
        props[42].setType(CIMDataType.getPredefinedType((int)8));
        String prop42Val = Integer.toString(v8Pack);
        props[42].setValue(new CIMValue((Object)prop42Val));
        props[43] = new CIMProperty("RequestedState");
        props[43].setName("RequestedState");
        props[43].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 prop43Val = new UnsignedInt16(5);
        props[43].setValue(new CIMValue((Object)prop43Val));
        props[44] = new CIMProperty("Security");
        props[44].setName("Security");
        props[44].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 prop44Val = new UnsignedInt16(1);
        props[44].setValue(new CIMValue((Object)prop44Val));
        props[45] = new CIMProperty("Status");
        props[45].setName("Status");
        props[45].setType(CIMDataType.getPredefinedType((int)8));
        Object prop45Val = null;
        props[45].setValue(new CIMValue(prop45Val));
        props[46] = new CIMProperty("StatusDescriptions");
        props[46].setName("StatusDescriptions");
        props[46].setType(CIMDataType.getPredefinedType((int)22));
        Vector prop46Val = new Vector();
        props[46].setValue(new CIMValue(prop46Val));
        props[47] = new CIMProperty("StatusInfo");
        props[47].setName("StatusInfo");
        props[47].setType(CIMDataType.getPredefinedType((int)2));
        Object prop47Val = null;
        props[47].setValue(new CIMValue(prop47Val));
        props[48] = new CIMProperty("SystemCreationClassName");
        props[48].setName("SystemCreationClassName");
        props[48].setKey(true);
        props[48].setType(CIMDataType.getPredefinedType((int)8));
        props[48].setValue(new CIMValue((Object)"IBMTSESS_StorageSystem"));
        props[49] = new CIMProperty("SystemName");
        props[49].setName("SystemName");
        props[49].setKey(true);
        props[49].setType(CIMDataType.getPredefinedType((int)8));
        props[49].setValue(new CIMValue((Object)this.subsystemNameWithModel));
        props[50] = new CIMProperty("TimeOfLastMount");
        props[50].setName("TimeOfLastMount");
        props[50].setType(CIMDataType.getPredefinedType((int)12));
        Object props50Val = null;
        props[50].setValue(new CIMValue(props50Val));
        props[51] = new CIMProperty("TimeOfLastStateChange");
        props[51].setName("TimeOfLastStateChange");
        props[51].setType(CIMDataType.getPredefinedType((int)12));
        Object props51Val = null;
        props[51].setValue(new CIMValue(props51Val));
        props[52] = new CIMProperty("TotalMountTime");
        props[52].setName("TotalMountTime");
        props[52].setType(CIMDataType.getPredefinedType((int)6));
        Object props52Val = null;
        props[52].setValue(new CIMValue(props52Val));
        props[53] = new CIMProperty("TotalPowerOnHours");
        props[53].setName("TotalPowerOnHours");
        props[53].setType(CIMDataType.getPredefinedType((int)6));
        Object props53Val = null;
        props[53].setValue(new CIMValue(props53Val));
        props[54] = new CIMProperty("UncompressedDataRate");
        props[54].setName("UncompressedDataRate");
        props[54].setType(CIMDataType.getPredefinedType((int)4));
        Object props54Val = null;
        props[54].setValue(new CIMValue(props54Val));
        props[55] = new CIMProperty("UnitsDescription");
        props[55].setName("UnitsDescription");
        props[55].setType(CIMDataType.getPredefinedType((int)8));
        Object props55Val = null;
        props[55].setValue(new CIMValue(props55Val));
        props[56] = new CIMProperty("UnitsUsed");
        props[56].setName("UnitsUsed");
        props[56].setType(CIMDataType.getPredefinedType((int)6));
        Object props56Val = null;
        props[56].setValue(new CIMValue(props56Val));
        props[57] = new CIMProperty("UnloadTime");
        props[57].setName("UnloadTime");
        props[57].setType(CIMDataType.getPredefinedType((int)6));
        Object props57Val = null;
        props[57].setValue(new CIMValue(props57Val));
        props[58] = new CIMProperty("physicalPackage");
        props[58].setName("physicalPackage");
        props[58].setType(CIMDataType.getPredefinedType((int)8));
        String props58Val = Integer.toString(v8Pack);
        props[58].setValue(new CIMValue((Object)props58Val));
        for (int idx = 0; idx < NUM_PROPERTIES; ++idx) {
            v.add(props[idx]);
        }
        cimInstance.setProperties(v);
        return cimInstance;
    }

    private CIMInstance get_ibmtsess_SAP_available_for_element(CIMInstance availableSAP, CIMInstance managedElement) throws Exception {
        CIMObjectPath availableSAPOP = this.getObjectPath(availableSAP);
        CIMObjectPath managedElementOP = this.getObjectPath(managedElement);
        CIMInstance cimInstance = new CIMInstance();
        cimInstance.setClassName("IBMTSESS_SAPAvailableForElement");
        cimInstance.setName("IBMTSESS_SAPAvailableForElement");
        Vector<CIMProperty> v = new Vector<CIMProperty>();
        CIMProperty prop1 = new CIMProperty("AvailableSAP");
        prop1.setName("GroupComponent");
        prop1.setType(new CIMDataType("IBMTSESS_SAPAvailableForElement"));
        prop1.setValue(new CIMValue((Object)availableSAPOP));
        CIMProperty prop2 = new CIMProperty("ManagedElement");
        prop2.setName("PartComponent");
        prop2.setType(new CIMDataType("IBMTSESS_StorageSystem"));
        prop2.setValue(new CIMValue((Object)managedElementOP));
        v.add(prop1);
        v.add(prop2);
        cimInstance.setProperties(v);
        return cimInstance;
    }

    private CIMInstance get_ibmtsess_product_physical_component(CIMInstance groupComponent, CIMInstance partComponent) throws Exception {
        CIMObjectPath groupComponentOP = this.getObjectPath(groupComponent);
        CIMObjectPath partComponentOP = this.getObjectPath(partComponent);
        CIMInstance cimInstance = new CIMInstance();
        cimInstance.setClassName("IBMTSESS_ProductPhysicalComponent");
        cimInstance.setName("IBMTSESS_ProductPhysicalComponent");
        Vector<CIMProperty> v = new Vector<CIMProperty>();
        CIMProperty prop1 = new CIMProperty("GroupComponent");
        prop1.setName("GroupComponent");
        prop1.setType(new CIMDataType("IBMTSESS_Product"));
        prop1.setValue(new CIMValue((Object)groupComponentOP));
        CIMProperty prop2 = new CIMProperty("PartComponent");
        prop2.setName("PartComponent");
        prop2.setType(new CIMDataType("IBMTS_Chassis"));
        prop2.setValue(new CIMValue((Object)partComponentOP));
        v.add(prop1);
        v.add(prop2);
        cimInstance.setProperties(v);
        return cimInstance;
    }

    private CIMInstance get_ibmtsess_pcm_elt_capabilities(CIMInstance capabilities, CIMInstance managedElement) throws Exception {
        CIMObjectPath capabilitiesOP = this.getObjectPath(capabilities);
        CIMObjectPath managedElementOP = this.getObjectPath(managedElement);
        CIMInstance cimInstance = new CIMInstance();
        cimInstance.setClassName("IBMTSESS_PCMEltCapabilities");
        cimInstance.setName("IBMTSESS_PCMEltCapabilities");
        Vector<CIMProperty> v = new Vector<CIMProperty>();
        CIMProperty prop1 = new CIMProperty("Capabilities");
        prop1.setName("Capabilities");
        prop1.setType(new CIMDataType("IBMTSESS_ProtocolControllerMaskingCapabilities"));
        prop1.setValue(new CIMValue((Object)capabilitiesOP));
        CIMProperty prop2 = new CIMProperty("ManagedElement");
        prop2.setName("ManagedElement");
        prop2.setType(new CIMDataType("IBMTSESS_StorageSystem"));
        prop2.setValue(new CIMValue((Object)managedElementOP));
        v.add(prop1);
        v.add(prop2);
        cimInstance.setProperties(v);
        return cimInstance;
    }

    private CIMInstance get_ibmtsess_protocol_controller_masking_capabilities() throws Exception {
        CIMInstance cimInstance = new CIMInstance();
        cimInstance.setClassName("IBMTSESS_ProtocolControllerMaskingCapabilities");
        cimInstance.setName("IBMTSESS_ProtocolControllerMaskingCapabilities");
        Vector<CIMProperty> v = new Vector<CIMProperty>();
        int NUM_PROPERTIES = 15;
        CIMProperty[] props = new CIMProperty[NUM_PROPERTIES];
        props[0] = new CIMProperty("AttachDeviceSupported");
        props[0].setName("AttachDeviceSupported");
        props[0].setType(CIMDataType.getPredefinedType((int)9));
        Boolean prop0Val = new Boolean(true);
        props[0].setValue(new CIMValue((Object)prop0Val));
        props[1] = new CIMProperty("Caption");
        props[1].setName("Caption");
        props[1].setType(CIMDataType.getPredefinedType((int)8));
        Object prop1Val = null;
        props[1].setValue(new CIMValue(prop1Val));
        props[2] = new CIMProperty("ClientSelectableDeviceNumbers");
        props[2].setName("ClientSelectableDeviceNumbers");
        props[2].setType(CIMDataType.getPredefinedType((int)9));
        Boolean prop2Val = new Boolean(true);
        props[2].setValue(new CIMValue((Object)prop2Val));
        props[3] = new CIMProperty("Description");
        props[3].setName("Description");
        props[3].setType(CIMDataType.getPredefinedType((int)8));
        Object prop3Val = null;
        props[3].setValue(new CIMValue(prop3Val));
        props[4] = new CIMProperty("InstanceID");
        props[4].setName("InstanceID");
        props[4].setKey(true);
        props[4].setType(CIMDataType.getPredefinedType((int)8));
        String prop4Val = "ProtocolControllerMaskingCapabilities";
        props[4].setValue(new CIMValue((Object)prop4Val));
        props[5] = new CIMProperty("OneHardwareIDPerView");
        props[5].setName("OneHardwareIDPerView");
        props[5].setType(CIMDataType.getPredefinedType((int)9));
        Boolean prop5Val = new Boolean(true);
        props[5].setValue(new CIMValue((Object)prop5Val));
        props[6] = new CIMProperty("OtherValidHardwareIDTypes");
        props[6].setName("OtherValidHardwareIDTypes");
        props[6].setType(CIMDataType.getPredefinedType((int)22));
        Vector prop6Val = new Vector();
        props[6].setValue(new CIMValue(prop6Val));
        props[7] = new CIMProperty("PortsPerView");
        props[7].setName("PortsPerView");
        props[7].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 prop7Val = new UnsignedInt16(3);
        props[7].setValue(new CIMValue((Object)prop7Val));
        props[8] = new CIMProperty("PrivilegeDeniedSupported");
        props[8].setName("PrivilegeDeniedSupported");
        props[8].setType(CIMDataType.getPredefinedType((int)9));
        Boolean prop8V = new Boolean(false);
        props[8].setValue(new CIMValue((Object)prop8V));
        props[9] = new CIMProperty("ProtocolControllerRequiresAuthorizedIdentity");
        props[9].setName("ProtocolControllerRequiresAuthorizedIdentity");
        props[9].setType(CIMDataType.getPredefinedType((int)9));
        Boolean prop9Val = new Boolean(true);
        props[9].setValue(new CIMValue((Object)prop9Val));
        props[10] = new CIMProperty("ProtocolControllerSupportsCollections");
        props[10].setName("ProtocolControllerSupportsCollections");
        props[10].setType(CIMDataType.getPredefinedType((int)9));
        Boolean prop10Val = new Boolean(false);
        props[10].setValue(new CIMValue((Object)prop10Val));
        props[11] = new CIMProperty("UniqueUnitNumbersPerPort");
        props[11].setName("UniqueUnitNumbersPerPort");
        props[11].setType(CIMDataType.getPredefinedType((int)9));
        Boolean prop11Val = new Boolean(false);
        props[11].setValue(new CIMValue((Object)prop11Val));
        props[12] = new CIMProperty("ValidHardwareIdTypes");
        props[12].setName("ValidHardwareIdTypes");
        props[12].setType(CIMDataType.getPredefinedType((int)16));
        Vector<UnsignedInt16> prop12V = new Vector<UnsignedInt16>();
        prop12V.add(new UnsignedInt16(2));
        props[12].setValue(new CIMValue(prop12V));
        props[13] = new CIMProperty("OnePortPerView");
        props[13].setName("OnePortPerView");
        props[13].setType(CIMDataType.getPredefinedType((int)9));
        Boolean prop13Val = new Boolean(false);
        props[13].setValue(new CIMValue((Object)prop13Val));
        props[14] = new CIMProperty("ElementName");
        props[14].setName("ElementName");
        props[14].setType(CIMDataType.getPredefinedType((int)8));
        String prop14Val = "ProtocolControllerMaskingCapabilities";
        props[14].setValue(new CIMValue((Object)prop14Val));
        for (int idx = 0; idx < NUM_PROPERTIES; ++idx) {
            v.add(props[idx]);
        }
        cimInstance.setProperties(v);
        return cimInstance;
    }

    private CIMInstance get_ibmtsess_installed_software_identity(CIMInstance installedSoftware, CIMInstance system) throws Exception {
        CIMObjectPath installedSoftwareOP = this.getObjectPath(installedSoftware);
        CIMObjectPath systemOP = this.getObjectPath(system);
        CIMInstance cimInstance = new CIMInstance();
        cimInstance.setClassName("IBMTSESS_InstalledSoftwareIdentity");
        cimInstance.setName("IBMTSESS_InstalledSoftwareIdentity");
        Vector<CIMProperty> v = new Vector<CIMProperty>();
        CIMProperty prop1 = new CIMProperty("InstalledSoftware");
        prop1.setName("InstalledSoftware");
        prop1.setType(new CIMDataType("IBMTSESS_SoftwareIdentity"));
        prop1.setValue(new CIMValue((Object)installedSoftwareOP));
        CIMProperty prop2 = new CIMProperty("System");
        prop2.setName("System");
        prop2.setType(new CIMDataType("IBMTSESS_StorageSystem"));
        prop2.setValue(new CIMValue((Object)systemOP));
        v.add(prop1);
        v.add(prop2);
        cimInstance.setProperties(v);
        return cimInstance;
    }

    private CIMInstance get_ibmtsess_hosted_service6(CIMInstance antecedent, CIMInstance dependent) throws Exception {
        CIMObjectPath antecedentOP = this.getObjectPath(antecedent);
        CIMObjectPath dependentOP = this.getObjectPath(dependent);
        CIMInstance cimInstance = new CIMInstance();
        cimInstance.setClassName("IBMTSESS_HostedService6");
        cimInstance.setName("IBMTSESS_HostedService6");
        Vector<CIMProperty> v = new Vector<CIMProperty>();
        CIMProperty prop1 = new CIMProperty("Antecedent");
        prop1.setName("Antecedent");
        prop1.setType(new CIMDataType("IBMTSESS_StorageSystem"));
        prop1.setValue(new CIMValue((Object)antecedentOP));
        CIMProperty prop2 = new CIMProperty("Dependent");
        prop2.setName("Dependent");
        prop2.setType(new CIMDataType("IBMTSESS_PerformanceStatisticService"));
        prop2.setValue(new CIMValue((Object)dependentOP));
        v.add(prop1);
        v.add(prop2);
        cimInstance.setProperties(v);
        return cimInstance;
    }

    private CIMInstance get_ibmtsess_hosted_service4(CIMInstance antecedent, CIMInstance dependent) throws Exception {
        CIMObjectPath antecedentOP = this.getObjectPath(antecedent);
        CIMObjectPath dependentOP = this.getObjectPath(dependent);
        CIMInstance cimInstance = new CIMInstance();
        cimInstance.setClassName("IBMTSESS_HostedService4");
        cimInstance.setName("IBMTSESS_HostedService4");
        Vector<CIMProperty> v = new Vector<CIMProperty>();
        CIMProperty prop1 = new CIMProperty("Antecedent");
        prop1.setName("Antecedent");
        prop1.setType(new CIMDataType("IBMTSESS_StorageSystem"));
        prop1.setValue(new CIMValue((Object)antecedentOP));
        CIMProperty prop2 = new CIMProperty("Dependent");
        prop2.setName("Dependent");
        prop2.setType(new CIMDataType("IBMTSESS_ControllerConfigurationService"));
        prop2.setValue(new CIMValue((Object)dependentOP));
        v.add(prop1);
        v.add(prop2);
        cimInstance.setProperties(v);
        return cimInstance;
    }

    private CIMInstance get_ibmtsess_hosted_service3(CIMInstance antecedent, CIMInstance dependent) throws Exception {
        CIMObjectPath antecedentOP = this.getObjectPath(antecedent);
        CIMObjectPath dependentOP = this.getObjectPath(dependent);
        CIMInstance cimInstance = new CIMInstance();
        cimInstance.setClassName("IBMTSESS_HostedService3");
        cimInstance.setName("IBMTSESS_HostedService3");
        Vector<CIMProperty> v = new Vector<CIMProperty>();
        CIMProperty prop1 = new CIMProperty("Antecedent");
        prop1.setName("Antecedent");
        prop1.setType(new CIMDataType("IBMTSESS_StorageSystem"));
        prop1.setValue(new CIMValue((Object)antecedentOP));
        CIMProperty prop2 = new CIMProperty("Dependent");
        prop2.setName("Dependent");
        prop2.setType(new CIMDataType("IBMTSESS_StorageHardwareIDManagementService"));
        prop2.setValue(new CIMValue((Object)dependentOP));
        v.add(prop1);
        v.add(prop2);
        cimInstance.setProperties(v);
        return cimInstance;
    }

    private CIMInstance get_ibmtsess_stg_config_srv_elt_capabilities(CIMInstance capabilities, CIMInstance managedElement) throws Exception {
        CIMObjectPath capabilitiesOP = this.getObjectPath(capabilities);
        CIMObjectPath managedElementOP = this.getObjectPath(managedElement);
        CIMInstance cimInstance = new CIMInstance();
        cimInstance.setClassName("IBMTSESS_StgConfigSrvEltCapabilities");
        cimInstance.setName("IBMTSESS_StgConfigSrvEltCapabilities");
        Vector<CIMProperty> v = new Vector<CIMProperty>();
        CIMProperty prop1 = new CIMProperty("Capabilities");
        prop1.setName("Capabilities");
        prop1.setType(new CIMDataType("IBMTSESS_StorageConfigurationCapabilities"));
        prop1.setValue(new CIMValue((Object)capabilitiesOP));
        CIMProperty prop2 = new CIMProperty("ManagedElement");
        prop2.setName("ManagedElement");
        prop2.setType(new CIMDataType("IBMTSESS_StorageConfigurationService"));
        prop2.setValue(new CIMValue((Object)managedElementOP));
        v.add(prop1);
        v.add(prop2);
        cimInstance.setProperties(v);
        return cimInstance;
    }

    private CIMInstance get_ibmtsess_storage_hardware_id_management_service() throws Exception {
        CIMInstance cimInstance = new CIMInstance();
        cimInstance.setClassName("IBMTSESS_StorageHardwareIDManagementService");
        cimInstance.setName("IBMTSESS_StorageHardwareIDManagementService");
        Vector<CIMProperty> v = new Vector<CIMProperty>();
        int NUM_PROPERTIES = 20;
        CIMProperty[] props = new CIMProperty[NUM_PROPERTIES];
        props[0] = new CIMProperty("PrimaryOwnerContact");
        props[0].setName("PrimaryOwnerContact");
        props[0].setType(CIMDataType.getPredefinedType((int)8));
        Object prop0Val = null;
        props[0].setValue(new CIMValue(prop0Val));
        props[1] = new CIMProperty("Caption");
        props[1].setName("Caption");
        props[1].setType(CIMDataType.getPredefinedType((int)8));
        Object prop1Val = null;
        props[1].setValue(new CIMValue(prop1Val));
        props[2] = new CIMProperty("CreationClassName");
        props[2].setName("CreationClassName");
        props[2].setKey(true);
        props[2].setType(CIMDataType.getPredefinedType((int)8));
        props[2].setValue(new CIMValue((Object)"IBMTSESS_StorageHardwareIDManagementService"));
        props[3] = new CIMProperty("Description");
        props[3].setName("Description");
        props[3].setType(CIMDataType.getPredefinedType((int)8));
        Object prop3Val = null;
        props[3].setValue(new CIMValue(prop3Val));
        props[4] = new CIMProperty("ElementName");
        props[4].setName("ElementName");
        props[4].setType(CIMDataType.getPredefinedType((int)8));
        String prop4Val = "StorageHardwareIDManagementService";
        props[4].setValue(new CIMValue((Object)prop4Val));
        props[5] = new CIMProperty("EnabledDefault");
        props[5].setName("EnabledDefault");
        props[5].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 prop5Val = new UnsignedInt16(2);
        props[5].setValue(new CIMValue((Object)prop5Val));
        props[6] = new CIMProperty("EnabledState");
        props[6].setName("EnabledState");
        props[6].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 prop6Val = new UnsignedInt16(5);
        props[6].setValue(new CIMValue((Object)prop6Val));
        props[7] = new CIMProperty("PrimaryOwnerName");
        props[7].setName("PrimaryOwnerName");
        props[7].setType(CIMDataType.getPredefinedType((int)8));
        Object prop7Val = null;
        props[7].setValue(new CIMValue(prop7Val));
        props[8] = new CIMProperty("InstallDate");
        props[8].setName("InstallDate");
        props[8].setType(CIMDataType.getPredefinedType((int)12));
        Object prop8Val = null;
        props[8].setValue(new CIMValue(prop8Val));
        props[9] = new CIMProperty("Name");
        props[9].setName("Name");
        props[9].setKey(true);
        props[9].setType(CIMDataType.getPredefinedType((int)8));
        String prop9Val = "StorageHardwareIDManagementService";
        props[9].setValue(new CIMValue((Object)prop9Val));
        props[10] = new CIMProperty("OperationalStatus");
        props[10].setName("OperationalStatus");
        props[10].setType(CIMDataType.getPredefinedType((int)16));
        Vector prop10V = new Vector();
        props[10].setValue(new CIMValue(prop10V));
        props[11] = new CIMProperty("OtherEnabledState");
        props[11].setName("OtherEnabledState");
        props[11].setType(CIMDataType.getPredefinedType((int)8));
        Object prop11Val = null;
        props[11].setValue(new CIMValue(prop11Val));
        props[12] = new CIMProperty("StartMode");
        props[12].setName("StartMode");
        props[12].setType(CIMDataType.getPredefinedType((int)8));
        Object prop12Val = null;
        props[12].setValue(new CIMValue(prop12Val));
        props[13] = new CIMProperty("RequestedState");
        props[13].setName("RequestedState");
        props[13].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 prop13Val = new UnsignedInt16(5);
        props[13].setValue(new CIMValue((Object)prop13Val));
        props[14] = new CIMProperty("Status");
        props[14].setName("Status");
        props[14].setType(CIMDataType.getPredefinedType((int)8));
        Object prop14Val = null;
        props[14].setValue(new CIMValue(prop14Val));
        props[15] = new CIMProperty("StatusDescriptions");
        props[15].setName("StatusDescriptions");
        props[15].setType(CIMDataType.getPredefinedType((int)22));
        Vector prop15Val = new Vector();
        props[15].setValue(new CIMValue(prop15Val));
        props[16] = new CIMProperty("SystemCreationClassName");
        props[16].setName("SystemCreationClassName");
        props[16].setKey(true);
        props[16].setType(CIMDataType.getPredefinedType((int)8));
        props[16].setValue(new CIMValue((Object)"IBMTSESS_StorageSystem"));
        props[17] = new CIMProperty("SystemName");
        props[17].setName("SystemName");
        props[17].setKey(true);
        props[17].setType(CIMDataType.getPredefinedType((int)8));
        props[17].setValue(new CIMValue((Object)this.subsystemName));
        props[18] = new CIMProperty("TimeOfLastStateChange");
        props[18].setName("TimeOfLastStateChange");
        props[18].setType(CIMDataType.getPredefinedType((int)12));
        Object prop18 = null;
        props[18].setValue(new CIMValue(prop18));
        props[19] = new CIMProperty("Started");
        props[19].setName("Started");
        props[19].setType(CIMDataType.getPredefinedType((int)9));
        Object prop19Val = null;
        props[19].setValue(new CIMValue(prop19Val));
        for (int idx = 0; idx < NUM_PROPERTIES; ++idx) {
            v.add(props[idx]);
        }
        cimInstance.setProperties(v);
        return cimInstance;
    }

    private CIMInstance get_ibmtsess_storage_configuration_capabilities() throws Exception {
        CIMInstance cimInstance = new CIMInstance();
        cimInstance.setClassName("IBMTSESS_StorageConfigurationCapabilities");
        cimInstance.setName("IBMTSESS_StorageConfigurationCapabilities");
        Vector<CIMProperty> v = new Vector<CIMProperty>();
        int NUM_PROPERTIES = 11;
        CIMProperty[] props = new CIMProperty[NUM_PROPERTIES];
        props[0] = new CIMProperty("InstanceID");
        props[0].setName("InstanceID");
        props[0].setKey(true);
        props[0].setType(CIMDataType.getPredefinedType((int)8));
        String prop0Val = "StorageConfigurationCapabilities";
        props[0].setValue(new CIMValue((Object)prop0Val));
        props[1] = new CIMProperty("Caption");
        props[1].setName("Caption");
        props[1].setType(CIMDataType.getPredefinedType((int)8));
        Object prop1Val = null;
        props[1].setValue(new CIMValue(prop1Val));
        props[2] = new CIMProperty("InitialReplicationState");
        props[2].setName("InitialReplicationState");
        props[2].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 prop2Val = new UnsignedInt16(2);
        props[2].setValue(new CIMValue((Object)"IBMTSESS_PerformanceStatisticService"));
        props[3] = new CIMProperty("Description");
        props[3].setName("Description");
        props[3].setType(CIMDataType.getPredefinedType((int)8));
        Object prop3Val = null;
        props[3].setValue(new CIMValue(prop3Val));
        props[4] = new CIMProperty("ElementName");
        props[4].setName("ElementName");
        props[4].setType(CIMDataType.getPredefinedType((int)8));
        String prop4Val = "StorageConfigurationCapabilities";
        props[4].setValue(new CIMValue((Object)prop4Val));
        props[5] = new CIMProperty("SupportedAsynchronousActions");
        props[5].setName("SupportedAsynchronousActions");
        props[5].setType(CIMDataType.getPredefinedType((int)16));
        Vector<UnsignedInt16> prop5V = new Vector<UnsignedInt16>();
        prop5V.add(new UnsignedInt16(10));
        props[5].setValue(new CIMValue(prop5V));
        props[6] = new CIMProperty("SupportedCopyTypes");
        props[6].setName("SupportedCopyTypes");
        props[6].setType(CIMDataType.getPredefinedType((int)16));
        Vector<UnsignedInt16> prop6V = new Vector<UnsignedInt16>();
        prop6V.add(new UnsignedInt16(2));
        prop6V.add(new UnsignedInt16(3));
        prop6V.add(new UnsignedInt16(4));
        prop6V.add(new UnsignedInt16(5));
        props[6].setValue(new CIMValue(prop6V));
        props[7] = new CIMProperty("SupportedStorageElementFeatures");
        props[7].setName("SupportedStorageElementFeatures");
        props[7].setType(CIMDataType.getPredefinedType((int)16));
        Vector<UnsignedInt16> prop7V = new Vector<UnsignedInt16>();
        prop7V.add(new UnsignedInt16(3));
        prop7V.add(new UnsignedInt16(6));
        props[7].setValue(new CIMValue(prop7V));
        props[8] = new CIMProperty("SupportedStorageElementTypes");
        props[8].setName("SupportedStorageElementTypes");
        props[8].setType(CIMDataType.getPredefinedType((int)16));
        Vector<UnsignedInt16> prop8V = new Vector<UnsignedInt16>();
        prop8V.add(new UnsignedInt16(2));
        prop8V.add(new UnsignedInt16(3));
        props[8].setValue(new CIMValue(prop8V));
        props[9] = new CIMProperty("SupportedStoragePoolFeatures");
        props[9].setName("SupportedStoragePoolFeatures");
        props[9].setType(CIMDataType.getPredefinedType((int)16));
        Vector<UnsignedInt16> prop9V = new Vector<UnsignedInt16>();
        prop9V.add(new UnsignedInt16(2));
        prop9V.add(new UnsignedInt16(3));
        props[9].setValue(new CIMValue(prop9V));
        props[10] = new CIMProperty("SupportedSynchronousActions");
        props[10].setName("SupportedSynchronousActions");
        props[10].setType(CIMDataType.getPredefinedType((int)16));
        Vector<UnsignedInt16> prop10V = new Vector<UnsignedInt16>();
        prop10V.add(new UnsignedInt16(2));
        prop10V.add(new UnsignedInt16(3));
        prop10V.add(new UnsignedInt16(5));
        prop10V.add(new UnsignedInt16(9));
        prop10V.add(new UnsignedInt16(10));
        props[10].setValue(new CIMValue(prop10V));
        for (int idx = 0; idx < NUM_PROPERTIES; ++idx) {
            v.add(props[idx]);
        }
        cimInstance.setProperties(v);
        return cimInstance;
    }

    private CIMInstance get_ibmtsess_performance_statistics_service() throws Exception {
        CIMInstance cimInstance = new CIMInstance();
        cimInstance.setClassName("IBMTSESS_PerformanceStatisticService");
        cimInstance.setName("IBMTSESS_PerformanceStatisticService");
        Vector<CIMProperty> v = new Vector<CIMProperty>();
        int NUM_PROPERTIES = 24;
        CIMProperty[] props = new CIMProperty[NUM_PROPERTIES];
        props[0] = new CIMProperty("PrimaryOwnerContact");
        props[0].setName("PrimaryOwnerContact");
        props[0].setType(CIMDataType.getPredefinedType((int)8));
        Object prop0Val = null;
        props[0].setValue(new CIMValue(prop0Val));
        props[1] = new CIMProperty("Caption");
        props[1].setName("Caption");
        props[1].setType(CIMDataType.getPredefinedType((int)8));
        props[1].setValue(new CIMValue((Object)"IBMTSESS_PerformanceStatisticService"));
        props[2] = new CIMProperty("CreationClassName");
        props[2].setName("CreationClassName");
        props[2].setKey(true);
        props[2].setType(CIMDataType.getPredefinedType((int)8));
        props[2].setValue(new CIMValue((Object)"IBMTSESS_PerformanceStatisticService"));
        props[3] = new CIMProperty("Description");
        props[3].setName("Description");
        props[3].setType(CIMDataType.getPredefinedType((int)8));
        String prop3Val = "This service is to query the performance statistic of the ESS.";
        props[3].setValue(new CIMValue((Object)prop3Val));
        props[4] = new CIMProperty("ElementName");
        props[4].setName("ElementName");
        props[4].setType(CIMDataType.getPredefinedType((int)8));
        props[4].setValue(new CIMValue((Object)"IBMTSESS_PerformanceStatisticService"));
        props[5] = new CIMProperty("EnabledDefault");
        props[5].setName("EnabledDefault");
        props[5].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 prop5Val = new UnsignedInt16(2);
        props[5].setValue(new CIMValue((Object)prop5Val));
        props[6] = new CIMProperty("EnabledState");
        props[6].setName("EnabledState");
        props[6].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 prop6Val = new UnsignedInt16(2);
        props[6].setValue(new CIMValue((Object)prop6Val));
        props[7] = new CIMProperty("PrimaryOwnerName");
        props[7].setName("PrimaryOwnerName");
        props[7].setType(CIMDataType.getPredefinedType((int)8));
        Object prop7Val = null;
        props[7].setValue(new CIMValue(prop7Val));
        props[8] = new CIMProperty("InstallDate");
        props[8].setName("InstallDate");
        props[8].setType(CIMDataType.getPredefinedType((int)12));
        Object prop8Val = null;
        props[8].setValue(new CIMValue(prop8Val));
        props[9] = new CIMProperty("Name");
        props[9].setName("Name");
        props[9].setKey(true);
        props[9].setType(CIMDataType.getPredefinedType((int)8));
        String prop9Val = "LunMaskPrivilegeService";
        props[9].setValue(new CIMValue((Object)prop9Val));
        props[10] = new CIMProperty("OperationalStatus");
        props[10].setName("OperationalStatus");
        props[10].setType(CIMDataType.getPredefinedType((int)16));
        Vector<UnsignedInt16> prop10V = new Vector<UnsignedInt16>();
        prop10V.add(new UnsignedInt16(2));
        props[10].setValue(new CIMValue(prop10V));
        props[11] = new CIMProperty("OtherEnabledState");
        props[11].setName("OtherEnabledState");
        props[11].setType(CIMDataType.getPredefinedType((int)8));
        Object prop11Val = null;
        props[11].setValue(new CIMValue(prop11Val));
        props[12] = new CIMProperty("StartMode");
        props[12].setName("StartMode");
        props[12].setType(CIMDataType.getPredefinedType((int)8));
        Object prop12Val = null;
        props[12].setValue(new CIMValue(prop12Val));
        props[13] = new CIMProperty("RequestedState");
        props[13].setName("RequestedState");
        props[13].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 prop13Val = new UnsignedInt16(5);
        props[13].setValue(new CIMValue((Object)prop13Val));
        props[14] = new CIMProperty("Status");
        props[14].setName("Status");
        props[14].setType(CIMDataType.getPredefinedType((int)8));
        Object prop14Val = null;
        props[14].setValue(new CIMValue(prop14Val));
        props[15] = new CIMProperty("StatusDescriptions");
        props[15].setName("StatusDescriptions");
        props[15].setType(CIMDataType.getPredefinedType((int)22));
        Vector prop15Val = new Vector();
        props[15].setValue(new CIMValue(prop15Val));
        props[16] = new CIMProperty("SystemCreationClassName");
        props[16].setName("SystemCreationClassName");
        props[16].setKey(true);
        props[16].setType(CIMDataType.getPredefinedType((int)8));
        props[16].setValue(new CIMValue((Object)"IBMTSESS_LunMaskPrivilegeService"));
        props[17] = new CIMProperty("SystemName");
        props[17].setName("SystemName");
        props[17].setKey(true);
        props[17].setType(CIMDataType.getPredefinedType((int)8));
        props[17].setValue(new CIMValue((Object)this.subsystemName));
        props[18] = new CIMProperty("TimeOfLastStateChange");
        props[18].setName("TimeOfLastStateChange");
        props[18].setType(CIMDataType.getPredefinedType((int)12));
        Object prop18 = null;
        props[18].setValue(new CIMValue(prop18));
        props[19] = new CIMProperty("Started");
        props[19].setName("Started");
        props[19].setType(CIMDataType.getPredefinedType((int)9));
        Boolean prop19Val = new Boolean(true);
        props[19].setValue(new CIMValue((Object)prop19Val));
        props[20] = new CIMProperty("EndTime");
        props[20].setName("EndTime");
        props[20].setType(CIMDataType.getPredefinedType((int)12));
        Object prop20Val = null;
        props[20].setValue(new CIMValue(prop20Val));
        props[21] = new CIMProperty("Frequency");
        props[21].setName("Frequency");
        props[21].setType(CIMDataType.getPredefinedType((int)6));
        UnsignedInt64 prop21Val = new UnsignedInt64("5");
        props[21].setValue(new CIMValue((Object)prop21Val));
        props[22] = new CIMProperty("Port");
        props[22].setName("Port");
        props[22].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 prop22Val = new UnsignedInt16(0);
        props[22].setValue(new CIMValue((Object)prop22Val));
        props[23] = new CIMProperty("StatisticsCollection");
        props[23].setName("StatisticsCollection");
        props[23].setType(CIMDataType.getPredefinedType((int)8));
        String prop23Val = "disabled";
        props[23].setValue(new CIMValue((Object)prop23Val));
        for (int idx = 0; idx < NUM_PROPERTIES; ++idx) {
            v.add(props[idx]);
        }
        cimInstance.setProperties(v);
        return cimInstance;
    }

    private CIMInstance get_ibmtsess_hosted_service2(CIMInstance antecedent, CIMInstance dependent) throws Exception {
        CIMObjectPath antecedentOP = this.getObjectPath(antecedent);
        CIMObjectPath dependentOP = this.getObjectPath(dependent);
        CIMInstance cimInstance = new CIMInstance();
        cimInstance.setClassName("IBMTSESS_HostedService2");
        cimInstance.setName("IBMTSESS_HostedService2");
        Vector<CIMProperty> v = new Vector<CIMProperty>();
        CIMProperty prop1 = new CIMProperty("Antecedent");
        prop1.setName("Antecedent");
        prop1.setType(new CIMDataType("IBMTSESS_StorageSystem"));
        prop1.setValue(new CIMValue((Object)antecedentOP));
        CIMProperty prop2 = new CIMProperty("Dependent");
        prop2.setName("Dependent");
        prop2.setType(new CIMDataType("IBMTSESS_LunMaskPrivilegeService"));
        prop2.setValue(new CIMValue((Object)dependentOP));
        v.add(prop1);
        v.add(prop2);
        cimInstance.setProperties(v);
        return cimInstance;
    }

    private CIMInstance get_ibmtsess_lun_mask_privilege_service() throws Exception {
        CIMInstance cimInstance = new CIMInstance();
        cimInstance.setClassName("IBMTSESS_LunMaskPrivilegeService");
        cimInstance.setName("IBMTSESS_LunMaskPrivilegeService");
        Vector<CIMProperty> v = new Vector<CIMProperty>();
        int NUM_PROPERTIES = 20;
        CIMProperty[] props = new CIMProperty[NUM_PROPERTIES];
        props[0] = new CIMProperty("PrimaryOwnerContact");
        props[0].setName("PrimaryOwnerContact");
        props[0].setType(CIMDataType.getPredefinedType((int)8));
        Object prop0Val = null;
        props[0].setValue(new CIMValue(prop0Val));
        props[1] = new CIMProperty("Caption");
        props[1].setName("Caption");
        props[1].setType(CIMDataType.getPredefinedType((int)8));
        Object prop1Val = null;
        props[1].setValue(new CIMValue(prop1Val));
        props[2] = new CIMProperty("CreationClassName");
        props[2].setName("CreationClassName");
        props[2].setKey(true);
        props[2].setType(CIMDataType.getPredefinedType((int)8));
        props[2].setValue(new CIMValue((Object)"IBMTSESS_LunMaskPrivilegeService"));
        props[3] = new CIMProperty("Description");
        props[3].setName("Description");
        props[3].setType(CIMDataType.getPredefinedType((int)8));
        Object prop3Val = null;
        props[3].setValue(new CIMValue(prop3Val));
        props[4] = new CIMProperty("ElementName");
        props[4].setName("ElementName");
        props[4].setType(CIMDataType.getPredefinedType((int)8));
        String prop4Val = "LunMaskPrivilegeService";
        props[4].setValue(new CIMValue((Object)prop4Val));
        props[5] = new CIMProperty("EnabledDefault");
        props[5].setName("EnabledDefault");
        props[5].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 prop5Val = new UnsignedInt16(2);
        props[5].setValue(new CIMValue((Object)prop5Val));
        props[6] = new CIMProperty("EnabledState");
        props[6].setName("EnabledState");
        props[6].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 prop6Val = new UnsignedInt16(5);
        props[6].setValue(new CIMValue((Object)prop6Val));
        props[7] = new CIMProperty("PrimaryOwnerName");
        props[7].setName("PrimaryOwnerName");
        props[7].setType(CIMDataType.getPredefinedType((int)8));
        Object prop7Val = null;
        props[7].setValue(new CIMValue(prop7Val));
        props[8] = new CIMProperty("InstallDate");
        props[8].setName("InstallDate");
        props[8].setType(CIMDataType.getPredefinedType((int)12));
        Object prop8Val = null;
        props[8].setValue(new CIMValue(prop8Val));
        props[9] = new CIMProperty("Name");
        props[9].setName("Name");
        props[9].setKey(true);
        props[9].setType(CIMDataType.getPredefinedType((int)8));
        String prop9Val = "LunMaskPrivilegeService";
        props[9].setValue(new CIMValue((Object)prop9Val));
        props[10] = new CIMProperty("OperationalStatus");
        props[10].setName("OperationalStatus");
        props[10].setType(CIMDataType.getPredefinedType((int)16));
        Vector prop10V = new Vector();
        props[10].setValue(new CIMValue(prop10V));
        props[11] = new CIMProperty("OtherEnabledState");
        props[11].setName("OtherEnabledState");
        props[11].setType(CIMDataType.getPredefinedType((int)8));
        Object prop11Val = null;
        props[11].setValue(new CIMValue(prop11Val));
        props[12] = new CIMProperty("StartMode");
        props[12].setName("StartMode");
        props[12].setType(CIMDataType.getPredefinedType((int)8));
        Object prop12Val = null;
        props[12].setValue(new CIMValue(prop12Val));
        props[13] = new CIMProperty("RequestedState");
        props[13].setName("RequestedState");
        props[13].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 prop13Val = new UnsignedInt16(5);
        props[13].setValue(new CIMValue((Object)prop13Val));
        props[14] = new CIMProperty("Status");
        props[14].setName("Status");
        props[14].setType(CIMDataType.getPredefinedType((int)8));
        Object prop14Val = null;
        props[14].setValue(new CIMValue(prop14Val));
        props[15] = new CIMProperty("StatusDescriptions");
        props[15].setName("StatusDescriptions");
        props[15].setType(CIMDataType.getPredefinedType((int)22));
        Vector prop15Val = new Vector();
        props[15].setValue(new CIMValue(prop15Val));
        props[16] = new CIMProperty("SystemCreationClassName");
        props[16].setName("SystemCreationClassName");
        props[16].setKey(true);
        props[16].setType(CIMDataType.getPredefinedType((int)8));
        props[16].setValue(new CIMValue((Object)"IBMTSESS_StorageSystem"));
        props[17] = new CIMProperty("SystemName");
        props[17].setName("SystemName");
        props[17].setKey(true);
        props[17].setType(CIMDataType.getPredefinedType((int)8));
        props[17].setValue(new CIMValue((Object)this.subsystemName));
        props[18] = new CIMProperty("TimeOfLastStateChange");
        props[18].setName("TimeOfLastStateChange");
        props[18].setType(CIMDataType.getPredefinedType((int)12));
        Object prop18 = null;
        props[18].setValue(new CIMValue(prop18));
        props[19] = new CIMProperty("Started");
        props[19].setName("Started");
        props[19].setType(CIMDataType.getPredefinedType((int)9));
        Object prop19Val = null;
        props[19].setValue(new CIMValue(prop19Val));
        for (int idx = 0; idx < NUM_PROPERTIES; ++idx) {
            v.add(props[idx]);
        }
        cimInstance.setProperties(v);
        return cimInstance;
    }

    private CIMInstance get_ibmtsess_hosted_service(CIMInstance antecedent, CIMInstance dependent) throws Exception {
        CIMObjectPath antecedentOP = this.getObjectPath(antecedent);
        CIMObjectPath dependentOP = this.getObjectPath(dependent);
        CIMInstance cimInstance = new CIMInstance();
        cimInstance.setClassName("IBMTSESS_HostedService");
        cimInstance.setName("IBMTSESS_HostedService");
        Vector<CIMProperty> v = new Vector<CIMProperty>();
        CIMProperty prop1 = new CIMProperty("Antecedent");
        prop1.setName("Antecedent");
        prop1.setType(new CIMDataType("IBMTSESS_StorageSystem"));
        prop1.setValue(new CIMValue((Object)antecedentOP));
        CIMProperty prop2 = new CIMProperty("Dependent");
        prop2.setName("Dependent");
        prop2.setType(new CIMDataType("IBMTSESS_StorageConfigurationService"));
        prop2.setValue(new CIMValue((Object)dependentOP));
        v.add(prop1);
        v.add(prop2);
        cimInstance.setProperties(v);
        return cimInstance;
    }

    private CIMInstance get_ibmtsess_storage_configuration_service() throws Exception {
        CIMInstance cimInstance = new CIMInstance();
        cimInstance.setClassName("IBMTSESS_StorageConfigurationService");
        cimInstance.setName("IBMTSESS_StorageConfigurationService");
        Vector<CIMProperty> v = new Vector<CIMProperty>();
        int NUM_PROPERTIES = 20;
        CIMProperty[] props = new CIMProperty[NUM_PROPERTIES];
        props[0] = new CIMProperty("PrimaryOwnerContact");
        props[0].setName("PrimaryOwnerContact");
        props[0].setType(CIMDataType.getPredefinedType((int)8));
        Object prop0Val = null;
        props[0].setValue(new CIMValue(prop0Val));
        props[1] = new CIMProperty("Caption");
        props[1].setName("Caption");
        props[1].setType(CIMDataType.getPredefinedType((int)8));
        Object prop1Val = null;
        props[1].setValue(new CIMValue(prop1Val));
        props[2] = new CIMProperty("CreationClassName");
        props[2].setName("CreationClassName");
        props[2].setKey(true);
        props[2].setType(CIMDataType.getPredefinedType((int)8));
        props[2].setValue(new CIMValue((Object)"IBMTSESS_StorageConfigurationService"));
        props[3] = new CIMProperty("Description");
        props[3].setName("Description");
        props[3].setType(CIMDataType.getPredefinedType((int)8));
        Object prop3Val = null;
        props[3].setValue(new CIMValue(prop3Val));
        props[4] = new CIMProperty("ElementName");
        props[4].setName("ElementName");
        props[4].setType(CIMDataType.getPredefinedType((int)8));
        String prop4Val = "StorageConfigurationService";
        props[4].setValue(new CIMValue((Object)prop4Val));
        props[5] = new CIMProperty("EnabledDefault");
        props[5].setName("EnabledDefault");
        props[5].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 prop5Val = new UnsignedInt16(2);
        props[5].setValue(new CIMValue((Object)prop5Val));
        props[6] = new CIMProperty("EnabledState");
        props[6].setName("EnabledState");
        props[6].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 prop6Val = new UnsignedInt16(5);
        props[6].setValue(new CIMValue((Object)prop6Val));
        props[7] = new CIMProperty("PrimaryOwnerName");
        props[7].setName("PrimaryOwnerName");
        props[7].setType(CIMDataType.getPredefinedType((int)8));
        Object prop7Val = null;
        props[7].setValue(new CIMValue(prop7Val));
        props[8] = new CIMProperty("InstallDate");
        props[8].setName("InstallDate");
        props[8].setType(CIMDataType.getPredefinedType((int)12));
        Object prop8Val = null;
        props[8].setValue(new CIMValue(prop8Val));
        props[9] = new CIMProperty("Name");
        props[9].setName("Name");
        props[9].setKey(true);
        props[9].setType(CIMDataType.getPredefinedType((int)8));
        String prop9Val = "ConfigService";
        props[9].setValue(new CIMValue((Object)prop9Val));
        props[10] = new CIMProperty("OperationalStatus");
        props[10].setName("OperationalStatus");
        props[10].setType(CIMDataType.getPredefinedType((int)16));
        Vector prop10V = new Vector();
        props[10].setValue(new CIMValue(prop10V));
        props[11] = new CIMProperty("OtherEnabledState");
        props[11].setName("OtherEnabledState");
        props[11].setType(CIMDataType.getPredefinedType((int)8));
        Object prop11Val = null;
        props[11].setValue(new CIMValue(prop11Val));
        props[12] = new CIMProperty("StartMode");
        props[12].setName("StartMode");
        props[12].setType(CIMDataType.getPredefinedType((int)8));
        Object prop12Val = null;
        props[12].setValue(new CIMValue(prop12Val));
        props[13] = new CIMProperty("RequestedState");
        props[13].setName("RequestedState");
        props[13].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 prop13Val = new UnsignedInt16(5);
        props[13].setValue(new CIMValue((Object)prop13Val));
        props[14] = new CIMProperty("Status");
        props[14].setName("Status");
        props[14].setType(CIMDataType.getPredefinedType((int)8));
        Object prop14Val = null;
        props[14].setValue(new CIMValue(prop14Val));
        props[15] = new CIMProperty("StatusDescriptions");
        props[15].setName("StatusDescriptions");
        props[15].setType(CIMDataType.getPredefinedType((int)22));
        Vector prop15Val = new Vector();
        props[15].setValue(new CIMValue(prop15Val));
        props[16] = new CIMProperty("SystemCreationClassName");
        props[16].setName("SystemCreationClassName");
        props[16].setKey(true);
        props[16].setType(CIMDataType.getPredefinedType((int)8));
        props[16].setValue(new CIMValue((Object)"IBMTSESS_StorageSystem"));
        props[17] = new CIMProperty("SystemName");
        props[17].setName("SystemName");
        props[17].setKey(true);
        props[17].setType(CIMDataType.getPredefinedType((int)8));
        props[17].setValue(new CIMValue((Object)this.subsystemName));
        props[18] = new CIMProperty("TimeOfLastStateChange");
        props[18].setName("TimeOfLastStateChange");
        props[18].setType(CIMDataType.getPredefinedType((int)12));
        Object prop18 = null;
        props[18].setValue(new CIMValue(prop18));
        props[19] = new CIMProperty("Started");
        props[19].setName("Started");
        props[19].setType(CIMDataType.getPredefinedType((int)9));
        Object prop19Val = null;
        props[19].setValue(new CIMValue(prop19Val));
        for (int idx = 0; idx < NUM_PROPERTIES; ++idx) {
            v.add(props[idx]);
        }
        cimInstance.setProperties(v);
        return cimInstance;
    }

    private CIMInstance get_ibmtsess_hosted_access_point(CIMInstance antecedent, CIMInstance dependent) throws Exception {
        CIMObjectPath antecedentOP = this.getObjectPath(antecedent);
        CIMObjectPath dependentOP = this.getObjectPath(dependent);
        CIMInstance cimInstance = new CIMInstance();
        cimInstance.setClassName("IBMTSESS_HostedAccessPoint");
        cimInstance.setName("IBMTSESS_HostedAccessPoint");
        Vector<CIMProperty> v = new Vector<CIMProperty>();
        CIMProperty prop1 = new CIMProperty("Antecedent");
        prop1.setName("Antecedent");
        prop1.setType(new CIMDataType("IBMTS_System"));
        prop1.setValue(new CIMValue((Object)antecedentOP));
        CIMProperty prop2 = new CIMProperty("Dependent");
        prop2.setName("Dependent");
        prop2.setType(new CIMDataType("IBMTSESS_RemoteServiceAccessPoint"));
        prop2.setValue(new CIMValue((Object)dependentOP));
        v.add(prop1);
        v.add(prop2);
        cimInstance.setProperties(v);
        return cimInstance;
    }

    private CIMInstance get_ibmtsess_remote_service_access_point() throws Exception {
        CIMInstance cimInstance = new CIMInstance();
        cimInstance.setClassName("IBMTSESS_RemoteServiceAccessPoint");
        cimInstance.setName("IBMTSESS_RemoteServiceAccessPoint");
        Vector<CIMProperty> v = new Vector<CIMProperty>();
        int NUM_PROPERTIES = 19;
        CIMProperty[] props = new CIMProperty[NUM_PROPERTIES];
        props[0] = new CIMProperty("AccessInfo");
        props[0].setName("AccessInfo");
        props[0].setType(CIMDataType.getPredefinedType((int)8));
        String prop0Val = "http://" + this.subsystemName + ":8451/DS8000/Login";
        props[0].setValue(new CIMValue((Object)prop0Val));
        props[1] = new CIMProperty("Caption");
        props[1].setName("Caption");
        props[1].setType(CIMDataType.getPredefinedType((int)8));
        Object prop1Val = null;
        props[1].setValue(new CIMValue(prop1Val));
        props[2] = new CIMProperty("CreationClassName");
        props[2].setName("CreationClassName");
        props[2].setKey(true);
        props[2].setType(CIMDataType.getPredefinedType((int)8));
        props[2].setValue(new CIMValue((Object)"IBMTSESS_RemoteServiceAccessPoint"));
        props[3] = new CIMProperty("Description");
        props[3].setName("Description");
        props[3].setType(CIMDataType.getPredefinedType((int)8));
        Object prop3Val = null;
        props[3].setValue(new CIMValue(prop3Val));
        props[4] = new CIMProperty("ElementName");
        props[4].setName("ElementName");
        props[4].setType(CIMDataType.getPredefinedType((int)8));
        String prop4Val = "System Management URL";
        props[4].setValue(new CIMValue((Object)prop4Val));
        props[5] = new CIMProperty("EnabledDefault");
        props[5].setName("EnabledDefault");
        props[5].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 prop5Val = new UnsignedInt16(2);
        props[5].setValue(new CIMValue((Object)prop5Val));
        props[6] = new CIMProperty("EnabledState");
        props[6].setName("EnabledState");
        props[6].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 prop6Val = new UnsignedInt16(5);
        props[6].setValue(new CIMValue((Object)prop6Val));
        props[7] = new CIMProperty("InfoFormat");
        props[7].setName("InfoFormat");
        props[7].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 prop7Val = new UnsignedInt16(200);
        props[7].setValue(new CIMValue((Object)prop7Val));
        props[8] = new CIMProperty("InstallDate");
        props[8].setName("InstallDate");
        props[8].setType(CIMDataType.getPredefinedType((int)12));
        Object prop8Val = null;
        props[8].setValue(new CIMValue(prop8Val));
        props[9] = new CIMProperty("Name");
        props[9].setName("Name");
        props[9].setKey(true);
        props[9].setType(CIMDataType.getPredefinedType((int)8));
        String prop9Val = "RemoteServiceAccessPoint";
        props[9].setValue(new CIMValue((Object)prop9Val));
        props[10] = new CIMProperty("OperationalStatus");
        props[10].setName("OperationalStatus");
        props[10].setType(CIMDataType.getPredefinedType((int)16));
        Vector prop10V = new Vector();
        props[10].setValue(new CIMValue(prop10V));
        props[11] = new CIMProperty("OtherEnabledState");
        props[11].setName("OtherEnabledState");
        props[11].setType(CIMDataType.getPredefinedType((int)8));
        Object prop11Val = null;
        props[11].setValue(new CIMValue(prop11Val));
        props[12] = new CIMProperty("OtherInfoFormatDescription");
        props[12].setName("OtherInfoFormatDescription");
        props[12].setType(CIMDataType.getPredefinedType((int)8));
        Object prop12Val = null;
        props[12].setValue(new CIMValue(prop12Val));
        props[13] = new CIMProperty("RequestedState");
        props[13].setName("RequestedState");
        props[13].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 prop13Val = new UnsignedInt16(5);
        props[13].setValue(new CIMValue((Object)prop13Val));
        props[14] = new CIMProperty("Status");
        props[14].setName("Status");
        props[14].setType(CIMDataType.getPredefinedType((int)8));
        Object prop14Val = null;
        props[14].setValue(new CIMValue(prop14Val));
        props[15] = new CIMProperty("StatusDescriptions");
        props[15].setName("StatusDescriptions");
        props[15].setType(CIMDataType.getPredefinedType((int)22));
        Vector prop15Val = new Vector();
        props[15].setValue(new CIMValue(prop15Val));
        props[16] = new CIMProperty("SystemCreationClassName");
        props[16].setName("SystemCreationClassName");
        props[16].setKey(true);
        props[16].setType(CIMDataType.getPredefinedType((int)8));
        props[16].setValue(new CIMValue((Object)"IBMTSESS_StorageSystem"));
        props[17] = new CIMProperty("SystemName");
        props[17].setName("SystemName");
        props[17].setKey(true);
        props[17].setType(CIMDataType.getPredefinedType((int)8));
        props[17].setValue(new CIMValue((Object)this.subsystemName));
        props[18] = new CIMProperty("TimeOfLastStateChange");
        props[18].setName("TimeOfLastStateChange");
        props[18].setType(CIMDataType.getPredefinedType((int)12));
        Object prop18 = null;
        props[18].setValue(new CIMValue(prop18));
        for (int idx = 0; idx < NUM_PROPERTIES; ++idx) {
            v.add(props[idx]);
        }
        cimInstance.setProperties(v);
        return cimInstance;
    }

    private CIMInstance get_ibmtsess_element_conforms_to_profile(CIMInstance conformantStandard, CIMInstance managedElement) throws Exception {
        CIMObjectPath conformantStandardOP = this.getObjectPath(conformantStandard);
        CIMObjectPath managedElementOP = this.getObjectPath(managedElement);
        CIMInstance cimInstance = new CIMInstance();
        cimInstance.setClassName("IBMTSESS_ElementConformsToProfile");
        cimInstance.setName("IBMTSESS_ElementConformsToProfile");
        Vector<CIMProperty> v = new Vector<CIMProperty>();
        CIMProperty prop1 = new CIMProperty("ConformantStandard");
        prop1.setName("ConformantStandard");
        prop1.setType(new CIMDataType("IBMTSESS_RegisteredProfile"));
        prop1.setValue(new CIMValue((Object)conformantStandardOP));
        CIMProperty prop2 = new CIMProperty("ManagedElement");
        prop2.setName("ManagedElement");
        prop2.setType(new CIMDataType("IBMTSESS_StorageSystem"));
        prop2.setValue(new CIMValue((Object)managedElementOP));
        v.add(prop1);
        v.add(prop2);
        cimInstance.setProperties(v);
        return cimInstance;
    }

    private CIMInstance get_ibmtsess_element_capabilities_masking(CIMInstance capabilities, CIMInstance managedElement) throws Exception {
        CIMObjectPath capabilitiesOP = this.getObjectPath(capabilities);
        CIMObjectPath managedElementOP = this.getObjectPath(managedElement);
        CIMInstance cimInstance = new CIMInstance();
        cimInstance.setClassName("IBMTSESS_ElementCapabilitiesMasking");
        cimInstance.setName("IBMTSESS_ElementCapabilitiesMasking");
        Vector<CIMProperty> v = new Vector<CIMProperty>();
        CIMProperty prop1 = new CIMProperty("Capabilities");
        prop1.setName("Capabilities");
        prop1.setType(new CIMDataType("IBMTSESS_DeviceMaskingCapabilities"));
        prop1.setValue(new CIMValue((Object)capabilitiesOP));
        CIMProperty prop2 = new CIMProperty("ManagedElement");
        prop2.setName("ManagedElement");
        prop2.setType(new CIMDataType("IBMTSESS_ControllerConfigurationService"));
        prop2.setValue(new CIMValue((Object)managedElementOP));
        v.add(prop1);
        v.add(prop2);
        cimInstance.setProperties(v);
        return cimInstance;
    }

    private CIMInstance get_ibmtsess_storage_client_setting_data(int csDataIdx) throws Exception {
        CIMInstance cimInstance = new CIMInstance();
        cimInstance.setClassName("IBMTSESS_StorageClientSettingData");
        cimInstance.setName("IBMTSESS_StorageClientSettingData");
        Vector<CIMProperty> v = new Vector<CIMProperty>();
        int NUM_PROPERTIES = 6;
        CIMProperty[] props = new CIMProperty[NUM_PROPERTIES];
        UnsignedInt16 prop1Val = null;
        String prop3Val = null;
        String prop4Val = null;
        Vector<String> prop5V = new Vector<String>();
        switch (csDataIdx) {
            case 0: {
                prop1Val = new UnsignedInt16(15);
                prop3Val = "StorageClientSettingData for Intel-based Servers (Microsoft Windows 2003)";
                prop4Val = "Win2000";
                prop5V.add("win2000");
                break;
            }
            case 1: {
                prop1Val = new UnsignedInt16(16);
                prop3Val = "StorageClientSettingData for IBM AS/400 (V5R3 or higher)";
                prop4Val = "OS400_B";
                prop5V.add("os400_b");
                break;
            }
            case 2: {
                prop1Val = new UnsignedInt16(32790);
                prop3Val = "StorageClientSettingData for Sun Clustering using MPxIO";
                prop4Val = "SunMPXIO";
                break;
            }
            case 3: {
                prop1Val = new UnsignedInt16(14);
                prop3Val = "StorageClientSettingData for IBM iSeries/pSeries Servers (Linux)";
                prop4Val = "Linux PPC";
                prop5V.add("linuxppc");
                break;
            }
            case 4: {
                prop1Val = new UnsignedInt16(13);
                prop3Val = "StorageClientSettingData for Cisco iSCSI Gateway";
                prop4Val = "Cisco iSCSI Storage Router";
                break;
            }
            case 5: {
                prop1Val = new UnsignedInt16(14);
                prop3Val = "StorageClientSettingData for Intel-based Servers (Linux)";
                prop4Val = "Linux";
                prop5V.add("linux");
                break;
            }
            case 6: {
                prop1Val = new UnsignedInt16(15);
                prop3Val = "StorageClientSettingData for Intel-based Servers (Microsoft Windows NT4)";
                prop4Val = "Microsoft Windows";
                prop5V.add("nt4");
                break;
            }
            case 7: {
                prop1Val = new UnsignedInt16(9);
                prop3Val = "StorageClientSettingData for IBM SAN File System (AIX MDS)";
                prop4Val = "SANFileSystemAIX";
                prop5V.add("SANFileSystemAIX");
            }
            case 8: {
                prop1Val = new UnsignedInt16(32780);
                prop3Val = "StorageClientSettingData for VMware ESX";
                prop4Val = "VMware";
                break;
            }
            case 9: {
                prop1Val = new UnsignedInt16(32800);
                prop3Val = "StorageClientSettingData for Apple Servers";
                prop4Val = "AppleOSX";
                break;
            }
            case 10: {
                prop1Val = new UnsignedInt16(15);
                prop3Val = "StorageClientSettingData for Intel-based Servers (Microsoft Windows 2003)";
                prop4Val = "Win2003";
                prop5V.add("win2003");
                break;
            }
            case 11: {
                prop1Val = new UnsignedInt16(14);
                prop3Val = "StorageClientSettingData for AMD Servers (Linux Suse)";
                prop4Val = "AMDLinuxSuse";
                prop5V.add("amdlinuxsuse");
            }
            case 12: {
                prop1Val = new UnsignedInt16(3);
                prop3Val = "StorageClientSettingData for Solaris 2.51";
                prop4Val = "Solaris 251";
                prop5V.add("solaris251");
            }
            case 13: {
                prop1Val = new UnsignedInt16(7);
                prop3Val = "StorageClientSettingData for Intel-based Servers (Novell Netware)";
                prop4Val = "Netware";
                break;
            }
            case 14: {
                prop1Val = new UnsignedInt16(4);
                prop3Val = "StorageClientSettingData for HP Servers (HP-UX)";
                prop4Val = "HPUX";
                break;
            }
            case 15: {
                prop1Val = new UnsignedInt16(11);
                prop3Val = "StorageClientSettingData for IBM NUMA-Q Servers (DYNIX/ptx)";
                prop4Val = "Dynix";
                break;
            }
            case 16: {
                prop1Val = new UnsignedInt16(12);
                prop3Val = "StorageClientSettingData for SGI Origin Servers (IRIX)";
                prop4Val = "Irix";
                break;
            }
            case 17: {
                prop1Val = new UnsignedInt16(14);
                prop3Val = "StorageClientSettingData for IBM pSeries, RS/6000 and RS/6000 SP Servers (pLinux)";
                prop4Val = "PLinux";
                prop5V.add("plinux");
                break;
            }
            case 18: {
                prop1Val = new UnsignedInt16(14);
                prop3Val = "StorageClientSettingData for AMD Servers (Linux RHEL)";
                prop4Val = "AMDLinuxRhel";
                prop5V.add("amdlinuxrhel");
                break;
            }
            case 19: {
                prop1Val = new UnsignedInt16(14);
                prop3Val = "StorageClientSettingData for Intel-based Servers (Linux Red Flag)";
                prop4Val = "LinuxRF";
                prop5V.add("linuxrf");
            }
            case 20: {
                prop1Val = new UnsignedInt16(14);
                prop3Val = "StorageClientSettingData for Intel-based Servers (Linux RHEL)";
                prop4Val = "LinuxRhel";
                prop5V.add("linuxrhel");
            }
            case 21: {
                prop1Val = new UnsignedInt16(3);
                prop3Val = "StorageClientSettingData for Fujitsu Servers (Solaris)";
                prop4Val = "Fujitsu";
                prop5V.add("fujitsu");
                break;
            }
            case 22: {
                prop1Val = new UnsignedInt16(14);
                prop3Val = "StorageClientSettingData for IBM SAN File System (Linux MDS)";
                prop4Val = "SANFileSystemLinux";
                prop5V.add("SANFileSystemLinux");
                break;
            }
            case 23: {
                prop1Val = new UnsignedInt16(6);
                prop3Val = "StorageClientSettingData for HP AlphaServer (Tru64 UNIX)";
                prop4Val = "Tru64";
                break;
            }
            case 24: {
                prop1Val = new UnsignedInt16(5);
                prop3Val = "StorageClientSettingData for HP AlphaServer (OpenVMS)";
                prop4Val = "OpenVMS";
                break;
            }
            case 25: {
                prop1Val = new UnsignedInt16(10);
                prop3Val = "StorageClientSettingData for DGUX";
                prop4Val = "DGUX";
                break;
            }
            case 26: {
                prop1Val = new UnsignedInt16(9);
                prop3Val = "StorageClientSettingData for IBM pSeries, RS/6000 and RS/6000 SP Servers (AIX)";
                prop4Val = "AIX";
                prop5V.add("AIX");
                break;
            }
            case 27: {
                prop1Val = new UnsignedInt16(14);
                prop3Val = "StorageClientSettingData for IBM zSeries Servers (Linux)";
                prop4Val = "Linux 390";
                prop5V.add("linux390");
                break;
            }
            case 28: {
                prop1Val = new UnsignedInt16(16);
                prop3Val = "StorageClientSettingData for IBM AS/400 (V3R7 to V5R2)";
                prop4Val = "OS400";
                prop5V.add("os400");
                break;
            }
            case 29: {
                prop1Val = new UnsignedInt16(3);
                prop3Val = "StorageClientSettingData for Sun Servers (Solaris 2.6 or higher)";
                prop4Val = "Solaris 26";
                prop5V.add("solaris26");
                break;
            }
            case 30: {
                prop1Val = new UnsignedInt16(32770);
                prop3Val = "StorageClientSettingData for IBM SAN Volume Controller";
                prop4Val = "SANVolController";
                break;
            }
            case 31: {
                prop1Val = new UnsignedInt16(14);
                prop3Val = "StorageClientSettingData for Intel-based Servers (Linux Suse)";
                prop4Val = "LinuxSuse";
                prop5V.add("linuxsuse");
                break;
            }
            case 32: {
                prop1Val = new UnsignedInt16(14);
                prop3Val = "StorageClientSettingData for Intel-based Servers (Linux Desktop)";
                prop4Val = "LinuxDT";
                prop5V.add("linuxdt");
            }
        }
        props[0] = new CIMProperty("Caption");
        props[0].setName("Caption");
        props[0].setType(CIMDataType.getPredefinedType((int)8));
        Object prop0Val = null;
        props[0].setValue(new CIMValue(prop0Val));
        props[1] = new CIMProperty("ClientTypes");
        props[1].setName("ClientTypes");
        props[1].setType(CIMDataType.getPredefinedType((int)16));
        props[1].setValue(new CIMValue((Object)prop1Val));
        props[2] = new CIMProperty("Description");
        props[2].setName("Description");
        props[2].setType(CIMDataType.getPredefinedType((int)8));
        Object prop2Val = null;
        props[2].setValue(new CIMValue(prop2Val));
        props[3] = new CIMProperty("ElementName");
        props[3].setName("ElementName");
        props[3].setType(CIMDataType.getPredefinedType((int)8));
        props[3].setValue(new CIMValue((Object)prop3Val));
        props[4] = new CIMProperty("InstanceID");
        props[4].setName("InstanceID");
        props[4].setKey(true);
        props[4].setType(CIMDataType.getPredefinedType((int)8));
        props[4].setValue(new CIMValue((Object)prop4Val));
        props[5] = new CIMProperty("OtherClientTypeDescriptions");
        props[5].setName("OtherClientTypeDescriptions");
        props[5].setType(CIMDataType.getPredefinedType((int)22));
        props[5].setValue(new CIMValue(prop5V));
        for (int idx = 0; idx < NUM_PROPERTIES; ++idx) {
            v.add(props[idx]);
        }
        cimInstance.setProperties(v);
        return cimInstance;
    }

    private CIMInstance get_ibmtsess_storage_capabilities() throws Exception {
        CIMInstance cimInstance = new CIMInstance();
        cimInstance.setClassName("IBMTSESS_StorageCapabilities");
        cimInstance.setName("IBMTSESS_StorageCapabilities");
        Vector<CIMProperty> v = new Vector<CIMProperty>();
        int NUM_PROPERTIES = 16;
        CIMProperty[] props = new CIMProperty[NUM_PROPERTIES];
        props[0] = new CIMProperty("Caption");
        props[0].setName("Caption");
        props[0].setType(CIMDataType.getPredefinedType((int)8));
        Object prop0Val = null;
        props[0].setValue(new CIMValue(prop0Val));
        props[1] = new CIMProperty("DataRedundancyDefault");
        props[1].setName("DataRedundancyDefault");
        props[1].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 prop1Val = new UnsignedInt16(1);
        props[1].setValue(new CIMValue((Object)prop1Val));
        props[2] = new CIMProperty("DataRedundancyMax");
        props[2].setName("DataRedundancyMax");
        props[2].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 prop2Val = new UnsignedInt16(1);
        props[2].setValue(new CIMValue((Object)prop2Val));
        props[3] = new CIMProperty("DataRedundancyMin");
        props[3].setName("DataRedundancyMin");
        props[3].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 prop3Val = new UnsignedInt16(1);
        props[3].setValue(new CIMValue((Object)prop3Val));
        props[4] = new CIMProperty("DeltaReservationDefault");
        props[4].setName("DeltaReservationDefault");
        props[4].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 prop4Val = new UnsignedInt16(100);
        props[4].setValue(new CIMValue((Object)prop4Val));
        props[5] = new CIMProperty("DeltaReservationMax");
        props[5].setName("DeltaReservationMax");
        props[5].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 prop5Val = new UnsignedInt16(100);
        props[5].setValue(new CIMValue((Object)prop5Val));
        props[6] = new CIMProperty("DeltaReservationMin");
        props[6].setName("DeltaReservationMin");
        props[6].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 prop6Val = new UnsignedInt16(100);
        props[6].setValue(new CIMValue((Object)prop6Val));
        props[7] = new CIMProperty("Description");
        props[7].setName("Description");
        props[7].setType(CIMDataType.getPredefinedType((int)8));
        Object prop7Val = null;
        props[7].setValue(new CIMValue(prop7Val));
        props[8] = new CIMProperty("ElementName");
        props[8].setName("ElementName");
        props[8].setType(CIMDataType.getPredefinedType((int)8));
        String prop8Val = "Storage Capabilities for VolumeSpace";
        props[8].setValue(new CIMValue((Object)prop8Val));
        props[9] = new CIMProperty("ElementType");
        props[9].setName("ElementType");
        props[9].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 prop9Val = new UnsignedInt16(5);
        props[9].setValue(new CIMValue((Object)prop9Val));
        props[10] = new CIMProperty("InstanceID");
        props[10].setName("InstanceID");
        props[10].setKey(true);
        props[10].setType(CIMDataType.getPredefinedType((int)8));
        props[10].setValue(new CIMValue((Object)"IBMTSESS"));
        props[11] = new CIMProperty("NoSinglePointOfFailure");
        props[11].setName("NoSinglePointOfFailure");
        props[11].setType(CIMDataType.getPredefinedType((int)9));
        Boolean prop11Val = new Boolean(true);
        props[11].setValue(new CIMValue((Object)prop11Val));
        props[12] = new CIMProperty("NoSinglePointOfFailureDefault");
        props[12].setName("NoSinglePointOfFailureDefault");
        props[12].setType(CIMDataType.getPredefinedType((int)9));
        Boolean prop12Val = new Boolean(true);
        props[12].setValue(new CIMValue((Object)prop12Val));
        props[13] = new CIMProperty("PackageRedundancyDefault");
        props[13].setName("PackageRedundancyDefault");
        props[13].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 prop13Val = new UnsignedInt16(1);
        props[13].setValue(new CIMValue((Object)prop13Val));
        props[14] = new CIMProperty("PackageRedundancyMax");
        props[14].setName("PackageRedundancyMax");
        props[14].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 prop14Val = new UnsignedInt16(1);
        props[14].setValue(new CIMValue((Object)prop14Val));
        props[15] = new CIMProperty("PackageRedundancyMin");
        props[15].setName("PackageRedundancyMin");
        props[15].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 prop15Val = new UnsignedInt16(1);
        props[15].setValue(new CIMValue((Object)prop15Val));
        for (int idx = 0; idx < NUM_PROPERTIES; ++idx) {
            v.add(props[idx]);
        }
        cimInstance.setProperties(v);
        return cimInstance;
    }

    private CIMInstance get_ibmtsess_storage_system_to_port(CIMInstance groupComponent, CIMInstance partComponent) throws Exception {
        CIMObjectPath groupComponentOP = this.getObjectPath(groupComponent);
        CIMObjectPath partComponentOP = this.getObjectPath(partComponent);
        CIMInstance cimInstance = new CIMInstance();
        cimInstance.setClassName("IBMTSESS_StorageSystemToPort");
        cimInstance.setName("IBMTSESS_StorageSystemToPort");
        Vector<CIMProperty> v = new Vector<CIMProperty>();
        CIMProperty prop1 = new CIMProperty("GroupComponent");
        prop1.setName("GroupComponent");
        prop1.setType(new CIMDataType("IBMTSESS_StorageSystem"));
        prop1.setValue(new CIMValue((Object)groupComponentOP));
        CIMProperty prop2 = new CIMProperty("PartComponent");
        prop2.setName("PartComponent");
        prop2.setType(new CIMDataType("IBMTS_FCPort"));
        prop2.setValue(new CIMValue((Object)partComponentOP));
        v.add(prop1);
        v.add(prop2);
        cimInstance.setProperties(v);
        return cimInstance;
    }

    private CIMInstance get_ibmtsess_device_masking_capabilities() throws Exception {
        CIMInstance cimInstance = new CIMInstance();
        cimInstance.setClassName("IBMTSESS_DeviceMaskingCapabilities");
        cimInstance.setName("IBMTSESS_DeviceMaskingCapabilities");
        Vector<CIMProperty> v = new Vector<CIMProperty>();
        int NUM_PROPERTIES = 15;
        CIMProperty[] props = new CIMProperty[NUM_PROPERTIES];
        props[0] = new CIMProperty("AttachDeviceSupported");
        props[0].setName("AttachDeviceSupported");
        props[0].setType(CIMDataType.getPredefinedType((int)9));
        Boolean prop0Val = new Boolean(true);
        props[0].setValue(new CIMValue((Object)prop0Val));
        props[1] = new CIMProperty("Caption");
        props[1].setName("Caption");
        props[1].setType(CIMDataType.getPredefinedType((int)8));
        String prop1Val = "IBM ESS Masking Capabilities";
        props[1].setValue(new CIMValue((Object)prop1Val));
        props[2] = new CIMProperty("ClientSelectableDeviceNumbers");
        props[2].setName("ClientSelectableDeviceNumbers");
        props[2].setType(CIMDataType.getPredefinedType((int)9));
        Boolean prop2Val = new Boolean(false);
        props[2].setValue(new CIMValue((Object)prop2Val));
        props[3] = new CIMProperty("Description");
        props[3].setName("Description");
        props[3].setType(CIMDataType.getPredefinedType((int)8));
        String prop3Val = "IBM ESS Masking Capabilities";
        props[3].setValue(new CIMValue((Object)prop3Val));
        props[4] = new CIMProperty("InstanceID");
        props[4].setName("InstanceID");
        props[4].setKey(true);
        props[4].setType(CIMDataType.getPredefinedType((int)8));
        props[4].setValue(new CIMValue((Object)"IBMTSESS_DeviceMaskingCapabilities"));
        props[5] = new CIMProperty("OneHardwareIDPerView");
        props[5].setName("OneHardwareIDPerView");
        props[5].setType(CIMDataType.getPredefinedType((int)9));
        Boolean prop5Val = new Boolean(true);
        props[5].setValue(new CIMValue((Object)prop5Val));
        props[6] = new CIMProperty("OtherValidHardwareIDTypes");
        props[6].setName("OtherValidHardwareIDTypes");
        props[6].setType(CIMDataType.getPredefinedType((int)22));
        Vector prop6Val = new Vector();
        props[6].setValue(new CIMValue(prop6Val));
        props[7] = new CIMProperty("PortsPerView");
        props[7].setName("PortsPerView");
        props[7].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 prop7Val = new UnsignedInt16(3);
        props[7].setValue(new CIMValue((Object)prop7Val));
        props[8] = new CIMProperty("PrivilegeDeniedSupported");
        props[8].setName("PrivilegeDeniedSupported");
        props[8].setType(CIMDataType.getPredefinedType((int)9));
        Boolean prop8V = new Boolean(false);
        props[8].setValue(new CIMValue((Object)prop8V));
        props[9] = new CIMProperty("ProtocolControllerRequiresAuthorizedIdentity");
        props[9].setName("ProtocolControllerRequiresAuthorizedIdentity");
        props[9].setType(CIMDataType.getPredefinedType((int)9));
        Boolean prop9Val = new Boolean(true);
        props[9].setValue(new CIMValue((Object)prop9Val));
        props[10] = new CIMProperty("ProtocolControllerSupportsCollections");
        props[10].setName("ProtocolControllerSupportsCollections");
        props[10].setType(CIMDataType.getPredefinedType((int)9));
        Boolean prop10Val = new Boolean(true);
        props[10].setValue(new CIMValue((Object)prop10Val));
        props[11] = new CIMProperty("UniqueUnitNumbersPerPort");
        props[11].setName("UniqueUnitNumbersPerPort");
        props[11].setType(CIMDataType.getPredefinedType((int)9));
        Boolean prop11Val = new Boolean(false);
        props[11].setValue(new CIMValue((Object)prop11Val));
        props[12] = new CIMProperty("ValidHardwareIdTypes");
        props[12].setName("ValidHardwareIdTypes");
        props[12].setType(CIMDataType.getPredefinedType((int)16));
        Vector<UnsignedInt16> prop12V = new Vector<UnsignedInt16>();
        prop12V.add(new UnsignedInt16(2));
        props[12].setValue(new CIMValue(prop12V));
        props[13] = new CIMProperty("OnePortPerView");
        props[13].setName("OnePortPerView");
        props[13].setType(CIMDataType.getPredefinedType((int)9));
        Boolean prop13Val = new Boolean(false);
        props[13].setValue(new CIMValue((Object)prop13Val));
        props[14] = new CIMProperty("ElementName");
        props[14].setName("ElementName");
        props[14].setType(CIMDataType.getPredefinedType((int)8));
        props[14].setValue(new CIMValue((Object)"IBMTSESS_DeviceMaskingCapabilities"));
        for (int idx = 0; idx < NUM_PROPERTIES; ++idx) {
            v.add(props[idx]);
        }
        cimInstance.setProperties(v);
        return cimInstance;
    }

    private CIMInstance get_ibmtsess_controller_configuration_service() throws Exception {
        CIMInstance cimInstance = new CIMInstance();
        cimInstance.setClassName("IBMTSESS_ControllerConfigurationService");
        cimInstance.setName("IBMTSESS_ControllerConfigurationService");
        Vector<CIMProperty> v = new Vector<CIMProperty>();
        int NUM_PROPERTIES = 20;
        CIMProperty[] props = new CIMProperty[NUM_PROPERTIES];
        props[0] = new CIMProperty("Caption");
        props[0].setName("Caption");
        props[0].setType(CIMDataType.getPredefinedType((int)8));
        Object prop0Val = null;
        props[0].setValue(new CIMValue(prop0Val));
        props[1] = new CIMProperty("CreationClassName");
        props[1].setName("CreationClassName");
        props[1].setKey(true);
        props[1].setType(CIMDataType.getPredefinedType((int)8));
        props[1].setValue(new CIMValue((Object)"IBMTSESS_ControllerConfigurationService"));
        props[2] = new CIMProperty("Description");
        props[2].setName("Description");
        props[2].setType(CIMDataType.getPredefinedType((int)8));
        Object prop2Val = null;
        props[2].setValue(new CIMValue(prop2Val));
        props[3] = new CIMProperty("ElementName");
        props[3].setName("ElementName");
        props[3].setType(CIMDataType.getPredefinedType((int)8));
        String prop3Val = "ControllerConfigurationService";
        props[3].setValue(new CIMValue((Object)prop3Val));
        props[4] = new CIMProperty("EnabledDefault");
        props[4].setName("EnabledDefault");
        props[4].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 prop4Val = new UnsignedInt16(2);
        props[4].setValue(new CIMValue((Object)prop4Val));
        props[5] = new CIMProperty("EnabledState");
        props[5].setName("EnabledState");
        props[5].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 prop5Val = new UnsignedInt16(5);
        props[5].setValue(new CIMValue((Object)prop5Val));
        props[6] = new CIMProperty("InstallDate");
        props[6].setName("InstallDate");
        props[6].setType(CIMDataType.getPredefinedType((int)12));
        Object prop6Val = null;
        props[6].setValue(new CIMValue(prop6Val));
        props[7] = new CIMProperty("Name");
        props[7].setName("Name");
        props[7].setKey(true);
        props[7].setType(CIMDataType.getPredefinedType((int)8));
        String prop7Val = "Controller Configuration Service";
        props[7].setValue(new CIMValue((Object)prop7Val));
        props[8] = new CIMProperty("OperationalStatus");
        props[8].setName("OperationalStatus");
        props[8].setType(CIMDataType.getPredefinedType((int)16));
        Vector prop8V = new Vector();
        props[8].setValue(new CIMValue(prop8V));
        props[9] = new CIMProperty("OtherEnabledState");
        props[9].setName("OtherEnabledState");
        props[9].setType(CIMDataType.getPredefinedType((int)8));
        Object prop9Val = null;
        props[9].setValue(new CIMValue(prop9Val));
        props[10] = new CIMProperty("PrimaryOwnerContact");
        props[10].setName("PrimaryOwnerContact");
        props[10].setType(CIMDataType.getPredefinedType((int)8));
        Object prop10Val = null;
        props[10].setValue(new CIMValue(prop10Val));
        props[11] = new CIMProperty("PrimaryOwnerName");
        props[11].setName("PrimaryOwnerName");
        props[11].setType(CIMDataType.getPredefinedType((int)8));
        Object prop11Val = null;
        props[11].setValue(new CIMValue(prop11Val));
        props[12] = new CIMProperty("RequestedState");
        props[12].setName("RequestedState");
        props[12].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 prop12Val = new UnsignedInt16(5);
        props[12].setValue(new CIMValue((Object)prop12Val));
        props[13] = new CIMProperty("StartMode");
        props[13].setName("StartMode");
        props[13].setType(CIMDataType.getPredefinedType((int)8));
        Object prop13Val = null;
        props[13].setValue(new CIMValue(prop13Val));
        props[14] = new CIMProperty("Started");
        props[14].setName("Started");
        props[14].setType(CIMDataType.getPredefinedType((int)9));
        Object prop14Val = null;
        props[14].setValue(new CIMValue(prop14Val));
        props[15] = new CIMProperty("Status");
        props[15].setName("Status");
        props[15].setType(CIMDataType.getPredefinedType((int)8));
        Object prop15Val = null;
        props[15].setValue(new CIMValue(prop15Val));
        props[16] = new CIMProperty("SystemName");
        props[16].setName("SystemName");
        props[16].setKey(true);
        props[16].setType(CIMDataType.getPredefinedType((int)8));
        props[16].setValue(new CIMValue((Object)this.subsystemName));
        props[17] = new CIMProperty("StatusDescriptions");
        props[17].setName("StatusDescriptions");
        props[17].setType(CIMDataType.getPredefinedType((int)22));
        Vector prop17Val = new Vector();
        props[17].setValue(new CIMValue(prop17Val));
        props[18] = new CIMProperty("SystemCreationClassName");
        props[18].setName("SystemCreationClassName");
        props[18].setKey(true);
        props[18].setType(CIMDataType.getPredefinedType((int)8));
        props[18].setValue(new CIMValue((Object)"IBMTSESS_StorageSystem"));
        props[19] = new CIMProperty("TimeOfLastStateChange");
        props[19].setName("TimeOfLastStateChange");
        props[19].setType(CIMDataType.getPredefinedType((int)12));
        Object prop19Val = null;
        props[19].setValue(new CIMValue(prop19Val));
        for (int idx = 0; idx < NUM_PROPERTIES; ++idx) {
            v.add(props[idx]);
        }
        cimInstance.setProperties(v);
        return cimInstance;
    }

    private CIMInstance get_ibmtsess_computer_system_physical_package(CIMInstance antecedent, CIMInstance dependent) throws Exception {
        CIMObjectPath antecedentOP = this.getObjectPath(antecedent);
        CIMObjectPath dependentOP = this.getObjectPath(dependent);
        CIMInstance cimInstance = new CIMInstance();
        cimInstance.setClassName("IBMTSESS_ComputerSystemPhysicalPackage");
        cimInstance.setName("IBMTSESS_ComputerSystemPhysicalPackage");
        Vector<CIMProperty> v = new Vector<CIMProperty>();
        CIMProperty prop1 = new CIMProperty("Antecedent");
        prop1.setName("Antecedent");
        prop1.setType(new CIMDataType("IBMTSESS_PhysicalPackage"));
        prop1.setValue(new CIMValue((Object)antecedentOP));
        CIMProperty prop2 = new CIMProperty("Dependent");
        prop2.setName("Dependent");
        prop2.setType(new CIMDataType("IBMTSESS_StorageSystem"));
        prop2.setValue(new CIMValue((Object)dependentOP));
        v.add(prop1);
        v.add(prop2);
        cimInstance.setProperties(v);
        return cimInstance;
    }

    private CIMInstance get_ibmtsess_computer_system_package_card(CIMInstance antecedent, CIMInstance dependent) throws Exception {
        CIMObjectPath antecedentOP = this.getObjectPath(antecedent);
        CIMObjectPath dependentOP = this.getObjectPath(dependent);
        CIMInstance cimInstance = new CIMInstance();
        cimInstance.setClassName("IBMTSESS_ComputerSystemPackageCard");
        cimInstance.setName("IBMTSESS_ComputerSystemPackageCard");
        Vector<CIMProperty> v = new Vector<CIMProperty>();
        CIMProperty prop1 = new CIMProperty("Antecedent");
        prop1.setName("Antecedent");
        prop1.setType(new CIMDataType("IBMTSESS_StorageProcessorCard"));
        prop1.setValue(new CIMValue((Object)antecedentOP));
        CIMProperty prop2 = new CIMProperty("Dependent");
        prop2.setName("Dependent");
        prop2.setType(new CIMDataType("IBMTSESS_StorageSystem"));
        prop2.setValue(new CIMValue((Object)dependentOP));
        v.add(prop1);
        v.add(prop2);
        cimInstance.setProperties(v);
        return cimInstance;
    }

    private CIMInstance get_ibmtsess_storage_processor_card(int cardIdx) throws Exception {
        CIMInstance cimInstance = new CIMInstance();
        cimInstance.setClassName("IBMTSESS_StorageProcessorCard");
        cimInstance.setName("IBMTSESS_StorageProcessorCard");
        Vector<CIMProperty> v = new Vector<CIMProperty>();
        int NUM_PROPERTIES = 36;
        CIMProperty[] props = new CIMProperty[NUM_PROPERTIES];
        props[0] = new CIMProperty("CanBeFRUed");
        props[0].setName("CanBeFRUed");
        props[0].setType(CIMDataType.getPredefinedType((int)9));
        Object prop0Val = null;
        props[0].setValue(new CIMValue(prop0Val));
        props[1] = new CIMProperty("Caption");
        props[1].setName("Caption");
        props[1].setType(CIMDataType.getPredefinedType((int)8));
        Object prop1Val = null;
        props[1].setValue(new CIMValue(prop1Val));
        props[2] = new CIMProperty("CreationClassName");
        props[2].setName("CreationClassName");
        props[2].setKey(true);
        props[2].setType(CIMDataType.getPredefinedType((int)8));
        props[2].setValue(new CIMValue((Object)"IBMTSESS_StorageProcessorCard"));
        props[3] = new CIMProperty("Depth");
        props[3].setName("Depth");
        props[3].setType(CIMDataType.getPredefinedType((int)10));
        Object prop3Val = null;
        props[3].setValue(new CIMValue(prop3Val));
        props[4] = new CIMProperty("Description");
        props[4].setName("Description");
        props[4].setType(CIMDataType.getPredefinedType((int)8));
        Object prop4Val = null;
        props[4].setValue(new CIMValue(prop4Val));
        props[5] = new CIMProperty("ElementName");
        props[5].setName("ElementName");
        props[5].setType(CIMDataType.getPredefinedType((int)8));
        String prop5Val = null;
        prop5Val = cardIdx == 0 ? "Cluster One Processor Card" : "Cluster Two Processor Card";
        props[5].setValue(new CIMValue((Object)prop5Val));
        props[6] = new CIMProperty("Height");
        props[6].setName("Height");
        props[6].setType(CIMDataType.getPredefinedType((int)10));
        Object prop6Val = null;
        props[6].setValue(new CIMValue(prop6Val));
        props[7] = new CIMProperty("HostingBoard");
        props[7].setName("HostingBoard");
        props[7].setType(CIMDataType.getPredefinedType((int)9));
        Object prop7Val = null;
        props[7].setValue(new CIMValue(prop7Val));
        props[8] = new CIMProperty("HotSwappable");
        props[8].setName("HotSwappable");
        props[8].setType(CIMDataType.getPredefinedType((int)9));
        Object prop8V = null;
        props[8].setValue(new CIMValue(prop8V));
        props[9] = new CIMProperty("InstallDate");
        props[9].setName("InstallDate");
        props[9].setType(CIMDataType.getPredefinedType((int)12));
        Object prop9Val = null;
        props[9].setValue(new CIMValue(prop9Val));
        props[10] = new CIMProperty("ManufactureDate");
        props[10].setName("ManufactureDate");
        props[10].setType(CIMDataType.getPredefinedType((int)12));
        Object prop10V = null;
        props[10].setValue(new CIMValue(prop10V));
        props[11] = new CIMProperty("Manufacturer");
        props[11].setName("Manufacturer");
        props[11].setType(CIMDataType.getPredefinedType((int)8));
        String prop11Val = "IBM";
        props[11].setValue(new CIMValue((Object)prop11Val));
        props[12] = new CIMProperty("Model");
        props[12].setName("Model");
        props[12].setType(CIMDataType.getPredefinedType((int)8));
        props[12].setValue(new CIMValue((Object)"2107"));
        props[13] = new CIMProperty("Name");
        props[13].setName("Name");
        props[13].setType(CIMDataType.getPredefinedType((int)8));
        props[13].setValue(new CIMValue((Object)this.subsystemName));
        props[14] = new CIMProperty("OperatingVoltages");
        props[14].setName("OperatingVoltages");
        props[14].setType(CIMDataType.getPredefinedType((int)17));
        Vector prop14V = new Vector();
        props[14].setValue(new CIMValue(prop14V));
        props[15] = new CIMProperty("OperationalStatus");
        props[15].setName("OperationalStatus");
        props[15].setType(CIMDataType.getPredefinedType((int)16));
        Vector prop15V = new Vector();
        props[15].setValue(new CIMValue(prop15V));
        props[16] = new CIMProperty("OtherIdentifyingInfo");
        props[16].setName("OtherIdentifyingInfo");
        props[16].setType(CIMDataType.getPredefinedType((int)8));
        Object prop16Val = null;
        props[16].setValue(new CIMValue(prop16Val));
        props[17] = new CIMProperty("PartNumber");
        props[17].setName("PartNumber");
        props[17].setType(CIMDataType.getPredefinedType((int)8));
        Object prop17Val = null;
        props[17].setValue(new CIMValue(prop17Val));
        props[18] = new CIMProperty("PoweredOn");
        props[18].setName("PoweredOn");
        props[18].setType(CIMDataType.getPredefinedType((int)9));
        Object prop18Val = null;
        props[18].setValue(new CIMValue(prop18Val));
        props[19] = new CIMProperty("Removable");
        props[19].setName("Removable");
        props[19].setType(CIMDataType.getPredefinedType((int)9));
        Object prop19Val = null;
        props[19].setValue(new CIMValue(prop19Val));
        props[20] = new CIMProperty("RemovalConditions");
        props[20].setName("RemovalConditions");
        props[20].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 prop20Val = new UnsignedInt16(2);
        props[20].setValue(new CIMValue((Object)prop20Val));
        props[21] = new CIMProperty("Replaceable");
        props[21].setName("Replaceable");
        props[21].setType(CIMDataType.getPredefinedType((int)9));
        Object prop21Val = null;
        props[21].setValue(new CIMValue(prop21Val));
        props[22] = new CIMProperty("RequirementsDescription");
        props[22].setName("RequirementsDescription");
        props[22].setType(CIMDataType.getPredefinedType((int)9));
        Object prop22Val = null;
        props[22].setValue(new CIMValue(prop22Val));
        props[23] = new CIMProperty("RequiresDaughterBoard");
        props[23].setName("RequiresDaughterBoard");
        props[23].setType(CIMDataType.getPredefinedType((int)9));
        Object prop23Val = null;
        props[23].setValue(new CIMValue(prop23Val));
        props[24] = new CIMProperty("SKU");
        props[24].setName("SKU");
        props[24].setType(CIMDataType.getPredefinedType((int)8));
        Object prop24Val = null;
        props[24].setValue(new CIMValue(prop24Val));
        props[25] = new CIMProperty("SerialNumber");
        props[25].setName("SerialNumber");
        props[25].setType(CIMDataType.getPredefinedType((int)8));
        Object prop25Val = null;
        props[25].setValue(new CIMValue(prop25Val));
        props[26] = new CIMProperty("SlotLayout");
        props[26].setName("SlotLayout");
        props[26].setType(CIMDataType.getPredefinedType((int)8));
        Object prop26Val = null;
        props[26].setValue(new CIMValue(prop26Val));
        props[27] = new CIMProperty("SpecialRequirements");
        props[27].setName("SpecialRequirements");
        props[27].setType(CIMDataType.getPredefinedType((int)9));
        Object prop27Val = null;
        props[27].setValue(new CIMValue(prop27Val));
        props[28] = new CIMProperty("Status");
        props[28].setName("Status");
        props[28].setType(CIMDataType.getPredefinedType((int)8));
        Object prop28Val = null;
        props[28].setValue(new CIMValue(prop28Val));
        props[29] = new CIMProperty("StatusDescriptions");
        props[29].setName("StatusDescriptions");
        props[29].setType(CIMDataType.getPredefinedType((int)22));
        Vector prop29Val = new Vector();
        props[29].setValue(new CIMValue(prop29Val));
        props[30] = new CIMProperty("Tag");
        props[30].setName("Tag");
        props[30].setKey(true);
        props[30].setType(CIMDataType.getPredefinedType((int)8));
        String prop30Val = null;
        prop30Val = cardIdx == 0 ? this.subsystemName + " Cluster One" : this.subsystemName + " Cluster Two";
        props[30].setValue(new CIMValue((Object)prop30Val));
        props[31] = new CIMProperty("UserTracking");
        props[31].setName("UserTracking");
        props[31].setType(CIMDataType.getPredefinedType((int)8));
        Object prop31Val = null;
        props[31].setValue(new CIMValue(prop31Val));
        props[32] = new CIMProperty("VendorEquipmentType");
        props[32].setName("VendorEquipmentType");
        props[32].setType(CIMDataType.getPredefinedType((int)8));
        Object prop32Val = null;
        props[32].setValue(new CIMValue(prop32Val));
        props[33] = new CIMProperty("version");
        props[33].setName("version");
        props[33].setType(CIMDataType.getPredefinedType((int)8));
        Object prop33Val = null;
        props[33].setValue(new CIMValue(prop33Val));
        props[34] = new CIMProperty("Weight");
        props[34].setName("Weight");
        props[34].setType(CIMDataType.getPredefinedType((int)8));
        Object prop34Val = null;
        props[34].setValue(new CIMValue(prop34Val));
        props[35] = new CIMProperty("Width");
        props[35].setName("Width");
        props[35].setType(CIMDataType.getPredefinedType((int)8));
        Object prop35Val = null;
        props[35].setValue(new CIMValue(prop35Val));
        for (int idx = 0; idx < NUM_PROPERTIES; ++idx) {
            v.add(props[idx]);
        }
        cimInstance.setProperties(v);
        return cimInstance;
    }

    private CIMInstance get_ibmtsess_computer_system_package(CIMInstance antecedent, CIMInstance dependent) throws Exception {
        CIMObjectPath antecedentOP = this.getObjectPath(antecedent);
        CIMObjectPath dependentOP = this.getObjectPath(dependent);
        CIMInstance cimInstance = new CIMInstance();
        cimInstance.setClassName("IBMTSESS_ComputerSystemPackage");
        cimInstance.setName("IBMTSESS_ComputerSystemPackage");
        Vector<CIMProperty> v = new Vector<CIMProperty>();
        CIMProperty prop1 = new CIMProperty("Antecedent");
        prop1.setName("Antecedent");
        prop1.setType(new CIMDataType("IBMTS_Chassis"));
        prop1.setValue(new CIMValue((Object)antecedentOP));
        CIMProperty prop2 = new CIMProperty("Dependent");
        prop2.setName("Dependent");
        prop2.setType(new CIMDataType("IBMTSESS_StorageSystem"));
        prop2.setValue(new CIMValue((Object)dependentOP));
        v.add(prop1);
        v.add(prop2);
        cimInstance.setProperties(v);
        return cimInstance;
    }

    private CIMInstance get_ibmtsess_software_identity() throws Exception {
        CIMInstance cimInstance = new CIMInstance();
        cimInstance.setClassName("IBMTSESS_SoftwareIdentity");
        cimInstance.setName("IBMTSESS_SoftwareIdentity");
        Vector<CIMProperty> v = new Vector<CIMProperty>();
        int NUM_PROPERTIES = 20;
        CIMProperty[] props = new CIMProperty[NUM_PROPERTIES];
        props[0] = new CIMProperty("BuildNumber");
        props[0].setName("BuildNumber");
        props[0].setType(CIMDataType.getPredefinedType((int)2));
        Object prop0Val = null;
        props[0].setValue(new CIMValue(prop0Val));
        props[1] = new CIMProperty("Caption");
        props[1].setName("Caption");
        props[1].setType(CIMDataType.getPredefinedType((int)8));
        Object prop1Val = null;
        props[1].setValue(new CIMValue(prop1Val));
        props[2] = new CIMProperty("ClassificationDescriptions");
        props[2].setName("ClassificationDescriptions");
        props[2].setType(CIMDataType.getPredefinedType((int)22));
        Vector prop2Val = new Vector();
        props[2].setValue(new CIMValue((Object)"IBMTSESS_PhysicalPackage"));
        props[3] = new CIMProperty("Classifications");
        props[3].setName("Classifications");
        props[3].setType(CIMDataType.getPredefinedType((int)16));
        Vector prop3Val = new Vector();
        props[3].setValue(new CIMValue(prop3Val));
        props[4] = new CIMProperty("Description");
        props[4].setName("Description");
        props[4].setType(CIMDataType.getPredefinedType((int)8));
        Object prop4Val = null;
        props[4].setValue(new CIMValue(prop4Val));
        props[5] = new CIMProperty("ElementName");
        props[5].setName("ElementName");
        props[5].setType(CIMDataType.getPredefinedType((int)8));
        Object prop5Val = null;
        props[5].setValue(new CIMValue(prop5Val));
        props[6] = new CIMProperty("InstallDate");
        props[6].setName("InstallDate");
        props[6].setType(CIMDataType.getPredefinedType((int)12));
        Object prop6Val = null;
        props[6].setValue(new CIMValue(prop6Val));
        props[7] = new CIMProperty("InstanceID");
        props[7].setName("InstanceID");
        props[7].setType(CIMDataType.getPredefinedType((int)8));
        String prop7Val = "IBM:ARC-" + this.subsystemName;
        props[7].setValue(new CIMValue((Object)prop7Val));
        props[8] = new CIMProperty("Languages");
        props[8].setName("Languages");
        props[8].setType(CIMDataType.getPredefinedType((int)22));
        Vector prop8V = new Vector();
        props[8].setValue(new CIMValue(prop8V));
        props[9] = new CIMProperty("MajorVersion");
        props[9].setName("MajorVersion");
        props[9].setType(CIMDataType.getPredefinedType((int)2));
        Object prop9Val = null;
        props[9].setValue(new CIMValue(prop9Val));
        props[10] = new CIMProperty("MinorVersion");
        props[10].setName("MinorVersion");
        props[10].setType(CIMDataType.getPredefinedType((int)2));
        Object prop10V = null;
        props[10].setValue(new CIMValue(prop10V));
        props[11] = new CIMProperty("Manufacturer");
        props[11].setName("Manufacturer");
        props[11].setType(CIMDataType.getPredefinedType((int)8));
        String prop11Val = "IBM";
        props[11].setValue(new CIMValue((Object)prop11Val));
        props[12] = new CIMProperty("Name");
        props[12].setName("Name");
        props[12].setType(CIMDataType.getPredefinedType((int)8));
        Object prop12Val = null;
        props[12].setValue(new CIMValue(prop12Val));
        props[13] = new CIMProperty("OperationalStatus");
        props[13].setName("OperationalStatus");
        props[13].setType(CIMDataType.getPredefinedType((int)16));
        Vector prop13Val = new Vector();
        props[13].setValue(new CIMValue(prop13Val));
        props[14] = new CIMProperty("RevisionNumber");
        props[14].setName("RevisionNumber");
        props[14].setType(CIMDataType.getPredefinedType((int)2));
        Object prop14Val = null;
        props[14].setValue(new CIMValue(prop14Val));
        props[15] = new CIMProperty("SerialNumber");
        props[15].setName("SerialNumber");
        props[15].setType(CIMDataType.getPredefinedType((int)8));
        Object prop15Val = null;
        props[15].setValue(new CIMValue(prop15Val));
        props[16] = new CIMProperty("Status");
        props[16].setName("Status");
        props[16].setType(CIMDataType.getPredefinedType((int)8));
        Object prop16Val = null;
        props[16].setValue(new CIMValue(prop16Val));
        props[17] = new CIMProperty("StatusDescriptions");
        props[17].setName("StatusDescriptions");
        props[17].setType(CIMDataType.getPredefinedType((int)22));
        Vector prop17Val = new Vector();
        props[17].setValue(new CIMValue(prop17Val));
        props[18] = new CIMProperty("TargetOperatingSystems");
        props[18].setName("TargetOperatingSystems");
        props[18].setType(CIMDataType.getPredefinedType((int)22));
        Vector prop18V = new Vector();
        props[18].setValue(new CIMValue(prop18V));
        props[19] = new CIMProperty("VersionString");
        props[19].setName("VersionString");
        props[19].setType(CIMDataType.getPredefinedType((int)8));
        Object prop19Val = null;
        props[19].setValue(new CIMValue(prop19Val));
        for (int idx = 0; idx < NUM_PROPERTIES; ++idx) {
            v.add(props[idx]);
        }
        cimInstance.setProperties(v);
        return cimInstance;
    }

    private CIMInstance get_ibmtsess_physical_package(int ppIdx) throws Exception {
        CIMInstance cimInstance = new CIMInstance();
        cimInstance.setClassName("IBMTSESS_PhysicalPackage");
        cimInstance.setName("IBMTSESS_PhysicalPackage");
        Vector<CIMProperty> v = new Vector<CIMProperty>();
        int NUM_PROPERTIES = 40;
        CIMProperty[] props = new CIMProperty[NUM_PROPERTIES];
        props[0] = new CIMProperty("CanBeFRUed");
        props[0].setName("CanBeFRUed");
        props[0].setType(CIMDataType.getPredefinedType((int)9));
        Object prop0Val = null;
        props[0].setValue(new CIMValue(prop0Val));
        props[1] = new CIMProperty("Caption");
        props[1].setName("Caption");
        props[1].setType(CIMDataType.getPredefinedType((int)8));
        Object prop1Val = null;
        props[1].setValue(new CIMValue(prop1Val));
        props[2] = new CIMProperty("CreationClassName");
        props[2].setName("CreationClassName");
        props[2].setKey(true);
        props[2].setType(CIMDataType.getPredefinedType((int)8));
        props[2].setValue(new CIMValue((Object)"IBMTSESS_PhysicalPackage"));
        props[3] = new CIMProperty("DAPair");
        props[3].setName("DAPair");
        props[3].setType(CIMDataType.getPredefinedType((int)8));
        String prop3Val = new String("2");
        props[3].setValue(new CIMValue((Object)prop3Val));
        props[4] = new CIMProperty("DDMCap");
        props[4].setName("DDMCap");
        props[4].setType(CIMDataType.getPredefinedType((int)10));
        Float prop4Val = new Float("146.0");
        props[4].setValue(new CIMValue((Object)prop4Val));
        props[5] = new CIMProperty("DDMSpeed");
        props[5].setName("DDMSpeed");
        props[5].setType(CIMDataType.getPredefinedType((int)8));
        String prop5Val = "10000";
        props[5].setValue(new CIMValue((Object)prop5Val));
        props[6] = new CIMProperty("Depth");
        props[6].setName("Depth");
        props[6].setType(CIMDataType.getPredefinedType((int)10));
        Object prop6Val = null;
        props[6].setValue(new CIMValue(prop6Val));
        props[7] = new CIMProperty("Description");
        props[7].setName("Description");
        props[7].setType(CIMDataType.getPredefinedType((int)8));
        Object prop7Val = null;
        props[7].setValue(new CIMValue(prop7Val));
        props[8] = new CIMProperty("DeviceAdapters");
        props[8].setName("DeviceAdapters");
        props[8].setType(CIMDataType.getPredefinedType((int)22));
        Vector<String> prop8V = new Vector<String>();
        prop8V.add(this.deviceAdapters[0]);
        prop8V.add(this.deviceAdapters[1]);
        props[8].setValue(new CIMValue(prop8V));
        props[9] = new CIMProperty("ElementName");
        props[9].setName("ElementName");
        props[9].setType(CIMDataType.getPredefinedType((int)8));
        String prop9Val = "null on ESS " + this.subsystemName;
        props[9].setValue(new CIMValue((Object)prop9Val));
        props[10] = new CIMProperty("EnclosureNumbers");
        props[10].setName("EnclosureNumbers");
        props[10].setType(CIMDataType.getPredefinedType((int)22));
        Vector<String> prop10V = new Vector<String>();
        prop10V.add("3");
        prop10V.add("2");
        props[10].setValue(new CIMValue(prop10V));
        props[11] = new CIMProperty("Height");
        props[11].setName("Height");
        props[11].setType(CIMDataType.getPredefinedType((int)10));
        Object prop11Val = null;
        props[11].setValue(new CIMValue(prop11Val));
        props[12] = new CIMProperty("HotSwappable");
        props[12].setName("HotSwappable");
        props[12].setType(CIMDataType.getPredefinedType((int)9));
        Boolean prop12Val = new Boolean(false);
        props[12].setValue(new CIMValue((Object)prop12Val));
        props[13] = new CIMProperty("InstallDate");
        props[13].setName("InstallDate");
        props[13].setType(CIMDataType.getPredefinedType((int)12));
        Object prop13Val = null;
        props[13].setValue(new CIMValue(prop13Val));
        props[14] = new CIMProperty("ManufactureDate");
        props[14].setName("ManufactureDate");
        props[14].setType(CIMDataType.getPredefinedType((int)12));
        Object prop14Val = null;
        props[14].setValue(new CIMValue(prop14Val));
        props[15] = new CIMProperty("Manufacturer");
        props[15].setName("Manufacturer");
        props[15].setType(CIMDataType.getPredefinedType((int)8));
        String prop15Val = "IBM";
        props[15].setValue(new CIMValue((Object)prop15Val));
        props[16] = new CIMProperty("Model");
        props[16].setName("Model");
        props[16].setType(CIMDataType.getPredefinedType((int)8));
        String prop16Val = "undefined";
        props[16].setValue(new CIMValue((Object)prop16Val));
        props[17] = new CIMProperty("Name");
        props[17].setName("Name");
        props[17].setType(CIMDataType.getPredefinedType((int)8));
        props[17].setValue(new CIMValue((Object)this.subsystemName));
        props[18] = new CIMProperty("NumOfDataDisks");
        props[18].setName("NumOfDataDisks");
        props[18].setType(CIMDataType.getPredefinedType((int)2));
        Object prop18Val = null;
        props[18].setValue(new CIMValue(prop18Val));
        props[19] = new CIMProperty("OperationalStatus");
        props[19].setName("OperationalStatus");
        props[19].setType(CIMDataType.getPredefinedType((int)16));
        Vector prop19Val = new Vector();
        props[19].setValue(new CIMValue(prop19Val));
        props[20] = new CIMProperty("OtherIdentifyingInfo");
        props[20].setName("OtherIdentifyingInfo");
        props[20].setType(CIMDataType.getPredefinedType((int)8));
        String prop20Val = "raid5";
        props[20].setValue(new CIMValue((Object)prop20Val));
        props[21] = new CIMProperty("PartNumber");
        props[21].setName("PartNumber");
        props[21].setType(CIMDataType.getPredefinedType((int)8));
        Object prop21Val = null;
        props[21].setValue(new CIMValue(prop21Val));
        props[22] = new CIMProperty("PoweredOn");
        props[22].setName("PoweredOn");
        props[22].setType(CIMDataType.getPredefinedType((int)9));
        Boolean prop22Val = new Boolean(true);
        props[22].setValue(new CIMValue((Object)prop22Val));
        props[23] = new CIMProperty("RIOLoops");
        props[23].setName("RIOLoops");
        props[23].setType(CIMDataType.getPredefinedType((int)22));
        Vector<String> prop23V = new Vector<String>();
        prop23V.add("1669");
        prop23V.add("1669");
        props[23].setValue(new CIMValue(prop23V));
        props[24] = new CIMProperty("RankID");
        props[24].setName("RankID");
        props[24].setType(CIMDataType.getPredefinedType((int)8));
        String prop24Val = "" + ppIdx;
        props[24].setValue(new CIMValue((Object)prop24Val));
        props[25] = new CIMProperty("Removable");
        props[25].setName("Removable");
        props[25].setType(CIMDataType.getPredefinedType((int)9));
        Boolean prop25Val = new Boolean(false);
        props[25].setValue(new CIMValue((Object)prop25Val));
        props[26] = new CIMProperty("RemovalConditions");
        props[26].setName("RemovalConditions");
        props[26].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 prop26Val = new UnsignedInt16(2);
        props[26].setValue(new CIMValue((Object)prop26Val));
        props[27] = new CIMProperty("Replaceable");
        props[27].setName("Replaceable");
        props[27].setType(CIMDataType.getPredefinedType((int)9));
        Boolean prop27Val = new Boolean(true);
        props[27].setValue(new CIMValue((Object)prop27Val));
        props[28] = new CIMProperty("SKU");
        props[28].setName("SKU");
        props[28].setType(CIMDataType.getPredefinedType((int)8));
        Object prop28Val = null;
        props[28].setValue(new CIMValue(prop28Val));
        props[29] = new CIMProperty("SerialNumber");
        props[29].setName("SerialNumber");
        props[29].setType(CIMDataType.getPredefinedType((int)8));
        Object prop29Val = null;
        props[29].setValue(new CIMValue(prop29Val));
        props[30] = new CIMProperty("Status");
        props[30].setName("Status");
        props[30].setType(CIMDataType.getPredefinedType((int)8));
        Object prop30Val = null;
        props[30].setValue(new CIMValue(prop30Val));
        props[31] = new CIMProperty("StatusDescriptions");
        props[31].setName("StatusDescriptions");
        props[31].setType(CIMDataType.getPredefinedType((int)22));
        Vector prop31Val = new Vector();
        props[31].setValue(new CIMValue(prop31Val));
        props[32] = new CIMProperty("SystemCreationClassName");
        props[32].setName("SystemCreationClassName");
        props[32].setKey(true);
        props[32].setType(CIMDataType.getPredefinedType((int)8));
        props[32].setValue(new CIMValue((Object)"IBMTSESS_StorageSystem"));
        props[33] = new CIMProperty("Tag");
        props[33].setName("Tag");
        props[33].setKey(true);
        props[33].setType(CIMDataType.getPredefinedType((int)8));
        String prop33Val = this.subsystemName + "-" + (ppIdx + 1);
        props[33].setValue(new CIMValue((Object)prop33Val));
        props[34] = new CIMProperty("UserTracking");
        props[34].setName("UserTracking");
        props[34].setType(CIMDataType.getPredefinedType((int)8));
        Object prop34Val = null;
        props[34].setValue(new CIMValue(prop34Val));
        props[35] = new CIMProperty("VendorEquipmentType");
        props[35].setName("VendorEquipmentType");
        props[35].setType(CIMDataType.getPredefinedType((int)8));
        Object prop35Val = null;
        props[35].setValue(new CIMValue(prop35Val));
        props[36] = new CIMProperty("version");
        props[36].setName("version");
        props[36].setType(CIMDataType.getPredefinedType((int)8));
        Object prop36Val = null;
        props[36].setValue(new CIMValue(prop36Val));
        props[37] = new CIMProperty("Weight");
        props[37].setName("Weight");
        props[37].setType(CIMDataType.getPredefinedType((int)10));
        Object prop37Val = null;
        props[37].setValue(new CIMValue(prop37Val));
        props[38] = new CIMProperty("Width");
        props[38].setName("Width");
        props[38].setType(CIMDataType.getPredefinedType((int)10));
        Object prop38Val = null;
        props[38].setValue(new CIMValue(prop38Val));
        props[39] = new CIMProperty("location");
        props[39].setName("location");
        props[39].setType(CIMDataType.getPredefinedType((int)8));
        String prop39Val = "Adapter Pair 2, Port (loop), Disk Group " + (ppIdx + 1);
        props[39].setValue(new CIMValue((Object)prop39Val));
        for (int idx = 0; idx < NUM_PROPERTIES; ++idx) {
            v.add(props[idx]);
        }
        cimInstance.setProperties(v);
        return cimInstance;
    }

    private CIMInstance get_ibmtsess_component_cs(CIMInstance groupComponent, CIMInstance partComponent) throws Exception {
        CIMObjectPath groupComponentOP = this.getObjectPath(groupComponent);
        CIMObjectPath partComponentOP = this.getObjectPath(partComponent);
        CIMInstance cimInstance = new CIMInstance();
        cimInstance.setClassName("IBMTS_ComponentCS");
        cimInstance.setName("IBMTS_ComponentCS");
        Vector<CIMProperty> v = new Vector<CIMProperty>();
        CIMProperty prop1 = new CIMProperty("GroupComponent");
        prop1.setName("GroupComponent");
        prop1.setType(new CIMDataType("IBMTSESS_StorageSystem"));
        prop1.setValue(new CIMValue((Object)groupComponentOP));
        CIMProperty prop2 = new CIMProperty("PartComponent");
        prop2.setName("PartComponent");
        prop2.setType(new CIMDataType("IBMTSESS_Cluster"));
        prop2.setValue(new CIMValue((Object)partComponentOP));
        v.add(prop1);
        v.add(prop2);
        cimInstance.setProperties(v);
        return cimInstance;
    }

    private CIMInstance get_ibmtsess_location() throws Exception {
        CIMInstance cimInstance = new CIMInstance();
        cimInstance.setClassName("IBMTSESS_Location");
        cimInstance.setName("IBMTSESS_Location");
        Vector<CIMProperty> v = new Vector<CIMProperty>();
        int NUM_PROPERTIES = 6;
        CIMProperty[] props = new CIMProperty[NUM_PROPERTIES];
        props[0] = new CIMProperty("Address");
        props[0].setName("Address");
        props[0].setType(CIMDataType.getPredefinedType((int)8));
        Object prop0Val = null;
        props[0].setValue(new CIMValue(prop0Val));
        props[1] = new CIMProperty("Caption");
        props[1].setName("Caption");
        props[1].setType(CIMDataType.getPredefinedType((int)8));
        Object prop1Val = null;
        props[1].setValue(new CIMValue(prop1Val));
        props[2] = new CIMProperty("Description");
        props[2].setName("Description");
        props[2].setType(CIMDataType.getPredefinedType((int)8));
        Object prop2Val = null;
        props[2].setValue(new CIMValue(prop2Val));
        props[3] = new CIMProperty("ElementName");
        props[3].setName("ElementName");
        props[3].setType(CIMDataType.getPredefinedType((int)8));
        String prop3Val = new String("DataCenter1");
        props[3].setValue(new CIMValue((Object)prop3Val));
        props[4] = new CIMProperty("Name");
        props[4].setName("Name");
        props[4].setKey(true);
        props[4].setType(CIMDataType.getPredefinedType((int)8));
        props[4].setValue(new CIMValue((Object)this.subsystemName));
        props[5] = new CIMProperty("PhysicalPosition");
        props[5].setName("PhysicalPosition");
        props[5].setKey(true);
        props[5].setType(CIMDataType.getPredefinedType((int)8));
        String prop5Val = "Some Rack";
        props[5].setValue(new CIMValue((Object)prop5Val));
        for (int idx = 0; idx < NUM_PROPERTIES; ++idx) {
            v.add(props[idx]);
        }
        cimInstance.setProperties(v);
        return cimInstance;
    }

    private CIMInstance get_ibmtsess_fcport(int portIdx) throws Exception {
        CIMInstance cimInstance = new CIMInstance();
        cimInstance.setClassName("IBMTS_FCPort");
        cimInstance.setName("IBMTS_FCPort");
        Vector<CIMProperty> v = new Vector<CIMProperty>();
        int NUM_PROPERTIES = 56;
        CIMProperty[] props = new CIMProperty[NUM_PROPERTIES];
        props[0] = new CIMProperty("ActiveCOS");
        props[0].setName("ActiveCOS");
        props[0].setType(CIMDataType.getPredefinedType((int)2));
        Object prop0Val = null;
        props[0].setValue(new CIMValue(prop0Val));
        props[1] = new CIMProperty("ActiveFC4Types");
        props[1].setName("ActiveFC4Types");
        props[1].setType(CIMDataType.getPredefinedType((int)16));
        Vector prop1Val = new Vector();
        props[1].setValue(new CIMValue(prop1Val));
        props[2] = new CIMProperty("ActiveMaximumTransmissionUnit");
        props[2].setName("ActiveMaximumTransmissionUnit");
        props[2].setType(CIMDataType.getPredefinedType((int)6));
        Object prop2Val = null;
        props[2].setValue(new CIMValue(prop2Val));
        props[3] = new CIMProperty("AdditionalAvailability");
        props[3].setName("AdditionalAvailability");
        props[3].setType(CIMDataType.getPredefinedType((int)16));
        Vector prop3Val = new Vector();
        props[3].setValue(new CIMValue(prop3Val));
        props[4] = new CIMProperty("Caption");
        props[4].setName("Caption");
        props[4].setType(CIMDataType.getPredefinedType((int)8));
        Object prop4Val = null;
        props[4].setValue(new CIMValue(prop4Val));
        props[5] = new CIMProperty("CreationClassName");
        props[5].setName("CreationClassName");
        props[5].setKey(true);
        props[5].setType(CIMDataType.getPredefinedType((int)8));
        props[5].setValue(new CIMValue((Object)"IBMTS_FCPort"));
        props[6] = new CIMProperty("Description");
        props[6].setName("Description");
        props[6].setType(CIMDataType.getPredefinedType((int)8));
        Object prop6Val = null;
        props[6].setValue(new CIMValue(prop6Val));
        props[7] = new CIMProperty("DeviceID");
        props[7].setName("DeviceID");
        props[7].setKey(true);
        props[7].setType(CIMDataType.getPredefinedType((int)8));
        String prop7Val = null;
        prop7Val = portIdx < 10 ? "000" + portIdx : "00" + portIdx;
        props[7].setValue(new CIMValue((Object)prop7Val));
        props[8] = new CIMProperty("ElementName");
        props[8].setName("ElementName");
        props[8].setType(CIMDataType.getPredefinedType((int)8));
        String port8Val = "Port" + prop7Val;
        props[8].setValue(new CIMValue((Object)"IBMTS_Chassis"));
        props[9] = new CIMProperty("EnabledDefault");
        props[9].setName("EnabledDefault");
        props[9].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 prop9Val = new UnsignedInt16(2);
        props[9].setValue(new CIMValue((Object)prop9Val));
        props[10] = new CIMProperty("EnabledState");
        props[10].setName("EnabledState");
        props[10].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 prop10Val = new UnsignedInt16(6);
        props[10].setValue(new CIMValue((Object)prop10Val));
        props[11] = new CIMProperty("EnclosureNumbers");
        props[11].setName("EnclosureNumbers");
        props[11].setType(CIMDataType.getPredefinedType((int)8));
        String prop11Val = null;
        if (portIdx >= 0 && portIdx <= 3) {
            prop11Val = "0";
        } else if (portIdx >= 4 && portIdx <= 7) {
            prop11Val = "1";
        } else if (portIdx >= 8 && portIdx <= 11) {
            prop11Val = "2";
        } else if (portIdx >= 12 && portIdx <= 15) {
            prop11Val = "3";
        }
        props[11].setValue(new CIMValue((Object)prop11Val));
        props[12] = new CIMProperty("ErrorCleared");
        props[12].setName("ErrorCleared");
        props[12].setType(CIMDataType.getPredefinedType((int)9));
        Object prop12Val = null;
        props[12].setValue(new CIMValue(prop12Val));
        props[13] = new CIMProperty("ErrorDescription");
        props[13].setName("ErrorDescription");
        props[13].setType(CIMDataType.getPredefinedType((int)8));
        Object prop13Val = null;
        props[13].setValue(new CIMValue(prop13Val));
        props[14] = new CIMProperty("FullDuplex");
        props[14].setName("FullDuplex");
        props[14].setType(CIMDataType.getPredefinedType((int)9));
        Object prop14Val = null;
        props[14].setValue(new CIMValue(prop14Val));
        props[15] = new CIMProperty("HostAdapter");
        props[15].setName("HostAdapter");
        props[15].setType(CIMDataType.getPredefinedType((int)8));
        String prop15Val = null;
        if (portIdx >= 0 && portIdx <= 3) {
            prop15Val = this.hostAdapters[0];
        } else if (portIdx >= 4 && portIdx <= 7) {
            prop15Val = this.hostAdapters[1];
        } else if (portIdx >= 8 && portIdx <= 11) {
            prop15Val = this.hostAdapters[2];
        } else if (portIdx >= 12 && portIdx <= 15) {
            prop15Val = this.hostAdapters[3];
        }
        props[15].setValue(new CIMValue((Object)prop15Val));
        props[16] = new CIMProperty("IdentifyingDescriptions");
        props[16].setName("IdentifyingDescriptions");
        props[16].setType(CIMDataType.getPredefinedType((int)22));
        Vector prop16Val = new Vector();
        props[16].setValue(new CIMValue(prop16Val));
        props[17] = new CIMProperty("InstallDate");
        props[17].setName("InstallDate");
        props[17].setType(CIMDataType.getPredefinedType((int)12));
        Object prop17Val = null;
        props[17].setValue(new CIMValue(prop17Val));
        props[18] = new CIMProperty("LastErrorCode");
        props[18].setName("LastErrorCode");
        props[18].setType(CIMDataType.getPredefinedType((int)4));
        Object prop18Val = null;
        props[18].setValue(new CIMValue(prop18Val));
        props[19] = new CIMProperty("LinkTechnology");
        props[19].setName("LinkTechnology");
        props[19].setType(CIMDataType.getPredefinedType((int)2));
        Object prop19Val = null;
        props[19].setValue(new CIMValue(prop19Val));
        props[20] = new CIMProperty("MaxQuiesceTime");
        props[20].setName("MaxQuiesceTime");
        props[20].setType(CIMDataType.getPredefinedType((int)6));
        Object prop20Val = null;
        props[20].setValue(new CIMValue(prop20Val));
        props[21] = new CIMProperty("Name");
        props[21].setName("Name");
        props[21].setType(CIMDataType.getPredefinedType((int)8));
        Object prop21Val = null;
        props[21].setValue(new CIMValue(prop21Val));
        props[22] = new CIMProperty("NetworkAddresses");
        props[22].setName("NetworkAddresses");
        props[22].setType(CIMDataType.getPredefinedType((int)22));
        Vector prop22Val = new Vector();
        props[22].setValue(new CIMValue(prop22Val));
        props[23] = new CIMProperty("OperationalStatus");
        props[23].setName("OperationalStatus");
        props[23].setType(CIMDataType.getPredefinedType((int)16));
        Vector<UnsignedInt16> prop23V = new Vector<UnsignedInt16>();
        prop23V.add(new UnsignedInt16(2));
        props[23].setValue(new CIMValue(prop23V));
        props[24] = new CIMProperty("OtherEnabledState");
        props[24].setName("OtherEnabledState");
        props[24].setType(CIMDataType.getPredefinedType((int)8));
        Object prop24Val = null;
        props[24].setValue(new CIMValue(prop24Val));
        props[25] = new CIMProperty("OtherIdentifyingInfo");
        props[25].setName("OtherIdentifyingInfo");
        props[25].setType(CIMDataType.getPredefinedType((int)22));
        Vector prop25Val = new Vector();
        props[25].setValue(new CIMValue(prop25Val));
        props[26] = new CIMProperty("OtherLinkTechnology");
        props[26].setName("OtherLinkTechnology");
        props[26].setType(CIMDataType.getPredefinedType((int)8));
        Object prop26Val = null;
        props[26].setValue(new CIMValue(prop26Val));
        props[27] = new CIMProperty("OtherNetworkPortType");
        props[27].setName("OtherNetworkPortType");
        props[27].setType(CIMDataType.getPredefinedType((int)8));
        Object prop27Val = null;
        props[27].setValue(new CIMValue(prop27Val));
        props[28] = new CIMProperty("PermanentAddress");
        props[28].setName("PermanentAddress");
        props[28].setType(CIMDataType.getPredefinedType((int)8));
        props[28].setValue(new CIMValue((Object)this.wwn));
        props[29] = new CIMProperty("PortNumber");
        props[29].setName("PortNumber");
        props[29].setType(CIMDataType.getPredefinedType((int)2));
        Object prop29Val = null;
        props[29].setValue(new CIMValue(prop29Val));
        props[30] = new CIMProperty("PortType");
        props[30].setName("PortType");
        props[30].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 prop30Val = new UnsignedInt16(11);
        props[30].setValue(new CIMValue((Object)prop30Val));
        props[31] = new CIMProperty("PowerManagementCapabilities");
        props[31].setName("PowerManagementCapabilities");
        props[31].setType(CIMDataType.getPredefinedType((int)16));
        Vector prop31Val = new Vector();
        props[31].setValue(new CIMValue(prop31Val));
        props[32] = new CIMProperty("PowerManagementSupported");
        props[32].setName("PowerManagementSupported");
        props[32].setType(CIMDataType.getPredefinedType((int)9));
        Object prop32Val = null;
        props[32].setValue(new CIMValue(prop32Val));
        props[33] = new CIMProperty("PoweredOnHours");
        props[33].setName("PoweredOnHours");
        props[33].setType(CIMDataType.getPredefinedType((int)6));
        Object prop33Val = null;
        props[33].setValue(new CIMValue(prop33Val));
        props[34] = new CIMProperty("RIOLoop");
        props[34].setName("RIOLoop");
        props[34].setType(CIMDataType.getPredefinedType((int)8));
        String prop34Val = "1669";
        props[34].setValue(new CIMValue((Object)prop34Val));
        props[35] = new CIMProperty("RequestedSpeed");
        props[35].setName("RequestedSpeed");
        props[35].setType(CIMDataType.getPredefinedType((int)6));
        Object prop35Val = null;
        props[35].setValue(new CIMValue(prop35Val));
        props[36] = new CIMProperty("RequestedState");
        props[36].setName("RequestedState");
        props[36].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 prop36Val = new UnsignedInt16(5);
        props[36].setValue(new CIMValue((Object)prop36Val));
        props[37] = new CIMProperty("Speed");
        props[37].setName("Speed");
        props[37].setType(CIMDataType.getPredefinedType((int)6));
        UnsignedInt64 prop37Val = new UnsignedInt64("2000000000");
        props[37].setValue(new CIMValue((Object)prop37Val));
        props[38] = new CIMProperty("Status");
        props[38].setName("Status");
        props[38].setType(CIMDataType.getPredefinedType((int)8));
        Object prop38Val = null;
        props[38].setValue(new CIMValue(prop38Val));
        props[39] = new CIMProperty("StatusDescriptions");
        props[39].setName("StatusDescriptions");
        props[39].setType(CIMDataType.getPredefinedType((int)22));
        Vector prop39Val = new Vector();
        props[39].setValue(new CIMValue(prop39Val));
        props[40] = new CIMProperty("StatusInfo");
        props[40].setName("StatusInfo");
        props[40].setType(CIMDataType.getPredefinedType((int)2));
        Object prop40Val = null;
        props[40].setValue(new CIMValue(prop40Val));
        props[41] = new CIMProperty("SupportedCOS");
        props[41].setName("SupportedCOS");
        props[41].setType(CIMDataType.getPredefinedType((int)8));
        props[41].setValue(new CIMValue((Object)"IBM Enterprise System Server"));
        props[42] = new CIMProperty("SupportedFC4Types");
        props[42].setName("SupportedFC4Types");
        props[42].setType(CIMDataType.getPredefinedType((int)16));
        Vector prop42V = new Vector();
        props[42].setValue(new CIMValue(prop42V));
        props[43] = new CIMProperty("SupportedMaximumTransmissionUnit");
        props[43].setName("SupportedMaximumTransmissionUnit");
        props[43].setType(CIMDataType.getPredefinedType((int)6));
        Object prop43Val = null;
        props[43].setValue(new CIMValue(prop43Val));
        props[44] = new CIMProperty("SystemCreationClassName");
        props[44].setName("SystemCreationClassName");
        props[44].setKey(true);
        props[44].setType(CIMDataType.getPredefinedType((int)8));
        props[44].setValue(new CIMValue((Object)"IBMTSESS_StorageSystem"));
        props[45] = new CIMProperty("SystemName");
        props[45].setName("SystemName");
        props[45].setKey(true);
        props[45].setType(CIMDataType.getPredefinedType((int)8));
        props[45].setValue(new CIMValue((Object)this.subsystemName));
        props[46] = new CIMProperty("TimeOfLastStateChange");
        props[46].setName("TimeOfLastStateChange");
        props[46].setType(CIMDataType.getPredefinedType((int)12));
        Object prop46Val = null;
        props[46].setValue(new CIMValue(prop46Val));
        props[47] = new CIMProperty("TotalPowerOnHours");
        props[47].setName("TotalPowerOnHours");
        props[47].setType(CIMDataType.getPredefinedType((int)6));
        Object prop47Val = null;
        props[47].setValue(new CIMValue(prop47Val));
        props[48] = new CIMProperty("UsageRestriction");
        props[48].setName("UsageRestriction");
        props[48].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 prop48Val = new UnsignedInt16(2);
        props[48].setValue(new CIMValue((Object)prop48Val));
        props[49] = new CIMProperty("loc");
        props[49].setName("loc");
        props[49].setType(CIMDataType.getPredefinedType((int)8));
        String prop49Val = null;
        if (portIdx >= 0 && portIdx <= 3) {
            prop49Val = this.hostAdapters[0] + "-T" + portIdx % 4;
        } else if (portIdx >= 4 && portIdx <= 7) {
            prop49Val = this.hostAdapters[0] + "-T" + portIdx % 4;
        } else if (portIdx >= 8 && portIdx <= 11) {
            prop49Val = this.hostAdapters[0] + "-T" + portIdx % 4;
        } else if (portIdx >= 12 && portIdx <= 15) {
            prop49Val = this.hostAdapters[0] + "-T" + portIdx % 4;
        }
        props[49].setValue(new CIMValue(prop49Val));
        props[50] = new CIMProperty("topology");
        props[50].setName("topology");
        props[50].setType(CIMDataType.getPredefinedType((int)8));
        if (portIdx >= 0 || portIdx <= 7) {
            props[50].setValue(new CIMValue((Object)"Unknown"));
        } else {
            props[50].setValue(new CIMValue((Object)"SCSIFcp"));
        }
        props[51] = new CIMProperty("Type");
        props[51].setName("Type");
        props[51].setType(CIMDataType.getPredefinedType((int)8));
        props[51].setValue(new CIMValue((Object)"FIBRE"));
        props[52] = new CIMProperty("Type");
        props[52].setName("Type");
        props[52].setType(CIMDataType.getPredefinedType((int)8));
        props[52].setValue(new CIMValue((Object)"FIBRE"));
        props[53] = new CIMProperty("wwn");
        props[53].setName("wwn");
        props[53].setType(CIMDataType.getPredefinedType((int)8));
        props[53].setValue(new CIMValue((Object)this.wwn));
        props[54] = new CIMProperty("AutoSense");
        props[54].setName("AutoSense");
        props[54].setType(CIMDataType.getPredefinedType((int)9));
        Object prop54Val = null;
        props[54].setValue(new CIMValue(prop54Val));
        props[55] = new CIMProperty("Availability");
        props[55].setName("Availability");
        props[55].setType(CIMDataType.getPredefinedType((int)2));
        Object prop55Val = null;
        props[55].setValue(new CIMValue(prop55Val));
        for (int idx = 0; idx < NUM_PROPERTIES; ++idx) {
            v.add(props[idx]);
        }
        cimInstance.setProperties(v);
        return cimInstance;
    }

    private CIMInstance get_ibmtsess_chassis() throws Exception {
        CIMInstance cimInstance = new CIMInstance();
        cimInstance.setClassName("IBMTS_Chassis");
        cimInstance.setName("IBMTS_Chassis");
        Vector<CIMProperty> v = new Vector<CIMProperty>();
        int NUM_PROPERTIES = 48;
        CIMProperty[] props = new CIMProperty[NUM_PROPERTIES];
        props[0] = new CIMProperty("AudibleAlarm");
        props[0].setName("AudibleAlarm");
        props[0].setType(CIMDataType.getPredefinedType((int)9));
        Object prop0Val = null;
        props[0].setValue(new CIMValue(prop0Val));
        props[1] = new CIMProperty("BreachDescription");
        props[1].setName("BreachDescription");
        props[1].setType(CIMDataType.getPredefinedType((int)8));
        Object prop1Val = null;
        props[1].setValue(new CIMValue(prop1Val));
        props[2] = new CIMProperty("CableManagementStrategy");
        props[2].setName("CableManagementStrategy");
        props[2].setType(CIMDataType.getPredefinedType((int)8));
        Object prop2Val = null;
        props[2].setValue(new CIMValue(prop2Val));
        props[3] = new CIMProperty("CanBeFRUed");
        props[3].setName("CanBeFRUed");
        props[3].setType(CIMDataType.getPredefinedType((int)9));
        Object prop3Val = null;
        props[3].setValue(new CIMValue(prop3Val));
        props[4] = new CIMProperty("Caption");
        props[4].setName("Caption");
        props[4].setType(CIMDataType.getPredefinedType((int)8));
        Object prop4Val = null;
        props[4].setValue(new CIMValue(prop4Val));
        props[5] = new CIMProperty("ChassisPackageType");
        props[5].setName("ChassisPackageType");
        props[5].setType(CIMDataType.getPredefinedType((int)2));
        Object prop5Val = null;
        props[5].setValue(new CIMValue(prop5Val));
        props[6] = new CIMProperty("ChassisTypeDescription");
        props[6].setName("ChassisTypeDescription");
        props[6].setType(CIMDataType.getPredefinedType((int)8));
        Object prop6Val = null;
        props[6].setValue(new CIMValue(prop6Val));
        props[7] = new CIMProperty("ChassisTypes");
        props[7].setName("ChassisTypes");
        props[7].setType(CIMDataType.getPredefinedType((int)16));
        Vector<UnsignedInt16> prop7V = new Vector<UnsignedInt16>();
        prop7V.add(new UnsignedInt16(22));
        props[7].setValue(new CIMValue(prop7V));
        props[8] = new CIMProperty("CreationClassName");
        props[8].setName("CreationClassName");
        props[8].setKey(true);
        props[8].setType(CIMDataType.getPredefinedType((int)8));
        props[8].setValue(new CIMValue((Object)"IBMTS_Chassis"));
        props[9] = new CIMProperty("CurrentRequiredOrProduced");
        props[9].setName("CurrentRequiredOrProduced");
        props[9].setType(CIMDataType.getPredefinedType((int)3));
        Short prop9Val = new Short("-1");
        props[9].setValue(new CIMValue((Object)prop9Val));
        props[10] = new CIMProperty("Depth");
        props[10].setName("Depth");
        props[10].setType(CIMDataType.getPredefinedType((int)10));
        Object prop10Val = null;
        props[10].setValue(new CIMValue(prop10Val));
        props[11] = new CIMProperty("Description");
        props[11].setName("Description");
        props[11].setType(CIMDataType.getPredefinedType((int)8));
        Object prop11Val = null;
        props[11].setValue(new CIMValue(prop11Val));
        props[12] = new CIMProperty("ElementName");
        props[12].setName("ElementName");
        props[12].setType(CIMDataType.getPredefinedType((int)8));
        String prop12Val = "Chassis";
        props[12].setValue(new CIMValue((Object)prop12Val));
        props[13] = new CIMProperty("HeatGeneration");
        props[13].setName("HeatGeneration");
        props[13].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 prop13Val = new UnsignedInt16(0);
        props[13].setValue(new CIMValue((Object)prop13Val));
        props[14] = new CIMProperty("Height");
        props[14].setName("Height");
        props[14].setType(CIMDataType.getPredefinedType((int)10));
        Object prop14Val = null;
        props[14].setValue(new CIMValue(prop14Val));
        props[15] = new CIMProperty("HotSwappable");
        props[15].setName("HotSwappable");
        props[15].setType(CIMDataType.getPredefinedType((int)9));
        Object prop15Val = null;
        props[15].setValue(new CIMValue(prop15Val));
        props[16] = new CIMProperty("InstallDate");
        props[16].setName("InstallDate");
        props[16].setType(CIMDataType.getPredefinedType((int)12));
        Object prop16Val = null;
        props[16].setValue(new CIMValue(prop16Val));
        props[17] = new CIMProperty("IsLocked");
        props[17].setName("IsLocked");
        props[17].setType(CIMDataType.getPredefinedType((int)9));
        Object prop17Val = null;
        props[17].setValue(new CIMValue(prop17Val));
        props[18] = new CIMProperty("LockPresent");
        props[18].setName("LockPresent");
        props[18].setType(CIMDataType.getPredefinedType((int)9));
        Object prop18Val = null;
        props[18].setValue(new CIMValue(prop18Val));
        props[19] = new CIMProperty("ManufactureDate");
        props[19].setName("ManufactureDate");
        props[19].setType(CIMDataType.getPredefinedType((int)12));
        Object prop19Val = null;
        props[19].setValue(new CIMValue(prop19Val));
        props[20] = new CIMProperty("Manufacturer");
        props[20].setName("Manufacturer");
        props[20].setType(CIMDataType.getPredefinedType((int)8));
        props[20].setValue(new CIMValue((Object)"IBM"));
        props[21] = new CIMProperty("Model");
        props[21].setName("Model");
        props[21].setType(CIMDataType.getPredefinedType((int)8));
        props[21].setValue(new CIMValue((Object)this.subsystemName));
        props[22] = new CIMProperty("MultipleSystemSupport");
        props[22].setName("MultipleSystemSupport");
        props[22].setType(CIMDataType.getPredefinedType((int)2));
        Object prop22Val = null;
        props[22].setValue(new CIMValue(prop22Val));
        props[23] = new CIMProperty("Name");
        props[23].setName("Name");
        props[23].setType(CIMDataType.getPredefinedType((int)8));
        Object prop23Val = null;
        props[23].setValue(new CIMValue(prop23Val));
        props[24] = new CIMProperty("NumberOfPowerCords");
        props[24].setName("NumberOfPowerCords");
        props[24].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 prop24Val = new UnsignedInt16(2);
        props[24].setValue(new CIMValue((Object)prop24Val));
        props[25] = new CIMProperty("OperationalStatus");
        props[25].setName("OperationalStatus");
        props[25].setType(CIMDataType.getPredefinedType((int)16));
        Vector prop25Val = new Vector();
        props[25].setValue(new CIMValue(prop25Val));
        props[26] = new CIMProperty("OtherIdentifyingInfo");
        props[26].setName("OtherIdentifyingInfo");
        props[26].setType(CIMDataType.getPredefinedType((int)8));
        Object prop26Val = null;
        props[26].setValue(new CIMValue(prop26Val));
        props[27] = new CIMProperty("PartNumber");
        props[27].setName("PartNumber");
        props[27].setType(CIMDataType.getPredefinedType((int)8));
        Object prop27Val = null;
        props[27].setValue(new CIMValue(prop27Val));
        props[28] = new CIMProperty("PoweredOn");
        props[28].setName("PoweredOn");
        props[28].setType(CIMDataType.getPredefinedType((int)9));
        Object prop28Val = null;
        props[28].setValue(new CIMValue(prop28Val));
        props[29] = new CIMProperty("RackMountable");
        props[29].setName("RackMountable");
        props[29].setType(CIMDataType.getPredefinedType((int)2));
        Object prop29Val = null;
        props[29].setValue(new CIMValue(prop29Val));
        props[30] = new CIMProperty("Removable");
        props[30].setName("Removable");
        props[30].setType(CIMDataType.getPredefinedType((int)9));
        Object prop30Val = null;
        props[30].setValue(new CIMValue(prop30Val));
        props[31] = new CIMProperty("RemovalConditions");
        props[31].setName("RemovalConditions");
        props[31].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 prop31Val = new UnsignedInt16(2);
        props[31].setValue(new CIMValue((Object)prop31Val));
        props[32] = new CIMProperty("Replaceable");
        props[32].setName("Replaceable");
        props[32].setType(CIMDataType.getPredefinedType((int)9));
        Object prop32Val = null;
        props[32].setValue(new CIMValue(prop32Val));
        props[33] = new CIMProperty("SKU");
        props[33].setName("SKU");
        props[33].setType(CIMDataType.getPredefinedType((int)8));
        Object prop33Val = null;
        props[33].setValue(new CIMValue(prop33Val));
        props[34] = new CIMProperty("SecurityBreach");
        props[34].setName("SecurityBreach");
        props[34].setType(CIMDataType.getPredefinedType((int)2));
        Object prop34Val = null;
        props[34].setValue(new CIMValue(prop34Val));
        props[35] = new CIMProperty("SerialNumber");
        props[35].setName("SerialNumber");
        props[35].setType(CIMDataType.getPredefinedType((int)8));
        Object prop35Val = null;
        props[35].setValue(new CIMValue(prop35Val));
        props[36] = new CIMProperty("ServiceDescriptions");
        props[36].setName("ServiceDescriptions");
        props[36].setType(CIMDataType.getPredefinedType((int)22));
        Vector prop36Val = new Vector();
        props[36].setValue(new CIMValue(prop36Val));
        props[37] = new CIMProperty("ServicePhilosophy");
        props[37].setName("ServicePhilosophy");
        props[37].setType(CIMDataType.getPredefinedType((int)22));
        Vector prop37Val = new Vector();
        props[37].setValue(new CIMValue(prop37Val));
        props[38] = new CIMProperty("Status");
        props[38].setName("Status");
        props[38].setType(CIMDataType.getPredefinedType((int)8));
        Object prop38Val = null;
        props[38].setValue(new CIMValue(prop38Val));
        props[39] = new CIMProperty("StatusDescriptions");
        props[39].setName("StatusDescriptions");
        props[39].setType(CIMDataType.getPredefinedType((int)22));
        Vector prop39Val = new Vector();
        props[39].setValue(new CIMValue(prop39Val));
        props[40] = new CIMProperty("Tag");
        props[40].setName("Tag");
        props[40].setKey(true);
        props[40].setType(CIMDataType.getPredefinedType((int)8));
        props[40].setValue(new CIMValue((Object)this.subsystemName));
        props[41] = new CIMProperty("TypeDescriptions");
        props[41].setName("TypeDescriptions");
        props[41].setType(CIMDataType.getPredefinedType((int)8));
        props[41].setValue(new CIMValue((Object)"IBM Enterprise System Server"));
        props[42] = new CIMProperty("UserTracking");
        props[42].setName("UserTracking");
        props[42].setType(CIMDataType.getPredefinedType((int)8));
        props[42].setValue(new CIMValue((Object)"IBM Enterprise System Server"));
        props[43] = new CIMProperty("version");
        props[43].setName("version");
        props[43].setType(CIMDataType.getPredefinedType((int)8));
        Object prop43Val = null;
        props[43].setValue(new CIMValue(prop43Val));
        props[44] = new CIMProperty("VisibleAlarm");
        props[44].setName("VisibleAlarm");
        props[44].setType(CIMDataType.getPredefinedType((int)9));
        Object prop44Val = null;
        props[44].setValue(new CIMValue(prop44Val));
        props[45] = new CIMProperty("Weight");
        props[45].setName("Weight");
        props[45].setType(CIMDataType.getPredefinedType((int)10));
        Object prop45Val = null;
        props[45].setValue(new CIMValue(prop45Val));
        props[46] = new CIMProperty("Width");
        props[46].setName("Width");
        props[46].setType(CIMDataType.getPredefinedType((int)10));
        Object prop46Val = null;
        props[46].setValue(new CIMValue(prop46Val));
        props[47] = new CIMProperty("VendorEquipmentType");
        props[47].setName("VendorEquipmentType");
        props[47].setType(CIMDataType.getPredefinedType((int)8));
        Object prop47Val = null;
        props[47].setValue(new CIMValue(prop47Val));
        for (int idx = 0; idx < NUM_PROPERTIES; ++idx) {
            v.add(props[idx]);
        }
        cimInstance.setProperties(v);
        return cimInstance;
    }

    private CIMInstance get_ibmtsess_product() throws Exception {
        CIMInstance cimInstance = new CIMInstance();
        cimInstance.setClassName("IBMTSESS_Product");
        cimInstance.setName("IBMTSESS_Product");
        Vector<CIMProperty> v = new Vector<CIMProperty>();
        int NUM_PROPERTIES = 10;
        CIMProperty[] props = new CIMProperty[NUM_PROPERTIES];
        props[0] = new CIMProperty("Caption");
        props[0].setName("Caption");
        props[0].setType(CIMDataType.getPredefinedType((int)8));
        Object prop0Val = null;
        props[0].setValue(new CIMValue(prop0Val));
        props[1] = new CIMProperty("Description");
        props[1].setName("Description");
        props[1].setType(CIMDataType.getPredefinedType((int)8));
        Object prop1Val = null;
        props[1].setValue(new CIMValue(prop1Val));
        props[2] = new CIMProperty("ElementName");
        props[2].setName("ElementName");
        props[2].setType(CIMDataType.getPredefinedType((int)8));
        String prop2Val = "IBM Product 5.0.500.123";
        props[2].setValue(new CIMValue((Object)prop2Val));
        props[3] = new CIMProperty("IdentifyingNumber");
        props[3].setName("IdentifyingNumber");
        props[3].setKey(true);
        props[3].setType(CIMDataType.getPredefinedType((int)8));
        props[3].setValue(new CIMValue((Object)this.subsystemName));
        props[4] = new CIMProperty("Name");
        props[4].setName("Name");
        props[4].setKey(true);
        props[4].setType(CIMDataType.getPredefinedType((int)8));
        props[4].setValue(new CIMValue((Object)"IBM TotalStorage DS8000"));
        props[5] = new CIMProperty("SKUNumber");
        props[5].setName("SKUNumber");
        props[5].setType(CIMDataType.getPredefinedType((int)8));
        Object prop5Val = null;
        props[5].setValue(new CIMValue(prop5Val));
        props[6] = new CIMProperty("Vendor");
        props[6].setName("Vendor");
        props[6].setKey(true);
        props[6].setType(CIMDataType.getPredefinedType((int)8));
        props[6].setValue(new CIMValue((Object)"IBM"));
        props[7] = new CIMProperty("version");
        props[7].setName("version");
        props[7].setKey(true);
        props[7].setType(CIMDataType.getPredefinedType((int)8));
        props[7].setValue(new CIMValue((Object)"5.0.500.123"));
        props[8] = new CIMProperty("WarrantyDuration");
        props[8].setName("WarrantyDuration");
        props[8].setType(CIMDataType.getPredefinedType((int)4));
        Object prop8Val = null;
        props[8].setValue(new CIMValue(prop8Val));
        props[9] = new CIMProperty("WarrantyStartDate");
        props[9].setName("WarrantyStartDate");
        props[9].setType(CIMDataType.getPredefinedType((int)12));
        Object prop9Val = null;
        props[9].setValue(new CIMValue(prop9Val));
        for (int idx = 0; idx < NUM_PROPERTIES; ++idx) {
            v.add(props[idx]);
        }
        cimInstance.setProperties(v);
        return cimInstance;
    }

    private CIMInstance get_ibmtsess_storage_cluster(String clusterID) throws Exception {
        CIMInstance cimInstance = new CIMInstance();
        cimInstance.setClassName("IBMTSESS_Cluster");
        cimInstance.setName("IBMTSESS_Cluster");
        Vector<CIMProperty> v = new Vector<CIMProperty>();
        int NUM_PROPERTIES = 30;
        CIMProperty[] props = new CIMProperty[NUM_PROPERTIES];
        props[0] = new CIMProperty("CreationClassName");
        props[0].setName("CreationClassName");
        props[0].setKey(true);
        props[0].setType(CIMDataType.getPredefinedType((int)8));
        props[0].setValue(new CIMValue((Object)"IBMTSESS_Cluster"));
        props[1] = new CIMProperty("Caption");
        props[1].setName("Caption");
        props[1].setType(CIMDataType.getPredefinedType((int)8));
        Object prop1Val = null;
        props[1].setValue(new CIMValue(prop1Val));
        props[2] = new CIMProperty("Name");
        props[2].setName("Name");
        props[2].setKey(true);
        props[2].setType(CIMDataType.getPredefinedType((int)8));
        String prop2Val = this.subsystemName + "-" + clusterID;
        props[2].setValue(new CIMValue((Object)prop2Val));
        props[3] = new CIMProperty("Dedicated");
        props[3].setName("Dedicated");
        props[3].setType(CIMDataType.getPredefinedType((int)16));
        Vector<UnsignedInt16> prop3V = new Vector<UnsignedInt16>();
        UnsignedInt16[] prop3Vals = new UnsignedInt16[]{new UnsignedInt16(3), new UnsignedInt16(15)};
        prop3V.add(prop3Vals[0]);
        prop3V.add(prop3Vals[1]);
        props[3].setValue(new CIMValue(prop3V));
        props[4] = new CIMProperty("Description");
        props[4].setName("Description");
        props[4].setType(CIMDataType.getPredefinedType((int)8));
        String prop4Val = "";
        props[4].setValue(new CIMValue((Object)prop4Val));
        props[5] = new CIMProperty("ElementName");
        props[5].setName("ElementName");
        props[5].setType(CIMDataType.getPredefinedType((int)8));
        String prop5Val = "Cluster on SHARK";
        props[5].setValue(new CIMValue((Object)prop5Val));
        props[6] = new CIMProperty("EnabledDefault");
        props[6].setName("EnabledDefault");
        props[6].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 prop6Val = new UnsignedInt16(2);
        props[6].setValue(new CIMValue((Object)prop6Val));
        props[7] = new CIMProperty("EnabledState");
        props[7].setName("EnabledState");
        props[7].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 prop7Val = new UnsignedInt16(5);
        props[7].setValue(new CIMValue((Object)prop7Val));
        props[8] = new CIMProperty("IdentifyingDescriptions");
        props[8].setName("IdentifyingDescriptions");
        props[8].setType(CIMDataType.getPredefinedType((int)22));
        Vector prop8V = new Vector();
        props[8].setValue(new CIMValue(prop8V));
        props[9] = new CIMProperty("InstallDate");
        props[9].setName("InstallDate");
        props[9].setType(CIMDataType.getPredefinedType((int)12));
        Object prop9Val = null;
        props[9].setValue(new CIMValue(prop9Val));
        props[10] = new CIMProperty("Interconnect");
        props[10].setName("Interconnect");
        props[10].setType(CIMDataType.getPredefinedType((int)8));
        Object prop10Val = null;
        props[10].setValue(new CIMValue(prop10Val));
        props[11] = new CIMProperty("NameFormat");
        props[11].setName("NameFormat");
        props[11].setType(CIMDataType.getPredefinedType((int)8));
        props[11].setValue(new CIMValue((Object)"Other"));
        props[12] = new CIMProperty("OperationalStatus");
        props[12].setName("OperationalStatus");
        props[12].setType(CIMDataType.getPredefinedType((int)16));
        Vector<UnsignedInt16> prop12V = new Vector<UnsignedInt16>();
        UnsignedInt16[] prop12Vals = new UnsignedInt16[]{new UnsignedInt16(2)};
        prop12V.add(prop3Vals[0]);
        props[12].setValue(new CIMValue(prop12V));
        props[13] = new CIMProperty("OtherDedicatedDescriptions");
        props[13].setName("OtherDedicatedDescriptions");
        props[13].setType(CIMDataType.getPredefinedType((int)22));
        Vector prop13V = new Vector();
        props[13].setValue(new CIMValue(prop13V));
        props[14] = new CIMProperty("OtherEnabledState");
        props[14].setName("OtherEnabledState");
        props[14].setType(CIMDataType.getPredefinedType((int)8));
        Object prop14Val = null;
        props[14].setValue(new CIMValue(prop14Val));
        props[15] = new CIMProperty("OtherIdentifyingInfo");
        props[15].setName("OtherIdentifyingInfo");
        props[15].setType(CIMDataType.getPredefinedType((int)22));
        Vector prop15V = new Vector();
        props[15].setValue(new CIMValue(prop15V));
        props[16] = new CIMProperty("PowerManagementCapabilities");
        props[16].setName("PowerManagementCapabilities");
        props[16].setType(CIMDataType.getPredefinedType((int)16));
        Vector prop16V = new Vector();
        props[16].setValue(new CIMValue(prop16V));
        props[17] = new CIMProperty("PrimaryOwnerContact");
        props[17].setName("PrimaryOwnerContact");
        props[17].setType(CIMDataType.getPredefinedType((int)8));
        Object prop17Val = null;
        props[17].setValue(new CIMValue(prop17Val));
        props[18] = new CIMProperty("PrimaryOwnerName");
        props[18].setName("PrimaryOwnerName");
        props[18].setType(CIMDataType.getPredefinedType((int)8));
        Object prop18Val = null;
        props[18].setValue(new CIMValue(prop18Val));
        props[19] = new CIMProperty("RequestedState");
        props[19].setName("RequestedState");
        props[19].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 prop19Val = new UnsignedInt16(5);
        props[19].setValue(new CIMValue((Object)prop6Val));
        props[20] = new CIMProperty("ResetCapability");
        props[20].setName("ResetCapability");
        props[19].setType(CIMDataType.getPredefinedType((int)2));
        Object prop20Val = null;
        props[20].setValue(new CIMValue(prop20Val));
        props[21] = new CIMProperty("Roles");
        props[21].setName("Roles");
        props[21].setType(CIMDataType.getPredefinedType((int)22));
        Vector prop21V = new Vector();
        props[21].setValue(new CIMValue(prop21V));
        props[22] = new CIMProperty("Status");
        props[22].setName("Status");
        props[22].setType(CIMDataType.getPredefinedType((int)8));
        Object prop22Val = null;
        props[22].setValue(new CIMValue(prop22Val));
        props[23] = new CIMProperty("StatusDescriptions");
        props[23].setName("StatusDescriptions");
        props[23].setType(CIMDataType.getPredefinedType((int)22));
        Vector prop23V = new Vector();
        props[23].setValue(new CIMValue((Object)"OK"));
        props[24] = new CIMProperty("TimeOfLastStateChange");
        props[24].setName("TimeOfLastStateChange");
        props[24].setType(CIMDataType.getPredefinedType((int)12));
        Object prop24V = null;
        props[24].setValue(new CIMValue(prop24V));
        props[25] = new CIMProperty("SystemCreationClassName");
        props[25].setName("SystemCreationClassName");
        props[25].setType(CIMDataType.getPredefinedType((int)8));
        props[25].setValue(new CIMValue((Object)"IBMTSESS_StorageSystem"));
        props[26] = new CIMProperty("Types");
        props[26].setName("Types");
        props[26].setType(CIMDataType.getPredefinedType((int)16));
        Vector prop26V = new Vector();
        props[26].setValue(new CIMValue(prop26V));
        props[27] = new CIMProperty("InterconnectAddress");
        props[27].setName("InterconnectAddress");
        props[27].setType(CIMDataType.getPredefinedType((int)8));
        Object prop27Val = null;
        props[27].setValue(new CIMValue(prop27Val));
        props[28] = new CIMProperty("MaxNumberOfNodes");
        props[28].setName("MaxNumberOfNodes");
        props[28].setType(CIMDataType.getPredefinedType((int)4));
        Object prop28Val = null;
        props[28].setValue(new CIMValue(prop28Val));
        props[29] = new CIMProperty("ClusterState");
        props[29].setName("ClusterState");
        props[29].setType(CIMDataType.getPredefinedType((int)2));
        Object prop29Val = null;
        props[29].setValue(new CIMValue(prop29Val));
        for (int idx = 0; idx < NUM_PROPERTIES; ++idx) {
            v.add(props[idx]);
        }
        cimInstance.setProperties(v);
        return cimInstance;
    }

    private CIMInstance get_ibmtsess_storage_system() throws Exception {
        CIMInstance cimInstance = new CIMInstance();
        cimInstance.setClassName("IBMTSESS_StorageSystem");
        cimInstance.setName("IBMTSESS_StorageSystem");
        Vector<CIMProperty> v = new Vector<CIMProperty>();
        int NUM_PROPERTIES = 28;
        CIMProperty[] props = new CIMProperty[NUM_PROPERTIES];
        props[0] = new CIMProperty("CreationClassName");
        props[0].setName("CreationClassName");
        props[0].setKey(true);
        props[0].setType(CIMDataType.getPredefinedType((int)8));
        props[0].setValue(new CIMValue((Object)"IBMTSESS_StorageSystem"));
        props[1] = new CIMProperty("Caption");
        props[1].setName("Caption");
        props[1].setType(CIMDataType.getPredefinedType((int)8));
        String prop1Val = "IBM TotalStorage DS8000";
        props[1].setValue(new CIMValue((Object)prop1Val));
        props[2] = new CIMProperty("Name");
        props[2].setName("Name");
        props[2].setKey(true);
        props[2].setType(CIMDataType.getPredefinedType((int)8));
        props[2].setValue(new CIMValue((Object)this.subsystemName));
        props[3] = new CIMProperty("Dedicated");
        props[3].setName("Dedicated");
        props[3].setType(CIMDataType.getPredefinedType((int)16));
        Vector<UnsignedInt16> prop3V = new Vector<UnsignedInt16>();
        UnsignedInt16[] prop3Vals = new UnsignedInt16[]{new UnsignedInt16(3), new UnsignedInt16(15)};
        prop3V.add(prop3Vals[0]);
        prop3V.add(prop3Vals[1]);
        props[3].setValue(new CIMValue(prop3V));
        props[4] = new CIMProperty("Description");
        props[4].setName("Description");
        props[4].setType(CIMDataType.getPredefinedType((int)8));
        String prop4Val = "IBM TotalStorage DS8000 " + this.subsystemName;
        props[4].setValue(new CIMValue((Object)prop4Val));
        props[5] = new CIMProperty("ElementName");
        props[5].setName("ElementName");
        props[5].setType(CIMDataType.getPredefinedType((int)8));
        String prop5Val = "IBM TotalStorage DS8000";
        props[5].setValue(new CIMValue((Object)prop5Val));
        props[6] = new CIMProperty("EnabledDefault");
        props[6].setName("EnabledDefault");
        props[6].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 prop6Val = new UnsignedInt16(2);
        props[6].setValue(new CIMValue((Object)prop6Val));
        props[7] = new CIMProperty("EnabledState");
        props[7].setName("EnabledState");
        props[7].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 prop7Val = new UnsignedInt16(2);
        props[7].setValue(new CIMValue((Object)prop7Val));
        props[8] = new CIMProperty("IdentifyingDescriptions");
        props[8].setName("IdentifyingDescriptions");
        props[8].setType(CIMDataType.getPredefinedType((int)22));
        Vector<String> prop8V = new Vector<String>();
        prop8V.add("IPAddressV4HMC");
        prop8V.add("MTMS");
        prop8V.add("Machine signature");
        prop8V.add("WWNN");
        props[8].setValue(new CIMValue(prop8V));
        props[9] = new CIMProperty("InstallDate");
        props[9].setName("InstallDate");
        props[9].setType(CIMDataType.getPredefinedType((int)12));
        Object prop9Val = null;
        props[9].setValue(new CIMValue(prop9Val));
        props[10] = new CIMProperty("Model");
        props[10].setName("Model");
        props[10].setType(CIMDataType.getPredefinedType((int)8));
        props[10].setValue(new CIMValue((Object)"921"));
        props[11] = new CIMProperty("NameFormat");
        props[11].setName("NameFormat");
        props[11].setType(CIMDataType.getPredefinedType((int)8));
        props[11].setValue(new CIMValue((Object)"Other"));
        props[12] = new CIMProperty("OperationalStatus");
        props[12].setName("OperationalStatus");
        props[12].setType(CIMDataType.getPredefinedType((int)16));
        Vector<UnsignedInt16> prop12V = new Vector<UnsignedInt16>();
        UnsignedInt16[] prop12Vals = new UnsignedInt16[]{new UnsignedInt16(2)};
        prop12V.add(prop3Vals[0]);
        prop12V.add(prop3Vals[1]);
        props[12].setValue(new CIMValue(prop12V));
        props[13] = new CIMProperty("OtherDedicatedDescriptions");
        props[13].setName("OtherDedicatedDescriptions");
        props[13].setType(CIMDataType.getPredefinedType((int)22));
        Vector prop13V = new Vector();
        props[13].setValue(new CIMValue(prop13V));
        props[14] = new CIMProperty("OtherEnabledState");
        props[14].setName("OtherEnabledState");
        props[14].setType(CIMDataType.getPredefinedType((int)8));
        Object prop14Val = null;
        props[14].setValue(new CIMValue(prop14Val));
        props[15] = new CIMProperty("OtherIdentifyingInfo");
        props[15].setName("OtherIdentifyingInfo");
        props[15].setType(CIMDataType.getPredefinedType((int)22));
        Vector<String> prop15V = new Vector<String>();
        prop15V.add(this.ipAddressSubsystem);
        prop15V.add(this.subsystemNameWithModel);
        prop15V.add(this.machineSignature);
        prop15V.add(this.wwn);
        props[15].setValue(new CIMValue(prop15V));
        props[16] = new CIMProperty("PowerManagementCapabilities");
        props[16].setName("PowerManagementCapabilities");
        props[16].setType(CIMDataType.getPredefinedType((int)16));
        Vector prop16V = new Vector();
        props[16].setValue(new CIMValue(prop16V));
        props[17] = new CIMProperty("PrimaryOwnerContact");
        props[17].setName("PrimaryOwnerContact");
        props[17].setType(CIMDataType.getPredefinedType((int)8));
        String prop17Val = "IBM Customer";
        props[17].setValue(new CIMValue((Object)prop17Val));
        props[18] = new CIMProperty("PrimaryOwnerName");
        props[18].setName("PrimaryOwnerName");
        props[18].setType(CIMDataType.getPredefinedType((int)8));
        String prop18Val = "IBM Corporation";
        props[18].setValue(new CIMValue((Object)prop18Val));
        props[19] = new CIMProperty("RequestedState");
        props[19].setName("RequestedState");
        props[19].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 prop19Val = new UnsignedInt16(5);
        props[19].setValue(new CIMValue((Object)prop6Val));
        props[20] = new CIMProperty("ResetCapability");
        props[20].setName("ResetCapability");
        props[19].setType(CIMDataType.getPredefinedType((int)2));
        Object prop20Val = null;
        props[20].setValue(new CIMValue(prop20Val));
        props[21] = new CIMProperty("Roles");
        props[21].setName("Roles");
        props[21].setType(CIMDataType.getPredefinedType((int)22));
        Vector prop21V = new Vector();
        props[21].setValue(new CIMValue(prop21V));
        props[22] = new CIMProperty("Status");
        props[22].setName("Status");
        props[22].setType(CIMDataType.getPredefinedType((int)8));
        Object prop22Val = null;
        props[22].setValue(new CIMValue(prop22Val));
        props[23] = new CIMProperty("StatusDescriptions");
        props[23].setName("StatusDescriptions");
        props[23].setType(CIMDataType.getPredefinedType((int)22));
        Vector prop23V = new Vector();
        props[23].setValue(new CIMValue((Object)"OK"));
        props[24] = new CIMProperty("TimeOfLastStateChange");
        props[24].setName("TimeOfLastStateChange");
        props[24].setType(CIMDataType.getPredefinedType((int)12));
        Object prop24V = null;
        props[24].setValue(new CIMValue(prop24V));
        props[25] = new CIMProperty("codelevel");
        props[25].setName("codelevel");
        props[25].setType(CIMDataType.getPredefinedType((int)8));
        props[25].setValue(new CIMValue((Object)"5.0.500.123"));
        props[26] = new CIMProperty("nvs");
        props[26].setName("nvs");
        props[26].setType(CIMDataType.getPredefinedType((int)8));
        String prop26Val = "";
        props[26].setValue(new CIMValue((Object)prop26Val));
        props[27] = new CIMProperty("cache");
        props[27].setName("cache");
        props[27].setType(CIMDataType.getPredefinedType((int)8));
        String prop27Val = "";
        props[27].setValue(new CIMValue((Object)prop27Val));
        for (int idx = 0; idx < NUM_PROPERTIES; ++idx) {
            v.add(props[idx]);
        }
        cimInstance.setProperties(v);
        return cimInstance;
    }

    private void populate_RegisteredProfile() throws Exception {
        int idx;
        CIMInstance ibmtsRegProfInst = this.get_ibmts_registered_profile();
        System.out.println("Instance = " + ibmtsRegProfInst);
        CIMInstance ibmtsessRegProfInst = this.get_ibmtsess_registered_profile();
        System.out.println("Instance = " + ibmtsessRegProfInst);
        CIMInstance[] ibmtsessRegSubProfInsts = this.get_ibmtsess_registered_sub_profile();
        for (int idx2 = 0; idx2 < ibmtsessRegSubProfInsts.length; ++idx2) {
            System.out.println("Instance = " + ibmtsessRegSubProfInsts[idx2]);
        }
        CIMInstance ibmtsObjectManagerInst = this.get_ibmts_object_manager();
        System.out.println("Instance = " + ibmtsObjectManagerInst);
        CIMInstance ibmtsNamespaceInst = this.get_ibmts_namespace();
        System.out.println("Instance = " + ibmtsNamespaceInst);
        CIMInstance ibmtsAccountInst = this.get_ibmts_account();
        System.out.println("Instance = " + ibmtsAccountInst);
        CIMInstance ibmtsAccountManagementServiceInst = this.get_ibmts_account_management_service();
        System.out.println("Instance = " + ibmtsAccountManagementServiceInst);
        CIMInstance ibmtsSystemInst = this.get_ibmts_system();
        System.out.println("Instance = " + ibmtsSystemInst);
        CIMInstance ibmtsCertificateInst = this.get_ibmts_certificate();
        System.out.println("Instance = " + ibmtsCertificateInst);
        if (ibmtsCertificateInst != null) {
            // empty if block
        }
        CIMInstance ibmtsCertificateSettingInst = this.get_certificate_setting();
        System.out.println("Instance = " + ibmtsCertificateSettingInst);
        CIMInstance ibmtsCcommunicationMechInst = this.get_cimxml_communication_mechanism();
        System.out.println("Instance = " + ibmtsCcommunicationMechInst);
        CIMInstance[] ibmtsIndicationFilterInsts = this.get_indication_filter();
        for (int idx3 = 0; idx3 < ibmtsIndicationFilterInsts.length; ++idx3) {
            System.out.println("Instance = " + ibmtsIndicationFilterInsts[idx3]);
        }
        CIMInstance ibmtsTruststoreInst = this.get_ibmts_truststore();
        System.out.println("Instance = " + ibmtsTruststoreInst);
        if (ibmtsTruststoreInst != null) {
            // empty if block
        }
        CIMInstance ibmtsTruststoreMgmtSvcInst = this.get_ibmts_truststore_management_service();
        System.out.println("Instance = " + ibmtsTruststoreMgmtSvcInst);
        if (ibmtsTruststoreMgmtSvcInst != null) {
            // empty if block
        }
        CIMInstance ibmtsessProviderInst = this.get_ibmtsess_provider();
        System.out.println("Instance = " + ibmtsessProviderInst);
        if (ibmtsessProviderInst != null) {
            // empty if block
        }
        CIMInstance ibmtsNamespaceInManagerInst = this.get_ibmts_namespace_in_manager(ibmtsObjectManagerInst, ibmtsNamespaceInst);
        System.out.println("Instance = " + ibmtsNamespaceInManagerInst);
        if (ibmtsNamespaceInManagerInst != null) {
            // empty if block
        }
        CIMInstance ibmtsAccountManagementServiceForSystemInst = this.get_ibmts_account_management_service_for_system(ibmtsAccountManagementServiceInst, ibmtsObjectManagerInst);
        System.out.println("Instance = " + ibmtsAccountManagementServiceForSystemInst);
        if (ibmtsAccountManagementServiceForSystemInst != null) {
            // empty if block
        }
        CIMInstance ibmtsAccountOnCIMOMInst = this.get_ibmts_account_on_cimom(ibmtsObjectManagerInst, ibmtsAccountInst);
        System.out.println("Instance = " + ibmtsAccountOnCIMOMInst);
        if (ibmtsAccountOnCIMOMInst != null) {
            // empty if block
        }
        CIMInstance ibmtsCommMechanismForManagerInst = this.get_ibmts_comm_mechanism_for_manager(ibmtsObjectManagerInst, ibmtsCcommunicationMechInst);
        System.out.println("Instance = " + ibmtsCommMechanismForManagerInst);
        if (ibmtsCommMechanismForManagerInst != null) {
            // empty if block
        }
        CIMInstance ibmtsHostedAccessPointInst = this.get_ibmts_hosted_access_point(ibmtsSystemInst, ibmtsCcommunicationMechInst);
        System.out.println("Instance = " + ibmtsHostedAccessPointInst);
        if (ibmtsHostedAccessPointInst != null) {
            // empty if block
        }
        CIMInstance ibmtsElementConformsToProfileInst = this.get_ibmts_element_conforms_to_profile(ibmtsRegProfInst, ibmtsObjectManagerInst);
        System.out.println("Instance = " + ibmtsElementConformsToProfileInst);
        if (ibmtsElementConformsToProfileInst != null) {
            // empty if block
        }
        CIMInstance ibmtsHostedServiceInst = this.get_ibmts_hosted_service(ibmtsSystemInst, ibmtsObjectManagerInst);
        System.out.println("Instance = " + ibmtsHostedServiceInst);
        if (ibmtsHostedServiceInst != null) {
            // empty if block
        }
        for (idx = 0; idx < ibmtsIndicationFilterInsts.length; ++idx) {
            CIMInstance ibmtsIndicationFiltersConformsToProfileInst = this.get_ibmts_indication_filters_conforms_to_profile(ibmtsRegProfInst, ibmtsIndicationFilterInsts[idx]);
            System.out.println("Instance = " + ibmtsIndicationFiltersConformsToProfileInst);
            if (ibmtsIndicationFiltersConformsToProfileInst == null) continue;
        }
        for (idx = 0; idx < ibmtsessRegSubProfInsts.length; ++idx) {
            CIMInstance ibmtsessSubProfileRequiresProfileInst = this.get_ibmtsess_sub_profile_requires_profile(ibmtsessRegProfInst, ibmtsessRegSubProfInsts[idx]);
            System.out.println("Instance = " + ibmtsessSubProfileRequiresProfileInst);
            if (ibmtsessSubProfileRequiresProfileInst == null) continue;
        }
    }

    private CIMInstance get_ibmtsess_provider() throws Exception {
        CIMInstance cimInstance = new CIMInstance();
        cimInstance.setClassName("IBMTSESS_Provider");
        cimInstance.setName("IBMTSESS_Provider");
        int NUM_PROPERTIES = 22;
        Vector<CIMProperty> v = new Vector<CIMProperty>();
        CIMProperty[] props = new CIMProperty[NUM_PROPERTIES];
        props[0] = new CIMProperty("Caption");
        props[0].setName("Caption");
        props[0].setType(CIMDataType.getPredefinedType((int)8));
        Object prop0Val = null;
        props[0].setValue(new CIMValue(prop0Val));
        props[1] = new CIMProperty("CreationClassName");
        props[1].setName("CreationClassName");
        props[1].setKey(true);
        props[1].setType(CIMDataType.getPredefinedType((int)8));
        props[1].setValue(new CIMValue((Object)"IBMTSESS_Provider"));
        props[2] = new CIMProperty("Description");
        props[2].setName("Description");
        props[2].setType(CIMDataType.getPredefinedType((int)8));
        String prop2Val = "IBM ESS CIM Provider";
        props[2].setValue(new CIMValue((Object)prop2Val));
        props[3] = new CIMProperty("ElementName");
        props[3].setName("ElementName");
        props[3].setType(CIMDataType.getPredefinedType((int)8));
        String prop3Val = "IBM ESS CIM Provider";
        props[3].setValue(new CIMValue((Object)prop3Val));
        props[4] = new CIMProperty("EnabledDefault");
        props[4].setName("EnabledDefault");
        props[4].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 prop4Val = new UnsignedInt16(2);
        props[4].setValue(new CIMValue((Object)prop4Val));
        props[5] = new CIMProperty("EnabledState");
        props[5].setName("EnabledState");
        props[5].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 prop5Val = new UnsignedInt16(5);
        props[5].setValue(new CIMValue((Object)prop5Val));
        props[6] = new CIMProperty("Handle");
        props[6].setName("Handle");
        props[6].setType(CIMDataType.getPredefinedType((int)8));
        String prop6Val = "com.ibm.tpc.simulator.cimom.sunwbem.provider.Provider";
        props[6].setValue(new CIMValue((Object)prop6Val));
        props[7] = new CIMProperty("InstallDate");
        props[7].setName("InstallDate");
        props[7].setType(CIMDataType.getPredefinedType((int)8));
        Object prop7Val = null;
        props[7].setValue(new CIMValue(prop7Val));
        props[8] = new CIMProperty("Name");
        props[8].setName("Name");
        props[8].setKey(true);
        props[8].setType(CIMDataType.getPredefinedType((int)8));
        String prop8Val = "IBM ESS Provider";
        props[8].setValue(new CIMValue((Object)prop8Val));
        props[9] = new CIMProperty("OperationalStatus");
        props[9].setName("OperationalStatus");
        props[9].setType(CIMDataType.getPredefinedType((int)22));
        Vector<UnsignedInt16> prop9V = new Vector<UnsignedInt16>();
        prop9V.add(new UnsignedInt16(2));
        props[9].setValue(new CIMValue(prop9V));
        props[10] = new CIMProperty("OtherEnabledState");
        props[10].setName("OtherEnabledState");
        props[10].setType(CIMDataType.getPredefinedType((int)8));
        Object prop10Val = null;
        props[10].setValue(new CIMValue(prop10Val));
        props[11] = new CIMProperty("PrimaryOwnerContact");
        props[11].setName("PrimaryOwnerContact");
        props[11].setType(CIMDataType.getPredefinedType((int)8));
        Object prop11Val = null;
        props[11].setValue(new CIMValue(prop11Val));
        props[12] = new CIMProperty("PrimaryOwnerName");
        props[12].setName("PrimaryOwnerName");
        props[12].setType(CIMDataType.getPredefinedType((int)8));
        Object prop12Val = null;
        props[12].setValue(new CIMValue(prop12Val));
        props[13] = new CIMProperty("RequestedState");
        props[13].setName("RequestedState");
        props[13].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 prop13Val = new UnsignedInt16(5);
        props[13].setValue(new CIMValue((Object)prop13Val));
        props[14] = new CIMProperty("Started");
        props[14].setName("Started");
        props[14].setType(CIMDataType.getPredefinedType((int)9));
        Boolean prop14Val = new Boolean(true);
        props[14].setValue(new CIMValue((Object)prop14Val));
        props[15] = new CIMProperty("StartMode");
        props[15].setName("StartMode");
        props[15].setType(CIMDataType.getPredefinedType((int)8));
        Object prop15Val = null;
        props[15].setValue(new CIMValue(prop15Val));
        props[16] = new CIMProperty("Status");
        props[16].setName("Status");
        props[16].setType(CIMDataType.getPredefinedType((int)8));
        Object prop16Val = null;
        props[16].setValue(new CIMValue(prop16Val));
        props[17] = new CIMProperty("StatusDescriptions");
        props[17].setName("StatusDescriptions");
        props[17].setType(CIMDataType.getPredefinedType((int)22));
        Vector<String> prop17V = new Vector<String>();
        prop17V.add("OK");
        props[17].setValue(new CIMValue(prop17V));
        props[18] = new CIMProperty("SystemCreationClassName");
        props[18].setName("SystemCreationClassName");
        props[18].setKey(true);
        props[18].setType(CIMDataType.getPredefinedType((int)8));
        props[18].setValue(new CIMValue((Object)"IBMTS"));
        props[19] = new CIMProperty("SystemName");
        props[19].setName("SystemName");
        props[19].setKey(true);
        props[19].setType(CIMDataType.getPredefinedType((int)8));
        props[19].setValue(new CIMValue((Object)"IBM Provider"));
        props[20] = new CIMProperty("TimeOfLastStateChange");
        props[20].setName("TimeOfLastStateChange");
        props[20].setType(CIMDataType.getPredefinedType((int)12));
        Object prop20Val = null;
        props[20].setValue(new CIMValue(prop20Val));
        props[21] = new CIMProperty("version");
        props[21].setName("version");
        props[21].setType(CIMDataType.getPredefinedType((int)8));
        props[21].setValue(new CIMValue((Object)"5.1.0.43"));
        for (int idx = 0; idx < NUM_PROPERTIES; ++idx) {
            v.add(props[idx]);
        }
        cimInstance.setProperties(v);
        return cimInstance;
    }

    private CIMInstance get_ibmtsess_sub_profile_requires_profile(CIMInstance antecedent, CIMInstance dependent) throws Exception {
        CIMObjectPath antecedentOP = this.getObjectPath(antecedent);
        CIMObjectPath dependentOP = this.getObjectPath(dependent);
        CIMInstance cimInstance = new CIMInstance();
        cimInstance.setClassName("IBMTSESS_SubProfileRequiresProfile");
        cimInstance.setName("IBMTSESS_SubProfileRequiresProfile");
        Vector<CIMProperty> v = new Vector<CIMProperty>();
        CIMProperty prop1 = new CIMProperty("Antecedent");
        prop1.setName("Antecedent");
        prop1.setType(new CIMDataType("IBMTSESS_RegisteredProfile"));
        prop1.setValue(new CIMValue((Object)antecedentOP));
        CIMProperty prop2 = new CIMProperty("Dependent");
        prop2.setName("Dependent");
        prop2.setType(new CIMDataType("IBMTSESS_RegisteredSubProfile"));
        prop2.setValue(new CIMValue((Object)dependentOP));
        v.add(prop1);
        v.add(prop2);
        cimInstance.setProperties(v);
        return cimInstance;
    }

    private CIMInstance get_ibmts_indication_filters_conforms_to_profile(CIMInstance conformantStandard, CIMInstance managedElement) throws Exception {
        CIMObjectPath conformantStandardOP = this.getObjectPath(conformantStandard);
        CIMObjectPath managedElementOP = this.getObjectPath(managedElement);
        CIMInstance cimInstance = new CIMInstance();
        cimInstance.setClassName("IBMTS_IndicationFiltersConformsToProfile");
        cimInstance.setName("IBMTS_IndicationFiltersConformsToProfile");
        Vector<CIMProperty> v = new Vector<CIMProperty>();
        CIMProperty prop1 = new CIMProperty("ConformantStandard");
        prop1.setName("ConformantStandard");
        prop1.setType(new CIMDataType("IBMTS_RegisteredProfile"));
        prop1.setValue(new CIMValue((Object)conformantStandardOP));
        CIMProperty prop2 = new CIMProperty("ManagedElement");
        prop2.setName("ManagedElement");
        prop2.setType(new CIMDataType("IBMTS_IndicationFilter"));
        prop2.setValue(new CIMValue((Object)managedElementOP));
        v.add(prop1);
        v.add(prop2);
        cimInstance.setProperties(v);
        return cimInstance;
    }

    private CIMInstance get_ibmts_hosted_service(CIMInstance antecedent, CIMInstance dependent) throws Exception {
        CIMObjectPath antecedentOP = this.getObjectPath(antecedent);
        CIMObjectPath dependentOP = this.getObjectPath(dependent);
        CIMInstance cimInstance = new CIMInstance();
        cimInstance.setClassName("IBMTS_HostedService");
        cimInstance.setName("IBMTS_HostedService");
        Vector<CIMProperty> v = new Vector<CIMProperty>();
        CIMProperty prop1 = new CIMProperty("Antecedent");
        prop1.setName("Antecedent");
        prop1.setType(new CIMDataType("IBMTS_System"));
        prop1.setValue(new CIMValue((Object)antecedentOP));
        CIMProperty prop2 = new CIMProperty("Dependent");
        prop2.setName("Dependent");
        prop2.setType(new CIMDataType("IBMTS_ObjectManager"));
        prop2.setValue(new CIMValue((Object)dependentOP));
        v.add(prop1);
        v.add(prop2);
        cimInstance.setProperties(v);
        return cimInstance;
    }

    private CIMInstance get_ibmts_element_conforms_to_profile(CIMInstance conformantStandard, CIMInstance managedElement) throws Exception {
        CIMObjectPath conformantStandardOP = this.getObjectPath(conformantStandard);
        CIMObjectPath managedElementOP = this.getObjectPath(managedElement);
        CIMInstance cimInstance = new CIMInstance();
        cimInstance.setClassName("IBMTS_ElementConformsToProfile");
        cimInstance.setName("IBMTS_ElementConformsToProfile");
        Vector<CIMProperty> v = new Vector<CIMProperty>();
        CIMProperty prop1 = new CIMProperty("ConformantStandard");
        prop1.setName("ConformantStandard");
        prop1.setType(new CIMDataType("IBMTS_RegisteredProfile"));
        prop1.setValue(new CIMValue((Object)conformantStandardOP));
        CIMProperty prop2 = new CIMProperty("ManagedElement");
        prop2.setName("ManagedElement");
        prop2.setType(new CIMDataType("IBMTS_ObjectManager"));
        prop2.setValue(new CIMValue((Object)managedElementOP));
        v.add(prop1);
        v.add(prop2);
        cimInstance.setProperties(v);
        return cimInstance;
    }

    private CIMInstance get_ibmts_hosted_access_point(CIMInstance antecedent, CIMInstance dependent) throws Exception {
        CIMObjectPath antecedentOP = this.getObjectPath(antecedent);
        CIMObjectPath dependentOP = this.getObjectPath(dependent);
        CIMInstance cimInstance = new CIMInstance();
        cimInstance.setClassName("IBMTS_HostedAccessPoint");
        cimInstance.setName("IBMTS_HostedAccessPoint");
        Vector<CIMProperty> v = new Vector<CIMProperty>();
        CIMProperty prop1 = new CIMProperty("Antecedent");
        prop1.setName("Antecedent");
        prop1.setType(new CIMDataType("IBMTS_System"));
        prop1.setValue(new CIMValue((Object)antecedentOP));
        CIMProperty prop2 = new CIMProperty("Dependent");
        prop2.setName("Dependent");
        prop2.setType(new CIMDataType("IBMTS_CIMXMLCommunicationMechanism"));
        prop2.setValue(new CIMValue((Object)dependentOP));
        v.add(prop1);
        v.add(prop2);
        cimInstance.setProperties(v);
        return cimInstance;
    }

    private CIMInstance get_ibmts_comm_mechanism_for_manager(CIMInstance antecedent, CIMInstance dependent) throws Exception {
        CIMObjectPath antecedentOP = this.getObjectPath(antecedent);
        CIMObjectPath dependentOP = this.getObjectPath(dependent);
        CIMInstance cimInstance = new CIMInstance();
        cimInstance.setClassName("IBMTS_CommMechanismForManager");
        cimInstance.setName("IBMTS_CommMechanismForManager");
        Vector<CIMProperty> v = new Vector<CIMProperty>();
        CIMProperty prop1 = new CIMProperty("Antecedent");
        prop1.setName("Antecedent");
        prop1.setType(new CIMDataType("IBMTS_ObjectManager"));
        prop1.setValue(new CIMValue((Object)antecedentOP));
        CIMProperty prop2 = new CIMProperty("Dependent");
        prop2.setName("Dependent");
        prop2.setType(new CIMDataType("IBMTS_CIMXMLCommunicationMechanism"));
        prop2.setValue(new CIMValue((Object)dependentOP));
        v.add(prop1);
        v.add(prop2);
        cimInstance.setProperties(v);
        return cimInstance;
    }

    private CIMInstance get_ibmts_account_on_cimom(CIMInstance groupComponent, CIMInstance partComponent) throws Exception {
        CIMObjectPath groupComponentOP = this.getObjectPath(groupComponent);
        CIMObjectPath partComponentOP = this.getObjectPath(partComponent);
        CIMInstance cimInstance = new CIMInstance();
        cimInstance.setClassName("IBMTS_AccountOnCIMOM");
        cimInstance.setName("IBMTS_AccountOnCIMOM");
        Vector<CIMProperty> v = new Vector<CIMProperty>();
        CIMProperty prop1 = new CIMProperty("GroupComponent");
        prop1.setName("GroupComponent");
        prop1.setType(new CIMDataType("IBMTS_ObjectManager"));
        prop1.setValue(new CIMValue((Object)groupComponentOP));
        CIMProperty prop2 = new CIMProperty("PartComponent");
        prop2.setName("PartComponent");
        prop2.setType(new CIMDataType("IBMTS_Account"));
        prop2.setValue(new CIMValue((Object)partComponentOP));
        CIMProperty prop3 = new CIMProperty("Role");
        prop3.setName("Role");
        prop3.setType(CIMDataType.getPredefinedType((int)8));
        String prop3Val = "Administrator";
        prop3.setValue(new CIMValue((Object)prop3Val));
        v.add(prop1);
        v.add(prop2);
        v.add(prop3);
        cimInstance.setProperties(v);
        return cimInstance;
    }

    private CIMInstance get_ibmts_account_management_service_for_system(CIMInstance antecedent, CIMInstance dependent) throws Exception {
        CIMObjectPath antecedentOP = this.getObjectPath(antecedent);
        CIMObjectPath dependentOP = this.getObjectPath(dependent);
        CIMInstance cimInstance = new CIMInstance();
        cimInstance.setClassName("IBMTS_NamespaceInManager");
        cimInstance.setName("IBMTS_NamespaceInManager");
        Vector<CIMProperty> v = new Vector<CIMProperty>();
        CIMProperty prop1 = new CIMProperty("Antecedent");
        prop1.setName("Antecedent");
        prop1.setType(new CIMDataType("IBMTS_AccountManagementService"));
        prop1.setValue(new CIMValue((Object)antecedentOP));
        CIMProperty prop2 = new CIMProperty("Dependent");
        prop2.setName("Dependent");
        prop2.setType(new CIMDataType("IBMTS_ObjectManager"));
        prop2.setValue(new CIMValue((Object)dependentOP));
        v.add(prop1);
        v.add(prop2);
        cimInstance.setProperties(v);
        return cimInstance;
    }

    private CIMInstance get_ibmts_namespace_in_manager(CIMInstance antecedent, CIMInstance dependent) throws Exception {
        CIMObjectPath antecedentOP = this.getObjectPath(antecedent);
        CIMObjectPath dependentOP = this.getObjectPath(dependent);
        CIMInstance cimInstance = new CIMInstance();
        cimInstance.setClassName("IBMTS_NamespaceInManager");
        cimInstance.setName("IBMTS_NamespaceInManager");
        Vector<CIMProperty> v = new Vector<CIMProperty>();
        CIMProperty prop1 = new CIMProperty("Antecedent");
        prop1.setName("Antecedent");
        prop1.setType(new CIMDataType("IBMTS_ObjectManager"));
        prop1.setValue(new CIMValue((Object)antecedentOP));
        CIMProperty prop2 = new CIMProperty("Dependent");
        prop2.setName("Dependent");
        prop2.setType(new CIMDataType("IBMTS_NameSpace"));
        prop2.setValue(new CIMValue((Object)dependentOP));
        v.add(prop1);
        v.add(prop2);
        cimInstance.setProperties(v);
        return cimInstance;
    }

    private CIMInstance get_ibmts_truststore_management_service() throws Exception {
        CIMInstance cimInstance = new CIMInstance();
        cimInstance.setClassName("IBMTS_TruststoreManagementService");
        cimInstance.setName("IBMTS_TruststoreManagementService");
        int NUM_PROPERTIES = 23;
        Vector<CIMProperty> v = new Vector<CIMProperty>();
        CIMProperty[] props = new CIMProperty[NUM_PROPERTIES];
        props[0] = new CIMProperty("AutoGenerationEnabled");
        props[0].setName("AutoGenerationEnabled");
        props[0].setType(CIMDataType.getPredefinedType((int)9));
        Boolean prop0Val = new Boolean(false);
        props[0].setValue(new CIMValue((Object)prop0Val));
        props[1] = new CIMProperty("Caption");
        props[1].setName("Caption");
        props[1].setType(CIMDataType.getPredefinedType((int)8));
        Object prop1Val = null;
        props[1].setValue(new CIMValue(prop1Val));
        props[2] = new CIMProperty("CreationClassName");
        props[2].setName("CreationClassName");
        props[2].setKey(true);
        props[2].setType(CIMDataType.getPredefinedType((int)8));
        props[2].setValue(new CIMValue((Object)"IBMTS_TruststoreManagementService"));
        props[3] = new CIMProperty("DefaultValidity");
        props[3].setName("DefaultValidity");
        props[3].setType(CIMDataType.getPredefinedType((int)4));
        UnsignedInt32 prop3Val = new UnsignedInt32(365L);
        props[3].setValue(new CIMValue((Object)prop3Val));
        props[4] = new CIMProperty("Description");
        props[4].setName("Description");
        props[4].setType(CIMDataType.getPredefinedType((int)8));
        Object prop4Val = null;
        props[4].setValue(new CIMValue(prop4Val));
        props[5] = new CIMProperty("ElementName");
        props[5].setName("ElementName");
        props[5].setType(CIMDataType.getPredefinedType((int)8));
        Object prop5Val = null;
        props[5].setValue(new CIMValue(prop5Val));
        props[6] = new CIMProperty("EnabledDefault");
        props[6].setName("EnabledDefault");
        props[6].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 prop6Val = new UnsignedInt16(2);
        props[6].setValue(new CIMValue((Object)prop6Val));
        props[7] = new CIMProperty("EnabledState");
        props[7].setName("EnabledState");
        props[7].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 prop7Val = new UnsignedInt16(5);
        props[7].setValue(new CIMValue((Object)prop7Val));
        props[8] = new CIMProperty("HealthState");
        props[8].setName("HealthState");
        props[8].setType(CIMDataType.getPredefinedType((int)2));
        Object prop8Val = null;
        props[8].setValue(new CIMValue(prop8Val));
        props[9] = new CIMProperty("InstallDate");
        props[9].setName("InstallDate");
        props[9].setType(CIMDataType.getPredefinedType((int)8));
        Object prop9Val = null;
        props[9].setValue(new CIMValue(prop9Val));
        props[10] = new CIMProperty("Name");
        props[10].setName("Name");
        props[10].setKey(true);
        props[10].setType(CIMDataType.getPredefinedType((int)8));
        String prop10Val = "SVC_CIMOM";
        props[10].setValue(new CIMValue((Object)prop10Val));
        props[11] = new CIMProperty("OperationalStatus");
        props[11].setName("OperationalStatus");
        props[11].setType(CIMDataType.getPredefinedType((int)22));
        Vector prop11V = new Vector();
        props[11].setValue(new CIMValue(prop11V));
        props[12] = new CIMProperty("OtherEnabledState");
        props[12].setName("OtherEnabledState");
        props[12].setType(CIMDataType.getPredefinedType((int)8));
        Object prop12Val = null;
        props[12].setValue(new CIMValue(prop12Val));
        props[13] = new CIMProperty("PrimaryOwnerContact");
        props[13].setName("PrimaryOwnerContact");
        props[13].setType(CIMDataType.getPredefinedType((int)8));
        Object prop13Val = null;
        props[13].setValue(new CIMValue(prop13Val));
        props[14] = new CIMProperty("PrimaryOwnerName");
        props[14].setName("PrimaryOwnerName");
        props[14].setType(CIMDataType.getPredefinedType((int)8));
        Object prop14Val = null;
        props[14].setValue(new CIMValue(prop14Val));
        props[15] = new CIMProperty("RequestedState");
        props[15].setName("RequestedState");
        props[15].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 prop15Val = new UnsignedInt16(12);
        props[15].setValue(new CIMValue((Object)prop15Val));
        props[16] = new CIMProperty("Started");
        props[16].setName("Started");
        props[16].setType(CIMDataType.getPredefinedType((int)9));
        Object prop16Val = null;
        props[16].setValue(new CIMValue(prop16Val));
        props[17] = new CIMProperty("StartMode");
        props[17].setName("StartMode");
        props[17].setType(CIMDataType.getPredefinedType((int)8));
        Object prop17Val = null;
        props[17].setValue(new CIMValue(prop17Val));
        props[18] = new CIMProperty("Status");
        props[18].setName("Status");
        props[18].setType(CIMDataType.getPredefinedType((int)8));
        Object prop18Val = null;
        props[18].setValue(new CIMValue(prop18Val));
        props[19] = new CIMProperty("StatusDescriptions");
        props[19].setName("StatusDescriptions");
        props[19].setType(CIMDataType.getPredefinedType((int)22));
        Vector prop19V = new Vector();
        props[19].setValue(new CIMValue(prop19V));
        props[20] = new CIMProperty("SystemCreationClassName");
        props[20].setName("SystemCreationClassName");
        props[20].setKey(true);
        props[20].setType(CIMDataType.getPredefinedType((int)8));
        props[20].setValue(new CIMValue((Object)"IBMTS"));
        props[21] = new CIMProperty("SystemName");
        props[21].setName("SystemName");
        props[21].setKey(true);
        props[21].setType(CIMDataType.getPredefinedType((int)8));
        props[21].setValue(new CIMValue((Object)"IBM SSG CIMOM"));
        props[22] = new CIMProperty("TimeOfLastStateChange");
        props[22].setName("TimeOfLastStateChange");
        props[22].setType(CIMDataType.getPredefinedType((int)8));
        Object prop22Val = null;
        props[22].setValue(new CIMValue(prop22Val));
        for (int idx = 0; idx < NUM_PROPERTIES; ++idx) {
            v.add(props[idx]);
        }
        cimInstance.setProperties(v);
        return cimInstance;
    }

    private CIMInstance get_ibmts_truststore() throws Exception {
        CIMInstance instance = null;
        return instance;
    }

    private CIMInstance[] get_indication_filter() throws Exception {
        CIMInstance[] cimInstances = new CIMInstance[4];
        for (int idx = 0; idx < cimInstances.length; ++idx) {
            cimInstances[idx] = new CIMInstance();
            cimInstances[idx].setClassName("IBMTS_IndicationFilter");
            cimInstances[idx].setName("IBMTS_IndicationFilter");
            int NUM_PROPERTIES = 10;
            Vector<CIMProperty> v = new Vector<CIMProperty>();
            CIMProperty[] props = new CIMProperty[NUM_PROPERTIES];
            props[0] = new CIMProperty("Caption");
            props[0].setName("Caption");
            props[0].setType(CIMDataType.getPredefinedType((int)8));
            Object prop0Val = null;
            props[0].setValue(new CIMValue(prop0Val));
            props[1] = new CIMProperty("CreationClassName");
            props[1].setName("CreationClassName");
            props[1].setKey(true);
            props[1].setType(CIMDataType.getPredefinedType((int)8));
            props[1].setValue(new CIMValue((Object)"CIM_IndicationFilter"));
            props[2] = new CIMProperty("Description");
            props[2].setName("Description");
            props[2].setType(CIMDataType.getPredefinedType((int)8));
            String prop2Val = null;
            switch (idx) {
                case 0: {
                    prop2Val = "CIM_InstCreation Filter";
                    break;
                }
                case 1: {
                    prop2Val = "CIM_InstDeletion Filter";
                    break;
                }
                case 2: {
                    prop2Val = "CIM_InstModification Filter";
                    break;
                }
                case 3: {
                    prop2Val = "CIM_ProcessIndication Filter";
                }
            }
            props[2].setValue(new CIMValue((Object)prop2Val));
            props[3] = new CIMProperty("ElementName");
            props[3].setName("ElementName");
            props[3].setType(CIMDataType.getPredefinedType((int)8));
            props[3].setValue(new CIMValue((Object)prop2Val));
            props[4] = new CIMProperty("Name");
            props[4].setName("Name");
            props[4].setKey(true);
            props[4].setType(CIMDataType.getPredefinedType((int)8));
            String prop4Val = null;
            switch (idx) {
                case 0: {
                    prop4Val = "CIM_InstCreation";
                    break;
                }
                case 1: {
                    prop4Val = "CIM_InstDeletion";
                    break;
                }
                case 2: {
                    prop4Val = "CIM_InstModification";
                    break;
                }
                case 3: {
                    prop4Val = "CIM_ProcessIndication";
                }
            }
            props[4].setValue(new CIMValue((Object)prop4Val));
            props[5] = new CIMProperty("Query");
            props[5].setName("Query");
            props[5].setKey(true);
            props[5].setType(CIMDataType.getPredefinedType((int)8));
            String prop5Val = null;
            switch (idx) {
                case 0: {
                    prop5Val = "SELECT * FROM CIM_InstCreation";
                    break;
                }
                case 1: {
                    prop5Val = "SELECT * FROM CIM_InstDeletion";
                    break;
                }
                case 2: {
                    prop5Val = "SELECT * FROM CIM_InstModification";
                    break;
                }
                case 3: {
                    prop5Val = "SELECT * FROM CIM_ProcessIndication";
                }
            }
            props[5].setValue(new CIMValue((Object)prop5Val));
            props[6] = new CIMProperty("QueryLanguage");
            props[6].setName("QueryLanguage");
            props[6].setType(CIMDataType.getPredefinedType((int)8));
            props[6].setValue(new CIMValue((Object)"WQL"));
            props[7] = new CIMProperty("SourceNamespace");
            props[7].setName("SourceNamespace");
            props[7].setType(CIMDataType.getPredefinedType((int)8));
            Object prop7Val = null;
            props[7].setValue(new CIMValue(prop7Val));
            props[8] = new CIMProperty("SystemCreationClassName");
            props[8].setName("SystemCreationClassName");
            props[8].setKey(true);
            props[8].setType(CIMDataType.getPredefinedType((int)8));
            props[8].setValue(new CIMValue((Object)"CIM_IndicationFilter"));
            props[9] = new CIMProperty("SystemName");
            props[9].setName("SystemName");
            props[9].setKey(true);
            props[9].setType(CIMDataType.getPredefinedType((int)8));
            props[9].setValue(new CIMValue((Object)"IBMTS"));
            for (int idx2 = 0; idx2 < NUM_PROPERTIES; ++idx2) {
                v.add(props[idx2]);
            }
            cimInstances[idx].setProperties(v);
        }
        return cimInstances;
    }

    private CIMInstance get_cimxml_communication_mechanism() throws Exception {
        CIMInstance cimInstance = new CIMInstance();
        cimInstance.setClassName("IBMTS_CIMXMLCommunicationMechanism");
        cimInstance.setName("IBMTS_CIMXMLCommunicationMechanism");
        int NUM_PROPERTIES = 26;
        Vector<CIMProperty> v = new Vector<CIMProperty>();
        CIMProperty[] props = new CIMProperty[NUM_PROPERTIES];
        props[0] = new CIMProperty("AuthenticationMechanismDescriptions");
        props[0].setName("AuthenticationMechanismDescriptions");
        props[0].setType(CIMDataType.getPredefinedType((int)22));
        Vector prop0V = new Vector();
        props[0].setValue(new CIMValue(prop0V));
        props[1] = new CIMProperty("AuthenticationMechanismsSupported");
        props[1].setName("AuthenticationMechanismsSupported");
        props[1].setType(CIMDataType.getPredefinedType((int)16));
        Vector<UnsignedInt16> prop1V = new Vector<UnsignedInt16>();
        prop1V.add(new UnsignedInt16(3));
        props[1].setValue(new CIMValue(prop1V));
        props[2] = new CIMProperty("Caption");
        props[2].setName("Caption");
        props[2].setType(CIMDataType.getPredefinedType((int)8));
        Object prop2V = null;
        props[2].setValue(new CIMValue(prop2V));
        props[3] = new CIMProperty("CIMValidated");
        props[3].setName("CIMValidated");
        props[3].setType(CIMDataType.getPredefinedType((int)9));
        Boolean prop3Val = new Boolean(false);
        props[3].setValue(new CIMValue((Object)prop3Val));
        props[4] = new CIMProperty("CIMXMLProtocolVersion");
        props[4].setName("CIMXMLProtocolVersion");
        props[4].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 prop4Val = new UnsignedInt16(1);
        props[4].setValue(new CIMValue((Object)prop4Val));
        props[5] = new CIMProperty("CommunicationMechanism");
        props[5].setName("CommunicationMechanism");
        props[5].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 prop5Val = new UnsignedInt16(2);
        props[5].setValue(new CIMValue((Object)prop5Val));
        props[6] = new CIMProperty("CreationClassName");
        props[6].setName("CreationClassName");
        props[6].setKey(true);
        props[6].setType(CIMDataType.getPredefinedType((int)8));
        props[6].setValue(new CIMValue((Object)"IBMTS_CIMXMLCommunicationMechanism"));
        props[7] = new CIMProperty("Description");
        props[7].setName("Description");
        props[7].setType(CIMDataType.getPredefinedType((int)8));
        Object prop7Val = null;
        props[7].setValue(new CIMValue(prop7Val));
        props[8] = new CIMProperty("ElementName");
        props[8].setName("ElementName");
        props[8].setType(CIMDataType.getPredefinedType((int)8));
        String prop8Val = "CIMXMLCommunicationMechanism";
        props[8].setValue(new CIMValue((Object)prop8Val));
        props[9] = new CIMProperty("EnabledDefault");
        props[9].setName("EnabledDefault");
        props[9].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 prop9Val = new UnsignedInt16(2);
        props[9].setValue(new CIMValue((Object)prop9Val));
        props[10] = new CIMProperty("EnabledState");
        props[10].setName("EnabledState");
        props[10].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 prop10Val = new UnsignedInt16(5);
        props[10].setValue(new CIMValue((Object)prop10Val));
        props[11] = new CIMProperty("FunctionalProfilesSupported");
        props[11].setName("FunctionalProfilesSupported");
        props[11].setType(CIMDataType.getPredefinedType((int)16));
        Vector<UnsignedInt16> prop11V = new Vector<UnsignedInt16>();
        UnsignedInt16[] prop11Vals = new UnsignedInt16[7];
        int idx1 = 0;
        for (int idx2 = 2; idx2 <= 9; ++idx2) {
            if (idx2 != 4) {
                prop11Vals[idx1] = new UnsignedInt16(idx2);
                prop11V.add(prop11Vals[idx1]);
            } else {
                --idx1;
            }
            ++idx1;
        }
        props[11].setValue(new CIMValue(prop11V));
        props[12] = new CIMProperty("InstallDate");
        props[12].setName("InstallDate");
        props[12].setType(CIMDataType.getPredefinedType((int)12));
        Object prop12Val = null;
        props[12].setValue(new CIMValue(prop12Val));
        props[13] = new CIMProperty("MultipleOperationsSupported");
        props[13].setName("MultipleOperationsSupported");
        props[13].setType(CIMDataType.getPredefinedType((int)9));
        Boolean prop13Val = new Boolean(false);
        props[13].setValue(new CIMValue((Object)prop13Val));
        props[14] = new CIMProperty("Name");
        props[14].setName("Name");
        props[14].setKey(true);
        props[14].setType(CIMDataType.getPredefinedType((int)8));
        props[14].setValue(new CIMValue((Object)"IBMTS_CIMXMLCommunicationMechanism"));
        props[15] = new CIMProperty("OperationalStatus");
        props[15].setName("OperationalStatus");
        props[15].setType(CIMDataType.getPredefinedType((int)16));
        Vector<UnsignedInt16> prop15V = new Vector<UnsignedInt16>();
        prop15V.add(new UnsignedInt16(2));
        props[15].setValue(new CIMValue(prop15V));
        props[16] = new CIMProperty("OtherCommunicationMechanismDescription");
        props[16].setName("OtherCommunicationMechanismDescription");
        props[16].setType(CIMDataType.getPredefinedType((int)8));
        String prop16Val = "CIM-XML";
        props[16].setValue(new CIMValue((Object)prop16Val));
        props[17] = new CIMProperty("OtherEnabledState");
        props[17].setName("OtherEnabledState");
        props[17].setType(CIMDataType.getPredefinedType((int)8));
        Object prop17Val = null;
        props[17].setValue(new CIMValue(prop17Val));
        props[18] = new CIMProperty("RequestedState");
        props[18].setName("RequestedState");
        props[18].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 prop18Val = new UnsignedInt16(5);
        props[18].setValue(new CIMValue((Object)prop18Val));
        props[19] = new CIMProperty("Status");
        props[19].setName("Status");
        props[19].setType(CIMDataType.getPredefinedType((int)8));
        Object prop19Val = null;
        props[19].setValue(new CIMValue(prop19Val));
        props[20] = new CIMProperty("StatusDescriptions");
        props[20].setName("StatusDescriptions");
        props[20].setType(CIMDataType.getPredefinedType((int)22));
        Vector<String> prop20V = new Vector<String>();
        prop20V.add("OK");
        props[20].setValue(new CIMValue(prop20V));
        props[21] = new CIMProperty("SystemCreationClassName");
        props[21].setName("SystemCreationClassName");
        props[21].setKey(true);
        props[21].setType(CIMDataType.getPredefinedType((int)8));
        props[21].setValue(new CIMValue((Object)"IBMTS"));
        props[22] = new CIMProperty("SystemName");
        props[22].setName("SystemName");
        props[22].setKey(true);
        props[22].setType(CIMDataType.getPredefinedType((int)8));
        String prop22Val = "IBM XMLCommunicationMechanism";
        props[22].setValue(new CIMValue((Object)prop22Val));
        props[23] = new CIMProperty("TimeOfLastStateChange");
        props[23].setName("TimeOfLastStateChange");
        props[23].setType(CIMDataType.getPredefinedType((int)12));
        Object prop23Val = null;
        props[23].setValue(new CIMValue(prop23Val));
        props[24] = new CIMProperty("version");
        props[24].setName("version");
        props[24].setType(CIMDataType.getPredefinedType((int)8));
        props[24].setValue(new CIMValue((Object)"1.0"));
        props[25] = new CIMProperty("FunctionalProfileDescriptions");
        props[25].setName("FunctionalProfileDescriptions");
        props[25].setType(CIMDataType.getPredefinedType((int)22));
        Vector prop25V = new Vector();
        props[25].setValue(new CIMValue(prop25V));
        for (int idx = 0; idx < NUM_PROPERTIES; ++idx) {
            v.add(props[idx]);
        }
        cimInstance.setProperties(v);
        return cimInstance;
    }

    private CIMInstance get_certificate_setting() throws Exception {
        CIMInstance cimInstance = new CIMInstance();
        cimInstance.setClassName("IBMTS_CertificateSetting");
        cimInstance.setName("IBMTS_CertificateSetting");
        int NUM_PROPERTIES = 8;
        Vector<CIMProperty> v = new Vector<CIMProperty>();
        CIMProperty[] props = new CIMProperty[8];
        props[0] = new CIMProperty("AutoGenerationEnabled");
        props[0].setName("AutoGenerationEnabled");
        props[0].setType(CIMDataType.getPredefinedType((int)9));
        props[0].setValue(new CIMValue((Object)new Boolean(false)));
        props[1] = new CIMProperty("Caption");
        props[1].setName("Caption");
        props[1].setType(CIMDataType.getPredefinedType((int)8));
        String prop1Val = "IBM default setting for certificate creation";
        props[1].setValue(new CIMValue((Object)prop1Val));
        props[2] = new CIMProperty("Description");
        props[2].setName("Description");
        props[2].setType(CIMDataType.getPredefinedType((int)8));
        String prop2Val = "The vital product data of a node.";
        props[2].setValue(new CIMValue((Object)prop2Val));
        props[3] = new CIMProperty("ElementName");
        props[3].setName("ElementName");
        props[3].setType(CIMDataType.getPredefinedType((int)8));
        String prop3Val = "IBM default setting for certificate creation";
        props[3].setValue(new CIMValue((Object)prop3Val));
        props[4] = new CIMProperty("InstanceID");
        props[4].setName("InstanceID");
        props[4].setKey(true);
        props[4].setType(CIMDataType.getPredefinedType((int)8));
        String prop4Val = "DefaultCertificateSetting";
        props[4].setValue(new CIMValue((Object)prop4Val));
        props[5] = new CIMProperty("ServerCertificateName");
        props[5].setName("ServerCertificateName");
        props[5].setType(CIMDataType.getPredefinedType((int)8));
        String prop5Val = "CIMOMserver";
        props[5].setValue(new CIMValue((Object)prop5Val));
        props[6] = new CIMProperty("SignerCertificateName");
        props[6].setName("SignerCertificateName");
        props[6].setType(CIMDataType.getPredefinedType((int)8));
        String prop6Val = "CIMOMserver";
        props[6].setValue(new CIMValue((Object)prop6Val));
        props[7] = new CIMProperty("Validity");
        props[7].setName("Validity");
        props[7].setType(CIMDataType.getPredefinedType((int)4));
        UnsignedInt32 prop7Val = new UnsignedInt32("365");
        props[7].setValue(new CIMValue((Object)prop7Val));
        for (int idx = 0; idx < NUM_PROPERTIES; ++idx) {
            v.add(props[idx]);
        }
        cimInstance.setProperties(v);
        return cimInstance;
    }

    private CIMInstance get_ibmts_certificate() throws Exception {
        CIMInstance instance = null;
        return instance;
    }

    private CIMInstance get_ibmts_system() throws Exception {
        CIMInstance cimInstance = new CIMInstance();
        cimInstance.setClassName("IBMTS_System");
        cimInstance.setName("IBMTS_System");
        int NUM_PROPERTIES = 18;
        Vector<CIMProperty> v = new Vector<CIMProperty>();
        CIMProperty[] props = new CIMProperty[NUM_PROPERTIES];
        props[0] = new CIMProperty("Caption");
        props[0].setName("Caption");
        props[0].setType(CIMDataType.getPredefinedType((int)8));
        Object prop0Val = null;
        props[0].setValue(new CIMValue(prop0Val));
        props[1] = new CIMProperty("CreationClassName");
        props[1].setName("CreationClassName");
        props[1].setKey(true);
        props[1].setType(CIMDataType.getPredefinedType((int)8));
        props[1].setValue(new CIMValue((Object)"IBMTS_System"));
        props[2] = new CIMProperty("Description");
        props[2].setName("Description");
        props[2].setType(CIMDataType.getPredefinedType((int)8));
        props[2].setValue(new CIMValue((Object)"IBMTS_System"));
        props[3] = new CIMProperty("ElementName");
        props[3].setName("ElementName");
        props[3].setType(CIMDataType.getPredefinedType((int)8));
        String prop3Val = "Proxy Server";
        props[3].setValue(new CIMValue((Object)prop3Val));
        props[4] = new CIMProperty("EnabledState");
        props[4].setName("EnabledState");
        props[4].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 prop4Val = new UnsignedInt16(5);
        props[4].setValue(new CIMValue((Object)prop4Val));
        props[5] = new CIMProperty("InstallDate");
        props[5].setName("InstallDate");
        props[5].setType(CIMDataType.getPredefinedType((int)12));
        Object prop5Val = null;
        props[5].setValue(new CIMValue(prop5Val));
        props[6] = new CIMProperty("Name");
        props[6].setName("Name");
        props[6].setKey(true);
        props[6].setType(CIMDataType.getPredefinedType((int)8));
        InetAddress localIP = InetAddress.getLocalHost();
        String prop6Val = localIP.getHostAddress();
        props[6].setValue(new CIMValue((Object)prop6Val));
        props[7] = new CIMProperty("NameFormat");
        props[7].setName("NameFormat");
        props[7].setType(CIMDataType.getPredefinedType((int)8));
        String prop7Val = "Other";
        props[7].setValue(new CIMValue((Object)prop7Val));
        props[8] = new CIMProperty("OperationalStatus");
        props[8].setName("OperationalStatus");
        props[8].setType(CIMDataType.getPredefinedType((int)16));
        Vector<UnsignedInt16> prop8V = new Vector<UnsignedInt16>();
        prop8V.add(new UnsignedInt16(2));
        props[8].setValue(new CIMValue(prop8V));
        props[9] = new CIMProperty("OtherEnabledState");
        props[9].setName("OtherEnabledState");
        props[9].setType(CIMDataType.getPredefinedType((int)8));
        Object prop9Val = null;
        props[9].setValue(new CIMValue(prop9Val));
        props[10] = new CIMProperty("PrimaryOwnerContact");
        props[10].setName("PrimaryOwnerContact");
        props[10].setType(CIMDataType.getPredefinedType((int)8));
        String prop10Val = "IBM Customer";
        props[10].setValue(new CIMValue((Object)prop10Val));
        props[11] = new CIMProperty("PrimaryOwnerName");
        props[11].setName("PrimaryOwnerName");
        props[11].setType(CIMDataType.getPredefinedType((int)8));
        String prop11Val = "IBM Corporation";
        props[11].setValue(new CIMValue((Object)prop11Val));
        props[12] = new CIMProperty("RequestedState");
        props[12].setName("RequestedState");
        props[12].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 prop12Val = new UnsignedInt16(5);
        props[12].setValue(new CIMValue((Object)prop12Val));
        props[13] = new CIMProperty("Roles");
        props[13].setName("Roles");
        props[13].setType(CIMDataType.getPredefinedType((int)22));
        Vector prop13V = new Vector();
        props[13].setValue(new CIMValue(prop13V));
        props[14] = new CIMProperty("StatusDescriptions");
        props[14].setName("StatusDescriptions");
        props[14].setType(CIMDataType.getPredefinedType((int)22));
        Vector<String> prop14V = new Vector<String>();
        prop14V.add(new String("OK"));
        props[14].setValue(new CIMValue(prop14V));
        props[15] = new CIMProperty("Status");
        props[15].setName("Status");
        props[15].setType(CIMDataType.getPredefinedType((int)8));
        Object prop15Val = null;
        props[15].setValue(new CIMValue(prop15Val));
        props[16] = new CIMProperty("EnabledState");
        props[16].setName("EnabledState");
        props[16].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 prop16Val = new UnsignedInt16(5);
        props[16].setValue(new CIMValue((Object)prop16Val));
        props[17] = new CIMProperty("TimeOfLastStateChange");
        props[17].setName("TimeOfLastStateChange");
        props[17].setType(CIMDataType.getPredefinedType((int)12));
        Object prop17Val = null;
        props[17].setValue(new CIMValue(prop17Val));
        for (int idx = 0; idx < NUM_PROPERTIES; ++idx) {
            v.add(props[idx]);
        }
        cimInstance.setProperties(v);
        return cimInstance;
    }

    private CIMInstance get_ibmts_account_management_service() throws Exception {
        CIMInstance cimInstance = new CIMInstance();
        cimInstance.setClassName("IBMTS_AccountManagementService");
        cimInstance.setName("IBMTS_AccountManagementService");
        int NUM_PROPERTIES = 20;
        Vector<CIMProperty> v = new Vector<CIMProperty>();
        CIMProperty[] props = new CIMProperty[NUM_PROPERTIES];
        props[0] = new CIMProperty("Caption");
        props[0].setName("Caption");
        props[0].setType(CIMDataType.getPredefinedType((int)8));
        Object prop0Value = null;
        props[0].setValue(new CIMValue(prop0Value));
        props[1] = new CIMProperty("CreationClassName");
        props[1].setName("CreationClassName");
        props[1].setKey(true);
        props[1].setType(CIMDataType.getPredefinedType((int)8));
        props[1].setValue(new CIMValue((Object)"IBMTS_AccountManagementService"));
        props[2] = new CIMProperty("Description");
        props[2].setName("Description");
        props[2].setType(CIMDataType.getPredefinedType((int)8));
        Object prop2Val = null;
        props[2].setValue(new CIMValue(prop2Val));
        props[3] = new CIMProperty("ElementName");
        props[3].setName("ElementName");
        props[3].setType(CIMDataType.getPredefinedType((int)8));
        Object prop3Val = null;
        props[3].setValue(new CIMValue(prop3Val));
        props[4] = new CIMProperty("EnabledDefault");
        props[4].setName("EnabledDefault");
        props[4].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 prop4Val = new UnsignedInt16(2);
        props[4].setValue(new CIMValue((Object)prop4Val));
        props[5] = new CIMProperty("EnabledState");
        props[5].setName("EnabledState");
        props[5].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 prop5Val = new UnsignedInt16(5);
        props[5].setValue(new CIMValue((Object)prop5Val));
        props[6] = new CIMProperty("InstallDate");
        props[6].setName("InstallDate");
        props[6].setType(CIMDataType.getPredefinedType((int)8));
        Object prop6Val = null;
        props[6].setValue(new CIMValue(prop6Val));
        props[7] = new CIMProperty("Name");
        props[7].setName("Name");
        props[7].setKey(true);
        props[7].setType(CIMDataType.getPredefinedType((int)8));
        String prop7Val = "SVC_CIMOM";
        props[7].setValue(new CIMValue((Object)prop7Val));
        props[8] = new CIMProperty("OperationalStatus");
        props[8].setName("OperationalStatus");
        props[8].setType(CIMDataType.getPredefinedType((int)22));
        Vector prop8V = new Vector();
        props[8].setValue(new CIMValue(prop8V));
        props[9] = new CIMProperty("OtherEnabledState");
        props[9].setName("OtherEnabledState");
        props[9].setType(CIMDataType.getPredefinedType((int)8));
        Object prop9Val = null;
        props[9].setValue(new CIMValue(prop9Val));
        props[10] = new CIMProperty("PrimaryOwnerContact");
        props[10].setName("PrimaryOwnerContact");
        props[10].setType(CIMDataType.getPredefinedType((int)8));
        Object prop10Val = null;
        props[10].setValue(new CIMValue(prop10Val));
        props[11] = new CIMProperty("PrimaryOwnerName");
        props[11].setName("PrimaryOwnerName");
        props[11].setType(CIMDataType.getPredefinedType((int)8));
        Object prop11Val = null;
        props[11].setValue(new CIMValue(prop11Val));
        props[12] = new CIMProperty("RequestedState");
        props[12].setName("RequestedState");
        props[12].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 prop12Val = new UnsignedInt16(5);
        props[12].setValue(new CIMValue((Object)prop12Val));
        props[13] = new CIMProperty("Started");
        props[13].setName("Started");
        props[13].setType(CIMDataType.getPredefinedType((int)9));
        Object prop13Val = null;
        props[13].setValue(new CIMValue(prop13Val));
        props[14] = new CIMProperty("StartMode");
        props[14].setName("StartMode");
        props[14].setType(CIMDataType.getPredefinedType((int)8));
        Object prop14Val = null;
        props[14].setValue(new CIMValue(prop14Val));
        props[15] = new CIMProperty("Status");
        props[15].setName("Status");
        props[15].setType(CIMDataType.getPredefinedType((int)8));
        Object prop15Val = null;
        props[15].setValue(new CIMValue(prop15Val));
        props[16] = new CIMProperty("StatusDescriptions");
        props[16].setName("StatusDescriptions");
        props[16].setType(CIMDataType.getPredefinedType((int)22));
        Vector prop16V = new Vector();
        props[16].setValue(new CIMValue(prop16V));
        props[17] = new CIMProperty("SystemCreationClassName");
        props[17].setName("SystemCreationClassName");
        props[17].setKey(true);
        props[17].setType(CIMDataType.getPredefinedType((int)8));
        props[17].setValue(new CIMValue((Object)"IBMTS"));
        props[18] = new CIMProperty("SystemName");
        props[18].setName("SystemName");
        props[18].setKey(true);
        props[18].setType(CIMDataType.getPredefinedType((int)8));
        props[18].setValue(new CIMValue((Object)"IBM SSG CIMOM"));
        props[19] = new CIMProperty("TimeOfLastStateChange");
        props[19].setName("TimeOfLastStateChange");
        props[19].setType(CIMDataType.getPredefinedType((int)8));
        Object prop19Val = null;
        props[19].setValue(new CIMValue(prop19Val));
        for (int idx = 0; idx < NUM_PROPERTIES; ++idx) {
            v.add(props[idx]);
        }
        cimInstance.setProperties(v);
        return cimInstance;
    }

    private CIMInstance get_ibmts_account() throws Exception {
        CIMInstance cimInstance = new CIMInstance();
        cimInstance.setClassName("IBMTS_Account");
        cimInstance.setName("IBMTS_Account");
        int NUM_PROPERTIES = 21;
        Vector<CIMProperty> v = new Vector<CIMProperty>();
        CIMProperty[] props = new CIMProperty[NUM_PROPERTIES];
        props[0] = new CIMProperty("Caption");
        props[0].setName("Caption");
        props[0].setType(CIMDataType.getPredefinedType((int)8));
        Object prop0Value = null;
        props[0].setValue(new CIMValue(prop0Value));
        props[1] = new CIMProperty("CreationClassName");
        props[1].setName("CreationClassName");
        props[1].setKey(true);
        props[1].setType(CIMDataType.getPredefinedType((int)8));
        props[1].setValue(new CIMValue((Object)"IBMTS_Account"));
        props[2] = new CIMProperty("Description");
        props[2].setName("Description");
        props[2].setType(CIMDataType.getPredefinedType((int)8));
        Object prop2Val = null;
        props[2].setValue(new CIMValue(prop2Val));
        props[3] = new CIMProperty("Descriptions");
        props[3].setName("Descriptions");
        props[3].setType(CIMDataType.getPredefinedType((int)22));
        Vector prop3V = new Vector();
        props[3].setValue(new CIMValue(prop3V));
        props[4] = new CIMProperty("ElementName");
        props[4].setName("ElementName");
        props[4].setType(CIMDataType.getPredefinedType((int)8));
        Object prop4Val = null;
        props[4].setValue(new CIMValue(prop4Val));
        props[5] = new CIMProperty("Host");
        props[5].setName("Host");
        props[5].setType(CIMDataType.getPredefinedType((int)22));
        Vector<String> prop5V = new Vector<String>();
        prop5V.add("Administrator");
        props[5].setValue(new CIMValue(prop5V));
        props[6] = new CIMProperty("InstallDate");
        props[6].setName("InstallDate");
        props[6].setType(CIMDataType.getPredefinedType((int)8));
        Object prop6Val = null;
        props[6].setValue(new CIMValue(prop6Val));
        props[7] = new CIMProperty("LocalityName");
        props[7].setName("LocalityName");
        props[7].setType(CIMDataType.getPredefinedType((int)22));
        Vector prop7V = new Vector();
        props[7].setValue(new CIMValue(prop7V));
        props[8] = new CIMProperty("Name");
        props[8].setName("Name");
        props[8].setKey(true);
        props[8].setType(CIMDataType.getPredefinedType((int)8));
        String prop8Val = "superuser";
        props[8].setValue(new CIMValue((Object)prop8Val));
        props[9] = new CIMProperty("OU");
        props[9].setName("OU");
        props[9].setType(CIMDataType.getPredefinedType((int)22));
        Vector prop9V = new Vector();
        props[9].setValue(new CIMValue(prop9V));
        props[10] = new CIMProperty("ObjectClass");
        props[10].setName("ObjectClass");
        props[10].setType(CIMDataType.getPredefinedType((int)22));
        Vector prop10V = new Vector();
        props[10].setValue(new CIMValue(prop10V));
        props[11] = new CIMProperty("OperationalStatus");
        props[11].setName("OperationalStatus");
        props[11].setType(CIMDataType.getPredefinedType((int)22));
        Vector prop11V = new Vector();
        props[11].setValue(new CIMValue(prop11V));
        props[12] = new CIMProperty("OrganizationName");
        props[12].setName("OrganizationName");
        props[12].setType(CIMDataType.getPredefinedType((int)22));
        Vector prop12V = new Vector();
        props[12].setValue(new CIMValue(prop12V));
        props[13] = new CIMProperty("SeeAlso");
        props[13].setName("SeeAlso");
        props[13].setType(CIMDataType.getPredefinedType((int)22));
        Vector prop13V = new Vector();
        props[13].setValue(new CIMValue(prop13V));
        props[14] = new CIMProperty("Status");
        props[14].setName("Status");
        props[14].setType(CIMDataType.getPredefinedType((int)8));
        Object prop14Val = null;
        props[14].setValue(new CIMValue(prop14Val));
        props[15] = new CIMProperty("StatusDescriptions");
        props[15].setName("StatusDescriptions");
        props[15].setType(CIMDataType.getPredefinedType((int)22));
        Vector prop15V = new Vector();
        props[15].setValue(new CIMValue(prop15V));
        props[16] = new CIMProperty("SystemCreationClassName");
        props[16].setName("SystemCreationClassName");
        props[16].setKey(true);
        props[16].setType(CIMDataType.getPredefinedType((int)8));
        props[16].setValue(new CIMValue((Object)"IBMTS_Account"));
        props[17] = new CIMProperty("SystemName");
        props[17].setName("SystemName");
        props[17].setKey(true);
        props[17].setType(CIMDataType.getPredefinedType((int)8));
        props[17].setValue(new CIMValue((Object)"icat"));
        props[18] = new CIMProperty("UserCertificate");
        props[18].setName("UserCertificate");
        props[18].setType(CIMDataType.getPredefinedType((int)22));
        Vector prop18V = new Vector();
        props[18].setValue(new CIMValue(prop18V));
        props[19] = new CIMProperty("UserID");
        props[19].setName("UserID");
        props[19].setType(CIMDataType.getPredefinedType((int)8));
        String prop19Val = "superuser";
        props[19].setValue(new CIMValue((Object)prop19Val));
        props[20] = new CIMProperty("UserPassword");
        props[20].setName("UserPassword");
        props[20].setType(CIMDataType.getPredefinedType((int)22));
        Vector<String> prop20V = new Vector<String>();
        prop20V.add("y95Se6dVeZuE8k8=");
        props[20].setValue(new CIMValue(prop20V));
        for (int idx = 0; idx < NUM_PROPERTIES; ++idx) {
            v.add(props[idx]);
        }
        cimInstance.setProperties(v);
        return cimInstance;
    }

    private CIMInstance get_ibmts_namespace() throws Exception {
        CIMInstance cimInstance = new CIMInstance();
        cimInstance.setClassName("IBMTS_NameSpace");
        cimInstance.setName("IBMTS_NameSpace");
        int NUM_PROPERTIES = 14;
        Vector<CIMProperty> v = new Vector<CIMProperty>();
        CIMProperty[] props = new CIMProperty[NUM_PROPERTIES];
        props[0] = new CIMProperty("Caption");
        props[0].setName("Caption");
        props[0].setType(CIMDataType.getPredefinedType((int)8));
        Object prop0Val = null;
        props[0].setValue(new CIMValue(prop0Val));
        props[1] = new CIMProperty("ClassInfo");
        props[1].setName("CreationClassName");
        props[1].setType(CIMDataType.getPredefinedType((int)2));
        props[1].setValue(new CIMValue((Object)new UnsignedInt16(10)));
        props[2] = new CIMProperty("ClassType");
        props[2].setName("ClassType");
        props[2].setType(CIMDataType.getPredefinedType((int)2));
        Object prop2Val = null;
        props[2].setValue(new CIMValue(prop2Val));
        props[3] = new CIMProperty("ClassTypeVersion");
        props[3].setName("ClassTypeVersion");
        props[3].setType(CIMDataType.getPredefinedType((int)8));
        Object prop3Val = null;
        props[3].setValue(new CIMValue(prop3Val));
        props[4] = new CIMProperty("CreationClassName");
        props[4].setName("CreationClassName");
        props[4].setKey(true);
        props[4].setType(CIMDataType.getPredefinedType((int)8));
        props[4].setValue(new CIMValue((Object)"IBMTS_NameSpace"));
        props[5] = new CIMProperty("Description");
        props[5].setName("Description");
        props[5].setType(CIMDataType.getPredefinedType((int)8));
        Object prop5Val = null;
        props[5].setValue(new CIMValue(prop5Val));
        props[6] = new CIMProperty("DescriptionOfClassInfo");
        props[6].setName("DescriptionOfClassInfo");
        props[6].setType(CIMDataType.getPredefinedType((int)8));
        Object prop6Val = null;
        props[6].setValue(new CIMValue(prop6Val));
        props[7] = new CIMProperty("DescriptionOfClassType");
        props[7].setName("DescriptionOfClassType");
        props[7].setType(CIMDataType.getPredefinedType((int)8));
        Object prop7Val = null;
        props[7].setValue(new CIMValue(prop7Val));
        props[8] = new CIMProperty("ElementName");
        props[8].setName("ElementName");
        props[8].setType(CIMDataType.getPredefinedType((int)8));
        props[8].setValue(new CIMValue((Object)"/root/ibm"));
        props[9] = new CIMProperty("Name");
        props[9].setName("Name");
        props[9].setKey(true);
        props[9].setType(CIMDataType.getPredefinedType((int)8));
        props[9].setValue(new CIMValue((Object)"/root/ibm"));
        props[10] = new CIMProperty("ObjectManagerCreationClassName");
        props[10].setName("ObjectManagerCreationClassName");
        props[10].setKey(true);
        props[10].setType(CIMDataType.getPredefinedType((int)8));
        props[10].setValue(new CIMValue((Object)"IBMTS_ObjectManager"));
        props[11] = new CIMProperty("ObjectManagerName");
        props[11].setName("ObjectManagerName");
        props[11].setKey(true);
        props[11].setType(CIMDataType.getPredefinedType((int)8));
        props[11].setValue(new CIMValue((Object)"IBM_CIMOM_1145095755750_1288880889"));
        props[12] = new CIMProperty("SystemCreationClassName");
        props[12].setName("SystemCreationClassName");
        props[12].setKey(true);
        props[12].setType(CIMDataType.getPredefinedType((int)8));
        props[12].setValue(new CIMValue((Object)"IBMTS"));
        props[13] = new CIMProperty("SystemName");
        props[13].setName("SystemName");
        props[13].setKey(true);
        props[13].setType(CIMDataType.getPredefinedType((int)8));
        props[13].setValue(new CIMValue((Object)"IBM Namespace"));
        for (int idx = 0; idx < NUM_PROPERTIES; ++idx) {
            v.add(props[idx]);
        }
        cimInstance.setProperties(v);
        return cimInstance;
    }

    private CIMInstance get_ibmts_object_manager() throws Exception {
        CIMInstance cimInstance = new CIMInstance();
        cimInstance.setClassName("IBMTS_ObjectManager");
        cimInstance.setName("IBMTS_ObjectManager");
        int NUM_PROPERTIES = 22;
        Vector<CIMProperty> v = new Vector<CIMProperty>();
        CIMProperty[] props = new CIMProperty[NUM_PROPERTIES];
        props[0] = new CIMProperty("Caption");
        props[0].setName("Caption");
        props[0].setType(CIMDataType.getPredefinedType((int)8));
        Object prop0Val = null;
        props[0].setValue(new CIMValue(prop0Val));
        props[1] = new CIMProperty("CreationClassName");
        props[1].setName("CreationClassName");
        props[1].setKey(true);
        props[1].setType(CIMDataType.getPredefinedType((int)8));
        props[1].setValue(new CIMValue((Object)"IBMTS_ObjectManager"));
        props[2] = new CIMProperty("Description");
        props[2].setName("Description");
        props[2].setType(CIMDataType.getPredefinedType((int)8));
        props[2].setValue(new CIMValue((Object)"IBM TotalStorage DS CIM Agent Version 5.1.0.43"));
        props[3] = new CIMProperty("ElementName");
        props[3].setName("ElementName");
        props[3].setType(CIMDataType.getPredefinedType((int)8));
        props[3].setValue(new CIMValue((Object)"ESS CIM Agent 5.1.0.43"));
        props[4] = new CIMProperty("EnabledDefault");
        props[4].setName("EnabledDefault");
        props[4].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 prop4Val = new UnsignedInt16(2);
        props[4].setValue(new CIMValue((Object)prop4Val));
        props[5] = new CIMProperty("EnabledState");
        props[5].setName("EnabledState");
        props[5].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 prop5Val = new UnsignedInt16(5);
        props[5].setValue(new CIMValue((Object)prop5Val));
        props[6] = new CIMProperty("GatherStatisticalData");
        props[6].setName("GatherStatisticalData");
        props[6].setType(CIMDataType.getPredefinedType((int)9));
        props[6].setValue(new CIMValue((Object)new Boolean(false)));
        props[7] = new CIMProperty("InstallDate");
        props[7].setName("InstallDate");
        props[7].setType(CIMDataType.getPredefinedType((int)12));
        Object prop7Val = null;
        props[7].setValue(new CIMValue(prop7Val));
        props[8] = new CIMProperty("Name");
        props[8].setName("Name");
        props[8].setKey(true);
        props[8].setType(CIMDataType.getPredefinedType((int)8));
        props[8].setValue(new CIMValue((Object)"IBM_CIMOM_1145095755750_1288880889"));
        props[9] = new CIMProperty("OperationalStatus");
        props[9].setName("OperationalStatus");
        props[9].setType(CIMDataType.getPredefinedType((int)16));
        Vector<UnsignedInt16> prop9V = new Vector<UnsignedInt16>();
        prop9V.add(new UnsignedInt16(2));
        props[9].setValue(new CIMValue(prop9V));
        props[10] = new CIMProperty("OtherEnabledState");
        props[10].setName("OtherEnabledState");
        props[10].setType(CIMDataType.getPredefinedType((int)8));
        Object prop10Val = null;
        props[10].setValue(new CIMValue(prop10Val));
        props[11] = new CIMProperty("PrimaryOwnerContact");
        props[11].setName("PrimaryOwnerContact");
        props[11].setType(CIMDataType.getPredefinedType((int)8));
        Object prop11Val = null;
        props[11].setValue(new CIMValue(prop11Val));
        props[12] = new CIMProperty("PrimaryOwnerName");
        props[12].setName("PrimaryOwnerName");
        props[12].setType(CIMDataType.getPredefinedType((int)8));
        Object prop12Val = null;
        props[12].setValue(new CIMValue(prop12Val));
        props[13] = new CIMProperty("RequestedState");
        props[13].setName("RequestedState");
        props[13].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 prop13Val = new UnsignedInt16(5);
        props[13].setValue(new CIMValue((Object)prop13Val));
        props[14] = new CIMProperty("StartMode");
        props[14].setName("StartMode");
        props[14].setType(CIMDataType.getPredefinedType((int)8));
        Object prop14Val = null;
        props[14].setValue(new CIMValue(prop14Val));
        props[15] = new CIMProperty("Started");
        props[15].setName("Started");
        props[15].setType(CIMDataType.getPredefinedType((int)9));
        Boolean prop15Val = new Boolean(true);
        props[15].setValue(new CIMValue((Object)prop15Val));
        props[16] = new CIMProperty("Status");
        props[16].setName("Status");
        props[16].setType(CIMDataType.getPredefinedType((int)8));
        Object prop16Val = null;
        props[16].setValue(new CIMValue(prop16Val));
        props[17] = new CIMProperty("StatusDescriptions");
        props[17].setName("StatusDescriptions");
        props[17].setType(CIMDataType.getPredefinedType((int)22));
        Vector<String> prop17V = new Vector<String>();
        prop17V.add("OK");
        props[17].setValue(new CIMValue(prop17V));
        props[18] = new CIMProperty("SystemCreationClassName");
        props[18].setName("SystemCreationClassName");
        props[18].setType(CIMDataType.getPredefinedType((int)8));
        props[18].setValue(new CIMValue((Object)"IBM_TS"));
        props[19] = new CIMProperty("SystemName");
        props[19].setName("SystemName");
        props[19].setType(CIMDataType.getPredefinedType((int)8));
        props[19].setValue(new CIMValue((Object)"IBM SSG CIMOM"));
        props[20] = new CIMProperty("TimeOfLastStateChange");
        props[20].setName("TimeOfLastStateChange");
        props[20].setType(CIMDataType.getPredefinedType((int)12));
        Object prop20Val = null;
        props[20].setValue(new CIMValue(prop20Val));
        props[21] = new CIMProperty("version");
        props[21].setName("version");
        props[21].setType(CIMDataType.getPredefinedType((int)8));
        props[21].setValue(new CIMValue((Object)"5.1.0.43"));
        for (int idx = 0; idx < NUM_PROPERTIES; ++idx) {
            v.add(props[idx]);
        }
        cimInstance.setProperties(v);
        return cimInstance;
    }

    private CIMInstance get_ibmts_registered_profile() throws Exception {
        CIMInstance cimInstance = new CIMInstance();
        cimInstance.setClassName("IBMTS_RegisteredProfile");
        cimInstance.setName("IBMTS_RegisteredProfile");
        Vector<CIMProperty> v = new Vector<CIMProperty>();
        CIMProperty prop1 = new CIMProperty("AdvertiseTypeDescriptions");
        prop1.setName("AdvertiseTypeDescriptions");
        prop1.setType(CIMDataType.getPredefinedType((int)22));
        Object prop1Val = null;
        prop1.setValue(new CIMValue(prop1Val));
        CIMProperty prop2 = new CIMProperty("AdvertiseTypes");
        prop2.setName("AdvertiseTypes");
        prop2.setType(CIMDataType.getPredefinedType((int)16));
        Vector<UnsignedInt16> prop2ValV = new Vector<UnsignedInt16>();
        UnsignedInt16 prop2Val = new UnsignedInt16(2);
        prop2ValV.add(prop2Val);
        prop2.setValue(new CIMValue(prop2ValV));
        CIMProperty prop3 = new CIMProperty("InstanceID");
        prop3.setKey(true);
        prop3.setName("InstanceID");
        prop3.setType(CIMDataType.getPredefinedType((int)8));
        prop3.setValue(new CIMValue((Object)"IBMTS:Server"));
        CIMProperty prop4 = new CIMProperty("OtherRegisteredOrganization");
        prop4.setName("OtherRegisteredOrganization");
        prop4.setType(CIMDataType.getPredefinedType((int)8));
        Object prop4Val = null;
        prop4.setValue(new CIMValue(prop4Val));
        CIMProperty prop5 = new CIMProperty("RegisteredName");
        prop5.setName("RegisteredName");
        prop5.setType(CIMDataType.getPredefinedType((int)8));
        prop5.setValue(new CIMValue((Object)"Server"));
        CIMProperty prop6 = new CIMProperty("RegisteredOrganization");
        prop6.setName("RegisteredOrganization");
        prop6.setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 prop6Val = new UnsignedInt16(11);
        prop6.setValue(new CIMValue((Object)prop6Val));
        CIMProperty prop7 = new CIMProperty("RegisteredVersion");
        prop7.setName("RegisteredVersion");
        prop7.setType(CIMDataType.getPredefinedType((int)8));
        prop7.setValue(new CIMValue((Object)"1.0.3"));
        v.add(prop1);
        v.add(prop2);
        v.add(prop3);
        v.add(prop4);
        v.add(prop5);
        v.add(prop6);
        v.add(prop7);
        cimInstance.setProperties(v);
        return cimInstance;
    }

    private CIMInstance get_ibmtsess_registered_profile() throws Exception {
        CIMInstance cimInstance = new CIMInstance();
        cimInstance.setClassName("IBMTSESS_RegisteredProfile");
        cimInstance.setName("IBMTSESS_RegisteredProfile");
        int NUM_PROPERTIES = 10;
        Vector<CIMProperty> v = new Vector<CIMProperty>();
        CIMProperty[] props = new CIMProperty[NUM_PROPERTIES];
        props[0] = new CIMProperty("AdvertiseTypeDescriptions");
        props[0].setName("AdvertiseTypeDescriptions");
        props[0].setType(CIMDataType.getPredefinedType((int)22));
        Object prop0Val = null;
        props[0].setValue(new CIMValue(prop0Val));
        props[1] = new CIMProperty("AdvertiseTypes");
        props[1].setName("AdvertiseTypes");
        props[1].setType(CIMDataType.getPredefinedType((int)16));
        Vector<UnsignedInt16> prop1V = new Vector<UnsignedInt16>();
        prop1V.add(new UnsignedInt16(2));
        props[1].setValue(new CIMValue(prop1V));
        props[2] = new CIMProperty("Caption");
        props[2].setName("Caption");
        props[2].setType(CIMDataType.getPredefinedType((int)8));
        Object prop2Val = null;
        props[2].setValue(new CIMValue(prop2Val));
        props[3] = new CIMProperty("Description");
        props[3].setName("Description");
        props[3].setType(CIMDataType.getPredefinedType((int)8));
        Object prop3Val = null;
        props[3].setValue(new CIMValue(prop3Val));
        props[4] = new CIMProperty("ElementName");
        props[4].setName("ElementName");
        props[4].setType(CIMDataType.getPredefinedType((int)8));
        Object prop4Val = null;
        props[4].setValue(new CIMValue(prop4Val));
        props[5] = new CIMProperty("InstanceID");
        props[5].setKey(true);
        props[5].setName("InstanceID");
        props[5].setType(CIMDataType.getPredefinedType((int)8));
        props[5].setValue(new CIMValue((Object)"Array"));
        props[6] = new CIMProperty("OtherRegisteredOrganization");
        props[6].setName("OtherRegisteredOrganization");
        props[6].setType(CIMDataType.getPredefinedType((int)8));
        props[6].setValue(new CIMValue((Object)"SNIA"));
        props[7] = new CIMProperty("RegisteredName");
        props[7].setName("RegisteredName");
        props[7].setType(CIMDataType.getPredefinedType((int)8));
        props[7].setValue(new CIMValue((Object)"Array"));
        props[8] = new CIMProperty("RegisteredOrganization");
        props[8].setName("RegisteredOrganization");
        props[8].setType(CIMDataType.getPredefinedType((int)2));
        UnsignedInt16 prop8Val = new UnsignedInt16(11);
        props[8].setValue(new CIMValue((Object)prop8Val));
        props[9] = new CIMProperty("RegisteredVersion");
        props[9].setName("RegisteredVersion");
        props[9].setType(CIMDataType.getPredefinedType((int)8));
        props[9].setValue(new CIMValue((Object)"1.0.3"));
        for (int idx = 0; idx < NUM_PROPERTIES; ++idx) {
            v.add(props[idx]);
        }
        cimInstance.setProperties(v);
        return cimInstance;
    }

    private CIMInstance[] get_ibmtsess_registered_sub_profile() throws Exception {
        int instanceCnt = 10;
        CIMInstance[] cimInstances = new CIMInstance[instanceCnt];
        for (int idx = 0; idx < instanceCnt; ++idx) {
            cimInstances[idx] = new CIMInstance();
            cimInstances[idx].setClassName("IBMTSESS_RegisteredSubProfile");
            cimInstances[idx].setName("IBMTSESS_RegisteredSubProfile");
            Vector<CIMProperty> v = new Vector<CIMProperty>();
            CIMProperty prop1 = new CIMProperty("AdvertiseTypeDescriptions");
            prop1.setName("AdvertiseTypeDescriptions");
            prop1.setType(CIMDataType.getPredefinedType((int)22));
            Object prop1Val = null;
            prop1.setValue(new CIMValue(prop1Val));
            CIMProperty prop2 = new CIMProperty("AdvertiseTypes");
            prop2.setName("AdvertiseTypes");
            prop2.setType(CIMDataType.getPredefinedType((int)16));
            Vector<UnsignedInt16> prop2ValV = new Vector<UnsignedInt16>();
            UnsignedInt16 prop2Val = new UnsignedInt16(2);
            prop2ValV.add(prop2Val);
            prop2.setValue(new CIMValue(prop2ValV));
            CIMProperty prop3 = new CIMProperty("InstanceID");
            prop3.setKey(true);
            prop3.setName("InstanceID");
            prop3.setType(CIMDataType.getPredefinedType((int)8));
            switch (idx) {
                case 1: {
                    prop3.setValue(new CIMValue((Object)"Extra Capacity Set"));
                    break;
                }
                case 2: {
                    prop3.setValue(new CIMValue((Object)"Access Points"));
                    break;
                }
                case 3: {
                    prop3.setValue(new CIMValue((Object)"LUN Mapping and Masking"));
                    break;
                }
                case 4: {
                    prop3.setValue(new CIMValue((Object)"Disk Drive"));
                    break;
                }
                case 5: {
                    prop3.setValue(new CIMValue((Object)"Location"));
                    break;
                }
                case 6: {
                    prop3.setValue(new CIMValue((Object)"LUN Creation"));
                    break;
                }
                case 7: {
                    prop3.setValue(new CIMValue((Object)"Software"));
                    break;
                }
                case 8: {
                    prop3.setValue(new CIMValue((Object)"Pool Manipulation Capabilities and Settings"));
                    break;
                }
                case 9: {
                    prop3.setValue(new CIMValue((Object)"Copy Services"));
                    break;
                }
                case 10: {
                    prop3.setValue(new CIMValue((Object)"Extent Mapping"));
                }
            }
            CIMProperty prop4 = new CIMProperty("OtherRegisteredOrganization");
            prop4.setName("OtherRegisteredOrganization");
            prop4.setType(CIMDataType.getPredefinedType((int)8));
            prop4.setValue(new CIMValue((Object)"SNIA"));
            CIMProperty prop5 = new CIMProperty("RegisteredName");
            prop5.setName("RegisteredName");
            prop5.setType(CIMDataType.getPredefinedType((int)8));
            switch (idx) {
                case 1: {
                    prop5.setValue(new CIMValue((Object)"Extra Capacity Set"));
                    break;
                }
                case 2: {
                    prop5.setValue(new CIMValue((Object)"Access Points"));
                    break;
                }
                case 3: {
                    prop5.setValue(new CIMValue((Object)"LUN Mapping and Masking"));
                    break;
                }
                case 4: {
                    prop5.setValue(new CIMValue((Object)"Disk Drive"));
                    break;
                }
                case 5: {
                    prop5.setValue(new CIMValue((Object)"Location"));
                    break;
                }
                case 6: {
                    prop5.setValue(new CIMValue((Object)"LUN Creation"));
                    break;
                }
                case 7: {
                    prop5.setValue(new CIMValue((Object)"Software"));
                    break;
                }
                case 8: {
                    prop5.setValue(new CIMValue((Object)"Pool Manipulation Capabilities and Settings"));
                    break;
                }
                case 9: {
                    prop5.setValue(new CIMValue((Object)"Copy Services"));
                    break;
                }
                case 10: {
                    prop5.setValue(new CIMValue((Object)"Extent Mapping"));
                }
            }
            CIMProperty prop6 = new CIMProperty("RegisteredOrganization");
            prop6.setName("RegisteredOrganization");
            prop6.setType(CIMDataType.getPredefinedType((int)2));
            UnsignedInt16 prop6Val = new UnsignedInt16(11);
            prop6.setValue(new CIMValue((Object)prop6Val));
            CIMProperty prop7 = new CIMProperty("RegisteredVersion");
            prop7.setName("RegisteredVersion");
            prop7.setType(CIMDataType.getPredefinedType((int)8));
            prop7.setValue(new CIMValue((Object)"1.0.3"));
            v.add(prop1);
            v.add(prop2);
            v.add(prop3);
            v.add(prop4);
            v.add(prop5);
            v.add(prop6);
            v.add(prop7);
            cimInstances[idx].setProperties(v);
        }
        return cimInstances;
    }

    private CIMObjectPath getObjectPath(CIMInstance instance) throws Exception {
        CIMObjectPath cimOP = null;
        if (instance != null) {
            cimOP = instance.getObjectPath();
            cimOP.setNameSpace("/root/ibm");
        }
        return cimOP;
    }

    public static void main(String[] argv) {
        try {
            DS8KCIMOMDataGenerator test = new DS8KCIMOMDataGenerator();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        try {
            Class.forName(SimulatorConfig.dbDriverName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

