/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.simulator.cimom.common;

import java.util.ArrayList;
import java.util.Enumeration;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.client.CIMClient;
import org.eclipse.aperi.simulator.cimom.common.CIMOM;
import org.eclipse.aperi.simulator.cimom.common.SimulatorUtility;
import org.eclipse.aperi.simulator.cimom.common.base.BaseMOFGenerator;
import org.eclipse.aperi.simulator.cimom.common.base.UtilitiesFactory;

public class GenericMOFGenerator {
    private BaseMOFGenerator mofGenerator;
    private String host;
    private String namespace;
    private String username;
    private String password;
    private ArrayList namespaceList;

    public GenericMOFGenerator(String host, String namespace, String username, String password, ArrayList namespaces) {
        this.host = host;
        this.namespace = namespace;
        this.username = username;
        this.password = password;
        this.namespaceList = namespaces;
    }

    public void startMOFGenerator(String filePath) {
        int type = this.getCIMOMType();
        ArrayList prefixClasses = null;
        prefixClasses = type == 3 ? SimulatorUtility.findSBLIMPrefixClasses(this.host, this.username, this.password, this.namespaceList) : SimulatorUtility.findPrefixClasses(this.host, this.username, this.password, this.namespaceList);
        try {
            CIMOM cimom = new CIMOM(this.host, this.username, this.password, this.namespace, null, type == 3 ? "Pegasus CIMOM" : "Sun Java WBEM CIMOM", prefixClasses);
            this.mofGenerator = UtilitiesFactory.getMOFGenerator(cimom);
            this.mofGenerator.namespaceList = this.namespaceList;
            this.mofGenerator.generateMOFData(filePath);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private int getCIMOMType() {
        int retVal = 3;
        try {
            CIMInstance element;
            CIMClient cimClient = SimulatorUtility.createCimClient(this.host, this.username, this.password, this.namespace);
            CIMObjectPath objectPath = new CIMObjectPath();
            objectPath.setNameSpace(this.namespace);
            objectPath.setObjectName("CIM_RegisteredProfile");
            Enumeration enumeration = cimClient.enumerateInstances(objectPath, true, false, false, false);
            while (enumeration.hasMoreElements()) {
                element = (CIMInstance)enumeration.nextElement();
                element.getKeys();
            }
            enumeration = cimClient.associators(objectPath);
            while (enumeration.hasMoreElements()) {
                element = (CIMClass)enumeration.nextElement();
                element.getKeys();
            }
        }
        catch (CIMException e) {
            e.printStackTrace();
            retVal = 1;
        }
        return retVal;
    }

    public static void main(String[] args) {
    }
}

