/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.simulator.cimom.common;

import java.util.ArrayList;
import java.util.Enumeration;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.client.CIMClient;
import org.eclipse.aperi.simulator.SimulatorException;
import org.eclipse.aperi.simulator.cimom.common.CIMOM;
import org.eclipse.aperi.simulator.cimom.common.SimulatorUtility;
import org.eclipse.aperi.simulator.cimom.common.base.BaseSnapshotMaker;
import org.eclipse.aperi.simulator.cimom.common.base.UtilitiesFactory;

public class GenericSnapshotmaker {
    private BaseSnapshotMaker snapshotMaker;
    private String host;
    private String namespace;
    private String username;
    private String password;
    private ArrayList namespacesToSnapshot;

    public GenericSnapshotmaker(String host, String namespace, String username, String password, ArrayList namespaceList) {
        this.host = host;
        this.namespace = namespace;
        this.username = username;
        this.password = password;
        this.namespacesToSnapshot = namespaceList;
    }

    public void run() {
    }

    public void startSnapshotMaker() {
        int type = this.getCIMOMType();
        ArrayList prefixClasses = null;
        prefixClasses = type == 1 ? SimulatorUtility.findPrefixClasses(this.host, this.username, this.password, this.namespacesToSnapshot) : SimulatorUtility.findSBLIMPrefixClasses(this.host, this.username, this.password, this.namespacesToSnapshot);
        System.out.println("[GENERIC SNAPSHOT MAKER]:TYPE = " + type);
        System.out.println("[GENERIC SNAPSHOT MAKER]:CLASS_PREFIXES = " + prefixClasses);
        try {
            CIMOM cimom = new CIMOM(this.host, this.username, this.password, this.namespace, null, type == 1 ? "Sun Java WBEM CIMOM" : "Pegasus CIMOM", prefixClasses);
            this.snapshotMaker = UtilitiesFactory.getSnapshotMaker(cimom);
            this.snapshotMaker.namespacesToSnapshot = this.namespacesToSnapshot;
            this.snapshotMaker.start();
            try {
                this.snapshotMaker.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        catch (SimulatorException e) {
            e.printStackTrace();
        }
    }

    private int getCIMOMType() {
        int retVal = 1;
        try {
            CIMInstance element;
            CIMClient cimClient = SimulatorUtility.createCimClient(this.host, this.username, this.password, this.namespace);
            CIMObjectPath objectPath = new CIMObjectPath();
            objectPath.setNameSpace(this.namespace);
            objectPath.setObjectName("CIM_RegisteredProfile");
            Enumeration enumeration = cimClient.enumerateInstances(objectPath, true, false, false, false);
            while (enumeration.hasMoreElements()) {
                element = (CIMInstance)enumeration.nextElement();
                element.getKeys();
            }
            enumeration = cimClient.associators(objectPath);
            while (enumeration.hasMoreElements()) {
                element = (CIMClass)enumeration.nextElement();
                element.getKeys();
            }
        }
        catch (CIMException e) {
            e.printStackTrace();
            retVal = 3;
        }
        return retVal;
    }
}

