/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.simulator.cimom.common;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMNameSpace;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMValue;
import javax.wbem.client.CIMClient;
import javax.wbem.client.PasswordCredential;
import org.sblim.wbem.cim.CIMProperty;
import org.sblim.wbem.client.UserPrincipal;

public final class SimulatorUtility {
    private static final String[] PREFIX_CLASSES = new String[]{"CIM_RegisteredProfile", "CIM_ObjectManager", "CIM_Component"};

    public static boolean equalsCIMObjectPath(CIMObjectPath objectPath1, CIMObjectPath objectPath2) throws CIMException {
        Vector srcKeys;
        String targetOPNamespace;
        String srcOPNamespace;
        boolean result = false;
        if (objectPath1 != null && objectPath2 != null && (srcOPNamespace = SimulatorUtility.fixNamespaceSlashIssue(objectPath1.getNameSpace())).equals(targetOPNamespace = SimulatorUtility.fixNamespaceSlashIssue(objectPath2.getNameSpace())) && (srcKeys = objectPath1.getKeys()).size() == objectPath2.getKeys().size()) {
            javax.wbem.cim.CIMProperty srcProp;
            javax.wbem.cim.CIMProperty dstProp;
            int propEqCnt = 0;
            for (int idx = 0; idx < srcKeys.size() && (dstProp = objectPath2.getKey((srcProp = (javax.wbem.cim.CIMProperty)srcKeys.elementAt(idx)).getName())) != null && srcProp.equals((Object)dstProp); ++idx) {
                CIMValue srcPropVal = srcProp.getValue();
                CIMValue dstPropVal = dstProp.getValue();
                if (srcPropVal == null || dstPropVal == null || !srcPropVal.equals((Object)dstPropVal)) continue;
                ++propEqCnt;
            }
            if (propEqCnt == srcKeys.size()) {
                result = true;
            }
        }
        return result;
    }

    public static boolean equalsCIMObjectPath(org.sblim.wbem.cim.CIMObjectPath objectPath1, org.sblim.wbem.cim.CIMObjectPath objectPath2) throws CIMException {
        Vector srcKeys;
        String targetOPNamespace;
        String srcOPNamespace;
        boolean result = false;
        if (objectPath1 != null && objectPath2 != null && (srcOPNamespace = SimulatorUtility.fixNamespaceSlashIssue(objectPath1.getNameSpace())).equals(targetOPNamespace = SimulatorUtility.fixNamespaceSlashIssue(objectPath2.getNameSpace())) && (srcKeys = objectPath1.getKeys()).size() == objectPath2.getKeys().size()) {
            CIMProperty srcProp;
            CIMProperty dstProp;
            int propEqCnt = 0;
            for (int idx = 0; idx < srcKeys.size() && (dstProp = objectPath2.getKey((srcProp = (CIMProperty)srcKeys.elementAt(idx)).getName())) != null && srcProp.equals((Object)dstProp); ++idx) {
                org.sblim.wbem.cim.CIMValue srcPropVal = srcProp.getValue();
                org.sblim.wbem.cim.CIMValue dstPropVal = dstProp.getValue();
                if (srcPropVal == null || dstPropVal == null || !srcPropVal.equals((Object)dstPropVal)) continue;
                ++propEqCnt;
            }
            if (propEqCnt == srcKeys.size()) {
                result = true;
            }
        }
        return result;
    }

    public static String fixNamespaceSlashIssue(String namespace) {
        String modifiedNamespace = namespace;
        try {
            if (namespace != null && !namespace.startsWith("/")) {
                modifiedNamespace = "/" + namespace;
            }
        }
        catch (Exception e) {
            return namespace;
        }
        modifiedNamespace = modifiedNamespace.toLowerCase();
        return modifiedNamespace;
    }

    public static CIMObjectPath getResultOP(Vector cimProps, int indexToIgnore) throws Exception {
        CIMObjectPath resultOP = null;
        for (int idx = 0; idx < cimProps.size(); ++idx) {
            javax.wbem.cim.CIMProperty assocOPFromDBProp;
            if (idx == indexToIgnore || (assocOPFromDBProp = (javax.wbem.cim.CIMProperty)cimProps.elementAt(idx)).getType().getType() != 28) continue;
            resultOP = (CIMObjectPath)assocOPFromDBProp.getValue().getValue();
        }
        return resultOP;
    }

    public static ArrayList findPrefixClasses(String host, String username, String password, List namespaceList) {
        ArrayList<String> prefixList = new ArrayList<String>();
        try {
            Iterator iter = namespaceList.iterator();
            while (iter.hasNext()) {
                String name = (String)iter.next();
                CIMObjectPath objectPath = new CIMObjectPath();
                CIMClient cimClient = SimulatorUtility.createCimClient(host, username, password, name);
                for (int i = 0; i < PREFIX_CLASSES.length; ++i) {
                    objectPath.setObjectName(PREFIX_CLASSES[i]);
                    Enumeration classNames = cimClient.enumerateClassNames(objectPath);
                    while (classNames.hasMoreElements()) {
                        String prefix;
                        CIMObjectPath op = (CIMObjectPath)classNames.nextElement();
                        String objectName = op.getObjectName();
                        if (objectName.startsWith("CIM") || prefixList.contains(prefix = objectName.substring(0, objectName.indexOf(95)))) continue;
                        prefixList.add(prefix);
                    }
                }
                cimClient.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return prefixList;
    }

    public static ArrayList findSBLIMPrefixClasses(String host, String username, String password, List namespaceList) {
        ArrayList<String> prefixList = new ArrayList<String>();
        try {
            Iterator iter = namespaceList.iterator();
            org.sblim.wbem.cim.CIMObjectPath objectPath = new org.sblim.wbem.cim.CIMObjectPath();
            while (iter.hasNext()) {
                String name = (String)iter.next();
                org.sblim.wbem.client.CIMClient cimClient = SimulatorUtility.createSBLIMCimClient(host, username, password, name);
                for (int i = 0; i < PREFIX_CLASSES.length; ++i) {
                    objectPath.setObjectName(PREFIX_CLASSES[i]);
                    try {
                        Enumeration classNames = cimClient.enumerateClassNames(objectPath);
                        while (classNames.hasMoreElements()) {
                            String prefix;
                            org.sblim.wbem.cim.CIMObjectPath op = (org.sblim.wbem.cim.CIMObjectPath)classNames.nextElement();
                            String objectName = op.getObjectName();
                            if (objectName.startsWith("CIM") || prefixList.contains(prefix = objectName.substring(0, objectName.indexOf(95)))) continue;
                            prefixList.add(prefix);
                        }
                        continue;
                    }
                    catch (Exception e) {
                        System.out.println(e.getMessage() + " " + name);
                        break;
                    }
                }
                cimClient.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return prefixList;
    }

    public static CIMClient createCimClient(String host, String username, String password, String nameSpace) {
        CIMClient cimClient = null;
        try {
            CIMNameSpace ns = new CIMNameSpace(host, nameSpace);
            javax.wbem.client.UserPrincipal userPrincipal = new javax.wbem.client.UserPrincipal(username);
            PasswordCredential passwordCredential = new PasswordCredential(password);
            cimClient = new CIMClient(ns, (Principal)userPrincipal, (Object)passwordCredential);
        }
        catch (CIMException e) {
            e.printStackTrace();
        }
        return cimClient;
    }

    public static org.sblim.wbem.client.CIMClient createSBLIMCimClient(String host, String username, String password, String nameSpace) {
        org.sblim.wbem.client.CIMClient cimClient = null;
        try {
            org.sblim.wbem.cim.CIMNameSpace ns = new org.sblim.wbem.cim.CIMNameSpace(host, nameSpace);
            UserPrincipal userPrincipal = new UserPrincipal(username);
            org.sblim.wbem.client.PasswordCredential passwordCredential = new org.sblim.wbem.client.PasswordCredential(password.toCharArray());
            cimClient = new org.sblim.wbem.client.CIMClient(ns, (Principal)userPrincipal, (Object)passwordCredential);
        }
        catch (org.sblim.wbem.cim.CIMException e) {
            e.printStackTrace();
        }
        return cimClient;
    }
}

