/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.simulator.cimom.sblim;

import java.io.InputStream;
import java.io.ObjectInputStream;
import java.security.Principal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import org.eclipse.aperi.simulator.SimulatorException;
import org.eclipse.aperi.simulator.cimom.common.CIMConverter;
import org.eclipse.aperi.simulator.cimom.common.CIMOM;
import org.eclipse.aperi.simulator.cimom.common.SimulatorUtility;
import org.eclipse.aperi.simulator.cimom.common.base.BaseSnapshotMaker;
import org.eclipse.aperi.simulator.cimom.sblim.util.DiscoveryUtil;
import org.eclipse.aperi.simulator.cimom.sunwbem.util.CIMDataBLOB;
import org.sblim.wbem.cim.CIMClass;
import org.sblim.wbem.cim.CIMInstance;
import org.sblim.wbem.cim.CIMNameSpace;
import org.sblim.wbem.client.CIMClient;
import org.sblim.wbem.client.PasswordCredential;
import org.sblim.wbem.client.UserPrincipal;

public class SnapshotMakerWithAssociation
extends BaseSnapshotMaker {
    private CIMClient cimClient;
    private CIMNameSpace cimNamespace;
    private UserPrincipal principal;
    private PasswordCredential credential;
    private PreparedStatement psEnumInstanceNamesWithString;
    private PreparedStatement psEnumInstanceNamesWithID;
    private PreparedStatement psCimDataInsert;
    private ArrayList classListAssoc = new ArrayList();

    public SnapshotMakerWithAssociation(CIMOM cimomDetails) throws SimulatorException {
        super(cimomDetails);
        this.prepareAllStatements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        System.out.println("Start Snapshot");
        try {
            String url = this.cimom.getServiceURL();
            String user = this.cimom.getUserID();
            String password = this.cimom.getPassword();
            String namespace = this.cimom.getNamespace();
            if (url != null && namespace != null) {
                try {
                    this.cimNamespace = new CIMNameSpace(url, namespace);
                    if (user != null) {
                        this.principal = new UserPrincipal(user);
                    }
                    if (password != null) {
                        this.credential = new PasswordCredential(password.toCharArray());
                    }
                    this.cimClient = new CIMClient(this.cimNamespace, (Principal)this.principal, (Object)this.credential);
                }
                catch (Exception e) {
                    System.out.println("Unable To Connect to CIMOM [" + url + "]" + e.getMessage());
                }
            } else {
                System.out.println("Given CIMOM URL AND/OR Namespace is NULL");
            }
            namespace = SimulatorUtility.fixNamespaceSlashIssue(namespace);
            this.insert_CIMOM_INFO(this.cimom.getCimomVendorType(), this.cimom.getCimomVendor(), url, namespace, user, password);
            int cimomInfoMaxCnt = this.getMaxID("SIM.CIMOM_INFO");
            ArrayList namespaces = new ArrayList();
            namespaces.add(namespace);
            namespaces = this.namespacesToSnapshot == null ? DiscoveryUtil.getNamespaces(this.cimClient, namespaces, this.cimom.getCimomType()) : this.namespacesToSnapshot;
            for (int idx = 0; idx < namespaces.size(); ++idx) {
                String aNamespace = (String)namespaces.get(idx);
                aNamespace = SimulatorUtility.fixNamespaceSlashIssue(aNamespace);
                this.insert_NS_INFO(cimomInfoMaxCnt, aNamespace);
                int nsInfoMaxCnt = this.getMaxID("SIM.NS_INFO");
                this.snapshotClasses(aNamespace, nsInfoMaxCnt);
            }
            this.buildAssociationIndexes();
            if (this.cimClient != null) {
                this.cimClient.close();
            }
            this.cimClient = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (this.cimClient != null) {
                    this.cimClient.close();
                }
                if (this.con != null) {
                    this.con.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.cimClient = null;
            this.con = null;
        }
    }

    private synchronized void insert_CIM_DATA(int cimClassCnt, CIMInstance instance) throws Exception {
        javax.wbem.cim.CIMInstance sunWBEMCIMInstance = CIMConverter.convertInstanceWBEMStyle(instance);
        org.sblim.wbem.cim.CIMObjectPath ibmCIMOP = instance.getObjectPath();
        CIMObjectPath sunWBEMCIMOP = CIMConverter.convertCIMOPWBEMStyle(ibmCIMOP);
        sunWBEMCIMOP.setHost(ibmCIMOP.getHost());
        sunWBEMCIMOP.setNameSpace(ibmCIMOP.getNameSpace());
        CIMDataBLOB instanceBlob = new CIMDataBLOB(sunWBEMCIMInstance);
        int instanceBlobLength = (int)instanceBlob.length();
        CIMDataBLOB opBlob = new CIMDataBLOB(sunWBEMCIMOP);
        int opBlobLength = (int)opBlob.length();
        String CIM_DATA_INSERT = "INSERT INTO SIM.CIM_DATA (CIM_CLASS_ID, CIM_OP, CIM_INST) VALUES (?, ?, ?)";
        PreparedStatement ps_cim_data_insert = this.con.prepareStatement(CIM_DATA_INSERT);
        ps_cim_data_insert.setInt(1, cimClassCnt);
        ps_cim_data_insert.setBinaryStream(2, opBlob.getBinaryStream(), opBlobLength);
        ps_cim_data_insert.setBinaryStream(3, instanceBlob.getBinaryStream(), instanceBlobLength);
        ps_cim_data_insert.executeUpdate();
        this.con.commit();
        ps_cim_data_insert.close();
    }

    protected synchronized void snapshotClasses(String namespace, int nsInfoCnt) throws Exception {
        this.cimClient = null;
        this.cimNamespace = null;
        this.cimNamespace = new CIMNameSpace(this.cimom.getServiceURL(), namespace);
        this.cimClient = new CIMClient(this.cimNamespace, (Principal)new UserPrincipal(this.cimom.getUserID()), (Object)new PasswordCredential(this.cimom.getPassword().toCharArray()));
        org.sblim.wbem.cim.CIMObjectPath path = new org.sblim.wbem.cim.CIMObjectPath();
        Enumeration en = this.cimClient.enumerateClasses(path, true, false, true, true);
        ArrayList<String> classList = new ArrayList<String>();
        while (en.hasMoreElements()) {
            CIMClass cimCls = (CIMClass)en.nextElement();
            if (!this.isClassSnapshotable(cimCls.getName())) continue;
            classList.add(cimCls.getName());
            if (!cimCls.isAssociation()) continue;
            this.classListAssoc.add(nsInfoCnt + "/" + cimCls.getName());
        }
        en = null;
        for (int idx = 0; idx < classList.size(); ++idx) {
            String classNameToGetData = (String)classList.get(idx);
            try {
                this.insert_CIM_CLASS(nsInfoCnt, classNameToGetData);
                int cimClassMaxCnt = this.getMaxID("SIM.CIM_CLASS");
                org.sblim.wbem.cim.CIMObjectPath cimOP = new org.sblim.wbem.cim.CIMObjectPath(classNameToGetData);
                Enumeration enumeration = this.cimClient.enumerateInstances(cimOP, true, false, false, true, null);
                while (enumeration.hasMoreElements()) {
                    CIMInstance instance = (CIMInstance)enumeration.nextElement();
                    this.insert_CIM_DATA(cimClassMaxCnt, instance);
                    System.out.println("NS = [" + namespace + "], CLS = [" + (String)classList.get(idx) + "]");
                }
                enumeration = null;
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.cimClient.close();
        this.cimClient = null;
    }

    private void buildAssociationIndexes() {
        for (int classIndex = 0; classIndex < this.classListAssoc.size(); ++classIndex) {
            String classNameToGetData = (String)this.classListAssoc.get(classIndex);
            int nsInfoCnt = Integer.parseInt(classNameToGetData.substring(0, classNameToGetData.indexOf("/")));
            classNameToGetData = classNameToGetData.substring(classNameToGetData.indexOf("/") + 1, classNameToGetData.length());
            try {
                this.psEnumInstanceNamesWithID.setString(1, classNameToGetData);
                this.psEnumInstanceNamesWithID.setInt(2, nsInfoCnt);
                ResultSet rs = this.psEnumInstanceNamesWithID.executeQuery();
                while (rs.next()) {
                    InputStream is = rs.getBinaryStream(1);
                    ObjectInputStream ois = new ObjectInputStream(is);
                    Object rawObj = ois.readObject();
                    CIMObjectPath assocOPFromDB = (CIMObjectPath)rawObj;
                    Vector assocOPFromDBKeys = assocOPFromDB.getKeys();
                    CIMObjectPath assocOPFromDBPropValOP = null;
                    CIMObjectPath assocOPToDBPropValOP = null;
                    for (int idx3 = 0; idx3 < assocOPFromDBKeys.size(); ++idx3) {
                        CIMProperty assocOPFromDBProp = (CIMProperty)assocOPFromDBKeys.elementAt(idx3);
                        if (assocOPFromDBProp.getType().getType() != 28 || assocOPFromDBPropValOP != null) continue;
                        assocOPFromDBPropValOP = (CIMObjectPath)assocOPFromDBProp.getValue().getValue();
                        assocOPToDBPropValOP = SimulatorUtility.getResultOP(assocOPFromDBKeys, idx3);
                        break;
                    }
                    int associationID = rs.getInt(2);
                    int fromID = this.getInstanceID(assocOPFromDBPropValOP);
                    int toID = this.getInstanceID(assocOPToDBPropValOP);
                    if (fromID == -1 || toID == -1) continue;
                    this.insert_CIM_ASSOC(associationID, fromID, toID);
                }
                rs.close();
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private boolean isClassSnapshotable(String classNameToGetData) {
        ArrayList classNamePrefixes = this.cimom.getLeafClassNamePrefixes();
        boolean classSnapshotable = false;
        for (int idx2 = 0; idx2 < classNamePrefixes.size(); ++idx2) {
            String leafClasNamePrefix = (String)classNamePrefixes.get(idx2);
            if (!classNameToGetData.startsWith(leafClasNamePrefix)) continue;
            classSnapshotable = true;
            break;
        }
        return classSnapshotable;
    }

    private void prepareAllStatements() {
        try {
            this.psEnumInstanceNamesWithString = this.con.prepareStatement("SELECT DATA.CIM_OP, DATA.ID FROM SIM.CIM_DATA DATA, SIM.CIM_CLASS CLS, SIM.NS_INFO NS WHERE DATA.CIM_CLASS_ID=CLS.ID AND CLS.NS_INFO_ID=NS.ID AND CLS.CLASS_NAME = ? AND NS.NAMESPACE=?");
            this.psEnumInstanceNamesWithID = this.con.prepareStatement("SELECT DATA.CIM_OP, DATA.ID FROM SIM.CIM_DATA DATA, SIM.CIM_CLASS CLS WHERE DATA.CIM_CLASS_ID=CLS.ID AND CLS.CLASS_NAME=? AND CLS.NS_INFO_ID=?");
            String CIM_DATA_INSERT = "INSERT INTO SIM.CIM_DATA (CIM_CLASS_ID, CIM_OP, CIM_INST) VALUES (?, ?, ?)";
            this.psCimDataInsert = this.con.prepareStatement(CIM_DATA_INSERT);
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
    }

    private int getInstanceID(CIMObjectPath assocOPPropValues) {
        int toID = -1;
        try {
            String toClassName = assocOPPropValues.getObjectName();
            String toNamespace = SimulatorUtility.fixNamespaceSlashIssue(assocOPPropValues.getNameSpace());
            this.psEnumInstanceNamesWithString.setString(1, toClassName);
            this.psEnumInstanceNamesWithString.setString(2, toNamespace);
            ResultSet rsTo = this.psEnumInstanceNamesWithString.executeQuery();
            while (rsTo.next()) {
                ObjectInputStream ois1;
                Object rawObj1;
                CIMObjectPath cimOP1;
                InputStream is1 = rsTo.getBinaryStream(1);
                if (is1 == null || !SimulatorUtility.equalsCIMObjectPath(cimOP1 = (CIMObjectPath)(rawObj1 = (ois1 = new ObjectInputStream(is1)).readObject()), assocOPPropValues)) continue;
                toID = rsTo.getInt(2);
                break;
            }
            rsTo.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return toID;
    }
}

