/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.simulator.cimom.sblim.util;

import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.aperi.simulator.cimom.common.CIMOM;
import org.eclipse.aperi.simulator.cimom.common.base.BaseMOFGenerator;
import org.eclipse.aperi.simulator.cimom.sblim.util.DiscoveryUtil;
import org.sblim.wbem.cim.CIMClass;
import org.sblim.wbem.cim.CIMDataType;
import org.sblim.wbem.cim.CIMException;
import org.sblim.wbem.cim.CIMMethod;
import org.sblim.wbem.cim.CIMNameSpace;
import org.sblim.wbem.cim.CIMObjectPath;
import org.sblim.wbem.cim.CIMParameter;
import org.sblim.wbem.cim.CIMProperty;
import org.sblim.wbem.cim.CIMQualifier;
import org.sblim.wbem.cim.CIMValue;
import org.sblim.wbem.client.CIMClient;
import org.sblim.wbem.client.PasswordCredential;
import org.sblim.wbem.client.UserPrincipal;

public class MOFGenerator
extends BaseMOFGenerator {
    private UserPrincipal principal;
    private PasswordCredential credential;
    private CIMClient cimClient;

    public MOFGenerator(CIMOM cimom) {
        super(cimom);
    }

    public void generateDataForNameSpace(String namespace, String filePath) throws Exception {
        this.cimClient = null;
        CIMNameSpace cimNamespace = new CIMNameSpace(this.cimom.getServiceURL(), namespace);
        this.cimClient = new CIMClient(cimNamespace, (Principal)this.principal, (Object)this.credential);
        CIMObjectPath path = new CIMObjectPath();
        Enumeration en = this.cimClient.enumerateClasses(path, true, false, false, true);
        ArrayList classList = new ArrayList();
        ArrayList qualifierList = new ArrayList();
        block0: while (en.hasMoreElements()) {
            CIMClass cimCls = (CIMClass)en.nextElement();
            String className = cimCls.getName();
            this.addQualifiersToList(qualifierList, cimCls.getQualifiers());
            if (classList.contains(className)) continue;
            if (this.isOnlyLeaf) {
                Iterator iter = this.cimom.getLeafClassNamePrefixes().iterator();
                while (iter.hasNext()) {
                    if (!className.startsWith((String)iter.next())) continue;
                    this.addClassWithReferences(classList, cimCls, qualifierList);
                    continue block0;
                }
                continue;
            }
            this.addClassWithReferences(classList, cimCls, qualifierList);
        }
        this.printData(namespace, filePath, classList, qualifierList);
        this.cimClient.close();
        this.cimClient = null;
    }

    private void printData(String namespace, String filePath, List classList, List qualifierList) throws IOException {
        CIMClass cimCls = new CIMClass();
        String fileName = this.createNewWriter(namespace, filePath);
        System.out.println("File created for namespace : " + namespace + " is : " + fileName);
        this.writeDataToFile("#pragma namespace (\"" + namespace + "\")");
        this.writeDataToFile("#pragma Locale (\"en-US\")");
        this.writeDataToFile("\n");
        this.writeQualifiers();
        CIMObjectPath op = null;
        int length = classList.size();
        for (int idx = 0; idx < length; ++idx) {
            try {
                op = new CIMObjectPath((String)classList.get(idx));
                cimCls = this.cimClient.getClass(op);
                this.doAdditionalChanges(cimCls);
                this.writeDataToFile("// " + cimCls.getName());
                this.writeDataToFile(cimCls.toString());
                continue;
            }
            catch (Exception e) {
                System.out.println("Error for class " + op);
                this.writeDataToFile("// " + cimCls.getName());
                this.writeDataToFile(cimCls.toString());
                System.out.println(e.getMessage());
            }
        }
        this.closeFile();
    }

    private void doAdditionalChanges(CIMClass cimCls) {
        String className = cimCls.getName();
        Vector v = cimCls.getQualifiers();
        Iterator iter = v.iterator();
        if (cimCls.getQualifier("Provider") != null) {
            cimCls.removeQualifier("Provider");
        }
        Iterator tempIter = this.cimom.getLeafClassNamePrefixes().iterator();
        while (tempIter.hasNext()) {
            if (!className.startsWith((String)tempIter.next())) continue;
            CIMQualifier tempQualifier = new CIMQualifier("Provider");
            tempQualifier.setValue(new CIMValue((Object)"java:org.eclipse.aperi.simulator.cimom.sunwbem.provider.Provider", new CIMDataType(8)));
            cimCls.addQualifier(tempQualifier);
        }
        if (this.isEmptyClass(cimCls)) {
            CIMClass tmpCIMClass = new CIMClass();
            tmpCIMClass.setName(cimCls.getName());
            tmpCIMClass.setObjectPath(cimCls.getObjectPath());
            tmpCIMClass.setProperties(cimCls.getProperties());
            tmpCIMClass.setQualifiers(cimCls.getQualifiers());
            tmpCIMClass.setIsAssociation(cimCls.isAssociation());
            tmpCIMClass.setSuperClass(cimCls.getSuperClass());
            Vector methodVector = cimCls.getAllMethods();
            for (int idxMethod = 0; idxMethod < methodVector.size(); ++idxMethod) {
                CIMMethod method = (CIMMethod)methodVector.get(idxMethod);
                Vector parameterVector = method.getParameters();
                for (int idx = 0; idx < parameterVector.size(); ++idx) {
                    CIMParameter tmpParameter = (CIMParameter)parameterVector.get(idx);
                    if (tmpParameter.getType().isArrayType() || tmpParameter.getType().toString().contains("[]")) {
                        if (tmpParameter.getType().toString().contains("ref")) {
                            System.out.println(tmpParameter.toString());
                            CIMDataType cDT = new CIMDataType(tmpParameter.getType().toString().replace("[] ref", ""));
                            tmpParameter.setType(cDT);
                        } else {
                            tmpParameter.setType(new CIMDataType(CIMDataType.findSimpleType((int)tmpParameter.getType().getType())));
                        }
                        tmpParameter.setName(tmpParameter.getName() + "[]");
                    }
                    if (method.getQualifier("Override") == null) continue;
                    if (this.superClassContainsMethod(method, cimCls, this.cimClient)) {
                        method.removeQualifier("Override");
                        CIMQualifier temp = new CIMQualifier("Override");
                        temp.setValue(new CIMValue((Object)method.getName(), new CIMDataType(8)));
                        method.addQualifier(temp);
                        continue;
                    }
                    method.removeQualifier("Override");
                }
                tmpCIMClass.addMethod(method);
            }
            cimCls.equals((Object)tmpCIMClass);
            Vector propertiesVector = cimCls.getAllProperties();
            iter = propertiesVector.iterator();
            while (iter.hasNext()) {
                CIMQualifier temp;
                CIMProperty property = (CIMProperty)iter.next();
                if (property.getType().getStringType().equalsIgnoreCase("datetime")) {
                    property.setValue(null);
                } else if (property.isReference()) {
                    property.setValue(null);
                }
                if (cimCls.getSuperClass() == null) continue;
                if (property.isKey()) {
                    if (!this.superClassContainsKeyProperty(property, cimCls, this.cimClient)) continue;
                    if (property.getQualifier("Override") != null) {
                        property.removeQualifier("Override");
                    }
                    temp = new CIMQualifier("Override");
                    temp.setValue(new CIMValue((Object)property.getName(), new CIMDataType(8)));
                    property.addQualifier(temp);
                    continue;
                }
                if (property.getQualifier("Override") == null) continue;
                if (this.superClassContainsProperty(property, cimCls, this.cimClient)) {
                    property.removeQualifier("Override");
                    temp = new CIMQualifier("Override");
                    temp.setValue(new CIMValue((Object)property.getName(), new CIMDataType(8)));
                    property.addQualifier(temp);
                    continue;
                }
                property.removeQualifier("Override");
            }
            if (cimCls.getName().equalsIgnoreCase("IBMTSDS_StorageConfigurationService")) {
                cimCls.getProperty("SystemName").removeQualifier("Propogated");
            }
        } else {
            CIMQualifier qualifier = new CIMQualifier("Abstract");
            qualifier.setValue(CIMValue.TRUE);
            cimCls.addQualifier(qualifier);
        }
    }

    private void addClassWithReferences(List classList, CIMClass cimCls, List qualifierList) throws CIMException {
        String className;
        String superClass = cimCls.getSuperClass();
        if (superClass != null && !superClass.trim().equals("") && !classList.contains(superClass)) {
            CIMObjectPath op = new CIMObjectPath(superClass);
            this.addClassWithReferences(classList, this.cimClient.getClass(op), qualifierList);
        }
        Vector properties = cimCls.getAllProperties();
        Iterator iterator = properties.iterator();
        while (iterator.hasNext()) {
            CIMProperty property = (CIMProperty)iterator.next();
            this.addQualifiersToList(qualifierList, property.getQualifiers());
            if (!property.isReference() || classList.contains(className = property.getType().getRefClassName())) continue;
            try {
                this.addClassWithReferences(classList, this.cimClient.getClass(new CIMObjectPath(className)), qualifierList);
            }
            catch (Exception e) {
                classList.add(cimCls.getName());
            }
        }
        this.addClassQualifier(cimCls, qualifierList);
        if (this.isOnlyLeaf) {
            Iterator iter = this.cimom.getLeafClassNamePrefixes().iterator();
            className = cimCls.getName();
            while (iter.hasNext()) {
                if (!className.startsWith((String)iter.next())) continue;
                classList.add(className);
                break;
            }
        } else {
            classList.add(cimCls.getName());
        }
    }

    private void addClassQualifier(CIMClass cimCls, List qualifierList) {
        this.addQualifiersToList(qualifierList, cimCls.getQualifiers());
        Vector methods = cimCls.getAllMethods();
        Iterator iter = methods.iterator();
        while (iter.hasNext()) {
            CIMMethod cimMethod = (CIMMethod)iter.next();
            this.addMethodQualifier(cimMethod, qualifierList);
        }
    }

    private void addMethodQualifier(CIMMethod cimMethod, List qualifierList) {
        this.addQualifiersToList(qualifierList, cimMethod.getQualifiers());
        Vector parameters = cimMethod.getParameters();
        Iterator iter = parameters.iterator();
        while (iter.hasNext()) {
            CIMParameter parameter = (CIMParameter)iter.next();
            this.addQualifiersToList(qualifierList, parameter.getQualifiers());
        }
    }

    private void addQualifiersToList(List qualifierList, Vector qualifiers) {
        Iterator iter = qualifiers.iterator();
        while (iter.hasNext()) {
            CIMQualifier qualifier = (CIMQualifier)iter.next();
            if (qualifierList.contains(qualifier.getName())) continue;
            qualifierList.add(qualifier.getName());
        }
    }

    protected void createCIMClient(String url, String user, String password, String namespace) {
        try {
            if (url != null && namespace != null) {
                CIMNameSpace cimNamespace = new CIMNameSpace(url, namespace);
                if (user != null) {
                    this.principal = new UserPrincipal(user);
                }
                if (password != null) {
                    this.credential = new PasswordCredential(password.toCharArray());
                }
                this.cimClient = new CIMClient(cimNamespace, (Principal)this.principal, (Object)this.credential);
            } else {
                System.err.println("Given CIMOM URL AND/OR Namespace is NULL");
            }
        }
        catch (CIMException e) {
            e.printStackTrace();
        }
    }

    protected void generateData(String filePath, ArrayList namespaces) throws Exception {
        if (this.namespaceList == null) {
            DiscoveryUtil.getNamespaces(this.cimClient, namespaces, this.cimom.getCimomType());
        } else {
            namespaces = this.namespaceList;
        }
        for (int idx = 0; idx < namespaces.size(); ++idx) {
            this.generateDataForNameSpace((String)namespaces.get(idx), filePath);
        }
        if (this.cimClient != null) {
            try {
                this.cimClient.close();
            }
            catch (CIMException e) {
                e.printStackTrace();
            }
        }
        this.cimClient = null;
    }

    protected boolean superClassContainsKeyProperty(CIMProperty prop, CIMClass class1, CIMClient client) {
        while (class1.getSuperClass() != null) {
            if ((class1 = client.getClass(new CIMObjectPath(class1.getSuperClass()))).getProperty(prop.getName()) == null || !class1.getProperty(prop.getName()).isKey()) continue;
            return true;
        }
        return false;
    }

    protected boolean superClassContainsMethod(CIMMethod method, CIMClass class1, CIMClient client) {
        while (class1.getSuperClass() != null) {
            if ((class1 = client.getClass(new CIMObjectPath(class1.getSuperClass()))).getMethod(method.getName()) == null) continue;
            return true;
        }
        return false;
    }

    protected boolean superClassContainsProperty(CIMProperty prop, CIMClass class1, CIMClient client) {
        while (class1.getSuperClass() != null) {
            if ((class1 = client.getClass(new CIMObjectPath(class1.getSuperClass()))).getProperty(prop.getName()) == null) continue;
            return true;
        }
        return false;
    }

    protected boolean isEmptyClass(CIMClass cimCls) {
        Iterator propiterator = cimCls.getAllProperties().iterator();
        Iterator methoditerator = cimCls.getAllMethods().iterator();
        return propiterator.hasNext() || methoditerator.hasNext();
    }
}

