/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.simulator.dbutil;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.logging.FileHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import javax.swing.JOptionPane;

public class CreateDatabase {
    private static final String DB_CREATE_LOG_FILE = "DBCreation.log";
    public static final String DB2_CREATE_DB_COMMAND = "C:\\Program Files\\IBM\\SQLLIB\\bin\\db2cmd.exe -c -w -i db2 create database ";
    public static final String DB2_DROP_DB_COMMAND = "C:\\Program Files\\IBM\\SQLLIB\\bin\\db2cmd.exe -c -w -i db2 drop database ";
    public static final String DB2_CONNECT_DB_COMMAND = "C:\\Program Files\\IBM\\SQLLIB\\bin\\db2cmd.exe db2 CONNECT TO ";
    public static final String RUN_DDL_COMMAND = "C:\\Program Files\\IBM\\SQLLIB\\bin\\db2batch.exe -d {0} -a {1}/{2} -f {3}";
    private static final String SIM_DDL_FILE = "SIM.ddl";
    private String dbName;
    private String dbUsername;
    private String dbPassword;
    private static Logger logger = Logger.getLogger(CreateDatabase.class.getName());

    public CreateDatabase(String dbName, String dbUsername, String dbPassword) {
        this.dbName = dbName;
        this.dbUsername = dbUsername;
        this.dbPassword = dbPassword;
    }

    private int createDatabase(String dbName) {
        return this.executeCommand(DB2_CREATE_DB_COMMAND + dbName);
    }

    private int dropDatabase(String dbName) {
        return this.executeCommand(DB2_DROP_DB_COMMAND + dbName);
    }

    private int runDDLFile(String dbName, String fileName, String userName, String passwd) {
        String command = MessageFormat.format(RUN_DDL_COMMAND, dbName, userName, passwd, fileName);
        return this.executeCommand(command);
    }

    private int executeCommand(String command) {
        int retVal = -1;
        try {
            Process process = Runtime.getRuntime().exec(command);
            new NullReader(process.getInputStream(), "Output").start();
            new NullReader(process.getErrorStream(), "Error").start();
            retVal = process.waitFor();
            logger.info("The return value is : " + retVal);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return retVal;
    }

    private static void initLogger() {
        try {
            Handler[] defaultHandlers = Logger.getLogger("").getHandlers();
            for (int i = 0; i < defaultHandlers.length; ++i) {
                Logger.getLogger("").removeHandler(defaultHandlers[i]);
            }
            FileHandler handler = new FileHandler(DB_CREATE_LOG_FILE);
            handler.setFormatter(new SimpleFormatter());
            Logger.getLogger("").addHandler(handler);
            Logger.getLogger("").setLevel(Level.INFO);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void createDB() {
        CreateDatabase.initLogger();
        System.out.println("Please wait while database is being created and configured.....");
        logger.info("============ Database Creation Starts ==========");
        logger.info("Drop " + this.dbName);
        this.dropDatabase(this.dbName);
        logger.info("Create " + this.dbName);
        if (this.createDatabase(this.dbName) != 0) {
            logger.severe("Database Creation Falied! ");
            JOptionPane.showMessageDialog(null, "Database creation failed! Please check the log file!", "Failed", 0);
            System.exit(0);
        }
        logger.info("Creating tables in " + this.dbName);
        if (this.runDDLFile(this.dbName, SIM_DDL_FILE, this.dbUsername, this.dbPassword) != 0) {
            logger.severe("Error occured during Configuring database!");
            this.dropDatabase(this.dbName);
            JOptionPane.showMessageDialog(null, "Database creation failed! Please check the log file!", "Failed", 0);
            System.exit(0);
        } else {
            System.out.println("Database created Successfully...");
            logger.info("============ Database Creation Ends ==========");
        }
    }

    private class NullReader
    extends Thread {
        private InputStream stream;
        private String name;

        public NullReader(InputStream stream, String name) {
            this.stream = stream;
            this.name = name;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            StringBuffer data = null;
            String line = null;
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new InputStreamReader(this.stream));
                while (null != (line = reader.readLine())) {
                    if (data == null) {
                        data = new StringBuffer(line);
                        continue;
                    }
                    data.append(line + "\n");
                }
                if (data != null) {
                    logger.info(this.name + "\n" + data.toString());
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            finally {
                if (null != reader) {
                    try {
                        reader.close();
                    }
                    catch (IOException ex) {}
                }
            }
        }
    }
}

