/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.simulator.ui;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Properties;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import org.eclipse.aperi.simulator.ui.SimulatorPropUtility;

public class CheckPreRequisites {
    private Logger logger = Logger.getLogger(CheckPreRequisites.class.getName());

    protected boolean CheckPort(int port) {
        boolean retval = false;
        if (this.checkPortAvailablity(port)) {
            SimulatorPropUtility.getInstance().setCimomPort(Integer.toString(port));
            retval = true;
        } else {
            retval = false;
        }
        return retval;
    }

    public boolean checkJavaVersion(String version) {
        this.logger.info("Checking whether Java Version is 5.0 or greater");
        String javaversion = null;
        javaversion = System.getProperty("java.version");
        String[] versions = this.spiltVersion(javaversion.toCharArray());
        this.logger.info("Java Version Set to: " + javaversion);
        if (Integer.parseInt(versions[1]) >= Integer.parseInt(version)) {
            this.logger.info("Java version higher than JDK 5");
            return true;
        }
        this.logger.info("Java version is smaller than JDK 5");
        return false;
    }

    private String[] spiltVersion(char[] buffer) {
        String[] strSpilt = new String[buffer.length / 2];
        int j = 0;
        for (int i = 0; i < buffer.length; ++i) {
            if (buffer[i] != '.') {
                if (strSpilt[j] == null) {
                    strSpilt[j] = "" + buffer[i];
                    continue;
                }
                int n = j;
                strSpilt[n] = strSpilt[n] + buffer[i];
                continue;
            }
            ++j;
        }
        return strSpilt;
    }

    public boolean checkJavaHome(String version) {
        this.logger.info("Check whether JAVA_HOME is set");
        if (this.checkJavaVersion(version)) {
            String javaHomeEnv = null;
            try {
                Properties envProperties = this.getEnvProperties();
                javaHomeEnv = envProperties.getProperty("JAVA_HOME");
                this.logger.info("JAVA_HOME is set to " + javaHomeEnv);
            }
            catch (Exception ex) {
                this.logger.severe(ex.getMessage() + ex);
                ex.printStackTrace();
            }
            if (javaHomeEnv == null) {
                this.logger.severe("JAVA_HOME environment variable not set");
                JOptionPane.showMessageDialog(null, "The JAVA_HOME environment variable must be set to an existing copy of the Java SDK.", "JAVA_HOME Error", 0);
                System.exit(0);
            }
        } else {
            JOptionPane.showMessageDialog(null, "JAVA SDK version installed on your machine is smaller than SDK 5.0.", "Java Version Incompatible", 0);
            System.exit(0);
        }
        return true;
    }

    private boolean checkPortAvailablity(int port) {
        this.logger.info("Check port availability");
        boolean isPortFree = true;
        String server = "localhost";
        Socket socket = null;
        try {
            socket = new Socket(server, port);
            this.logger.info("Port check for " + socket.getInetAddress() + ":" + socket.getPort());
            isPortFree = false;
        }
        catch (UnknownHostException e) {
        }
        catch (IOException e) {
            this.logger.info("Port availability Successful");
        }
        if (!isPortFree) {
            try {
                socket.close();
            }
            catch (IOException e) {
                this.logger.severe(e.getMessage() + e);
                System.out.println(e);
            }
            JOptionPane.showMessageDialog(null, "Port " + port + " is currently in use.Close application that might be using that port !", "Port 5988 In Use", 0);
        }
        return isPortFree;
    }

    private Properties getEnvProperties() throws Exception {
        Properties envProps = new Properties();
        File file = File.createTempFile("temp", ".properties");
        file.deleteOnExit();
        String batFileName = this.createTempFile(file.getAbsolutePath(), "set");
        Process process = Runtime.getRuntime().exec(batFileName);
        Thread.sleep(500L);
        FileInputStream in = new FileInputStream(file.getAbsoluteFile());
        envProps.load(in);
        in.close();
        return envProps;
    }

    private String createTempFile(String absolutePath, String command) throws IOException {
        File file = File.createTempFile("temp", ".bat");
        file.deleteOnExit();
        BufferedWriter writer = new BufferedWriter(new FileWriter(file));
        writer.write(command + " > " + absolutePath);
        writer.flush();
        writer.close();
        return file.getAbsolutePath();
    }
}

