/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.simulator.ui;

import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;
import org.eclipse.aperi.simulator.cimom.DS4K.DS4KCimomDataGenerator;
import org.eclipse.aperi.simulator.cimom.DS6K.DS6K5_2CimomDataGenerator;
import org.eclipse.aperi.simulator.cimom.DS6K.DS6KCimomDataGenerator;
import org.eclipse.aperi.simulator.cimom.DS8K.DS8K5_2CimomDataGenerator;
import org.eclipse.aperi.simulator.cimom.DS8K.DS8KGenerator;
import org.eclipse.aperi.simulator.cimom.brocade.BrocadeCIMOMDataGenerator;
import org.eclipse.aperi.simulator.ui.SimulatorPropUtility;

public class ConfigDataGenerator {
    private Logger logger = Logger.getLogger(ConfigDataGenerator.class.getName());

    public void generator(String FilePath, String deviceType) {
        Object test;
        if (deviceType.equalsIgnoreCase("DS6K_5.1.0.40")) {
            this.logger.info("Generating data for DS6K_5.1.0.40");
            test = new DS6KCimomDataGenerator();
            ((DS6KCimomDataGenerator)test).generateData(FilePath);
        }
        if (deviceType.equalsIgnoreCase("DS8K_5.1.0.40")) {
            this.logger.info("Generating data for DS8K_5.1.0.40");
            test = new DS8KGenerator();
            ((DS8KGenerator)test).generateData(FilePath);
        } else if (deviceType.equalsIgnoreCase("DS4K_9.16.G0.06")) {
            this.logger.info("Generating data for DS4K_9.16.G0.06");
            test = new DS4KCimomDataGenerator();
            ((DS4KCimomDataGenerator)test).generateData(FilePath);
        } else if (deviceType.equalsIgnoreCase("Brocade_110.4.0a")) {
            this.logger.info("Generating data for Brocade_110.4.0a");
            test = new BrocadeCIMOMDataGenerator();
            try {
                ((BrocadeCIMOMDataGenerator)test).generateData();
            }
            catch (Exception e) {
                this.logger.severe("Error in Data Generatiion for Brocade: " + e);
            }
        } else if (deviceType.equalsIgnoreCase("DS6K_5.2.1.93")) {
            this.logger.info("Generating data for DS6K_5.2.1.93");
            test = new DS6K5_2CimomDataGenerator();
            ((DS6K5_2CimomDataGenerator)test).generateData(FilePath);
        } else if (deviceType.equalsIgnoreCase("DS8K_5.2.1.93")) {
            this.logger.info("Generating data for DS8K_5.2.1.93");
            test = new DS8K5_2CimomDataGenerator();
            ((DS8K5_2CimomDataGenerator)test).generateData(FilePath);
        }
    }

    public void ConfigureDBForConfiguration() {
        try {
            File temp = File.createTempFile("setupwizard", ".config");
            temp.deleteOnExit();
            SimulatorPropUtility.getInstance().saveProperties(temp);
            System.setProperty("SETUP_WIZARD_CONFIG_FILEPATH", temp.getAbsolutePath());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

