/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.simulator.ui;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.wbem.client.CIMClient;
import org.eclipse.aperi.simulator.ui.RemoteCIMClient;
import org.eclipse.aperi.simulator.ui.SwitchDBClient;
import org.eclipse.aperi.simulator.ui.TargetDeviceDBClient;

public class ConnectionUtility {
    public static String simulateOption;
    public static boolean isSwitchDBLocal;
    public static boolean isOtherDBLocal;
    public static boolean targetDeviceDBLocal;
    public static String SWITCH_TO_SWITCH;
    public static String SWITCH_TO_ARRAY;
    public static String SWITCH_TO_HOST;
    public static final String TEST_DB_CONNECTION_BUTTON_COMMAND = "TestDBConnection";
    public static final String TEST_TARGET_DB_CONNECTION_COMMAND = "TestTargetDB";
    public static final String ADD_BUTTON_COMMAND = "Add";
    public static final String REMOVE_BUTTON_COMMAND = "Remove";
    public static final String TEST_CIMOM_BUTTON_COMMAND = "TestCIMOM";
    public static String ConnectMedium;
    public static boolean isCIMOMConnected;
    public static String DB_CLIENT;
    public static String CIM_CLIENT;
    public static String SWITCH_CLIENT;
    public static Vector switchPortAvailable;
    public static Vector devicePortAvailable;
    public static Vector portConnections;
    public static List switchPortConnected;
    public static List oDevicePortConnected;
    public static boolean isSimConnection;
    public static String CIMOMHostUrl;
    public static String CIMOMPort;
    public static String CIMOMUserName;
    public static String CIMOMPassword;
    public static String CIMOMNameSpace;
    public static String CIMOMProtocol;
    public static String deviceConfig;
    public static boolean isLocal;
    public static String switchName;
    public static String deviceName;
    public static String sourceFabric;
    public static String destFabric;
    public static Vector switchnamesVector;
    public static Vector otherDevicesvector;
    public static CIMClient cimClient;
    public static boolean targetDeviceisSwitch;
    public static boolean targetDeviceisStorage;
    public static String targetDevcieType;
    public static String profileConnection;
    public static String switchDBUrl;
    public static String switchDBName;
    public static String switchDBUserid;
    public static String switchDBPassword;
    public static String switchDBType;
    public static String switchDBPort;
    public static String targetDevcieDBUrl;
    public static String targetDevcieDBName;
    public static String targetDevcieDBUserid;
    public static String targetDevcieDBPassword;
    public static String targetDeviceDBType;
    public static String targetDeviceDBPort;

    public static Vector getSwitchPorts() {
        switchPortAvailable.removeAllElements();
        SwitchDBClient.configDBForSwitch();
        switchPortAvailable = SwitchDBClient.getFreePortsForSwitch(true);
        return switchPortAvailable;
    }

    public static Vector getTargetDevicePorts() {
        devicePortAvailable.removeAllElements();
        if (profileConnection.equals(SWITCH_TO_SWITCH)) {
            devicePortAvailable = SwitchDBClient.getFreePortsForSwitch(false);
        } else if (profileConnection.equals(SWITCH_TO_ARRAY)) {
            devicePortAvailable = ConnectMedium.equals(DB_CLIENT) ? TargetDeviceDBClient.getFreePortsForSelectedDevice() : RemoteCIMClient.getFreePortsForSelectedDevice();
        }
        return devicePortAvailable;
    }

    public static void setPortConnections(Object connection) {
        portConnections.add(connection);
    }

    public static Vector getPortConnections() {
        return portConnections;
    }

    public static Vector getSwitchNames() {
        switchnamesVector = SwitchDBClient.enumerateSwitchNames();
        return switchnamesVector;
    }

    public static Vector getSwitchNames(String fabricId) {
        switchnamesVector.removeAllElements();
        Vector switchNameInfabric = (Vector)SwitchDBClient.fabricMap.get(fabricId);
        switchnamesVector.removeAllElements();
        Iterator iter = switchNameInfabric.iterator();
        while (iter.hasNext()) {
            switchnamesVector.add(iter.next());
        }
        return switchNameInfabric;
    }

    public static Vector getDeviceToConnect() {
        Vector result = new Vector();
        if (profileConnection.equals(SWITCH_TO_SWITCH)) {
            result = ConnectionUtility.getTargetSwitchNames();
        } else if (profileConnection.equals(SWITCH_TO_ARRAY)) {
            result = ConnectionUtility.getTargetStorageNames();
        } else if (profileConnection.equals(SWITCH_TO_HOST)) {
            result = ConnectionUtility.getTargetHostNames();
        }
        return result;
    }

    private static Vector getTargetSwitchNames() {
        otherDevicesvector.clear();
        otherDevicesvector.add("");
        Iterator iter = switchnamesVector.iterator();
        iter.next();
        while (iter.hasNext()) {
            otherDevicesvector.add(iter.next());
        }
        return otherDevicesvector;
    }

    private static Vector getTargetStorageNames() {
        otherDevicesvector.add("");
        Vector temp = new Vector();
        if (ConnectMedium.equals(DB_CLIENT)) {
            TargetDeviceDBClient.configDBForTargetDevice();
            temp = TargetDeviceDBClient.enumerateStorageNames();
            Iterator getNext = temp.iterator();
            while (getNext.hasNext()) {
                otherDevicesvector.add(getNext.next());
            }
        } else {
            Vector deviceName = RemoteCIMClient.enumerateTargetDevcieNames();
            Iterator deviceIterator = deviceName.iterator();
            while (deviceIterator.hasNext()) {
                otherDevicesvector.add(deviceIterator.next());
            }
        }
        return otherDevicesvector;
    }

    private static Vector getTargetHostNames() {
        otherDevicesvector.add("");
        return otherDevicesvector;
    }

    public static void connectToCIMOM() {
        RemoteCIMClient.connect(CIMOMHostUrl, CIMOMPort, CIMOMUserName, CIMOMPassword, CIMOMNameSpace, CIMOMProtocol);
        isCIMOMConnected = true;
        RemoteCIMClient.configureConnection();
    }

    public static void initDeviceConnect() {
        SwitchDBClient.configDBForSwitch();
        SwitchDBClient.getDeviceConnectData();
    }

    public static void closeConnection() {
        RemoteCIMClient.closeConnection();
    }

    public static Vector getFabricNames() {
        Vector<String> fabricNames = new Vector<String>();
        fabricNames.add("");
        Iterator iter = SwitchDBClient.fabricNames.iterator();
        while (iter.hasNext()) {
            fabricNames.add((String)iter.next());
        }
        return fabricNames;
    }

    public static void resetSwitchNames() {
        switchnamesVector.removeAllElements();
    }

    public static void resetOtherDeviceNames() {
        otherDevicesvector.removeAllElements();
    }

    static {
        SWITCH_TO_SWITCH = "SwitchToSwitch";
        SWITCH_TO_ARRAY = "SwitchToArray";
        SWITCH_TO_HOST = "SwitchToHost";
        isCIMOMConnected = false;
        DB_CLIENT = "Use Database to extract Storage Port Information";
        CIM_CLIENT = "Use CIMOM to extract Storage Port Information";
        SWITCH_CLIENT = "Use Database to extract Switch Port Information";
        switchPortAvailable = new Vector();
        devicePortAvailable = new Vector();
        portConnections = new Vector();
        switchPortConnected = new ArrayList();
        oDevicePortConnected = new ArrayList();
        isLocal = true;
        switchnamesVector = new Vector();
        otherDevicesvector = new Vector();
        targetDeviceisSwitch = false;
        targetDeviceisStorage = false;
        targetDevcieType = "DB2";
        targetDeviceDBPort = "1527";
    }
}

