/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.simulator.ui;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import javax.wbem.cim.CIMException;
import javax.wbem.client.CIMClient;
import org.eclipse.aperi.simulator.cimom.common.SimulatorUtility;
import org.eclipse.aperi.simulator.cimom.sunwbem.util.DiscoveryUtil;
import org.eclipse.aperi.simulator.ui.InputScreens;
import org.eclipse.aperi.simulator.ui.TestWbemCimomConnection;

public class SetupWizardUtility {
    protected static Properties simulatorProperties = new Properties();
    protected static final String WBEM_INSTALL_PATH = "WBEM_INSTALL_PATH";
    protected static final String CIMOM_USER_NAME = "CIMOM_USER_ID";
    protected static final String CIMOM_PASSWORD = "CIMOM_PASSWORD";
    protected static final String CIMOM_NAMESPACE = "CIMOM_NAMESPACE";
    protected static final String CIMOM_PORT = "CIMOM_PORT";
    protected static final String CIMOM_PROTOCOL = "CIMOM_PROTOCOL";
    protected static final String CIMOM_TYPE = "CIMOM_TYPE";
    protected static final String CIMOM_HOST_URL = "CIMOM_HOST_URL";
    protected static final String DEVICE_TYPE = "DEVICE_TYPE";
    protected static final String DEVICE_CATEGORY = "DEVICE_CATEGORY";
    protected static final String DB_HOST_URL = "DB_HOST_URL";
    protected static final String DB_USER_NAME = "DB_USER_NAME";
    protected static final String DB_PASSWORD = "DB_PASSWORD";
    protected static final String DB_NAME = "DB_NAME";
    protected static final String DB_TYPE = "DB_TYPE";
    protected static final String DERBY_SERVER_PORT = "DERBY_SERVER_PORT";
    protected static final String SIMULATION_MODE = "SIMULATION_MODE";
    protected static final String CONFIGURATION_FILE_PATH = "CONFIG_FILE_PATH";
    protected static final String SAN_SIMULATION_PROPERTY_FILE_PATH = "SAN_SIMULATION_PROPERTY_FILE_PATH";
    protected static final String SIMULATOR_PROP_FILENAME = "san_simulator_cimom.properties";
    protected static final String BACKUP_DB_PATH = "BACK_UP_PATH";
    protected static final String SNAPSHOT_SIMULATION_TYPE = "SNAPSHOT_SIMULATION_MODE";
    private static final String LOGGER_CONF_FILEPATH = "resources" + File.separator + "Logger.properties";
    protected static final String BROCADE_110_4_0 = "Brocade_110.4.0";
    protected static final String BROCADE_110_4_0A = "Brocade_110.4.0a";
    protected static final String SNAPSHOT_SIMULAION = "Snapshot-based";
    protected static final String CONFIGUARTION_SIMULATION = "Configuaration-based";
    protected static final String CISCO = "Cisco (Not Supported)";
    protected static final String MCDATA = "McData (Not Supported)";
    protected static final String QLOGIC = "QLogic (Not Supported)";
    protected static final String DS4K = "DS4K_9.16.G0.06";
    protected static final String DS6K = "DS6K_5.1.0.40";
    protected static final String DS8K = "DS8K_5.1.0.40";
    protected static final String DS6K5_2 = "DS6K_5.2.1.93";
    protected static final String DS8K5_2 = "DS8K_5.2.1.93";
    protected static final String IBM_AIX = "IBM AIX(Not Supported)";
    protected static final String Linux = "Linux(Not Supported)";
    protected static final String MICOSOFT_WINDOWS = "Microsoft Windows(Not Supported)";
    protected static final String TAPE = "IBM Tape Library";
    protected static final String iSCSI = "iSCSi Device(Not Supported)";
    protected static final String SWITCH_DEVCIE = "Switch";
    protected static final String STORAGE_DEVICE = "Storage";
    protected static final String SERVER_DEVICE = "Server";
    protected static final String OTHER_DEVCIE = "Others";
    protected static final String SETUP_MODE = "SETUP_MODE";
    protected static final String CIMOM_INSTALLED_DIRECTORY_VALUE = "DIRECTORY_LOCATION_TO_INSTALL_CIMOM";
    protected static final String DIRECTORY_LOCATION_TO_INSTALL_CIMOM_VALUE = "DIRECTORY_LOCATION_TO_INSTALL_CIMOM";
    protected static final String LOCATION_TO_SAVE_MOF_FILE = "LOCATION_TO_SAVE_MOF";
    protected static final String MOF_FILE_PATH = "MOF_FILE_PATH";
    protected static final String IS_INSTALL_CIMOM = "IS_INSTALL_CIMOM";
    protected static final String IS_COMPILE_CIMOM = "IS_COMPILE_CIMOM";
    protected static final String IS_SIMULATE_DEVICE = "IS_SIMULATE_DEVICE";
    protected static final String IS_CREATE_MOF = "IS_CREATE_MOF";
    protected static final String SNAPSHOT_MODE = "SNAPSHOT_MODE";
    protected static final String CONFIGURATION_MODE = "CONFIGURATION_MODE";
    public static String dirLocationToInstallCIMOM;
    public static String cimomInstalledLocation;
    public static String mofFilePath;
    public static boolean isInstallCIMOM;
    public static boolean isCompileMof;
    public static boolean isSimulateDevice;
    public static boolean isCustomSetup;
    protected static String strPathTosaveMofFile;
    protected static boolean isCreateMof;
    protected static boolean interactive;
    protected static final String NAMESPACES_TO_SNAPSHOT = "NAMESPACES_TO_SNAPSHOT";
    private static Vector namespaceVecor;
    private static Vector selectedNamespaceVector;
    protected static List propToDisplay;
    protected static String propFileName;
    private static Logger logger;

    protected static void loadProperties() throws IOException {
        SetupWizardUtility.loadPropToList();
        FileInputStream propFile = interactive ? new FileInputStream(propFileName) : new FileInputStream(InputScreens.SANPropPath);
        simulatorProperties.load(propFile);
        isCreateMof = new Boolean(SetupWizardUtility.getProperty(IS_CREATE_MOF)) != false;
        isInstallCIMOM = new Boolean(SetupWizardUtility.getProperty(IS_INSTALL_CIMOM)) != false;
        isCompileMof = new Boolean(SetupWizardUtility.getProperty(IS_COMPILE_CIMOM)) != false;
        isSimulateDevice = new Boolean(SetupWizardUtility.getProperty(IS_SIMULATE_DEVICE)) != false;
        propFile.close();
    }

    private static void loadPropToList() {
        propToDisplay = new ArrayList();
        propToDisplay.add(DB_NAME);
        propToDisplay.add(DB_HOST_URL);
        propToDisplay.add(DB_USER_NAME);
        propToDisplay.add(DB_TYPE);
        propToDisplay.add(CIMOM_HOST_URL);
        propToDisplay.add(CIMOM_PORT);
        propToDisplay.add(CIMOM_NAMESPACE);
        propToDisplay.add(CIMOM_USER_NAME);
        propToDisplay.add(CIMOM_PROTOCOL);
        propToDisplay.add(CONFIGURATION_FILE_PATH);
        propToDisplay.add(SAN_SIMULATION_PROPERTY_FILE_PATH);
        propToDisplay.add(SIMULATION_MODE);
    }

    protected static ArrayList pareseNamespace(String namespace) {
        char[] chNamesapce = SetupWizardUtility.getProperty(NAMESPACES_TO_SNAPSHOT).toCharArray();
        ArrayList<String> namespaceList = new ArrayList<String>();
        StringBuffer namesapce = new StringBuffer();
        for (int i = 0; i < chNamesapce.length; ++i) {
            String strNamespace;
            if (chNamesapce[i] == '[') continue;
            if (chNamesapce[i] == ']') {
                strNamespace = namesapce.toString().trim();
                strNamespace = SimulatorUtility.fixNamespaceSlashIssue(strNamespace.toLowerCase());
                namespaceList.add(strNamespace);
                continue;
            }
            if (chNamesapce[i] != ',') {
                namesapce = namesapce.append(chNamesapce[i]);
                continue;
            }
            strNamespace = namesapce.toString().trim();
            strNamespace = SimulatorUtility.fixNamespaceSlashIssue(strNamespace.toLowerCase());
            namespaceList.add(strNamespace);
            namesapce = namesapce.delete(0, namesapce.length());
        }
        return namespaceList;
    }

    protected static String getProperty(String propertyName) {
        return simulatorProperties.getProperty(propertyName);
    }

    protected static void setProperty(String property, String value) {
        simulatorProperties.setProperty(property, value);
    }

    protected static void savePropToFile() {
        try {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss");
            Date date = new Date();
            String dateTime = dateFormat.format(date);
            propFileName = "userInput" + File.separator + "UserInput" + dateTime + ".properties";
            FileOutputStream output = new FileOutputStream(propFileName);
            simulatorProperties.store(output, "SAN Simulator Properties");
            output.close();
        }
        catch (IOException ioException) {
            ioException.printStackTrace();
        }
    }

    public static void initLogger() {
        try {
            FileInputStream fileIn = new FileInputStream(new File(LOGGER_CONF_FILEPATH));
            LogManager.getLogManager().readConfiguration(fileIn);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        logger.info("Logger Initiated");
    }

    public static Vector getNamespaceList(String cimomURL, String cimomPort, String cimomUSername, String cimomPassword, String cimomNamespace, String cimomPrototcol) {
        namespaceVecor.clear();
        selectedNamespaceVector.clear();
        CIMClient cimClient = TestWbemCimomConnection.getConnection(cimomURL, cimomPort, cimomUSername, cimomPassword, cimomNamespace, cimomPrototcol);
        selectedNamespaceVector.add(cimomNamespace);
        namespaceVecor.add(cimomNamespace);
        ArrayList namespaceList = new ArrayList();
        try {
            namespaceList = DiscoveryUtil.getNamespaces(cimClient, namespaceList, "");
        }
        catch (Exception e1) {
            // empty catch block
        }
        Iterator iterator = namespaceList.iterator();
        while (iterator.hasNext()) {
            String namespace = (String)iterator.next();
            if (namespaceVecor.contains(namespace)) continue;
            namespaceVecor.add(namespace);
        }
        return namespaceVecor;
    }

    public static Vector getSelectedNamespaces() {
        return selectedNamespaceVector;
    }

    public static void updateNamespaceList(Object[] nmspace) {
        selectedNamespaceVector.trimToSize();
        for (int i = 0; i < nmspace.length; ++i) {
            if (selectedNamespaceVector.contains(nmspace[i])) continue;
            selectedNamespaceVector.add(nmspace[i]);
        }
    }

    public static void updateRemoveList(Object[] nmspace) {
        for (int i = 0; i < nmspace.length; ++i) {
            if (!namespaceVecor.contains(nmspace[i])) {
                selectedNamespaceVector.remove(nmspace[i]);
                continue;
            }
            selectedNamespaceVector.remove(nmspace[i]);
        }
    }

    public static void addNewNamespace(String nmspace) {
        namespaceVecor.add(nmspace);
    }

    public static Vector getAllNamespaces() {
        return namespaceVecor;
    }

    public static boolean validateNamespace(String cimomURL, String cimomPort, String cimomUSername, String cimomPassword, String strNamespace, String cimomPrototcol) {
        int testConnection = 0;
        try {
            testConnection = TestWbemCimomConnection.testConnection(cimomURL, cimomPort, cimomUSername, cimomPassword, strNamespace, cimomPrototcol);
        }
        catch (CIMException e) {
            testConnection = 0;
        }
        return testConnection != 0;
    }

    public static boolean isNamespaceListEmpty() {
        return selectedNamespaceVector.size() == 0;
    }

    static {
        namespaceVecor = new Vector();
        selectedNamespaceVector = new Vector();
        logger = Logger.getLogger(SetupWizardUtility.class.getName());
    }
}

