/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.simulator.ui;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMValue;
import org.eclipse.aperi.simulator.cimom.common.DatabaseManager;
import org.eclipse.aperi.simulator.ui.ConnectionUtility;
import org.eclipse.aperi.simulator.ui.SimulatorPropUtility;

public class SwitchDBClient {
    public static List sanPClassList;
    public static Vector switchNames;
    public static Map fabricMap;
    public static Map switchNameIDMap;
    private static Logger logger;
    public static Vector fabricNames;

    public static void configDBForSwitch() {
        try {
            File temp = File.createTempFile("setupwizard", ".config");
            temp.deleteOnExit();
            SimulatorPropUtility.getInstance().saveProperties(temp);
            System.setProperty("SETUP_WIZARD_CONFIG_FILEPATH", temp.getAbsolutePath());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static Vector getFreePortsForSwitch(boolean isSourceSwitch) {
        Vector<String> freePorts = new Vector<String>();
        String switchName = isSourceSwitch ? ConnectionUtility.switchName : ConnectionUtility.deviceName;
        Iterator fcPortIterator = null;
        try {
            fcPortIterator = SwitchDBClient.getAllFCPortsForSwitch(switchName).iterator();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        while (fcPortIterator.hasNext()) {
            boolean isPortBusy = false;
            CIMInstance inst = (CIMInstance)fcPortIterator.next();
            List enPE = DatabaseManager.getDbManager().associators("/root/brocade1", "Brocade_FCPortSANProtocolEndPoint", inst.getObjectPath());
            Iterator enPEIterator = enPE.iterator();
            while (enPEIterator.hasNext()) {
                CIMInstance aInst = (CIMInstance)enPEIterator.next();
                List enPE2 = DatabaseManager.getDbManager().associators("/root/brocade1", "Brocade_SANActiveConnection", aInst.getObjectPath());
                Iterator enPE2Iterator = enPE2.iterator();
                while (enPE2Iterator.hasNext()) {
                    isPortBusy = true;
                    enPE2Iterator.next();
                }
                enPE2 = null;
            }
            if (!isPortBusy) {
                String portNo = inst.getProperty("PortNumber").getValue().getValue().toString();
                String portWWN = inst.getProperty("PermanentAddress").getValue().getValue().toString();
                freePorts.add("" + portNo + " (" + portWWN + ")");
            }
            enPE = null;
        }
        if (freePorts == null) {
            JOptionPane.showMessageDialog(null, "Free ports not available on selected Switch !", "All Ports Busy", 0);
            System.exit(0);
        }
        return freePorts;
    }

    private static List getAllFCPortsForSwitch(String switchName) throws Exception {
        ArrayList<CIMInstance> switchFCPorts = new ArrayList<CIMInstance>();
        List switchFCClassList = DatabaseManager.getDbManager().enumerateInstances("/root/brocade1", "Brocade_SwitchFCPort");
        List referenceClassList = DatabaseManager.getDbManager().enumerateInstances("/root/brocade1", "Brocade_Switch");
        Iterator referenceSystemIterator = referenceClassList.iterator();
        Iterator fcPortIterator = switchFCClassList.iterator();
        while (referenceSystemIterator.hasNext()) {
            CIMInstance switchInst = (CIMInstance)referenceSystemIterator.next();
            String elementName = switchInst.getProperty("ElementName").getValue().getValue().toString();
            if (!elementName.equals(switchName)) continue;
            CIMValue name = switchInst.getProperty("Name").getValue();
            while (fcPortIterator.hasNext()) {
                CIMInstance portInst = (CIMInstance)fcPortIterator.next();
                CIMValue systemName = portInst.getProperty("SystemName").getValue();
                if (!name.equals((Object)systemName)) continue;
                switchFCPorts.add(portInst);
            }
            break block0;
        }
        return switchFCPorts;
    }

    public static Vector enumerateSwitchNames() {
        Object switchList = null;
        Vector<String> switchVector = new Vector<String>();
        switchVector.add("");
        return switchVector;
    }

    public static Vector enumerateSwitchName(String fabricId) {
        Vector temp = null;
        return temp;
    }

    public static Vector enumerateSwitchNames(String fabricName) {
        Object switchList = null;
        Vector<String> switchVector = new Vector<String>();
        switchVector.add("");
        List switchInFabricList = null;
        try {
            switchInFabricList = DatabaseManager.getDbManager().enumerateInstances("/root/brocade1", "Brocade_SwitchInFabric");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Iterator iterator = switchInFabricList.iterator();
        while (iterator.hasNext()) {
            CIMInstance inst = (CIMInstance)iterator.next();
            CIMObjectPath fabricOpath = new CIMObjectPath(inst.getProperty("GroupComponent").getValue().getValue().toString());
            String fabricName1 = fabricOpath.getKey("Name").getValue().getValue().toString();
            if (!fabricName1.equals(fabricName)) continue;
            CIMObjectPath switchOP = new CIMObjectPath(inst.getProperty("PartComponent").getValue().getValue().toString());
            String switchID = switchOP.getKey("Name").getValue().getValue().toString();
            String switchName = (String)switchNameIDMap.get(switchID);
            logger.info("Switch available: " + switchName);
            switchVector.add(switchName);
        }
        return switchVector;
    }

    public static Vector enumerateFabric() {
        List fabricList = null;
        Vector<CIMObjectPath> fabricVector = new Vector<CIMObjectPath>();
        try {
            fabricList = DatabaseManager.getDbManager().enumerateInstances("/root/brocade1", "Brocade_Fabric");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Iterator iter = fabricList.iterator();
        while (iter.hasNext()) {
            CIMInstance inst = (CIMInstance)iter.next();
            fabricVector.add(inst.getObjectPath());
        }
        return fabricVector;
    }

    public static List getSANProtocolEndPointFromSwitch() {
        try {
            sanPClassList = DatabaseManager.getDbManager().enumerateInstances("/root/brocade1", "Brocade_SANProtocolEndPoint");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sanPClassList;
    }

    private static void createSwitchIDMap() {
        switchNameIDMap.clear();
        try {
            List switchList = DatabaseManager.getDbManager().enumerateInstances("/root/brocade1", "Brocade_Switch");
            Iterator iter = switchList.iterator();
            while (iter.hasNext()) {
                CIMInstance inst = (CIMInstance)iter.next();
                String switchId = inst.getProperty("Name").getValue().getValue().toString();
                String switchName = inst.getProperty("ElementName").getValue().getValue().toString();
                switchNameIDMap.put(switchId, switchName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void getDeviceConnectData() {
        SwitchDBClient.createSwitchIDMap();
        Vector fabricObjectPaths = SwitchDBClient.enumerateFabric();
        Iterator iter = fabricObjectPaths.iterator();
        fabricNames.removeAllElements();
        fabricMap.clear();
        while (iter.hasNext()) {
            CIMObjectPath fabricOp = (CIMObjectPath)iter.next();
            String strFabricName = fabricOp.getKey("Name").getValue().getValue().toString();
            Vector switchesInfabric = SwitchDBClient.enumerateSwitchNames(strFabricName);
            fabricMap.put(strFabricName, switchesInfabric);
            fabricNames.add(strFabricName);
        }
    }

    static {
        fabricMap = new HashMap();
        switchNameIDMap = new HashMap();
        logger = Logger.getLogger(SwitchDBClient.class.getName());
        fabricNames = new Vector();
    }
}

