/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.simulator.ui;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Logger;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMValue;
import org.eclipse.aperi.simulator.cimom.common.DatabaseManager;
import org.eclipse.aperi.simulator.ui.ConnectionUtility;
import org.eclipse.aperi.simulator.ui.SwitchDBClient;

public class TargetDeviceDBClient {
    private static final String DS4K = "DS4K";
    private static final String DS6K_5_2 = "DS6K_5.2";
    private static final String DS6K_5_1 = "DS6K_5.1";
    private static Connection connection;
    public static String storageDeviceCategory;
    private static Map DeviceTypeMap;
    private static Logger logger;

    private static List getAllPortsForSelectedDevice() {
        Iterator FCPortIterator = null;
        Iterator ReferenceSystemIterator = null;
        try {
            List otherFCClassList = null;
            List referenceClassList = null;
            if (storageDeviceCategory.equals(DS4K)) {
                otherFCClassList = DatabaseManager.getDbManager().enumerateInstances(connection, "/root/lsissi11", "LSISSI_FCPort");
                referenceClassList = DatabaseManager.getDbManager().enumerateInstances(connection, "/root/lsissi11", "LSISSI_StorageSystem");
            } else if (storageDeviceCategory.equals(DS6K_5_1)) {
                otherFCClassList = DatabaseManager.getDbManager().enumerateInstances(connection, "/root/ibm", "IBMTSESS_FCPort");
                referenceClassList = DatabaseManager.getDbManager().enumerateInstances(connection, "/root/ibm", "IBMTSESS_StorageSystem");
            } else if (storageDeviceCategory.equals(DS6K_5_2)) {
                otherFCClassList = DatabaseManager.getDbManager().enumerateInstances(connection, "/root/ibm", "IBMTSDS_FCPort");
                referenceClassList = DatabaseManager.getDbManager().enumerateInstances(connection, "/root/ibm", "IBMTSDS_StorageSystem");
            }
            FCPortIterator = otherFCClassList.iterator();
            ReferenceSystemIterator = referenceClassList.iterator();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ArrayList<CIMInstance> allPortList = new ArrayList<CIMInstance>();
        while (ReferenceSystemIterator.hasNext()) {
            CIMInstance systemInst = (CIMInstance)ReferenceSystemIterator.next();
            CIMValue deviceName = systemInst.getProperty("Name").getValue();
            String strDeviceName = ConnectionUtility.deviceName.split("_")[1];
            if (!deviceName.getValue().toString().equalsIgnoreCase(strDeviceName)) continue;
            while (FCPortIterator.hasNext()) {
                CIMInstance fcPortInst = (CIMInstance)FCPortIterator.next();
                CIMValue systemName = fcPortInst.getProperty("SystemName").getValue();
                if (!deviceName.equals((Object)systemName)) continue;
                allPortList.add(fcPortInst);
            }
            break block2;
        }
        return allPortList;
    }

    public static void configDBForTargetDevice() {
        String url = ConnectionUtility.targetDevcieDBUrl;
        String name = ConnectionUtility.targetDevcieDBName;
        String uid = ConnectionUtility.targetDevcieDBUserid;
        String pwd = ConnectionUtility.targetDevcieDBPassword;
        String dbType = ConnectionUtility.targetDeviceDBType;
        String dbPort = ConnectionUtility.targetDeviceDBPort;
        if (dbType.equals("Derby")) {
            try {
                Class.forName("org.apache.derby.jdbc.ClientDriver").newInstance();
                String dbUrl = MessageFormat.format("jdbc:derby://{0}:{1}/{2};create=false;user={3};password={4}", url, dbPort, name, uid, pwd);
                connection = DriverManager.getConnection(dbUrl);
            }
            catch (InstantiationException e) {
                logger.info("Error in loading Derby Driver: " + e.getMessage());
            }
            catch (IllegalAccessException e) {
                logger.info("Error in loading Derby Driver: " + e.getMessage());
            }
            catch (ClassNotFoundException e) {
                logger.info("Error in loading Derby Driver: " + e.getMessage());
            }
            catch (SQLException e) {
                logger.info("Error in loading Derby Driver: " + e.getMessage());
            }
        } else if (pwd.equals("") || uid.equals("")) {
            String DB_URL = "jdbc:db2:" + name;
            try {
                Class.forName("com.ibm.db2.jcc.DB2Driver");
                connection = DriverManager.getConnection(DB_URL);
            }
            catch (ClassNotFoundException e) {
                logger.severe("Exception in DB Configuration: " + e);
            }
            catch (SQLException e) {
                logger.severe("SQLException in DB Configuration: " + e);
            }
            logger.info("Target Device DB Configured with DB URL: " + DB_URL);
        } else {
            String DB_URL = "jdbc:db2://" + url + ":50000/" + name;
            try {
                Class.forName("com.ibm.db2.jcc.DB2Driver");
                connection = DriverManager.getConnection(DB_URL, uid, pwd);
            }
            catch (ClassNotFoundException e) {
                logger.severe("Exception in DB COnfiguration: " + e);
            }
            catch (SQLException e) {
                logger.severe("Exception in DB COnfiguration: " + e);
            }
            logger.info("Target Device DB Configured for DB URL: " + DB_URL);
        }
    }

    private static String getDeviceType() {
        String strDevice = null;
        String deviceSelected = ConnectionUtility.deviceName;
        strDevice = (String)DeviceTypeMap.get(deviceSelected);
        return strDevice;
    }

    public static Vector getFreePortsForSelectedDevice() {
        storageDeviceCategory = TargetDeviceDBClient.getDeviceType();
        int dummyPortNo = 1;
        Iterator SANProtocolIterator = null;
        List sanPClassList = new ArrayList();
        Vector<String> freePorts = new Vector<String>();
        try {
            sanPClassList = SwitchDBClient.getSANProtocolEndPointFromSwitch();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Iterator FCPortIterator = TargetDeviceDBClient.getAllPortsForSelectedDevice().iterator();
        while (FCPortIterator.hasNext()) {
            boolean isPortBusy = false;
            CIMInstance inst1 = (CIMInstance)FCPortIterator.next();
            CIMValue otherFCDeviceId = inst1.getProperty("DeviceID").getValue();
            SANProtocolIterator = sanPClassList.iterator();
            while (SANProtocolIterator.hasNext()) {
                CIMInstance inst2 = (CIMInstance)SANProtocolIterator.next();
                CIMValue sanPName = inst2.getProperty("Name").getValue();
                if (!sanPName.equals((Object)otherFCDeviceId)) continue;
                isPortBusy = true;
                break;
            }
            if (isPortBusy) continue;
            CIMValue portNumber = inst1.getProperty("PortNumber").getValue();
            String portNo = portNumber != null ? portNumber.getValue().toString() : Integer.toString(dummyPortNo++);
            String portWWN = inst1.getProperty("PermanentAddress").getValue().getValue().toString();
            freePorts.add("" + portNo + " (" + portWWN + ")");
        }
        return freePorts;
    }

    public static Vector enumerateStorageNames() {
        String targetDeviceName;
        CIMInstance inst;
        List targetDevice = null;
        Vector<String> deviceVector = new Vector<String>();
        String targetDevicePrefix = "DS";
        try {
            targetDevice = DatabaseManager.getDbManager().enumerateInstances(connection, "/root/lsissi11", "LSISSI_StorageSystem");
        }
        catch (Exception e) {
            logger.severe("Error in Enumerating: " + e);
        }
        Iterator iterator = targetDevice.iterator();
        while (iterator.hasNext()) {
            inst = (CIMInstance)iterator.next();
            targetDeviceName = inst.getProperty("Name").getValue().getValue().toString();
            deviceVector.add(targetDevicePrefix + "_" + targetDeviceName);
            DeviceTypeMap.put(targetDevicePrefix + "_" + targetDeviceName, DS4K);
        }
        try {
            targetDevice = DatabaseManager.getDbManager().enumerateInstances(connection, "/root/ibm", "IBMTSESS_StorageSystem");
        }
        catch (Exception e) {
            logger.severe("Error in Enumerating: " + e);
        }
        iterator = targetDevice.iterator();
        while (iterator.hasNext()) {
            inst = (CIMInstance)iterator.next();
            targetDeviceName = inst.getProperty("Name").getValue().getValue().toString();
            deviceVector.add(targetDevicePrefix + "_" + targetDeviceName);
            DeviceTypeMap.put(targetDevicePrefix + "_" + targetDeviceName, DS6K_5_1);
        }
        try {
            targetDevice = DatabaseManager.getDbManager().enumerateInstances(connection, "/root/ibm", "IBMTSDS_StorageSystem");
        }
        catch (Exception e) {
            logger.severe("Error in Enumerating: " + e);
        }
        iterator = targetDevice.iterator();
        while (iterator.hasNext()) {
            inst = (CIMInstance)iterator.next();
            targetDeviceName = inst.getProperty("Name").getValue().getValue().toString();
            deviceVector.add(targetDevicePrefix + "_" + targetDeviceName);
            DeviceTypeMap.put(targetDevicePrefix + "_" + targetDeviceName, DS6K_5_2);
        }
        return deviceVector;
    }

    static {
        DeviceTypeMap = new HashMap();
        logger = Logger.getLogger(TargetDeviceDBClient.class.getName());
    }
}

