/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.wbem.cim;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Vector;
import org.sblim.wbem.cim.CIMDataType;
import org.sblim.wbem.cim.CIMObject;
import org.sblim.wbem.cim.CIMObjectPath;
import org.sblim.wbem.cim.CIMProperty;
import org.sblim.wbem.cim.CIMQualifier;
import org.sblim.wbem.cim.CIMValue;
import org.sblim.wbem.util.Utils;

public class CIMInstance
extends CIMObject
implements Serializable {
    protected String alias;

    public CIMInstance() {
        this.objectpath = new CIMObjectPath();
    }

    public CIMInstance(CIMObjectPath op) {
        if (op == null) {
            this.objectpath = new CIMObjectPath();
        } else {
            this.objectpath = (CIMObjectPath)op.clone();
            this.name = this.objectpath.getObjectName();
            if (this.name == null) {
                throw new IllegalArgumentException("null class name");
            }
            Vector keys = op.getKeys();
            Iterator iter = keys.iterator();
            while (iter.hasNext()) {
                this.addProperty((CIMProperty)iter.next());
            }
        }
    }

    public Object clone() {
        CIMInstance that = new CIMInstance();
        that.name = this.name;
        that.alias = this.alias;
        that.objectpath = (CIMObjectPath)this.objectpath.clone();
        Iterator iter = this.qualifiers.iterator();
        while (iter.hasNext()) {
            CIMQualifier qual = (CIMQualifier)iter.next();
            that.qualifiers.add(qual.clone());
        }
        iter = this.allProperties.iterator();
        while (iter.hasNext()) {
            CIMProperty prop = (CIMProperty)iter.next();
            that.addProperty((CIMProperty)prop.clone());
        }
        return that;
    }

    public boolean equals(Object o) {
        if (!(o instanceof CIMInstance)) {
            return false;
        }
        CIMInstance that = (CIMInstance)o;
        if (!this.qualifiers.equals(that.qualifiers) || !this.allProperties.equals(that.allProperties)) {
            return false;
        }
        if (!(this.alias != null ? this.alias.equalsIgnoreCase(that.alias) : that.alias == null)) {
            return false;
        }
        return this.name.equalsIgnoreCase(that.name);
    }

    public int hashCode() {
        return this.name.hashCode() + this.qualifiers.hashCode() + this.allProperties.hashCode() + (this.alias != null ? this.alias.hashCode() : 0);
    }

    public String getAlias() {
        return this.alias;
    }

    public String getClassName() {
        return this.name;
    }

    public Vector getKeyValuePairs() {
        return this.getKeys();
    }

    public String getName() {
        return this.name;
    }

    public CIMObjectPath getObjectPath() {
        this.objectpath.setKeys(this.getKeyValuePairs());
        return this.objectpath;
    }

    public void setObjectPath(CIMObjectPath objectpath) {
        if (objectpath == null) {
            throw new IllegalArgumentException("null objectpath argument");
        }
        this.name = objectpath.getObjectName();
        this.objectpath.setObjectName(this.name);
        this.objectpath.setHost(objectpath.getHost());
        this.objectpath.setNameSpace(objectpath.getNameSpace());
        Vector keys = objectpath.getKeys();
        Iterator iter = keys.iterator();
        while (iter.hasNext()) {
            CIMProperty key = (CIMProperty)iter.next();
            CIMProperty localProp = this.getProperty(key);
            if (localProp == null) {
                this.addProperty(key);
                continue;
            }
            localProp.addQualifier(new CIMQualifier("Key"));
            if (localProp.getType().getType() != 14) continue;
            this.setProperty(key.getName(), key.getValue());
        }
    }

    public void setAlias(String aliasName) {
        this.alias = aliasName;
    }

    public void setClassName(String classname) {
        if (classname == null) {
            throw new IllegalArgumentException("null classname argument");
        }
        this.objectpath.setObjectName(classname);
        this.name = classname;
    }

    public void setName(String newName) {
        if (newName == null) {
            throw new IllegalArgumentException("null name argument");
        }
        this.name = newName;
        this.objectpath.setObjectName(newName);
    }

    public String toMOF() {
        StringBuffer buffer = new StringBuffer();
        if (this.qualifiers.size() > 0) {
            buffer.append("\n\t");
            buffer.append(CIMInstance.vectorToMOFString(this.qualifiers, false, 1));
            buffer.append("\n");
        }
        buffer.append("instance of ");
        buffer.append(this.getClassName());
        buffer.append(" ");
        if (this.alias != null && this.alias.length() > 0) {
            buffer.append("as space");
            buffer.append(this.alias);
            buffer.append(" ");
        }
        buffer.append("{\n");
        if (this.allProperties.size() > 0) {
            buffer.append(CIMInstance.vectorToMOFString(this.allProperties, true, 0, 0, false));
            buffer.append(" ");
        }
        buffer.append("};");
        return buffer.toString();
    }

    public String toString() {
        return this.toMOF();
    }

    public void updateProperty(CIMProperty property) {
        if (property == null) {
            throw new IllegalArgumentException("null property argument");
        }
        Iterator iter = this.allProperties.iterator();
        while (iter.hasNext()) {
            CIMProperty prop = (CIMProperty)iter.next();
            if (!prop.getName().equals(property.getName())) continue;
            prop.setValue(property.getValue());
            Iterator iter2 = property.getQualifiers().iterator();
            while (iter2.hasNext()) {
                CIMQualifier qual = (CIMQualifier)iter2.next();
                prop.addQualifier(qual);
            }
            prop.setOverridingProperty(property.getOverridingProperty());
            prop.setOriginClass(property.getOriginClass());
            return;
        }
        this.addProperty(property);
    }

    public boolean updatePropertyValue(CIMProperty property) {
        if (property == null) {
            throw new IllegalArgumentException("null property argument");
        }
        Iterator iter = this.allProperties.iterator();
        while (iter.hasNext()) {
            CIMProperty prop = (CIMProperty)iter.next();
            if (!prop.getName().equals(property.getName())) continue;
            prop.setValue(property.getValue());
            return true;
        }
        Utils.addSorted(this.allProperties, property);
        return false;
    }

    public void updatePropertyValue(Vector values) {
        if (values == null) {
            throw new IllegalArgumentException("null values argument");
        }
        Iterator iter = values.iterator();
        if (iter.hasNext()) {
            CIMProperty property = (CIMProperty)iter.next();
            this.updatePropertyValue(property);
            return;
        }
    }

    public static void main(String[] args) {
        CIMObjectPath op = new CIMObjectPath("MyTestClass");
        CIMProperty p1 = new CIMProperty("KeyedProperty");
        p1.addQualifier(new CIMQualifier("Key"));
        op.addKey(p1);
        CIMProperty p2 = new CIMProperty("KeyedProperty");
        p2.setValue(new CIMValue("Value1", CIMDataType.getPredefinedType(8)));
        p2.addQualifier(new CIMQualifier("Key"));
        p2.addQualifier(new CIMQualifier("Overridable"));
        System.out.println("CIMInstance(ObjectPath)");
        CIMInstance instance = new CIMInstance(op);
        System.out.println(instance);
        System.out.println("updateProperty()");
        instance.updateProperty(p2);
        System.out.println(instance);
        System.out.println("setName()");
        instance.setName("NewClassName");
        System.out.println(instance);
        System.out.println("getObjectPath()");
        System.out.println(instance.getObjectPath());
        System.out.println("hashCode()");
        System.out.println(instance.hashCode());
        System.out.println("clone()");
        CIMInstance instance2 = (CIMInstance)instance.clone();
        System.out.println(instance2);
        System.out.println("instance.equals(instance2)");
        System.out.println(instance2.equals(instance));
        System.out.println("instance.addQualifier(new CIMQualifier(\"Association\"))");
        instance2.addQualifier(new CIMQualifier("Association"));
        System.out.println("instance.equals(instance2)");
        System.out.println(instance2.equals(instance));
    }
}

