/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.wbem.cim;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.sblim.wbem.cim.CIMDataType;
import org.sblim.wbem.cim.CIMException;
import org.sblim.wbem.cim.CIMNameSpace;
import org.sblim.wbem.cim.CIMProperty;
import org.sblim.wbem.cim.CIMQualifier;
import org.sblim.wbem.cim.CIMValue;
import org.sblim.wbem.util.CharUtils;
import org.sblim.wbem.util.GlobalProperties;

public class CIMObjectPath
implements Serializable,
Cloneable {
    private String className;
    private String host;
    private String namespace;
    private Vector keys = new Vector();
    private static final String EMPTY = "";
    protected String toString;

    public CIMObjectPath() {
        this(EMPTY, EMPTY);
    }

    public CIMObjectPath(String className) {
        this(className, EMPTY);
    }

    public CIMObjectPath(String className, String namespace) throws CIMException {
        this.className = className;
        this.setNamespace(namespace);
    }

    public CIMObjectPath(String className, Vector keyValuePairs) {
        this(className, EMPTY);
        if (keyValuePairs == null) {
            throw new IllegalArgumentException("null keys argument");
        }
        this.setKeys(keyValuePairs);
    }

    protected void setNamespace(String namespace) {
        if (namespace != null) {
            if (namespace.indexOf(92) > -1) {
                throw new CIMException("CIM_ERR_INVALID_PARAMETER", "namespace should not contain '\\' character");
            }
            boolean tryAgain = false;
            do {
                tryAgain = false;
                if (namespace.startsWith("/")) {
                    namespace = namespace.substring(1);
                    tryAgain = true;
                }
                if (!namespace.endsWith("/")) continue;
                namespace = namespace.substring(0, namespace.length() - 1);
                tryAgain = true;
            } while (tryAgain);
            this.namespace = namespace;
        } else {
            this.namespace = EMPTY;
        }
    }

    public void addKey(String propertyName, CIMValue value) {
        if (propertyName == null) {
            throw new IllegalArgumentException("null property name argument");
        }
        this.addKey(new CIMProperty(propertyName, value));
    }

    public void addKey(CIMProperty property) {
        block6: {
            if (property == null) {
                throw new IllegalArgumentException("null property name argument");
            }
            try {
                CIMQualifier key = new CIMQualifier("Key");
                property.addQualifier(key);
            }
            catch (Exception e) {
                Logger logger = GlobalProperties.getLogger();
                if (!logger.isLoggable(Level.WARNING)) break block6;
                logger.log(Level.WARNING, "exception while adding key property", e);
            }
        }
        Iterator iter = this.keys.iterator();
        int i = 0;
        while (iter.hasNext()) {
            CIMProperty key = (CIMProperty)iter.next();
            String name = key.getName();
            if (name.equals(property.getName())) {
                return;
            }
            if (name.compareTo(property.getName()) > 0) {
                this.keys.insertElementAt(property, i);
                this.toString = null;
                return;
            }
            ++i;
        }
        this.keys.add(property);
        this.toString = null;
    }

    public void removeAllKeys() {
        this.keys.setSize(0);
        this.toString = null;
    }

    public void removeKey(String propertyName) {
        Iterator iter = this.keys.iterator();
        while (iter.hasNext()) {
            CIMProperty key = (CIMProperty)iter.next();
            if (!key.getName().equals(propertyName)) continue;
            iter.remove();
            this.toString = null;
            break;
        }
    }

    public Object clone() {
        CIMObjectPath that = new CIMObjectPath();
        that.namespace = this.namespace;
        that.className = this.className;
        that.host = this.host;
        if (this.keys != null) {
            Iterator iter = this.keys.iterator();
            while (iter.hasNext()) {
                that.keys.add(((CIMProperty)iter.next()).clone());
            }
        }
        return that;
    }

    public static CIMObjectPath parse(String objectPath) {
        throw new RuntimeException("not implemented");
    }

    public boolean equals(Object obj) {
        return this.equals(obj, true);
    }

    public boolean equals(Object obj, boolean ignoreClassOrigin) {
        if (!(obj instanceof CIMObjectPath)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        CIMObjectPath that = (CIMObjectPath)obj;
        if (!(this.className != null ? this.className.equals(that.className) : that.className == null)) {
            return false;
        }
        if (!(this.namespace != null ? this.namespace.equals(that.namespace) : that.namespace == null)) {
            return false;
        }
        if (that.keys.size() != this.keys.size()) {
            return false;
        }
        for (int i = 0; i < that.keys.size(); ++i) {
            CIMProperty thatProperty = (CIMProperty)that.keys.elementAt(i);
            CIMProperty thisProperty = (CIMProperty)this.keys.elementAt(i);
            if (!thatProperty.getName().equals(thisProperty.getName())) {
                return false;
            }
            if (!ignoreClassOrigin && !(thisProperty.getOriginClass() != null ? thatProperty.getOriginClass().equalsIgnoreCase(thisProperty.getOriginClass()) : thatProperty.getOriginClass() == null)) {
                return false;
            }
            CIMValue thatValue = thatProperty.getValue();
            CIMValue thisValue = thisProperty.getValue();
            if (thisValue != null ? thisValue.equals(thatValue) : thisValue == null) continue;
            return false;
        }
        return true;
    }

    public String getHost() {
        return this.host;
    }

    public CIMProperty getKey(String propertyName) {
        if (propertyName == null) {
            return null;
        }
        Iterator iterator = this.keys.iterator();
        while (iterator.hasNext()) {
            CIMProperty key = (CIMProperty)iterator.next();
            if (!key.getName().equals(propertyName)) continue;
            return key;
        }
        return null;
    }

    public Vector getKeys() {
        return this.keys;
    }

    public String getNameSpace() {
        return this.namespace;
    }

    public void setNameSpace(CIMNameSpace namespace) {
        if (namespace == null) {
            this.namespace = null;
            this.host = null;
        } else {
            this.host = namespace.getHost();
            this.setNamespace(namespace.getNameSpace());
        }
        this.toString = null;
    }

    public String getObjectName() {
        return this.className;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setNameSpace(String namespace) {
        this.setNamespace(namespace);
        this.toString = null;
    }

    public void setObjectName(String className) {
        this.className = className;
        this.toString = null;
    }

    public void setKeys(Vector keysV) {
        if (keysV == null) {
            throw new IllegalArgumentException("null keys argument");
        }
        try {
            Iterator iter = keysV.iterator();
            while (iter.hasNext()) {
                CIMProperty prop = (CIMProperty)iter.next();
                this.addKey(prop);
            }
            this.toString = null;
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("key vector contains must contains CIMProperties only");
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.namespace != null && this.namespace.trim().length() != 0) {
            sb.append(this.namespace);
            sb.append(":");
        }
        if (this.className != null) {
            sb.append(this.className);
        }
        if (this.keys != null && this.keys.size() > 0) {
            sb.append(".");
            boolean first = false;
            for (int i = 0; i < this.keys.size(); ++i) {
                CIMProperty property = (CIMProperty)this.keys.elementAt(i);
                if (property == null) continue;
                CIMValue value = property.getValue();
                if (first) {
                    sb.append(",");
                }
                first = true;
                String propertyName = property.getName();
                Object o = null;
                if (value != null && (o = value.getValue()) != null) {
                    if (o instanceof String) {
                        sb.append(propertyName + "=\"" + CharUtils.escape((String)o) + "\"");
                        continue;
                    }
                    if (value.getValue() instanceof CIMObjectPath) {
                        sb.append(propertyName + "=\"" + CharUtils.escape(o.toString()) + "\"");
                        continue;
                    }
                    sb.append(propertyName + "=" + o.toString());
                    continue;
                }
                sb.append(propertyName + "=null");
            }
        }
        this.toString = sb.toString();
        return this.toString;
    }

    public String toString(boolean includeHostname) {
        StringBuffer sb = new StringBuffer();
        if (this.host != null) {
            if (!this.host.startsWith("//")) {
                sb.append("//");
            }
            sb.append(this.host);
            sb.append("/");
        } else {
            sb.append("///");
        }
        sb.append(this.toString());
        return sb.toString();
    }

    public int hashCode() {
        int keyHashCode = 0;
        Iterator iter = this.keys.iterator();
        while (iter.hasNext()) {
            CIMProperty prop = (CIMProperty)iter.next();
            int propHashCode = 0;
            propHashCode = prop.getName().hashCode() << 16 + (prop.getValue() != null ? prop.getValue().hashCode() : 0);
            keyHashCode = keyHashCode * 31 + propHashCode;
        }
        return (this.className != null ? this.className.toUpperCase().hashCode() : 0) + (this.namespace != null ? this.namespace.hashCode() : 0) + keyHashCode;
    }

    public static void main(String[] args) {
        CIMObjectPath op1 = new CIMObjectPath("CIM_ComputerSystem", "/////");
        CIMObjectPath op2 = new CIMObjectPath("CIM_ComputerSystem", (String)null);
        System.out.println("Equals:" + op1.equals(op2));
        CIMProperty p1 = new CIMProperty("Name", new CIMValue(new Integer(1), CIMDataType.getPredefinedType(5)));
        CIMProperty p2 = new CIMProperty("Name", new CIMValue(new Integer(1), CIMDataType.getPredefinedType(5)));
        p1.addQualifier(new CIMQualifier("Key"));
        p2.addQualifier(new CIMQualifier("Overridable"));
        op1.addKey(p1);
        op2.addKey(p2);
        System.out.println("op1" + op1);
        System.out.println("op2" + op2);
        long initial = System.currentTimeMillis();
        for (int i = 0; i < 1000000; ++i) {
            op1.equals(op2);
            op1.hashCode();
            op2.hashCode();
        }
        System.out.println("Elapse:" + (double)(System.currentTimeMillis() - initial) / 1000000.0);
    }
}

