/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.wbem.cim;

import java.io.Serializable;
import org.sblim.wbem.cim.CIMDataType;
import org.sblim.wbem.cim.CIMQualifiableElement;
import org.sblim.wbem.cim.CIMQualifier;

public class CIMParameter
extends CIMQualifiableElement
implements Cloneable,
Serializable {
    private CIMDataType type;

    public CIMParameter() {
    }

    public CIMParameter(String name) {
        super(name);
    }

    public Object clone() {
        CIMParameter that = new CIMParameter(this.name);
        that.type = (CIMDataType)this.type.clone();
        for (int i = 0; i < this.qualifiers.size(); ++i) {
            that.qualifiers.add(((CIMQualifier)this.qualifiers.elementAt(i)).clone());
        }
        return that;
    }

    public int hashCode() {
        return this.name.hashCode() + (this.type != null ? this.type.hashCode() : 0);
    }

    public int getSize() {
        if (this.type != null) {
            return this.type.getSize();
        }
        return -1;
    }

    public CIMDataType getType() {
        return this.type;
    }

    public void setSize(int size) {
    }

    public void setType(CIMDataType type) {
        if (type == null) {
            throw new IllegalArgumentException("null data type argument");
        }
        this.type = type;
    }

    public String toMOF() {
        StringBuffer buff = new StringBuffer();
        if (this.qualifiers.size() > 0) {
            buff.append(CIMParameter.vectorToMOFString(this.qualifiers, false, 1));
            buff.append("\n\t\t");
        }
        buff.append(this.type);
        buff.append(" ");
        buff.append(this.name);
        return buff.toString();
    }

    public String toString() {
        return this.toMOF();
    }
}

