/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.wbem.cim;

import org.sblim.wbem.cim.CIMDateTime;

public class CIMTimeInterval
extends CIMDateTime {
    public CIMTimeInterval() {
        this.s = "00000000000000.000000:000";
        this.interval = true;
        this.presicion = 12;
    }

    public CIMTimeInterval(String str) {
        this.interval = true;
        if (str.indexOf(43) > -1 || str.indexOf(45) > -1) {
            throw new IllegalArgumentException("CIMTimeInterval must not be used to define points in time: " + str);
        }
        CIMTimeInterval.valueOf(this, str);
    }

    public void setDay(int i) {
        if (i < 1 || i > 31) {
            throw new IllegalArgumentException("invalid value of offset minute:" + i);
        }
        this.calendar = null;
        this.day = i;
    }

    protected static String convertSecondsToCIMInterval(int intervalInSeconds) {
        int seconds = intervalInSeconds % 60;
        String secondsStr = (seconds < 10 ? "0" : "") + seconds;
        int minutes = intervalInSeconds / 60 % 60;
        String minutesStr = (minutes < 10 ? "0" : "") + minutes;
        int hours = intervalInSeconds / 3600 % 24;
        String hoursStr = (hours < 10 ? "0" : "") + hours;
        return "00000000" + hoursStr + minutesStr + secondsStr + ".******:000";
    }

    public static void main(String[] args) {
        System.out.println(new CIMTimeInterval("00000000000000.000000:000"));
        System.out.println(new CIMTimeInterval("12345678901234.567890:000"));
        System.out.println(new CIMTimeInterval("12345678901234.56789*:000"));
        System.out.println(new CIMTimeInterval("12345678901234.5678**:000"));
        System.out.println(new CIMTimeInterval("12345678901234.567***:000"));
        System.out.println(new CIMTimeInterval("12345678901234.56****:000"));
        System.out.println(new CIMTimeInterval("12345678901234.5*****:000"));
        System.out.println(new CIMTimeInterval("12345678901234.******:000"));
        System.out.println(new CIMTimeInterval("123456789012**.******:000"));
        System.out.println(new CIMTimeInterval("1234567890****.******:000"));
        System.out.println(new CIMTimeInterval("12345678******.******:000"));
        System.out.println(new CIMTimeInterval("1234567*******.******:000"));
    }
}

